# vim: set noet sw=4 ts=4:
# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

$(eval $(call gb_CustomTarget_CustomTarget,static/emscripten_fs_image))

gb_emscripten_fs_image_autoinstall :=
gb_emscripten_fs_image_filelists :=

# file_packager.py supports renaming files by using "<src>@<dest>" input with all
# @ escaped as @@ in both paths. Decoding this "encoding" in Makefile seems hard.
#
# Currently WASM simply assumes the image has the same layout then instdir. The
# command is run from $(BUILDDIR), so everything from $(BUILDDIR) can be just
# included "as it". Files from $(SRCDIR) are converted to the '@' syntax.
#
# Easiest workaround for most other limitations is probably to hack the filenames
# in soffice.data.js.metadata after the image generation or manually add additional
# commandline entries to the file_packager.py call.
#
gb_emscripten_fs_image_files := \
    $(call gb_UnoApi_get_target,offapi) \
    $(call gb_UnoApi_get_target,oovbaapi) \
    $(call gb_UnoApi_get_target,udkapi) \
    $(INSTROOT)/$(LIBO_BIN_FOLDER)/intro-highres.png \
    $(INSTROOT)/$(LIBO_BIN_FOLDER)/intro.png \
    $(INSTROOT)/$(LIBO_BIN_FOLDER)/shell/about.svg \
    $(INSTROOT)/$(LIBO_BIN_FOLDER)/shell/logo_inverted.svg \
    $(INSTROOT)/$(LIBO_BIN_FOLDER)/shell/logo-sc_inverted.svg \
    $(INSTROOT)/$(LIBO_BIN_FOLDER)/shell/logo-sc.svg \
    $(INSTROOT)/$(LIBO_BIN_FOLDER)/shell/logo.svg \
    $(INSTROOT)/$(LIBO_ETC_FOLDER)/$(call gb_Helper_get_rcfile,bootstrap) \
    $(INSTROOT)/$(LIBO_ETC_FOLDER)/$(call gb_Helper_get_rcfile,fundamental) \
    $(INSTROOT)/$(LIBO_ETC_FOLDER)/$(call gb_Helper_get_rcfile,louno) \
    $(INSTROOT)/$(LIBO_ETC_FOLDER)/$(call gb_Helper_get_rcfile,setup) \
    $(INSTROOT)/$(LIBO_ETC_FOLDER)/$(call gb_Helper_get_rcfile,soffice) \
    $(INSTROOT)/$(LIBO_ETC_FOLDER)/$(call gb_Helper_get_rcfile,version) \
    $(INSTROOT)/$(LIBO_ETC_FOLDER)/services/services.rdb \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/aboutconfigdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/aboutconfigvaluedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/aboutdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/accelconfigpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/acorexceptpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/acoroptionspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/acorreplacepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/additionsdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/additionsfragment.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/agingdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/applyautofmtpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/applylocalizedpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/areadialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/areatabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/asiantypography.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/assigncomponentdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/autocorrectdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/baselinksdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/borderareatransparencydialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/borderbackgrounddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/borderpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/breaknumberoption.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/bulletandposition.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/calloutdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/calloutpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/cellalignment.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/certdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/chapterfragment.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/charnamepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/colorconfigwin.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/colorfragment.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/colorpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/colorpickerdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/comment.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/connectortabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/connpooloptions.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/croppage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/cuiimapdlg.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/customizedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/databaselinkdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/dbregisterpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/diagramdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/dimensionlinestabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/editdictionarydialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/editmodulesdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/effectspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/embossdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/entrycontextmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/eventassigndialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/eventassignpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/eventsconfigpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/fmsearchdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/fontfeaturesdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/fontfragment.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/formatcellsdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/formatnumberdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/galleryapplyprogress.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/galleryfilespage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/gallerygeneralpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/gallerysearchprogress.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/gallerythemedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/gallerythemeiddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/gallerytitledialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/galleryupdateprogress.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/gradientpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/graphictestdlg.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/graphictestentry.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/hangulhanjaadddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/hangulhanjaconversiondialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/hangulhanjaeditdictdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/hangulhanjaoptdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/hatchpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/hyperlinkdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/hyperlinkdocpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/hyperlinkinternetpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/hyperlinkmailpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/hyperlinkmarkdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/hyperlinknewdocpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/hyphenate.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/iconchangedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/iconselectordialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/imagetabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/imageviewer.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/insertfloatingframe.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/insertoleobject.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/insertrowcolumn.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/javaclasspathdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/javastartparametersdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/linedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/lineendstabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/linestyletabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/linetabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/macroassigndialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/macroassignpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/macroselectordialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/menuassignpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/mosaicdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/movemenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/multipathdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/namedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/newlibdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/newtabledialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/newtoolbardialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/numberingformatpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/numberingoptionspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/numberingpositionpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/objectnamedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/objecttitledescdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optaccessibilitypage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optadvancedpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optappearancepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optasianpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optbasicidepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optchartcolorspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optctlpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optemailpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optfltrembedpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optfltrpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optfontspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optgeneralpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/opthtmlpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optionsdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optjsearchpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optlanguagespage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optlingupage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optnewdictionarydialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optonlineupdatepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optpathspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optproxypage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optsavepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optsecuritypage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optuserpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/optviewpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/pageformatpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/paragalignpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/paraindentspacing.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/paratabspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/password.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/pastespecial.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/patterntabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/percentdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/personalization_tab.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/pickbulletpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/pickgraphicpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/picknumberingpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/pickoutlinepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/positionpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/positionsizedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/possizetabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/posterdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/qrcodegen.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/querychangelineenddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/querydeletebitmapdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/querydeletechartcolordialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/querydeletecolordialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/querydeletedictionarydialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/querydeletegradientdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/querydeletehatchdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/querydeletelineenddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/querydeletelinestyledialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/queryduplicatedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/querynoloadedfiledialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/querynosavefiledialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/querysavelistdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/queryupdategalleryfilelistdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/recordnumberdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/rotationtabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/screenshotannotationdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/scriptorganizer.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/searchattrdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/searchformatdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/securityoptionsdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/selectpathdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/shadowtabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/showcoldialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/signatureline.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/signsignatureline.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/similaritysearchdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/slantcornertabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/smarttagoptionspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/smoothdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/solarizedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/specialcharacters.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/spellingdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/spelloptionsdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/spinbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/splitcellsdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/storedwebconnectiondialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/swpossizepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/textanimtabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/textattrtabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/textcolumnstabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/textdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/textflowpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/thesaurus.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/toolbarmodedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/transparencytabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/tsaurldialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/twolinespage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/wordcompletionpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/cui/ui/zoomdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/desktop/ui/dependenciesdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/desktop/ui/extensionmanager.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/desktop/ui/extensionmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/desktop/ui/installforalldialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/desktop/ui/licensedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/desktop/ui/showlicensedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/desktop/ui/updatedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/desktop/ui/updateinstalldialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/desktop/ui/updaterequireddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/editeng/ui/spellmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/filter/ui/pdfgeneralpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/filter/ui/pdflinkspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/filter/ui/pdfoptionsdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/filter/ui/pdfsecuritypage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/filter/ui/pdfsignpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/filter/ui/pdfuserinterfacepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/filter/ui/pdfviewpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/filter/ui/testxmlfilter.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/filter/ui/warnpdfdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/filter/ui/xmlfiltersettings.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/filter/ui/xmlfiltertabpagegeneral.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/filter/ui/xmlfiltertabpagetransformation.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/filter/ui/xsltfilterdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/formula/ui/formuladialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/formula/ui/functionpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/formula/ui/parameter.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/formula/ui/structpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/fps/ui/breadcrumb.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/fps/ui/explorerfiledialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/fps/ui/foldernamedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/fps/ui/remotefilesdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/menubar/menubar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/anchor.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/annotation.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/drawtext.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/draw.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/formrichtext.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/form.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/frame.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/graphic.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/insertfield.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/media.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/oleobject.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/preview.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/showtrackedchanges.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/table.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/popupmenu/text.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/statusbar/statusbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/alignmentbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/arrowshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/basicshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/bezierobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/calloutshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/colorbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/drawbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/drawingobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/drawtextobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/extrusionobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/findbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/flowchartshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/fontworkobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/fontworkshapetype.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/formcontrols.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/formdesign.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/formsfilterbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/formsnavigationbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/formtextobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/frameobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/fullscreenbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/graffilterbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/graphicobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/insertbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/insertobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/mediaobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/numobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/oleobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/optimizetablebar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/previewobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/standardbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/starshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/symbolshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/tableobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/textobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/textstylebar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/toolbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sglobal/toolbar/viewerbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/StartModule/menubar/menubar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/menubar/menubar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/popupmenu/anchor.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/popupmenu/annotation.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/popupmenu/formrichtext.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/popupmenu/form.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/popupmenu/frame.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/popupmenu/graphic.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/popupmenu/insertfield.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/popupmenu/oleobject.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/popupmenu/preview.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/popupmenu/showtrackedchanges.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/popupmenu/source.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/popupmenu/table.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/popupmenu/text.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/statusbar/statusbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/arrowshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/basicshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/bezierobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/calloutshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/colorbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/drawingobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/drawtextobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/extrusionobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/findbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/flowchartshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/fontworkobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/fontworkshapetype.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/formcontrols.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/formdesign.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/formsfilterbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/formsnavigationbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/formtextobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/frameobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/fullscreenbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/graffilterbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/graphicobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/insertbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/mediaobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/numobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/oleobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/optimizetablebar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/previewobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/standardbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/starshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/symbolshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/tableobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/textobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/toolbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/sweb/toolbar/viewerbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/menubar/menubar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/anchor.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/annotation.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/drawtext.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/draw.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/formrichtext.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/form.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/frame.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/graphic.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/insertfield.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/media.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/oleobject.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/preview.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/table.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/popupmenu/text.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/statusbar/statusbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/alignmentbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/arrowshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/basicshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/bezierobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/calloutshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/colorbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/drawbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/drawingobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/drawtextobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/extrusionobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/flowchartshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/fontworkobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/fontworkshapetype.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/formcontrols.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/formdesign.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/formsfilterbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/formsnavigationbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/formtextobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/frameobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/fullscreenbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/graffilterbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/graphicobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/insertbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/insertobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/mailmerge.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/mediaobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/numobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/oleobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/optimizetablebar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/previewobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/standardbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/starshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/symbolshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/tableobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/textobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/toolbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swform/toolbar/viewerbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/menubar/menubar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/anchor.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/annotation.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/drawtext.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/draw.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/formrichtext.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/form.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/frame.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/graphic.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/insertfield.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/media.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/oleobject.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/preview.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/showtrackedchanges.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/table.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/popupmenu/text.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/statusbar/statusbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/alignmentbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/arrowshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/basicshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/bezierobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/calloutshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/colorbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/drawbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/drawingobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/drawtextobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/extrusionobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/flowchartshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/fontworkobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/fontworkshapetype.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/formcontrols.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/formdesign.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/formsfilterbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/formsnavigationbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/formtextobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/frameobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/fullscreenbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/graffilterbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/graphicobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/insertbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/insertobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/mailmerge.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/mediaobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/numobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/oleobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/optimizetablebar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/previewobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/standardbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/starshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/symbolshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/tableobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/textobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/toolbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swreport/toolbar/viewerbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/menubar/menubar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/menubar/mscompatibleformsmenu.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/anchor.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/annotation.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/drawtext.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/draw.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/formrichtext.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/form.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/frame.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/graphic.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/insertfield.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/media.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/notebookbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/oleobject.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/preview.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/showtrackedchanges.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/table.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/popupmenu/text.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/statusbar/statusbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/alignmentbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/arrowsbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/arrowshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/basicshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/bezierobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/calloutshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/changes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/classificationbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/colorbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/drawbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/drawingobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/drawtextobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/extrusionobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/findbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/flowchartshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/fontworkobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/fontworkshapetype.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/formcontrols.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/formdesign.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/formsfilterbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/formsnavigationbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/formtextobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/frameobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/fullscreenbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/graffilterbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/graphicobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/insertbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/linesbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/mailmerge.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/mediaobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/navigationobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/notebookbarshortcuts.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/numobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/oleobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/optimizetablebar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/previewobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/singlemode.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/standardbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/starshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/symbolshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/tableobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/textobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/textstylebar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/toolbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/toolbar/viewerbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/abstractdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/addentrydialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/addressblockdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/addressfragment.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/alreadyexistsdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/annotation.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/asciifilterdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/asksearchdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/assignfieldsdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/assignfragment.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/assignstylesdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/attachnamedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/authenticationsettingsdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/autoformattable.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/autotext.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/bibliofragment.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/bibliographyentry.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/bookmarkmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/bulletsandnumbering.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/businessdatapage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/calendar.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/cannotsavelabeldialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/captiondialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/captionoptions.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/cardmediumpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/ccdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/characterproperties.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/charurlpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/checkbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/columndialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/columnpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/columnwidth.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/comboboxfragment.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/combobox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/conditionpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/converttexttable.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/createaddresslist.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/createauthorentry.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/createautomarkdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/customizeaddrlistdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/datasourcesunavailabledialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/dateformfielddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/dropcapspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/dropdownfielddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/dropdownformfielddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/editbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/editcategories.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/editfielddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/editsectiondialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/endnotepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/envaddresspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/envdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/envformatpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/envprinterpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/exchangedatabases.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/fielddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/findentrydialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/flddbpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/flddocinfopage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/flddocumentpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/fldfuncpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/fldrefpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/fldvarpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/floatingsync.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/footendnotedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/footnoteareapage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/footnotepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/footnotesendnotestabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/formatsectiondialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/formattablepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/formdropdown.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/framedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/frmaddpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/frmtypepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/frmurlpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/gotopagedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/hfmenubutton.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/indentpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/indexentry.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/infonotfounddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/inforeadonlydialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/inputeditbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/inputfielddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/inputwinmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/insertautotextdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/insertbookmark.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/insertbreak.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/insertcaption.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/insertdbcolumnsdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/insertfootnote.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/insertscript.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/insertsectiondialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/inserttable.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/jumpposbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/labeldialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/labelformatpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/labeloptionspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/linenumbering.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mailconfigpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mailmergedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mailmerge.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/managechangessidebar.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mastercontextmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mergeconnectdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mergetabledialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mmaddressblockpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mmcreatingdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mmlayoutpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mmmailbody.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mmoutputtypepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mmresultemaildialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mmresultprintdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mmresultsavedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mmsalutationpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mmselectpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/mmsendmails.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/navigatorcontextmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/navigatorpanel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/newuserindexdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/notebookbar_compact.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/notebookbar_groupedbar_compact.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/notebookbar_groupedbar_full.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/notebookbar_groups.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/notebookbar_online.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/notebookbar_single.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/notebookbar.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/numberingnamedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/numparapage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/objectdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/optcaptionpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/optcomparison.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/optcompatpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/optfonttabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/optformataidspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/optgeneralpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/optredlinepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/opttablepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/opttestpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/outlinebutton.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/outlinenumberingpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/outlinenumbering.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/outlinepositionpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/pagecolumncontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/pagefooterpanel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/pageformatpanel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/pageheaderpanel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/pagemargincontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/pageorientationcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/pagesizecontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/pagestylemenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/pagestylespanel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/paradialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/pbmenubutton.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/picturedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/picturepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/poseditbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/previewmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/previewzoomdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/printeroptions.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/printmergedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/printmonitordialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/printoptionspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/privateuserpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/querycontinuebegindialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/querycontinueenddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/querydefaultcompatdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/queryredlinedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/querysavelabeldialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/readonlymenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/renameautotextdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/renameentrydialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/renameobjectdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/rowheight.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/saveashtmldialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/savelabeldialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/savemonitordialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/sectionpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/selectaddressdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/selectautotextdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/selectblockdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/selectindexdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/selecttabledialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/sidebarstylepresets.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/sidebartableedit.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/sidebartheme.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/sidebarwrap.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/sortdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/spellmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/splittable.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/statisticsinfopage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/stringinput.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/subjectdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/tablecolumnpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/tablepreviewdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/tableproperties.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/tabletextflowpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/templatedialog16.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/templatedialog1.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/templatedialog2.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/templatedialog4.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/templatedialog8.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/testmailsettings.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/textgridpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/titlepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/tocdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/tocentriespage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/tocindexpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/tocstylespage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/tokenwidget.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/toxbuttonwidget.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/toxentrywidget.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/unfloatbutton.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/viewoptionspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/warndatasourcedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/warnemaildialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/watermarkdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/wordcount-mobile.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/wordcount.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/wrapdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/wrappage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swriter/ui/zoombox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/menubar/menubar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/anchor.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/annotation.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/drawtext.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/draw.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/formrichtext.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/form.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/frame.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/graphic.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/insertfield.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/media.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/oleobject.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/preview.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/showtrackedchanges.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/table.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/popupmenu/text.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/statusbar/statusbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/alignmentbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/arrowshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/basicshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/bezierobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/calloutshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/colorbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/drawbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/drawingobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/drawtextobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/extrusionobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/findbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/flowchartshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/fontworkobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/fontworkshapetype.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/formcontrols.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/formdesign.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/formsfilterbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/formsnavigationbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/formtextobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/frameobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/fullscreenbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/graffilterbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/graphicobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/insertbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/insertobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/mailmerge.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/mediaobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/numobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/oleobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/optimizetablebar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/previewobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/standardbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/starshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/symbolshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/tableobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/textobjectbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/toolbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/swxform/toolbar/viewerbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/addtargetdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/alienwarndialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/autoredactdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/bookmarkdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/bookmarkmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/charmapcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/charviewmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/checkin.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/classificationbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/cmisinfopage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/cmisline.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/commandpopup.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/custominfopage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/deck.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/descriptioninfopage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/developmenttool.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/devtoolsmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/documentfontspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/documentinfopage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/documentpropertiesdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/editdocumentdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/editdurationdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/emojicontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/errorfindemaildialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/extrabutton.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/floatingrecord.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/helpbookmarkpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/helpcontentpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/helpcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/helpindexpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/helpmanual.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/helpsearchpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/helpwindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/infobar.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/inputdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/licensedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/linefragment.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/linkeditdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/loadtemplatedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/managestylepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/navigator.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/newstyle.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/notebookbarpopup.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/notebookbar.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/optprintpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/panel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/password.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/printeroptionsdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/querysavedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/safemodequerydialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/saveastemplatedlg.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/searchdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/securityinfopage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/singletabdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/startcenter.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/stylecontextmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/tabbarcontents.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/tabbar.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/tabbutton.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/templatecategorydlg.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/templatedlg.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/templatepanel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/urlbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/versioncommentdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/versionscmis.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/sfx/ui/versionsofdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/addresstemplatedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/calendar.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/checkboxcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/combocontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/datewindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/editcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/emptypage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/fileviewmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/fixedimagecontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/fixedtextcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/graphicexport.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/inputbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/interimparent.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/javadisableddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/linewindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/listcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/managedtoolbar.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/placeedit.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/printersetupdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/querydeletedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/restartdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/spinfieldcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/subtoolbar.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/tabbaredit.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/tabbuttonsmirrored.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/tabbuttons.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/textviewcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svt/ui/thineditcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/absrecbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/acceptrejectchangesdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/accessibilitycheckdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/accessibilitycheckentry.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/addconditiondialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/adddataitemdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/addinstancedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/addmodeldialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/addnamespacedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/addsubmissiondialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/applystylebox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/asianphoneticguidedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/cellmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/charsetmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/checkbuttonbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/chineseconversiondialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/chinesedictionary.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/classificationdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/clipboardmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/colorwindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/colsmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/columnswindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/compressgraphicdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/crashreportdlg.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/currencywindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/datanavigator.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/defaultshapespanel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/deletefooterdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/deleteheaderdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/depthwindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/directionwindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/docking3deffects.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/dockingcolorreplace.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/dockingcolorwindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/dockingfontwork.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/docrecoverybrokendialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/docrecoveryprogressdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/docrecoveryrecoverdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/docrecoverysavedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/extrustiondepthdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/fileexporteddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/fillctrlbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/filtermenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/filternavigator.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/findbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/findreplacedialog-mobile.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/findreplacedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/floatingareastyle.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/floatingcontour.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/floatingframeborder.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/floatinglineend.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/floatinglineproperty.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/floatinglinestyle.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/floatingundoredo.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/fontnamebox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/fontsizebox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/fontworkalignmentcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/fontworkcharacterspacingcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/fontworkgallerydialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/fontworkspacingdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/formdatamenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/formfielddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/formlinkwarndialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/formnavigator.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/formnavimenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/formpropertydialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/functionmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/gallerymenu1.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/gallerymenu2.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/grafctrlbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/grafmodebox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/headfootformatpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/imapdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/imapmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/inspectortextpanel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/labelbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/lightingwindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/linkwarndialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/measurewidthbar.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/medialine.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/mediaplayback.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/mediawindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/metricfieldbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/namespacedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/navigationbar.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/numberingwindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/optgridpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/paralinespacingcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/paralrspacing.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/paraulspacing.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/passwd.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/presetmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/querydeletecontourdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/querydeleteobjectdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/querydeletethemedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/querymodifyimagemapchangesdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/querynewcontourdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/querysavecontchangesdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/querysaveimagemapchangesdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/queryunlinkgraphicsdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/redlinecontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/redlinefilterpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/redlineviewpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/rowsmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/rulermenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/safemodedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/savemodifieddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/selectionmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebararea.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebareffect.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebarempty.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebarfontwork.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebargallery.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebargraphic.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebarline.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebarlists.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebarparagraph.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebarpossize.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebarshadow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebarstylespanel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebartextcolumnspanel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/sidebartextpanel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/stylemenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/stylespreview.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/surfacewindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/tablewindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/textcharacterspacingcontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/textcontrolchardialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/textcontrolparadialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/textunderlinecontrol.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/toolbarpopover.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/xformspage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/xmlsecstatmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/svx/ui/zoommenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/uui/ui/authfallback.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/uui/ui/filterselect.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/uui/ui/logindialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/uui/ui/macrowarnmedium.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/uui/ui/masterpassworddlg.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/uui/ui/password.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/uui/ui/setmasterpassworddlg.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/uui/ui/simplenameclash.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/uui/ui/sslwarndialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/uui/ui/unknownauthdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/aboutbox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/combobox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/cupspassworddialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/dockingwindow.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/editmenu.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/errornocontentdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/errornoprinterdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/interimdockparent.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/interimtearableparent.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/menutogglebutton3.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/menutogglebutton4.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/printdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/printerdevicepage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/printerpaperpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/printerpropertiesdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/printprogressdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/querydialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/screenshotparent.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/vcl/ui/wizard.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/writerperfect/ui/exportepub.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/writerperfect/ui/wpftencodingdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/xmlsec/ui/certdetails.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/xmlsec/ui/certgeneral.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/xmlsec/ui/certpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/xmlsec/ui/digitalsignaturesdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/xmlsec/ui/macrosecuritydialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/xmlsec/ui/securitylevelpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/xmlsec/ui/securitytrustpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/xmlsec/ui/selectcertificatedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/xmlsec/ui/viewcertdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/wizard/form/styles/beige.css \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/wizard/form/styles/bgr.css \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/wizard/form/styles/dark.css \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/wizard/form/styles/grey.css \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/wizard/form/styles/ibg.css \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/wizard/form/styles/ice.css \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/wizard/form/styles/orange.css \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/wizard/form/styles/red.css \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/wizard/form/styles/violet.css \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/wizard/form/styles/water.css \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/fonts/truetype/fc_local.conf \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/gallery/fontwork.sdg \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/gallery/fontwork.sdv \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/gallery/fontwork.thm \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/registry/cjk.xcd \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/registry/ctlseqcheck.xcd \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/registry/ctl.xcd \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/registry/graphicfilter.xcd \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/registry/Langpack-en-US.xcd \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/registry/lingucomponent.xcd \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/registry/main.xcd \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/registry/res/fcfg_langpack_en-US.xcd \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/registry/res/registry_en-US.xcd \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/registry/writer.xcd \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/registry/xsltfilter.xcd \
    $(INSTROOT)/$(LIBO_SHARE_PRESETS_FOLDER)/autotext/mytexts.bau \
    $(INSTROOT)/$(LIBO_SHARE_PRESETS_FOLDER)/basic/dialog.xlc \
    $(INSTROOT)/$(LIBO_SHARE_PRESETS_FOLDER)/basic/script.xlc \
    $(INSTROOT)/$(LIBO_SHARE_PRESETS_FOLDER)/basic/Standard/dialog.xlb \
    $(INSTROOT)/$(LIBO_SHARE_PRESETS_FOLDER)/basic/Standard/Module1.xba \
    $(INSTROOT)/$(LIBO_SHARE_PRESETS_FOLDER)/basic/Standard/script.xlb \
    $(INSTROOT)/$(LIBO_SHARE_PRESETS_FOLDER)/config/autotbl.fmt \
    $(INSTROOT)/$(LIBO_SHARE_PRESETS_FOLDER)/gallery/sg30.sdv \
    $(INSTROOT)/$(LIBO_SHARE_PRESETS_FOLDER)/gallery/sg30.thm \
    $(INSTROOT)/$(LIBO_SHARE_RESOURCE_FOLDER)/common/fonts/opens___.ttf \
    $(INSTROOT)/$(LIBO_URE_ETC_FOLDER)/$(call gb_Helper_get_rcfile,uno) \
    $(INSTROOT)/$(LIBO_URE_MISC_FOLDER)/services.rdb \
    $(SRCDIR)/android/default-document/example.odt \

ifneq ($(ENABLE_WASM_STRIP_CHART),TRUE)
gb_emscripten_fs_image_files += \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/menubar/menubar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/popupmenu/drawtext.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/popupmenu/draw.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/statusbar/statusbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/toolbar/arrowshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/toolbar/basicshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/toolbar/calloutshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/toolbar/drawbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/toolbar/flowchartshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/toolbar/standardbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/toolbar/starshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/toolbar/symbolshapes.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/toolbar/toolbar.xml \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/3dviewdialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/attributedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/chardialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/chartdatadialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/charttypedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/columnfragment.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/combobox.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/datarangedialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/dlg_DataLabel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/dlg_InsertErrorBars.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/dlg_InsertLegend.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/imagefragment.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/insertaxisdlg.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/insertgriddlg.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/inserttitledlg.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/paradialog.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/sidebaraxis.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/sidebarelements.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/sidebarerrorbar.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/sidebarseries.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/sidebartype.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/smoothlinesdlg.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/steppedlinesdlg.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/titlerotationtabpage.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_3D_SceneAppearance.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_3D_SceneGeometry.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_3D_SceneIllumination.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_axisLabel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_AxisPositions.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_ChartType.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_DataLabel.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_DataPointOption.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_DataSource.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_ErrorBars.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_LegendPosition.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_PolarOptions.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_RangeChooser.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_Scale.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_SeriesToAxis.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/tp_Trendline.ui \
    $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/soffice.cfg/modules/schart/ui/wizelementspage.ui \

endif # !ENABLE_WASM_STRIP_CHART

$(foreach theme,$(WITH_THEMES), \
    $(eval gb_emscripten_fs_image_files += $(INSTROOT)/$(LIBO_SHARE_FOLDER)/config/images_$(theme).zip))

ifeq ($(WITH_FONTS),TRUE)
gb_emscripten_fs_image_autoinstall += $(call gb_AutoInstall_get_target,ooo_fonts)
endif

gb_emscripten_fs_image_filelists += $(call gb_Package_get_target,liblangtag_data)
gb_emscripten_fs_image_filelists += $(call gb_Package_get_target,fontconfig_data)

#
# Ruleset
#

emscripten_fs_image_WORKDIR := $(call gb_CustomTarget_get_workdir,static/emscripten_fs_image)

# we just need data.js.link at link time, which is equal to soffice.data.js
$(call gb_CustomTarget_get_target,static/emscripten_fs_image): \
    $(emscripten_fs_image_WORKDIR)/soffice.data \
    $(emscripten_fs_image_WORKDIR)/soffice.data.js.link \
    $(emscripten_fs_image_WORKDIR)/soffice.data.js.metadata \

$(emscripten_fs_image_WORKDIR)/soffice.data $(emscripten_fs_image_WORKDIR)/soffice.data.js : $(emscripten_fs_image_WORKDIR)/soffice.data.js.metadata

.PRECIOUS: $(emscripten_fs_image_WORKDIR)/soffice.data.js.link
$(emscripten_fs_image_WORKDIR)/soffice.data.js.link: $(emscripten_fs_image_WORKDIR)/soffice.data.js
	$(call gb_Helper_copy_if_different_and_touch,$^,$@)

.PHONY: $(emscripten_fs_image_WORKDIR)/soffice.data.concat_lists
$(emscripten_fs_image_WORKDIR)/soffice.data.concat_lists: $(gb_emscripten_fs_image_filelists) $(gb_emscripten_fs_image_autoinstall)
	$(shell cat $(gb_emscripten_fs_image_filelists) >> $@.tmp)
	$(foreach list,$(shell sed -ne 's/PACKAGE_FILELIST.*,//' -e 's/.filelist.$$//p' $(gb_emscripten_fs_image_autoinstall)), \
	    $(shell cat $(call gb_Package_get_target,$(list)) >> $@.tmp))
	$(shell mv $@.tmp $@)

gb_emscripten_fs_image_all_files = $(gb_emscripten_fs_image_files) $(shell cat $(emscripten_fs_image_WORKDIR)/soffice.data.concat_lists)

.PHONY: $(emscripten_fs_image_WORKDIR)/soffice.data.filelist
$(emscripten_fs_image_WORKDIR)/soffice.data.filelist: \
		$(call gb_InstallModule_get_target,scp2/ooo) \
		$(emscripten_fs_image_WORKDIR)/soffice.data.concat_lists \
		$(gb_emscripten_fs_image_files) \
		| $(emscripten_fs_image_WORKDIR)/.dir
	TEMPFILE=$(call gb_var2file,$(shell $(gb_MKTEMP)),1,\
	    $(subst @,@@,$(subst $(BUILDDIR)/,,$(filter $(BUILDDIR)%,$(gb_emscripten_fs_image_all_files)))) \
	    $(foreach item,$(filter-out $(BUILDDIR)%,$(gb_emscripten_fs_image_all_files)),$(subst @,@@,$(item))@$(subst @,@@,$(subst $(SRCDIR)/,,$(item))))) \
	&& mv $$TEMPFILE $@

# Unfortunately the file packager just allows a cmdline file list, but all paths are
# relative to $(BUILDDIR), so we won't run out of cmdline space that fast...
$(emscripten_fs_image_WORKDIR)/soffice.data.js.metadata: $(emscripten_fs_image_WORKDIR)/soffice.data.filelist
	$(call gb_Output_announce,$(subst $(BUILDDIR)/,,$(emscripten_fs_image_WORKDIR)/soffice.data),$(true),GEN,2)
	$(EMSDK_FILE_PACKAGER) $(emscripten_fs_image_WORKDIR)/soffice.data --preload $(shell cat $^) --js-output=$(emscripten_fs_image_WORKDIR)/soffice.data.js --separate-metadata \
	    || rm -f $(emscripten_fs_image_WORKDIR)/soffice.data.js $(emscripten_fs_image_WORKDIR)/soffice.data $(emscripten_fs_image_WORKDIR)/soffice.data.js.metadata

# vim: set noet sw=4:
