/*
 * Copyright (C) 2012,2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Michael Terry <michael.terry@canonical.com>
 *          Iain Lane <iain.lane@canonical.com>
 */

#ifndef SECURITYPRIVACY_H
#define SECURITYPRIVACY_H

#include <QDBusServiceWatcher>
#include <QStringList>
#include <QtDBus/QDBusInterface>
#include <QtCore/QMap>
#include <QtCore/QObject>
#include <QtCore/QSettings>
#include <QtCore/QString>

#include "accountsservice.h"

class SecurityPrivacy: public QObject
{
    Q_OBJECT
    Q_ENUMS(SecurityType)
    Q_PROPERTY (bool enableFingerprintIdentification
                READ getEnableFingerprintIdentification
                WRITE setEnableFingerprintIdentification
                NOTIFY enableFingerprintIdentificationChanged)
    Q_PROPERTY (bool statsWelcomeScreen
                READ getStatsWelcomeScreen
                WRITE setStatsWelcomeScreen
                NOTIFY statsWelcomeScreenChanged)
    Q_PROPERTY (bool messagesWelcomeScreen
                READ getMessagesWelcomeScreen
                WRITE setMessagesWelcomeScreen
                NOTIFY messagesWelcomeScreenChanged)
    Q_PROPERTY (bool enableLauncherWhileLocked
                READ getEnableLauncherWhileLocked
                WRITE setEnableLauncherWhileLocked
                NOTIFY enableLauncherWhileLockedChanged)
    Q_PROPERTY (bool enableIndicatorsWhileLocked
                READ getEnableIndicatorsWhileLocked
                WRITE setEnableIndicatorsWhileLocked
                NOTIFY enableIndicatorsWhileLockedChanged)
    Q_PROPERTY (bool hideNotificationContentWhileLocked
                READ getHideNotificationContentWhileLocked
                WRITE setHideNotificationContentWhileLocked
                NOTIFY hideNotificationContentWhileLockedChanged)
    Q_PROPERTY (SecurityType securityType
                READ getSecurityType
                NOTIFY securityTypeChanged)
    Q_PROPERTY (bool hereEnabled
                READ hereEnabled
                WRITE setHereEnabled
                NOTIFY hereEnabledChanged)
    Q_PROPERTY (QString hereLicensePath
                READ hereLicensePath
                NOTIFY hereLicensePathChanged)
    Q_PROPERTY (QString pinCodePromptManager
                READ pinCodePromptManager
                WRITE setPinCodePromptManager
                NOTIFY pinCodePromptManagerChanged)


public:
    enum SecurityType {
         Swipe,
         Passcode,
         Passphrase,
         Fingerprint
    };

    explicit SecurityPrivacy(QObject *parent = 0);
    virtual ~SecurityPrivacy();

    bool getEnableFingerprintIdentification();
    void setEnableFingerprintIdentification(bool enabled);
    bool getStatsWelcomeScreen();
    void setStatsWelcomeScreen(bool enabled);
    bool getMessagesWelcomeScreen();
    void setMessagesWelcomeScreen(bool enabled);
    bool getEnableLauncherWhileLocked();
    void setEnableLauncherWhileLocked(bool enabled);
    bool getEnableIndicatorsWhileLocked();
    void setEnableIndicatorsWhileLocked(bool enabled);
    bool getHideNotificationContentWhileLocked();
    void setHideNotificationContentWhileLocked(bool enabled);
    SecurityType getSecurityType();

    bool hereEnabled();
    void setHereEnabled(bool enabled);
    QString hereLicensePath();

    QString pinCodePromptManager();
    void setPinCodePromptManager(QString value);

    // Returns error text, if an error occurred
    Q_INVOKABLE QString setSecurity(QString oldValue, QString value, SecurityType type);

public Q_SLOTS:
    void slotChanged(QString, QString);
    void slotNameOwnerChanged();

Q_SIGNALS:
    void enableFingerprintIdentificationChanged();
    void statsWelcomeScreenChanged();
    void messagesWelcomeScreenChanged();
    void enableLauncherWhileLockedChanged();
    void enableIndicatorsWhileLockedChanged();
    void securityTypeChanged();
    void hereEnabledChanged();
    void hereLicensePathChanged();
    void hideNotificationContentWhileLockedChanged();
    void pinCodePromptManagerChanged();

private:
    void loadUser();


    QString badPasswordMessage(SecurityType type);
    bool setDisplayHint(SecurityType type);
    bool setPasswordMode(SecurityType type);
    bool setPasswordModeWithPolicykit(SecurityType type, QString password);
    QString setPassword(QString oldValue, QString value);

    LomiriSystemSettings::AccountsService m_accountsService;
    QString m_username;
};

#endif //SECURITYPRIVACY_H
