; RUN: llc -mtriple=hexagon -O0 < %s | FileCheck %s
; RUN: llc -mtriple=hexagon -O0 < %s | FileCheck -check-prefix=CHECK-CALL %s
; Hexagon Programmer's Reference Manual 11.10.7 XTYPE/PRED

; CHECK-CALL-NOT: call

; Compare byte
declare i32 @llvm.hexagon.A4.cmpbgt(i32, i32)
define i32 @A4_cmpbgt(i32 %a, i32 %b) {
  %z = call i32 @llvm.hexagon.A4.cmpbgt(i32 %a, i32 %b)
  ret i32 %z
}
; CHECK: = cmpb.gt({{.*}},{{.*}})

declare i32 @llvm.hexagon.A4.cmpbeq(i32, i32)
define i32 @A4_cmpbeq(i32 %a, i32 %b) {
  %z = call i32 @llvm.hexagon.A4.cmpbeq(i32 %a, i32 %b)
  ret i32 %z
}
; CHECK: = cmpb.eq({{.*}},{{.*}})

declare i32 @llvm.hexagon.A4.cmpbgtu(i32, i32)
define i32 @A4_cmpbgtu(i32 %a, i32 %b) {
  %z = call i32 @llvm.hexagon.A4.cmpbgtu(i32 %a, i32 %b)
  ret i32 %z
}
; CHECK: = cmpb.gtu({{.*}},{{.*}})

declare i32 @llvm.hexagon.A4.cmpbgti(i32, i32)
define i32 @A4_cmpbgti(i32 %a) {
  %z = call i32 @llvm.hexagon.A4.cmpbgti(i32 %a, i32 0)
  ret i32 %z
}
; CHECK: = cmpb.gt({{.*}},#0)

declare i32 @llvm.hexagon.A4.cmpbeqi(i32, i32)
define i32 @A4_cmpbeqi(i32 %a) {
  %z = call i32 @llvm.hexagon.A4.cmpbeqi(i32 %a, i32 0)
  ret i32 %z
}
; CHECK: = cmpb.eq({{.*}},#0)

declare i32 @llvm.hexagon.A4.cmpbgtui(i32, i32)
define i32 @A4_cmpbgtui(i32 %a) {
  %z = call i32 @llvm.hexagon.A4.cmpbgtui(i32 %a, i32 0)
  ret i32 %z
}
; CHECK: = cmpb.gtu({{.*}},#0)

; Compare half
declare i32 @llvm.hexagon.A4.cmphgt(i32, i32)
define i32 @A4_cmphgt(i32 %a, i32 %b) {
  %z = call i32 @llvm.hexagon.A4.cmphgt(i32 %a, i32 %b)
  ret i32 %z
}
; CHECK: = cmph.gt({{.*}},{{.*}})

declare i32 @llvm.hexagon.A4.cmpheq(i32, i32)
define i32 @A4_cmpheq(i32 %a, i32 %b) {
  %z = call i32 @llvm.hexagon.A4.cmpheq(i32 %a, i32 %b)
  ret i32 %z
}
; CHECK: = cmph.eq({{.*}},{{.*}})

declare i32 @llvm.hexagon.A4.cmphgtu(i32, i32)
define i32 @A4_cmphgtu(i32 %a, i32 %b) {
  %z = call i32 @llvm.hexagon.A4.cmphgtu(i32 %a, i32 %b)
  ret i32 %z
}
; CHECK: = cmph.gtu({{.*}},{{.*}})

declare i32 @llvm.hexagon.A4.cmphgti(i32, i32)
define i32 @A4_cmphgti(i32 %a) {
  %z = call i32 @llvm.hexagon.A4.cmphgti(i32 %a, i32 0)
  ret i32 %z
}
; CHECK: = cmph.gt({{.*}},#0)

declare i32 @llvm.hexagon.A4.cmpheqi(i32, i32)
define i32 @A4_cmpheqi(i32 %a) {
  %z = call i32 @llvm.hexagon.A4.cmpheqi(i32 %a, i32 0)
  ret i32 %z
}
; CHECK: = cmph.eq({{.*}},#0)

declare i32 @llvm.hexagon.A4.cmphgtui(i32, i32)
define i32 @A4_cmphgtui(i32 %a) {
  %z = call i32 @llvm.hexagon.A4.cmphgtui(i32 %a, i32 0)
  ret i32 %z
}
; CHECK: = cmph.gtu({{.*}},#0)

; Compare doublewords
declare i32 @llvm.hexagon.C2.cmpgtp(i64, i64)
define i32 @C2_cmpgtp(i64 %a, i64 %b) {
  %z = call i32 @llvm.hexagon.C2.cmpgtp(i64 %a, i64 %b)
  ret i32 %z
}
; CHECK: = cmp.gt({{.*}},{{.*}})

declare i32 @llvm.hexagon.C2.cmpeqp(i64, i64)
define i32 @C2_cmpeqp(i64 %a, i64 %b) {
  %z = call i32 @llvm.hexagon.C2.cmpeqp(i64 %a, i64 %b)
  ret i32 %z
}
; CHECK: = cmp.eq({{.*}},{{.*}})

declare i32 @llvm.hexagon.C2.cmpgtup(i64, i64)
define i32 @C2_cmpgtup(i64 %a, i64 %b) {
  %z = call i32 @llvm.hexagon.C2.cmpgtup(i64 %a, i64 %b)
  ret i32 %z
}
; CHE