; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=ipsccp -S %s | FileCheck %s

declare i8 @llvm.abs.i8(i8, i1)
declare <2 x i8> @llvm.abs.v2i8(<2 x i8>, i1)
declare i8 @llvm.umax.i8(i8, i8)

declare void @use(i1)
declare void @use_vec(<2 x i1>)

define void @abs1(ptr %p) {
; CHECK-LABEL: @abs1(
; CHECK-NEXT:    [[X:%.*]] = load i8, ptr [[P:%.*]], align 1, !range [[RNG0:![0-9]+]]
; CHECK-NEXT:    [[ABS:%.*]] = call i8 @llvm.abs.i8(i8 [[X]], i1 false)
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[CMP3:%.*]] = icmp sge i8 [[ABS]], 1
; CHECK-NEXT:    call void @use(i1 [[CMP3]])
; CHECK-NEXT:    [[CMP4:%.*]] = icmp slt i8 [[ABS]], 9
; CHECK-NEXT:    call void @use(i1 [[CMP4]])
; CHECK-NEXT:    ret void
;
  %x = load i8, ptr %p, !range !{i8 -9, i8 10}
  %abs = call i8 @llvm.abs.i8(i8 %x, i1 false)
  %cmp1 = icmp sge i8 %abs, 0
  call void @use(i1 %cmp1)
  %cmp2 = icmp slt i8 %abs, 10
  call void @use(i1 %cmp2)
  %cmp3 = icmp sge i8 %abs, 1
  call void @use(i1 %cmp3)
  %cmp4 = icmp slt i8 %abs, 9
  call void @use(i1 %cmp4)
  ret void
}

; Even if we don't know anything about the input range of the operand,
; we still know something about the result range of abs().
define void @abs2(i8 %x) {
; CHECK-LABEL: @abs2(
; CHECK-NEXT:    [[ABS:%.*]] = call i8 @llvm.abs.i8(i8 [[X:%.*]], i1 true)
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    ret void
;
  %abs = call i8 @llvm.abs.i8(i8 %x, i1 true)
  %cmp = icmp sge i8 %abs, 0
  call void @use(i1 %cmp)
  ret void
}

define void @abs2_vec(<2 x i8> %x) {
; CHECK-LABEL: @abs2_vec(
; CHECK-NEXT:    [[ABS:%.*]] = call <2 x i8> @llvm.abs.v2i8(<2 x i8> [[X:%.*]], i1 true)
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge <2 x i8> [[ABS]], zeroinitializer
; CHECK-NEXT:    call void @use_vec(<2 x i1> [[CMP]])
; CHECK-NEXT:    ret void
;
  %abs = call <2 x i8> @llvm.abs.v2i8(<2 x i8> %x, i1 true)
  %cmp = icmp sge <2 x i8> %abs, zeroinitializer
  call void @use_vec(<2 x i1> %cmp)
  ret void
}

define void @umax1(ptr %p1, ptr %p2) {
; CHECK-LABEL: @umax1(
; CHECK-NEXT:    [[X1:%.*]] = load i8, ptr [[P1:%.*]], align 1, !range [[RNG1:![0-9]+]]
; CHECK-NEXT:    [[X2:%.*]] = load i8, ptr [[P2:%.*]], align 1, !range [[RNG2:![0-9]+]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X1]], i8 [[X2]])
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[CMP3:%.*]] = icmp uge i8 [[M]], 6
; CHECK-NEXT:    call void @use(i1 [[CMP3]])
; CHECK-NEXT:    [[CMP4:%.*]] = icmp ult i8 [[M]], 14
; CHECK-NEXT:    call void @use(i1 [[CMP4]])
; CHECK-NEXT:    ret void
;
  %x1 = load i8, ptr %p1, !range !{i8 0, i8 10}
  %x2 = load i8, ptr %p2, !range !{i8 5, i8 15}
  %m = call i8 @llvm.umax.i8(i8 %x1, i8 %x2)
  %cmp1 = icmp uge i8 %m, 5
  call void @use(i1 %cmp1)
  %cmp2 = icmp ult i8 %m, 15
  call void @use(i1 %cmp2)
  %cmp3 = icmp uge i8 %m, 6
  call void @use(i1 %cmp3)
  %cmp4 = icmp ult i8 %m, 14
  call void @use(i1 %cmp4)
  ret void
}

define void @umax2(i8 %x) {
; CHECK-LABEL: @umax2(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X:%.*]], i8 10)
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    ret void
;
  %m = call i8 @llvm.umax.i8(i8 %x, i8 10)
  %cmp = icmp uge i8 %m, 10
  call void @use(i1 %cmp)
  ret void
}

define i8 @umax_including_undef(i1 %c.1, i1 %c.2) {
; CHECK-LABEL: @umax_including_undef(
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       false:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret i8 3
;
  br i1 %c.1, label %true, label %false

true:
  br label %exit

false:
  br label %exit

exit:
  %p = phi i8 [ 3, %true], [ undef, %false ]
  %p_umax = call i8 @llvm.umax.i8(i8 %p, i8 1)
  ret i8 %p_umax
}

define <4 x i32> @pr63380(<4 x i32> %input) {
; CHECK-LABEL: @pr63380(
; CHECK-NEXT:    [[CTLZ_1:%.*]] = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> [[INPUT:%.*]], i1 false)
; CHECK-NEXT:    [[CTLZ_2:%.*]] = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> [[CTLZ_1]], i1 true)
; CHECK-NEXT:    ret <4 x i32> <i32 27, i32 27, i32 27, i32 27>
;
  %ctlz.1 = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %input, i1 false)
  %ctlz.2 = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %ctlz.1, i1 true)
  %ctlz.3 = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %ctlz.2, i1 true)
  ret <4 x i32> %ctlz.3
}

declare <4 x i32> @llvm.ctlz.v4i32(<4 x i32>, i1 immarg)
