; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=memcpyopt -S %s -verify-memoryssa | FileCheck %s

%T = type { i8, i32 }

; A global constant of %T
@C = external constant %T

; Ensure load-store forwarding of an aggregate is interpreted as
; a memmove when the source and dest may alias
define void @test_memmove(ptr align 8 %a, ptr align 16 %b) {
; CHECK-LABEL: @test_memmove(
; CHECK-NEXT:    call void @llvm.memmove.p0.p0.i64(ptr align 16 [[B:%.*]], ptr align 8 [[A:%.*]], i64 8, i1 false)
; CHECK-NEXT:    ret void
;
  %val = load %T, ptr %a, align 8
  store %T %val, ptr %b, align 16
  ret void
}

; Ensure load-store forwarding of an aggregate is interpreted as
; a memcpy when the source and dest do not alias
define void @test_memcpy(ptr noalias align 8 %a, ptr noalias align 16 %b) {
; CHECK-LABEL: @test_memcpy(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[B:%.*]], ptr align 8 [[A:%.*]], i64 8, i1 false)
; CHECK-NEXT:    ret void
;
  %val = load %T, ptr %a, align 8
  store %T %val, ptr %b, align 16
  ret void
}

define void @test_memcpy_constant(ptr %d) {
; CHECK-LABEL: @test_memcpy_constant(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[D:%.*]], ptr align 8 @C, i64 8, i1 false)
; CHECK-NEXT:    ret void
;
  %val = load %T, ptr @C, align 8
  store %T %val, ptr %d, align 16
  ret void
}

; memcpy(%d, %a) should not be generated since store2 may-aliases load %a.
define void @f(ptr %a, ptr %b, ptr %c, ptr %d) {
; CHECK-LABEL: @f(
; CHECK-NEXT:    [[VAL:%.*]] = load [[T:%.*]], ptr [[A:%.*]], align 4, !alias.scope !0
; CHECK-NEXT:    store [[T]] { i8 23, i32 23 }, ptr [[B:%.*]], align 4, !alias.scope !3
; CHECK-NEXT:    store [[T]] { i8 44, i32 44 }, ptr [[C:%.*]], align 4, !alias.scope !6, !noalias !3
; CHECK-NEXT:    store [[T]] [[VAL]], ptr [[D:%.*]], align 4, !alias.scope !9, !noalias !12
; CHECK-NEXT:    ret void
;
  %val = load %T, ptr %a, !alias.scope !{!10}

  ; store1 may-aliases the load
  store %T { i8 23, i32 23 }, ptr %b, !alias.scope !{!11}

  ; store2 may-aliases the load and store3
  store %T { i8 44, i32 44 }, ptr %c, !alias.scope !{!12}, !noalias !{!11}

  ; store3
  store %T %val, ptr %d, !alias.scope !{!13}, !noalias !{!10, !11}
  ret void
}

!0 = !{!0}
!1 = !{!1}
!2 = !{!2}
!3 = !{!3}

!10 = !{ !10, !0 }
!11 = !{ !11, !1 }
!12 = !{ !12, !2 }
!13 = !{ !13, !3 }
