; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals --include-generated-funcs
; RUN: opt -S -passes=iroutliner -ir-outlining-no-cost < %s | FileCheck %s

; This is a test to ensure that when the first instruction is a commutative
; instruction, but the order of operands is reversed, we pass the arguments
; in the correct order, such that we do not use the wrong arguments
; later on in the computation.

define void @fish(i32 %0, i32 %1, i32 %2) {
entry:
  %3 = add nsw i32 %0, %1
  %4 = sub nsw i32 %1, %2
  %5 = sub nsw i32 %0, %2
  ret void
}

define void @turtle(i32 %0, i32 %1, i32 %2) {
  %4 = add nsw i32 %1, %0
  %5 = sub nsw i32 %1, %2
  %6 = sub nsw i32 %0, %2
  ret void
}
; CHECK-LABEL: @fish(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @outlined_ir_func_0(i32 [[TMP0:%.*]], i32 [[TMP1:%.*]], i32 [[TMP2:%.*]])
; CHECK-NEXT:    ret void
;
;
; CHECK-LABEL: @turtle(
; CHECK-NEXT:    call void @outlined_ir_func_0(i32 [[TMP0:%.*]], i32 [[TMP1:%.*]], i32 [[TMP2:%.*]])
; CHECK-NEXT:    ret void
;
;
; CHECK: @outlined_ir_func_0(i32 [[TMP0:%.*]], i32 [[TMP1:%.*]], i32 [[TMP2:%.*]])
; CHECK:       entry_to_outline:
; CHECK-NEXT:    [[TMP3:%.*]] = add nsw i32 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[TMP4:%.*]] = sub nsw i32 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP5:%.*]] = sub nsw i32 [[TMP0]], [[TMP2]]
; CHECK-NEXT:    br label [[ENTRY_AFTER_OUTLINE_EXITSTUB:%.*]]
;
