; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -ipsccp %s | FileCheck %s

; Make sure IPSCCP does not assume %r < 256 for @f1. Undef is passed at a call
; site, which won't be eliminated.

define i1 @constant_and_undef(i64 %a) {
; CHECK-LABEL: @constant_and_undef(
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @f1(i64 undef)
; CHECK-NEXT:    br label [[BB1:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[C_2:%.*]] = call i1 @f1(i64 10)
; CHECK-NEXT:    br label [[BB2:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    [[RANGE:%.*]] = and i64 [[A:%.*]], 255
; CHECK-NEXT:    [[C_3:%.*]] = call i1 @f1(i64 [[RANGE]])
; CHECK-NEXT:    ret i1 true
;
  %c.1 = call i1 @f1(i64 undef)
  br label %bb1

bb1:
  %c.2 = call i1 @f1(i64 10)
  br label %bb2

bb2:
  %range = and i64 %a, 255
  %c.3 = call i1 @f1(i64 %range)
  %r.1 = and i1 %c.1, %c.2
  %r.2 = and i1 %r.1, %c.3
  ret i1 %r.2
}

declare void @sideeffect(i1, i64 %a)

define internal i1 @f1(i64 %r) {
; CHECK-LABEL: define {{.*}} @f1(
; CHECK-NEXT:    call void @sideeffect(i1 true, i64 [[R:%.*]])
; CHECK-NEXT:    ret i1 undef
;
  %c = icmp ult i64 %r, 256
  call void @sideeffect(i1 %c, i64 %r)
  ret i1 %c
}
