; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32

define i32 @cttz_i32(i32 %a) {
; MIPS32-LABEL: cttz_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    not $1, $4
; MIPS32-NEXT:    addiu $2, $4, -1
; MIPS32-NEXT:    and $1, $1, $2
; MIPS32-NEXT:    ori $2, $zero, 32
; MIPS32-NEXT:    clz $1, $1
; MIPS32-NEXT:    subu $2, $2, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = call i32 @llvm.cttz.i32(i32 %a, i1 false)
  ret i32 %0
}
declare i32 @llvm.cttz.i32(i32, i1 immarg)

define i64 @cttz_i64(i64  %a) {
; MIPS32-LABEL: cttz_i64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    ori $3, $zero, 0
; MIPS32-NEXT:    sltiu $1, $4, 1
; MIPS32-NEXT:    not $2, $5
; MIPS32-NEXT:    addiu $5, $5, -1
; MIPS32-NEXT:    and $2, $2, $5
; MIPS32-NEXT:    ori $5, $zero, 32
; MIPS32-NEXT:    clz $2, $2
; MIPS32-NEXT:    subu $2, $5, $2
; MIPS32-NEXT:    addiu $2, $2, 32
; MIPS32-NEXT:    not $6, $4
; MIPS32-NEXT:    addiu $4, $4, -1
; MIPS32-NEXT:    and $4, $6, $4
; MIPS32-NEXT:    clz $4, $4
; MIPS32-NEXT:    subu $4, $5, $4
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    movn $4, $2, $1
; MIPS32-NEXT:    move $2, $4
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = call i64 @llvm.cttz.i64(i64 %a, i1 false)
  ret i64 %0
}
declare i64 @llvm.cttz.i64(i64, i1 immarg)


define i32 @ffs_i32_expansion(i32 %a) {
; MIPS32-LABEL: ffs_i32_expansion:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    ori $1, $zero, 0
; MIPS32-NEXT:    not $2, $4
; MIPS32-NEXT:    addiu $3, $4, -1
; MIPS32-NEXT:    and $2, $2, $3
; MIPS32-NEXT:    ori $3, $zero, 32
; MIPS32-NEXT:    clz $2, $2
; MIPS32-NEXT:    subu $2, $3, $2
; MIPS32-NEXT:    addiu $2, $2, 1
; MIPS32-NEXT:    sltiu $3, $4, 1
; MIPS32-NEXT:    andi $3, $3, 1
; MIPS32-NEXT:    movn $2, $1, $3
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = call i32 @llvm.cttz.i32(i32 %a, i1 true)
  %1 = add nuw nsw i32 %0, 1
  %iszero = icmp eq i32 %a, 0
  %ffs = select i1 %iszero, i32 0, i32 %1
  ret i32 %ffs
}

define i64 @ffs_i64_expansion(i64 %a) {
; MIPS32-LABEL: ffs_i64_expansion:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    ori $2, $zero, 0
; MIPS32-NEXT:    sltiu $3, $4, 1
; MIPS32-NEXT:    not $6, $5
; MIPS32-NEXT:    addiu $7, $5, -1
; MIPS32-NEXT:    and $6, $6, $7
; MIPS32-NEXT:    ori $7, $zero, 32
; MIPS32-NEXT:    clz $6, $6
; MIPS32-NEXT:    subu $6, $7, $6
; MIPS32-NEXT:    addiu $6, $6, 32
; MIPS32-NEXT:    not $8, $4
; MIPS32-NEXT:    addiu $9, $4, -1
; MIPS32-NEXT:    and $8, $8, $9
; MIPS32-NEXT:    clz $8, $8
; MIPS32-NEXT:    subu $7, $7, $8
; MIPS32-NEXT:    andi $3, $3, 1
; MIPS32-NEXT:    movn $7, $6, $3
; MIPS32-NEXT:    addiu $3, $7, 1
; MIPS32-NEXT:    sltu $1, $3, $1
; MIPS32-NEXT:    addiu $6, $2, 0
; MIPS32-NEXT:    andi $1, $1, 1
; MIPS32-NEXT:    addu $1, $6, $1
; MIPS32-NEXT:    xori $4, $4, 0
; MIPS32-NEXT:    xori $5, $5, 0
; MIPS32-NEXT:    or $4, $4, $5
; MIPS32-NEXT:    sltiu $4, $4, 1
; MIPS32-NEXT:    andi $4, $4, 1
; MIPS32-NEXT:    movn $3, $2, $4
; MIPS32-NEXT:    movn $1, $2, $4
; MIPS32-NEXT:    move $2, $3
; MIPS32-NEXT:    move $3, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = call i64 @llvm.cttz.i64(i64 %a, i1 true)
  %1 = add nuw nsw i64 %0, 1
  %iszero = icmp eq i64 %a, 0
  %ffs = select i1 %iszero, i64 0, i64 %1
  ret i64 %ffs
}
