/*
 * AM62X Clocks Info
 *
 * Copyright (C) 2022 Texas Instruments Incorporated - https://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <tisci.h>
#include <socinfo.h>

struct ti_sci_clocks_info am62x_clocks_info[] = {
	{166, 2, "DEV_A53SS0_A53_DIVH_CLK4_OBSCLK_OUT_CLK", "Output clock"},
	{166, 3, "DEV_A53SS0_COREPAC_ARM_CLK_CLK", "Input clock"},
	{166, 5, "DEV_A53SS0_PLL_CTRL_CLK", "Input clock"},
	{135, 0, "DEV_A53SS0_CORE_0_A53_CORE0_ARM_CLK_CLK", "Input clock"},
	{136, 0, "DEV_A53SS0_CORE_1_A53_CORE1_ARM_CLK_CLK", "Input clock"},
	{137, 0, "DEV_A53SS0_CORE_2_A53_CORE2_ARM_CLK_CLK", "Input clock"},
	{138, 0, "DEV_A53SS0_CORE_3_A53_CORE3_ARM_CLK_CLK", "Input clock"},
	{172, 0, "DEV_A53_RS_BW_LIMITER0_CLK_CLK", "Input clock"},
	{173, 0, "DEV_A53_WS_BW_LIMITER1_CLK_CLK", "Input clock"},
	{157, 0, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN", "Input muxed clock"},
	{157, 1, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 2, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 3, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 4, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 5, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 6, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 7, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_POSTDIV1_16FFT_MAIN_1_HSDIVOUT6_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 8, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT8_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 9, "DEV_BOARD0_AUDIO_EXT_REFCLK0_OUT", "Output clock"},
	{157, 10, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN", "Input muxed clock"},
	{157, 11, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 12, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 13, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 14, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 15, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 16, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 17, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_POSTDIV1_16FFT_MAIN_1_HSDIVOUT6_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 18, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT8_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 19, "DEV_BOARD0_AUDIO_EXT_REFCLK1_OUT", "Output clock"},
	{157, 20, "DEV_BOARD0_CLKOUT0_IN", "Input muxed clock"},
	{157, 21, "DEV_BOARD0_CLKOUT0_IN_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK5", "Parent input clock option to DEV_BOARD0_CLKOUT0_IN"},
	{157, 22, "DEV_BOARD0_CLKOUT0_IN_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK10", "Parent input clock option to DEV_BOARD0_CLKOUT0_IN"},
	{157, 23, "DEV_BOARD0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Output clock"},
	{157, 24, "DEV_BOARD0_DDR0_CK0_IN", "Input clock"},
	{157, 25, "DEV_BOARD0_DDR0_CK0_N_IN", "Input clock"},
	{157, 27, "DEV_BOARD0_DDR0_CK0_OUT", "Output clock"},
	{157, 33, "DEV_BOARD0_EXT_REFCLK1_OUT", "Output clock"},
	{157, 34, "DEV_BOARD0_GPMC0_CLKLB_IN", "Input clock"},
	{157, 35, "DEV_BOARD0_GPMC0_CLKLB_OUT", "Output clock"},
	{157, 36, "DEV_BOARD0_GPMC0_CLK_IN", "Input clock"},
	{157, 37, "DEV_BOARD0_GPMC0_FCLK_MUX_IN", "Input muxed clock"},
	{157, 38, "DEV_BOARD0_GPMC0_FCLK_MUX_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_BOARD0_GPMC0_FCLK_MUX_IN"},
	{157, 39, "DEV_BOARD0_GPMC0_FCLK_MUX_IN_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT7_CLK", "Parent input clock option to DEV_BOARD0_GPMC0_FCLK_MUX_IN"},
	{157, 40, "DEV_BOARD0_I2C0_SCL_IN", "Input clock"},
	{157, 41, "DEV_BOARD0_I2C0_SCL_OUT", "Output clock"},
	{157, 42, "DEV_BOARD0_I2C1_SCL_IN", "Input clock"},
	{157, 43, "DEV_BOARD0_I2C1_SCL_OUT", "Output clock"},
	{157, 44, "DEV_BOARD0_I2C2_SCL_IN", "Input clock"},
	{157, 45, "DEV_BOARD0_I2C2_SCL_OUT", "Output clock"},
	{157, 46, "DEV_BOARD0_I2C3_SCL_IN", "Input clock"},
	{157, 47, "DEV_BOARD0_I2C3_SCL_OUT", "Output clock"},
	{157, 49, "DEV_BOARD0_MCASP0_ACLKR_IN", "Input clock"},
	{157, 50, "DEV_BOARD0_MCASP0_ACLKR_OUT", "Output clock"},
	{157, 51, "DEV_BOARD0_MCASP0_ACLKX_IN", "Input clock"},
	{157, 52, "DEV_BOARD0_MCASP0_ACLKX_OUT", "Output clock"},
	{157, 53, "DEV_BOARD0_MCASP0_AFSR_IN", "Input clock"},
	{157, 54, "DEV_BOARD0_MCASP0_AFSX_IN", "Input clock"},
	{157, 55, "DEV_BOARD0_MCASP1_ACLKR_IN", "Input clock"},
	{157, 56, "DEV_BOARD0_MCASP1_ACLKR_OUT", "Output clock"},
	{157, 57, "DEV_BOARD0_MCASP1_ACLKX_IN", "Input clock"},
	{157, 58, "DEV_BOARD0_MCASP1_ACLKX_OUT", "Output clock"},
	{157, 59, "DEV_BOARD0_MCASP1_AFSR_IN", "Input clock"},
	{157, 60, "DEV_BOARD0_MCASP1_AFSX_IN", "Input clock"},
	{157, 61, "DEV_BOARD0_MCASP2_ACLKR_IN", "Input clock"},
	{157, 62, "DEV_BOARD0_MCASP2_ACLKR_OUT", "Output clock"},
	{157, 63, "DEV_BOARD0_MCASP2_ACLKX_IN", "Input clock"},
	{157, 64, "DEV_BOARD0_MCASP2_ACLKX_OUT", "Output clock"},
	{157, 65, "DEV_BOARD0_MCASP2_AFSR_IN", "Input clock"},
	{157, 66, "DEV_BOARD0_MCASP2_AFSX_IN", "Input clock"},
	{157, 67, "DEV_BOARD0_MCU_EXT_REFCLK0_OUT", "Output clock"},
	{157, 68, "DEV_BOARD0_MCU_I2C0_SCL_IN", "Input clock"},
	{157, 69, "DEV_BOARD0_MCU_I2C0_SCL_OUT", "Output clock"},
	{157, 70, "DEV_BOARD0_MCU_OBSCLK0_IN", "Input muxed clock"},
	{157, 71, "DEV_BOARD0_MCU_OBSCLK0_IN_PARENT_MCU_OBSCLK_DIV_OUT0", "Parent input clock option to DEV_BOARD0_MCU_OBSCLK0_IN"},
	{157, 72, "DEV_BOARD0_MCU_OBSCLK0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_MCU_OBSCLK0_IN"},
	{157, 73, "DEV_BOARD0_MCU_SPI0_CLK_IN", "Input clock"},
	{157, 75, "DEV_BOARD0_MCU_SPI1_CLK_IN", "Input clock"},
	{157, 77, "DEV_BOARD0_MCU_SYSCLKOUT0_IN", "Input clock"},
	{157, 78, "DEV_BOARD0_MCU_TIMER_IO0_IN", "Input clock"},
	{157, 79, "DEV_BOARD0_MCU_TIMER_IO1_IN", "Input clock"},
	{157, 80, "DEV_BOARD0_MCU_TIMER_IO2_IN", "Input clock"},
	{157, 81, "DEV_BOARD0_MCU_TIMER_IO3_IN", "Input clock"},
	{157, 82, "DEV_BOARD0_MDIO0_MDC_IN", "Input clock"},
	{157, 83, "DEV_BOARD0_MMC0_CLKLB_IN", "Input clock"},
	{157, 84, "DEV_BOARD0_MMC0_CLKLB_OUT", "Output clock"},
	{157, 86, "DEV_BOARD0_MMC0_CLK_OUT", "Output clock"},
	{157, 87, "DEV_BOARD0_MMC1_CLKLB_IN", "Input clock"},
	{157, 88, "DEV_BOARD0_MMC1_CLKLB_OUT", "Output clock"},
	{157, 89, "DEV_BOARD0_MMC1_CLK_IN", "Input clock"},
	{157, 90, "DEV_BOARD0_MMC1_CLK_OUT", "Output clock"},
	{157, 91, "DEV_BOARD0_MMC2_CLKLB_IN", "Input clock"},
	{157, 92, "DEV_BOARD0_MMC2_CLKLB_OUT", "Output clock"},
	{157, 93, "DEV_BOARD0_MMC2_CLK_IN", "Input clock"},
	{157, 94, "DEV_BOARD0_MMC2_CLK_OUT", "Output clock"},
	{157, 95, "DEV_BOARD0_OBSCLK0_IN", "Input clock"},
	{157, 96, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 97, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 98, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 99, "DEV_BOARD0_OBSCLK0_IN_PARENT_SAM62_A53_512KB_WRAP_MAIN_0_ARM_COREPACK_0_A53_DIVH_CLK4_OBSCLK_OUT_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 100, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_12_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 101, "DEV_BOARD0_OBSCLK0_IN_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 102, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 103, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK_DUP0", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 104, "DEV_BOARD0_OBSCLK0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 105, "DEV_BOARD0_OBSCLK0_IN_PARENT_MAIN_OBSCLK0_MUX_SEL_DIV_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 106, "DEV_BOARD0_OBSCLK0_IN_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 107, "DEV_BOARD0_OBSCLK0_IN_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 108, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 109, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 110, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 111, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 112, "DEV_BOARD0_OBSCLK0_IN_PARENT_SAM62_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 113, "DEV_BOARD0_OBSCLK0_IN_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 128, "DEV_BOARD0_OSPI0_DQS_OUT", "Output clock"},
	{157, 129, "DEV_BOARD0_OSPI0_LBCLKO_IN", "Input clock"},
	{157, 130, "DEV_BOARD0_OSPI0_LBCLKO_OUT", "Output clock"},
	{157, 131, "DEV_BOARD0_RGMII1_RXC_OUT", "Output clock"},
	{157, 132, "DEV_BOARD0_RGMII1_TXC_IN", "Input clock"},
	{157, 133, "DEV_BOARD0_RGMII1_TXC_OUT", "Output clock"},
	{157, 134, "DEV_BOARD0_RGMII2_RXC_OUT", "Output clock"},
	{157, 135, "DEV_BOARD0_RGMII2_TXC_IN", "Input clock"},
	{157, 136, "DEV_BOARD0_RGMII2_TXC_OUT", "Output clock"},
	{157, 137, "DEV_BOARD0_RMII1_REF_CLK_OUT", "Output clock"},
	{157, 138, "DEV_BOARD0_RMII2_REF_CLK_OUT", "Output clock"},
	{157, 139, "DEV_BOARD0_SPI0_CLK_IN", "Input clock"},
	{157, 141, "DEV_BOARD0_SPI1_CLK_IN", "Input clock"},
	{157, 143, "DEV_BOARD0_SPI2_CLK_IN", "Input clock"},
	{157, 145, "DEV_BOARD0_SYSCLKOUT0_IN", "Input clock"},
	{157, 146, "DEV_BOARD0_TCK_OUT", "Output clock"},
	{157, 147, "DEV_BOARD0_TIMER_IO0_IN", "Input clock"},
	{157, 148, "DEV_BOARD0_TIMER_IO1_IN", "Input clock"},
	{157, 149, "DEV_BOARD0_TIMER_IO2_IN", "Input clock"},
	{157, 150, "DEV_BOARD0_TIMER_IO3_IN", "Input clock"},
	{157, 151, "DEV_BOARD0_TIMER_IO4_IN", "Input clock"},
	{157, 152, "DEV_BOARD0_TIMER_IO5_IN", "Input clock"},
	{157, 153, "DEV_BOARD0_TIMER_IO6_IN", "Input clock"},
	{157, 154, "DEV_BOARD0_TIMER_IO7_IN", "Input clock"},
	{157, 155, "DEV_BOARD0_TRC_CLK_IN", "Input clock"},
	{157, 156, "DEV_BOARD0_VOUT0_EXTPCLKIN_OUT", "Output clock"},
	{157, 157, "DEV_BOARD0_VOUT0_PCLK_IN", "Input clock"},
	{157, 158, "DEV_BOARD0_WKUP_CLKOUT0_IN", "Input muxed clock"},
	{157, 159, "DEV_BOARD0_WKUP_CLKOUT0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_WKUP_CLKOUT0_IN"},
	{157, 160, "DEV_BOARD0_WKUP_CLKOUT0_IN_PARENT_GLUELOGIC_LFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_WKUP_CLKOUT0_IN"},
	{157, 161, "DEV_BOARD0_WKUP_CLKOUT0_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_WKUP_CLKOUT0_IN"},
	{157, 162, "DEV_BOARD0_WKUP_CLKOUT0_IN_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_WKUP_CLKOUT0_IN"},
	{157, 163, "DEV_BOARD0_WKUP_CLKOUT0_IN_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT9_CLK", "Parent input clock option to DEV_BOARD0_WKUP_CLKOUT0_IN"},
	{157, 164, "DEV_BOARD0_WKUP_CLKOUT0_IN_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_BOARD0_WKUP_CLKOUT0_IN"},
	{157, 165, "DEV_BOARD0_WKUP_CLKOUT0_IN_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_BOARD0_WKUP_CLKOUT0_IN"},
	{157, 166, "DEV_BOARD0_WKUP_CLKOUT0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT_DUP0", "Parent input clock option to DEV_BOARD0_WKUP_CLKOUT0_IN"},
	{193, 0, "DEV_CLK_32K_RC_SEL_DEV_VD_CLK", "Input muxed clock"},
	{193, 1, "DEV_CLK_32K_RC_SEL_DEV_VD_CLK_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_CLK_32K_RC_SEL_DEV_VD_CLK"},
	{193, 2, "DEV_CLK_32K_RC_SEL_DEV_VD_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_CLK_32K_RC_SEL_DEV_VD_CLK"},
	{193, 3, "DEV_CLK_32K_RC_SEL_DEV_VD_CLK_PARENT_CLK_32K_RC_SEL_DIV_CLKOUT", "Parent input clock option to DEV_CLK_32K_RC_SEL_DEV_VD_CLK"},
	{193, 4, "DEV_CLK_32K_RC_SEL_DEV_VD_CLK_PARENT_GLUELOGIC_LFOSC0_CLKOUT", "Parent input clock option to DEV_CLK_32K_RC_SEL_DEV_VD_CLK"},
	{1, 0, "DEV_CMP_EVENT_INTROUTER0_INTR_CLK", "Input clock"},
	{13, 0, "DEV_CPSW0_CPPI_CLK_CLK", "Input clock"},
	{13, 1, "DEV_CPSW0_CPTS_GENF0", "Output clock"},
	{13, 2, "DEV_CPSW0_CPTS_GENF1", "Output clock"},
	{13, 3, "DEV_CPSW0_CPTS_RFT_CLK", "Input muxed clock"},
	{13, 4, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT5_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 5, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 6, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 8, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 9, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 10, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_SAM62_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 11, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_SAM62_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 13, "DEV_CPSW0_GMII1_MR_CLK", "Input clock"},
	{13, 14, "DEV_CPSW0_GMII1_MT_CLK", "Input clock"},
	{13, 15, "DEV_CPSW0_GMII2_MR_CLK", "Input clock"},
	{13, 16, "DEV_CPSW0_GMII2_MT_CLK", "Input clock"},
	{13, 17, "DEV_CPSW0_GMII_RFT_CLK", "Input clock"},
	{13, 18, "DEV_CPSW0_MDIO_MDCLK_O", "Output clock"},
	{13, 19, "DEV_CPSW0_RGMII1_RXC_I", "Input clock"},
	{13, 20, "DEV_CPSW0_RGMII1_TXC_I", "Input clock"},
	{13, 21, "DEV_CPSW0_RGMII1_TXC_O", "Output clock"},
	{13, 22, "DEV_CPSW0_RGMII2_RXC_I", "Input clock"},
	{13, 23, "DEV_CPSW0_RGMII2_TXC_I", "Input clock"},
	{13, 24, "DEV_CPSW0_RGMII2_TXC_O", "Output clock"},
	{13, 25, "DEV_CPSW0_RGMII_MHZ_250_CLK", "Input clock"},
	{13, 26, "DEV_CPSW0_RGMII_MHZ_50_CLK", "Input clock"},
	{13, 27, "DEV_CPSW0_RGMII_MHZ_5_CLK", "Input clock"},
	{13, 28, "DEV_CPSW0_RMII1_MHZ_50_CLK", "Input clock"},
	{13, 29, "DEV_CPSW0_RMII2_MHZ_50_CLK", "Input clock"},
	{14, 0, "DEV_CPT2_AGGR0_VCLK_CLK", "Input clock"},
	{181, 0, "DEV_CPT2_AGGR1_VCLK_CLK", "Input clock"},
	{182, 0, "DEV_CSI_RX_IF0_MAIN_CLK_CLK", "Input clock"},
	{182, 2, "DEV_CSI_RX_IF0_PPI_RX_BYTE_CLK", "Input clock"},
	{182, 3, "DEV_CSI_RX_IF0_VBUS_CLK_CLK", "Input clock"},
	{182, 4, "DEV_CSI_RX_IF0_VP_CLK_CLK", "Input clock"},
	{2, 0, "DEV_DBGSUSPENDROUTER0_INTR_CLK", "Input clock"},
	{16, 0, "DEV_DCC0_DCC_CLKSRC0_CLK", "Input clock"},
	{16, 1, "DEV_DCC0_DCC_CLKSRC1_CLK", "Input clock"},
	{16, 2, "DEV_DCC0_DCC_CLKSRC2_CLK", "Input clock"},
	{16, 3, "DEV_DCC0_DCC_CLKSRC3_CLK", "Input clock"},
	{16, 4, "DEV_DCC0_DCC_CLKSRC4_CLK", "Input clock"},
	{16, 5, "DEV_DCC0_DCC_CLKSRC5_CLK", "Input clock"},
	{16, 6, "DEV_DCC0_DCC_CLKSRC6_CLK", "Input clock"},
	{16, 7, "DEV_DCC0_DCC_CLKSRC7_CLK", "Input clock"},
	{16, 8, "DEV_DCC0_DCC_INPUT00_CLK", "Input clock"},
	{16, 9, "DEV_DCC0_DCC_INPUT01_CLK", "Input clock"},
	{16, 10, "DEV_DCC0_DCC_INPUT02_CLK", "Input clock"},
	{16, 11, "DEV_DCC0_DCC_INPUT10_CLK", "Input clock"},
	{16, 12, "DEV_DCC0_VBUS_CLK", "Input clock"},
	{17, 0, "DEV_DCC1_DCC_CLKSRC0_CLK", "Input clock"},
	{17, 1, "DEV_DCC1_DCC_CLKSRC1_CLK", "Input clock"},
	{17, 2, "DEV_DCC1_DCC_CLKSRC2_CLK", "Input clock"},
	{17, 3, "DEV_DCC1_DCC_CLKSRC3_CLK", "Input clock"},
	{17, 4, "DEV_DCC1_DCC_CLKSRC4_CLK", "Input clock"},
	{17, 5, "DEV_DCC1_DCC_CLKSRC5_CLK", "Input clock"},
	{17, 6, "DEV_DCC1_DCC_CLKSRC6_CLK", "Input clock"},
	{17, 7, "DEV_DCC1_DCC_CLKSRC7_CLK", "Input clock"},
	{17, 8, "DEV_DCC1_DCC_INPUT00_CLK", "Input clock"},
	{17, 9, "DEV_DCC1_DCC_INPUT01_CLK", "Input clock"},
	{17, 10, "DEV_DCC1_DCC_INPUT02_CLK", "Input clock"},
	{17, 11, "DEV_DCC1_DCC_INPUT10_CLK", "Input clock"},
	{17, 12, "DEV_DCC1_VBUS_CLK", "Input clock"},
	{18, 0, "DEV_DCC2_DCC_CLKSRC0_CLK", "Input clock"},
	{18, 1, "DEV_DCC2_DCC_CLKSRC1_CLK", "Input clock"},
	{18, 2, "DEV_DCC2_DCC_CLKSRC2_CLK", "Input clock"},
	{18, 3, "DEV_DCC2_DCC_CLKSRC3_CLK", "Input clock"},
	{18, 4, "DEV_DCC2_DCC_CLKSRC4_CLK", "Input clock"},
	{18, 5, "DEV_DCC2_DCC_CLKSRC5_CLK", "Input clock"},
	{18, 6, "DEV_DCC2_DCC_CLKSRC6_CLK", "Input clock"},
	{18, 7, "DEV_DCC2_DCC_CLKSRC7_CLK", "Input clock"},
	{18, 8, "DEV_DCC2_DCC_INPUT00_CLK", "Input clock"},
	{18, 9, "DEV_DCC2_DCC_INPUT01_CLK", "Input clock"},
	{18, 10, "DEV_DCC2_DCC_INPUT02_CLK", "Input clock"},
	{18, 11, "DEV_DCC2_DCC_INPUT10_CLK", "Input clock"},
	{18, 12, "DEV_DCC2_VBUS_CLK", "Input clock"},
	{19, 0, "DEV_DCC3_DCC_CLKSRC0_CLK", "Input clock"},
	{19, 1, "DEV_DCC3_DCC_CLKSRC1_CLK", "Input clock"},
	{19, 3, "DEV_DCC3_DCC_CLKSRC3_CLK", "Input clock"},
	{19, 4, "DEV_DCC3_DCC_CLKSRC4_CLK", "Input clock"},
	{19, 5, "DEV_DCC3_DCC_CLKSRC5_CLK", "Input clock"},
	{19, 6, "DEV_DCC3_DCC_CLKSRC6_CLK", "Input clock"},
	{19, 7, "DEV_DCC3_DCC_CLKSRC7_CLK", "Input clock"},
	{19, 8, "DEV_DCC3_DCC_INPUT00_CLK", "Input clock"},
	{19, 9, "DEV_DCC3_DCC_INPUT01_CLK", "Input clock"},
	{19, 10, "DEV_DCC3_DCC_INPUT02_CLK", "Input clock"},
	{19, 11, "DEV_DCC3_DCC_INPUT10_CLK", "Input clock"},
	{19, 12, "DEV_DCC3_VBUS_CLK", "Input clock"},
	{20, 0, "DEV_DCC4_DCC_CLKSRC0_CLK", "Input clock"},
	{20, 1, "DEV_DCC4_DCC_CLKSRC1_CLK", "Input clock"},
	{20, 2, "DEV_DCC4_DCC_CLKSRC2_CLK", "Input clock"},
	{20, 3, "DEV_DCC4_DCC_CLKSRC3_CLK", "Input clock"},
	{20, 4, "DEV_DCC4_DCC_CLKSRC4_CLK", "Input clock"},
	{20, 5, "DEV_DCC4_DCC_CLKSRC5_CLK", "Input clock"},
	{20, 6, "DEV_DCC4_DCC_CLKSRC6_CLK", "Input clock"},
	{20, 7, "DEV_DCC4_DCC_CLKSRC7_CLK", "Input clock"},
	{20, 8, "DEV_DCC4_DCC_INPUT00_CLK", "Input clock"},
	{20, 9, "DEV_DCC4_DCC_INPUT01_CLK", "Input clock"},
	{20, 10, "DEV_DCC4_DCC_INPUT02_CLK", "Input clock"},
	{20, 11, "DEV_DCC4_DCC_INPUT10_CLK", "Input clock"},
	{20, 12, "DEV_DCC4_VBUS_CLK", "Input clock"},
	{21, 0, "DEV_DCC5_DCC_CLKSRC0_CLK", "Input clock"},
	{21, 1, "DEV_DCC5_DCC_CLKSRC1_CLK", "Input clock"},
	{21, 2, "DEV_DCC5_DCC_CLKSRC2_CLK", "Input clock"},
	{21, 3, "DEV_DCC5_DCC_CLKSRC3_CLK", "Input clock"},
	{21, 4, "DEV_DCC5_DCC_CLKSRC4_CLK", "Input clock"},
	{21, 5, "DEV_DCC5_DCC_CLKSRC5_CLK", "Input clock"},
	{21, 6, "DEV_DCC5_DCC_CLKSRC6_CLK", "Input clock"},
	{21, 7, "DEV_DCC5_DCC_CLKSRC7_CLK", "Input clock"},
	{21, 8, "DEV_DCC5_DCC_INPUT00_CLK", "Input clock"},
	{21, 9, "DEV_DCC5_DCC_INPUT01_CLK", "Input clock"},
	{21, 10, "DEV_DCC5_DCC_INPUT02_CLK", "Input clock"},
	{21, 11, "DEV_DCC5_DCC_INPUT10_CLK", "Input clock"},
	{21, 12, "DEV_DCC5_VBUS_CLK", "Input clock"},
	{183, 0, "DEV_DCC6_DCC_CLKSRC0_CLK", "Input clock"},
	{183, 1, "DEV_DCC6_DCC_CLKSRC1_CLK", "Input clock"},
	{183, 2, "DEV_DCC6_DCC_CLKSRC2_CLK", "Input clock"},
	{183, 3, "DEV_DCC6_DCC_CLKSRC3_CLK", "Input clock"},
	{183, 4, "DEV_DCC6_DCC_CLKSRC4_CLK", "Input clock"},
	{183, 5, "DEV_DCC6_DCC_CLKSRC5_CLK", "Input clock"},
	{183, 6, "DEV_DCC6_DCC_CLKSRC6_CLK", "Input clock"},
	{183, 7, "DEV_DCC6_DCC_CLKSRC7_CLK", "Input clock"},
	{183, 8, "DEV_DCC6_DCC_INPUT00_CLK", "Input clock"},
	{183, 9, "DEV_DCC6_DCC_INPUT01_CLK", "Input clock"},
	{183, 10, "DEV_DCC6_DCC_INPUT02_CLK", "Input clock"},
	{183, 11, "DEV_DCC6_DCC_INPUT10_CLK", "Input clock"},
	{183, 12, "DEV_DCC6_VBUS_CLK", "Input clock"},
	{85, 0, "DEV_DDPA0_DDPA_CLK", "Input clock"},
	{170, 0, "DEV_DDR16SS0_DDRSS_DDR_PLL_CLK", "Input clock"},
	{170, 1, "DEV_DDR16SS0_DDRSS_TCK", "Input clock"},
	{170, 2, "DEV_DDR16SS0_PLL_CTRL_CLK", "Input clock"},
	{171, 0, "DEV_DEBUGSS0_CFG_CLK", "Input clock"},
	{171, 1, "DEV_DEBUGSS0_DBG_CLK", "Input clock"},
	{171, 2, "DEV_DEBUGSS0_SYS_CLK", "Input clock"},
	{24, 0, "DEV_DEBUGSS_WRAP0_ATB_CLK", "Input clock"},
	{24, 1, "DEV_DEBUGSS_WRAP0_CORE_CLK", "Input clock"},
	{24, 2, "DEV_DEBUGSS_WRAP0_CSTPIU_TRACECLK", "Output clock"},
	{24, 20, "DEV_DEBUGSS_WRAP0_JTAG_TCK", "Input clock"},
	{24, 22, "DEV_DEBUGSS_WRAP0_TREXPT_CLK", "Input clock"},
	{26, 0, "DEV_DMASS0_BCDMA_0_CLK", "Input clock"},
	{27, 0, "DEV_DMASS0_CBASS_0_CLK", "Input clock"},
	{28, 0, "DEV_DMASS0_INTAGGR_0_CLK", "Input clock"},
	{29, 0, "DEV_DMASS0_IPCSS_0_CLK", "Input clock"},
	{30, 0, "DEV_DMASS0_PKTDMA_0_CLK", "Input clock"},
	{33, 0, "DEV_DMASS0_RINGACC_0_CLK", "Input clock"},
	{185, 2, "DEV_DPHY_RX0_IO_RX_CL_L_M", "Input clock"},
	{185, 2, "DEV_DPHY_RX0_IO_RX_CL_L_M", "Output clock"},
	{185, 3, "DEV_DPHY_RX0_IO_RX_CL_L_P", "Input clock"},
	{185, 3, "DEV_DPHY_RX0_IO_RX_CL_L_P", "Output clock"},
	{185, 4, "DEV_DPHY_RX0_JTAG_TCK", "Input clock"},
	{185, 5, "DEV_DPHY_RX0_MAIN_CLK_CLK", "Input clock"},
	{185, 7, "DEV_DPHY_RX0_PPI_RX_BYTE_CLK", "Output clock"},
	{186, 0, "DEV_DSS0_DPI_0_IN_CLK", "Input clock"},
	{186, 2, "DEV_DSS0_DPI_1_IN_CLK", "Input muxed clock"},
	{186, 3, "DEV_DSS0_DPI_1_IN_CLK_PARENT_HSDIV0_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DPI_1_IN_CLK"},
	{186, 4, "DEV_DSS0_DPI_1_IN_CLK_PARENT_BOARD_0_VOUT0_EXTPCLKIN_OUT", "Parent input clock option to DEV_DSS0_DPI_1_IN_CLK"},
	{186, 5, "DEV_DSS0_DPI_1_OUT_CLK", "Output clock"},
	{186, 6, "DEV_DSS0_DSS_FUNC_CLK", "Input clock"},
	{51, 0, "DEV_ECAP0_VBUS_CLK", "Input clock"},
	{52, 0, "DEV_ECAP1_VBUS_CLK", "Input clock"},
	{53, 0, "DEV_ECAP2_VBUS_CLK", "Input clock"},
	{54, 0, "DEV_ELM0_VBUSP_CLK", "Input clock"},
	{86, 0, "DEV_EPWM0_VBUSP_CLK", "Input clock"},
	{87, 0, "DEV_EPWM1_VBUSP_CLK", "Input clock"},
	{88, 0, "DEV_EPWM2_VBUSP_CLK", "Input clock"},
	{59, 0, "DEV_EQEP0_VBUS_CLK", "Input clock"},
	{60, 0, "DEV_EQEP1_VBUS_CLK", "Input clock"},
	{62, 0, "DEV_EQEP2_VBUS_CLK", "Input clock"},
	{63, 0, "DEV_ESM0_CLK", "Input clock"},
	{74, 0, "DEV_FSS0_FSAS_0_GCLK", "Input clock"},
	{75, 0, "DEV_FSS0_OSPI_0_OSPI_DQS_CLK", "Input clock"},
	{75, 1, "DEV_FSS0_OSPI_0_OSPI_HCLK_CLK", "Input clock"},
	{75, 2, "DEV_FSS0_OSPI_0_OSPI_ICLK_CLK", "Input muxed clock"},
	{75, 3, "DEV_FSS0_OSPI_0_OSPI_ICLK_CLK_PARENT_BOARD_0_OSPI0_DQS_OUT", "Parent input clock option to DEV_FSS0_OSPI_0_OSPI_ICLK_CLK"},
	{75, 4, "DEV_FSS0_OSPI_0_OSPI_ICLK_CLK_PARENT_BOARD_0_OSPI0_LBCLKO_OUT", "Parent input clock option to DEV_FSS0_OSPI_0_OSPI_ICLK_CLK"},
	{75, 5, "DEV_FSS0_OSPI_0_OSPI_OCLK_CLK", "Output clock"},
	{75, 6, "DEV_FSS0_OSPI_0_OSPI_PCLK_CLK", "Input clock"},
	{75, 7, "DEV_FSS0_OSPI_0_OSPI_RCLK_CLK", "Input muxed clock"},
	{75, 8, "DEV_FSS0_OSPI_0_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_FSS0_OSPI_0_OSPI_RCLK_CLK"},
	{75, 9, "DEV_FSS0_OSPI_0_OSPI_RCLK_CLK_PARENT_POSTDIV1_16FFT_MAIN_1_HSDIVOUT5_CLK", "Parent input clock option to DEV_FSS0_OSPI_0_OSPI_RCLK_CLK"},
	{76, 0, "DEV_GICSS0_VCLK_CLK", "Input clock"},
	{77, 0, "DEV_GPIO0_MMR_CLK", "Input clock"},
	{78, 0, "DEV_GPIO1_MMR_CLK", "Input clock"},
	{80, 0, "DEV_GPMC0_FUNC_CLK", "Input muxed clock"},
	{80, 1, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{80, 2, "DEV_GPMC0_FUNC_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT7_CLK", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{80, 3, "DEV_GPMC0_PI_GPMC_RET_CLK", "Input clock"},
	{80, 4, "DEV_GPMC0_PO_GPMC_DEV_CLK", "Output clock"},
	{80, 5, "DEV_GPMC0_VBUSM_CLK", "Input clock"},
	{187, 0, "DEV_GPU0_GPU_CLK", "Input clock"},
	{174, 0, "DEV_GPU_RS_BW_LIMITER2_CLK_CLK", "Input clock"},
	{175, 0, "DEV_GPU_WS_BW_LIMITER3_CLK_CLK", "Input clock"},
	{102, 0, "DEV_I2C0_CLK", "Input clock"},
	{102, 1, "DEV_I2C0_PISCL", "Input clock"},
	{102, 2, "DEV_I2C0_PISYS_CLK", "Input clock"},
	{102, 3, "DEV_I2C0_PORSCL", "Output clock"},
	{103, 0, "DEV_I2C1_CLK", "Input clock"},
	{103, 1, "DEV_I2C1_PISCL", "Input clock"},
	{103, 2, "DEV_I2C1_PISYS_CLK", "Input clock"},
	{103, 3, "DEV_I2C1_PORSCL", "Output clock"},
	{104, 0, "DEV_I2C2_CLK", "Input clock"},
	{104, 1, "DEV_I2C2_PISCL", "Input clock"},
	{104, 2, "DEV_I2C2_PISYS_CLK", "Input clock"},
	{104, 3, "DEV_I2C2_PORSCL", "Output clock"},
	{105, 0, "DEV_I2C3_CLK", "Input clock"},
	{105, 1, "DEV_I2C3_PISCL", "Input clock"},
	{105, 2, "DEV_I2C3_PISYS_CLK", "Input clock"},
	{105, 3, "DEV_I2C3_PORSCL", "Output clock"},
	{81, 0, "DEV_ICSSM0_CORE_CLK", "Input muxed clock"},
	{81, 1, "DEV_ICSSM0_CORE_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT0_CLK", "Parent input clock option to DEV_ICSSM0_CORE_CLK"},
	{81, 2, "DEV_ICSSM0_CORE_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT9_CLK", "Parent input clock option to DEV_ICSSM0_CORE_CLK"},
	{81, 3, "DEV_ICSSM0_IEP_CLK", "Input muxed clock"},
	{81, 4, "DEV_ICSSM0_IEP_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT5_CLK", "Parent input clock option to DEV_ICSSM0_IEP_CLK"},
	{81, 5, "DEV_ICSSM0_IEP_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_ICSSM0_IEP_CLK"},
	{81, 6, "DEV_ICSSM0_IEP_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_ICSSM0_IEP_CLK"},
	{81, 8, "DEV_ICSSM0_IEP_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ICSSM0_IEP_CLK"},
	{81, 9, "DEV_ICSSM0_IEP_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ICSSM0_IEP_CLK"},
	{81, 10, "DEV_ICSSM0_IEP_CLK_PARENT_SAM62_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_ICSSM0_IEP_CLK"},
	{81, 11, "DEV_ICSSM0_IEP_CLK_PARENT_SAM62_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_ICSSM0_IEP_CLK"},
	{81, 13, "DEV_ICSSM0_UCLK_CLK", "Input clock"},
	{81, 14, "DEV_ICSSM0_VCLK_CLK", "Input clock"},
	{83, 1, "DEV_LED0_VBUS_CLK", "Input clock"},
	{3, 0, "DEV_MAIN_GPIOMUX_INTROUTER0_INTR_CLK", "Input clock"},
	{98, 1, "DEV_MCAN0_MCANSS_CCLK_CLK", "Input muxed clock"},
	{98, 2, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{98, 3, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{98, 4, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{98, 5, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{98, 6, "DEV_MCAN0_MCANSS_HCLK_CLK", "Input clock"},
	{190, 0, "DEV_MCASP0_AUX_CLK", "Input muxed clock"},
	{190, 1, "DEV_MCASP0_AUX_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT8_CLK", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{190, 2, "DEV_MCASP0_AUX_CLK_PARENT_POSTDIV1_16FFT_MAIN_1_HSDIVOUT6_CLK", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{190, 3, "DEV_MCASP0_MCASP_ACLKR_PIN", "Input clock"},
	{190, 4, "DEV_MCASP0_MCASP_ACLKR_POUT", "Output clock"},
	{190, 5, "DEV_MCASP0_MCASP_ACLKX_PIN", "Input clock"},
	{190, 6, "DEV_MCASP0_MCASP_ACLKX_POUT", "Output clock"},
	{190, 7, "DEV_MCASP0_MCASP_AFSR_POUT", "Output clock"},
	{190, 8, "DEV_MCASP0_MCASP_AFSX_POUT", "Output clock"},
	{190, 9, "DEV_MCASP0_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{190, 10, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{190, 11, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{190, 12, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{190, 13, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{190, 14, "DEV_MCASP0_MCASP_AHCLKR_POUT", "Output clock"},
	{190, 15, "DEV_MCASP0_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{190, 16, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{190, 17, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{190, 18, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{190, 19, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{190, 20, "DEV_MCASP0_MCASP_AHCLKX_POUT", "Output clock"},
	{190, 21, "DEV_MCASP0_VBUSP_CLK", "Input clock"},
	{191, 0, "DEV_MCASP1_AUX_CLK", "Input muxed clock"},
	{191, 1, "DEV_MCASP1_AUX_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT8_CLK", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{191, 2, "DEV_MCASP1_AUX_CLK_PARENT_POSTDIV1_16FFT_MAIN_1_HSDIVOUT6_CLK", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{191, 3, "DEV_MCASP1_MCASP_ACLKR_PIN", "Input clock"},
	{191, 4, "DEV_MCASP1_MCASP_ACLKR_POUT", "Output clock"},
	{191, 5, "DEV_MCASP1_MCASP_ACLKX_PIN", "Input clock"},
	{191, 6, "DEV_MCASP1_MCASP_ACLKX_POUT", "Output clock"},
	{191, 7, "DEV_MCASP1_MCASP_AFSR_POUT", "Output clock"},
	{191, 8, "DEV_MCASP1_MCASP_AFSX_POUT", "Output clock"},
	{191, 9, "DEV_MCASP1_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{191, 10, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{191, 11, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{191, 12, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{191, 13, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{191, 14, "DEV_MCASP1_MCASP_AHCLKR_POUT", "Output clock"},
	{191, 15, "DEV_MCASP1_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{191, 16, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{191, 17, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{191, 18, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{191, 19, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{191, 20, "DEV_MCASP1_MCASP_AHCLKX_POUT", "Output clock"},
	{191, 21, "DEV_MCASP1_VBUSP_CLK", "Input clock"},
	{192, 0, "DEV_MCASP2_AUX_CLK", "Input muxed clock"},
	{192, 1, "DEV_MCASP2_AUX_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT8_CLK", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{192, 2, "DEV_MCASP2_AUX_CLK_PARENT_POSTDIV1_16FFT_MAIN_1_HSDIVOUT6_CLK", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{192, 3, "DEV_MCASP2_MCASP_ACLKR_PIN", "Input clock"},
	{192, 4, "DEV_MCASP2_MCASP_ACLKR_POUT", "Output clock"},
	{192, 5, "DEV_MCASP2_MCASP_ACLKX_PIN", "Input clock"},
	{192, 6, "DEV_MCASP2_MCASP_ACLKX_POUT", "Output clock"},
	{192, 7, "DEV_MCASP2_MCASP_AFSR_POUT", "Output clock"},
	{192, 8, "DEV_MCASP2_MCASP_AFSX_POUT", "Output clock"},
	{192, 9, "DEV_MCASP2_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{192, 10, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{192, 11, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{192, 12, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{192, 13, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{192, 14, "DEV_MCASP2_MCASP_AHCLKR_POUT", "Output clock"},
	{192, 15, "DEV_MCASP2_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{192, 16, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{192, 17, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{192, 18, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{192, 19, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{192, 20, "DEV_MCASP2_MCASP_AHCLKX_POUT", "Output clock"},
	{192, 21, "DEV_MCASP2_VBUSP_CLK", "Input clock"},
	{116, 0, "DEV_MCRC64_0_CLK", "Input clock"},
	{141, 0, "DEV_MCSPI0_CLKSPIREF_CLK", "Input clock"},
	{141, 1, "DEV_MCSPI0_IO_CLKSPIO_CLK", "Output clock"},
	{141, 2, "DEV_MCSPI0_VBUSP_CLK", "Input clock"},
	{142, 0, "DEV_MCSPI1_CLKSPIREF_CLK", "Input clock"},
	{142, 1, "DEV_MCSPI1_IO_CLKSPIO_CLK", "Output clock"},
	{142, 2, "DEV_MCSPI1_VBUSP_CLK", "Input clock"},
	{143, 0, "DEV_MCSPI2_CLKSPIREF_CLK", "Input clock"},
	{143, 1, "DEV_MCSPI2_IO_CLKSPIO_CLK", "Output clock"},
	{143, 2, "DEV_MCSPI2_VBUSP_CLK", "Input clock"},
	{23, 0, "DEV_MCU_DCC0_DCC_CLKSRC0_CLK", "Input clock"},
	{23, 1, "DEV_MCU_DCC0_DCC_CLKSRC1_CLK", "Input clock"},
	{23, 2, "DEV_MCU_DCC0_DCC_CLKSRC2_CLK", "Input clock"},
	{23, 3, "DEV_MCU_DCC0_DCC_CLKSRC3_CLK", "Input clock"},
	{23, 4, "DEV_MCU_DCC0_DCC_CLKSRC4_CLK", "Input clock"},
	{23, 5, "DEV_MCU_DCC0_DCC_CLKSRC5_CLK", "Input clock"},
	{23, 6, "DEV_MCU_DCC0_DCC_CLKSRC6_CLK", "Input clock"},
	{23, 7, "DEV_MCU_DCC0_DCC_CLKSRC7_CLK", "Input clock"},
	{23, 8, "DEV_MCU_DCC0_DCC_INPUT00_CLK", "Input clock"},
	{23, 9, "DEV_MCU_DCC0_DCC_INPUT01_CLK", "Input clock"},
	{23, 10, "DEV_MCU_DCC0_DCC_INPUT02_CLK", "Input clock"},
	{23, 11, "DEV_MCU_DCC0_DCC_INPUT10_CLK", "Input clock"},
	{23, 12, "DEV_MCU_DCC0_VBUS_CLK", "Input clock"},
	{79, 0, "DEV_MCU_GPIO0_MMR_CLK", "Input muxed clock"},
	{79, 1, "DEV_MCU_GPIO0_MMR_CLK_PARENT_SAM62_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_MCU_GPIO0_MMR_CLK"},
	{79, 2, "DEV_MCU_GPIO0_MMR_CLK_PARENT_GLUELOGIC_LFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_GPIO0_MMR_CLK"},
	{79, 3, "DEV_MCU_GPIO0_MMR_CLK_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_MCU_GPIO0_MMR_CLK"},
	{79, 4, "DEV_MCU_GPIO0_MMR_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_MCU_GPIO0_MMR_CLK"},
	{106, 0, "DEV_MCU_I2C0_CLK", "Input clock"},
	{106, 1, "DEV_MCU_I2C0_PISCL", "Input clock"},
	{106, 2, "DEV_MCU_I2C0_PISYS_CLK", "Input clock"},
	{106, 3, "DEV_MCU_I2C0_PORSCL", "Output clock"},
	{8, 0, "DEV_MCU_M4FSS0_CBASS_0_CLK", "Input clock"},
	{9, 0, "DEV_MCU_M4FSS0_CORE0_DAP_CLK", "Input clock"},
	{9, 1, "DEV_MCU_M4FSS0_CORE0_VBUS_CLK", "Input muxed clock"},
	{9, 2, "DEV_MCU_M4FSS0_CORE0_VBUS_CLK_PARENT_SAM62_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_MCU_M4FSS0_CORE0_VBUS_CLK"},
	{9, 3, "DEV_MCU_M4FSS0_CORE0_VBUS_CLK_PARENT_SAM62_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_M4FSS0_CORE0_VBUS_CLK"},
	{188, 1, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK", "Input muxed clock"},
	{188, 2, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{188, 3, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{188, 4, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{188, 5, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT_DUP0", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{188, 6, "DEV_MCU_MCAN0_MCANSS_HCLK_CLK", "Input clock"},
	{189, 1, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK", "Input muxed clock"},
	{189, 2, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{189, 3, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{189, 4, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{189, 5, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT_DUP0", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{189, 6, "DEV_MCU_MCAN1_MCANSS_HCLK_CLK", "Input clock"},
	{100, 0, "DEV_MCU_MCRC64_0_CLK", "Input clock"},
	{147, 0, "DEV_MCU_MCSPI0_CLKSPIREF_CLK", "Input clock"},
	{147, 1, "DEV_MCU_MCSPI0_IO_CLKSPIO_CLK", "Output clock"},
	{147, 2, "DEV_MCU_MCSPI0_VBUSP_CLK", "Input clock"},
	{148, 0, "DEV_MCU_MCSPI1_CLKSPIREF_CLK", "Input clock"},
	{148, 1, "DEV_MCU_MCSPI1_IO_CLKSPIO_CLK", "Output clock"},
	{148, 2, "DEV_MCU_MCSPI1_VBUSP_CLK", "Input clock"},
	{180, 3, "DEV_MCU_MCU_16FF0_PLL_CTRL_MCU_CLK24_CLK", "Input clock"},
	{131, 0, "DEV_MCU_RTI0_RTI_CLK", "Input muxed clock"},
	{131, 1, "DEV_MCU_RTI0_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{131, 2, "DEV_MCU_RTI0_RTI_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{131, 3, "DEV_MCU_RTI0_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{131, 4, "DEV_MCU_RTI0_RTI_CLK_PARENT_MCU_WWDTCLK_SEL_DIV_CLKOUT", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{131, 5, "DEV_MCU_RTI0_VBUSP_CLK", "Input clock"},
	{35, 0, "DEV_MCU_TIMER0_TIMER_HCLK_CLK", "Input clock"},
	{35, 1, "DEV_MCU_TIMER0_TIMER_PWM", "Output clock"},
	{35, 2, "DEV_MCU_TIMER0_TIMER_TCLK_CLK", "Input muxed clock"},
	{35, 3, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 4, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_SAM62_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 5, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 6, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 7, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 8, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 9, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 10, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_MCU_TIMERCLKN_SEL_OUT0_DIV_CLKOUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{48, 0, "DEV_MCU_TIMER1_TIMER_HCLK_CLK", "Input clock"},
	{48, 1, "DEV_MCU_TIMER1_TIMER_PWM", "Output clock"},
	{48, 2, "DEV_MCU_TIMER1_TIMER_TCLK_CLK", "Input muxed clock"},
	{48, 3, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 4, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_SAM62_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 5, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 6, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 7, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 8, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 9, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 10, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_MCU_TIMERCLKN_SEL_OUT1_DIV_CLKOUT", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{49, 0, "DEV_MCU_TIMER2_TIMER_HCLK_CLK", "Input clock"},
	{49, 1, "DEV_MCU_TIMER2_TIMER_PWM", "Output clock"},
	{49, 2, "DEV_MCU_TIMER2_TIMER_TCLK_CLK", "Input muxed clock"},
	{49, 3, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 4, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_SAM62_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 5, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 6, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 7, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 8, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 9, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 10, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_MCU_TIMERCLKN_SEL_OUT2_DIV_CLKOUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{50, 0, "DEV_MCU_TIMER3_TIMER_HCLK_CLK", "Input clock"},
	{50, 1, "DEV_MCU_TIMER3_TIMER_PWM", "Output clock"},
	{50, 2, "DEV_MCU_TIMER3_TIMER_TCLK_CLK", "Input muxed clock"},
	{50, 3, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 4, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_SAM62_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 5, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 6, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 7, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 8, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 9, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 10, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_MCU_TIMERCLKN_SEL_OUT3_DIV_CLKOUT", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{149, 0, "DEV_MCU_UART0_FCLK_CLK", "Input clock"},
	{149, 3, "DEV_MCU_UART0_VBUSP_CLK", "Input clock"},
	{57, 0, "DEV_MMCSD0_EMMCSDSS_IO_CLK_I", "Input muxed clock"},
	{57, 1, "DEV_MMCSD0_EMMCSDSS_IO_CLK_I_PARENT_BOARD_0_MMC0_CLKLB_OUT", "Parent input clock option to DEV_MMCSD0_EMMCSDSS_IO_CLK_I"},
	{57, 2, "DEV_MMCSD0_EMMCSDSS_IO_CLK_I_PARENT_BOARD_0_MMC0_CLK_OUT", "Parent input clock option to DEV_MMCSD0_EMMCSDSS_IO_CLK_I"},
	{57, 3, "DEV_MMCSD0_EMMCSDSS_IO_CLK_O", "Output clock"},
	{57, 5, "DEV_MMCSD0_EMMCSDSS_VBUS_CLK", "Input clock"},
	{57, 6, "DEV_MMCSD0_EMMCSDSS_XIN_CLK", "Input muxed clock"},
	{57, 7, "DEV_MMCSD0_EMMCSDSS_XIN_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT5_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSDSS_XIN_CLK"},
	{57, 8, "DEV_MMCSD0_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSDSS_XIN_CLK"},
	{58, 0, "DEV_MMCSD1_EMMCSDSS_IO_CLK_I", "Input muxed clock"},
	{58, 1, "DEV_MMCSD1_EMMCSDSS_IO_CLK_I_PARENT_BOARD_0_MMC1_CLKLB_OUT", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_IO_CLK_I"},
	{58, 2, "DEV_MMCSD1_EMMCSDSS_IO_CLK_I_PARENT_BOARD_0_MMC1_CLK_OUT", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_IO_CLK_I"},
	{58, 3, "DEV_MMCSD1_EMMCSDSS_IO_CLK_O", "Output clock"},
	{58, 5, "DEV_MMCSD1_EMMCSDSS_VBUS_CLK", "Input clock"},
	{58, 6, "DEV_MMCSD1_EMMCSDSS_XIN_CLK", "Input muxed clock"},
	{58, 7, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT5_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{58, 8, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{184, 0, "DEV_MMCSD2_EMMCSDSS_IO_CLK_I", "Input muxed clock"},
	{184, 1, "DEV_MMCSD2_EMMCSDSS_IO_CLK_I_PARENT_BOARD_0_MMC2_CLKLB_OUT", "Parent input clock option to DEV_MMCSD2_EMMCSDSS_IO_CLK_I"},
	{184, 2, "DEV_MMCSD2_EMMCSDSS_IO_CLK_I_PARENT_BOARD_0_MMC2_CLK_OUT", "Parent input clock option to DEV_MMCSD2_EMMCSDSS_IO_CLK_I"},
	{184, 3, "DEV_MMCSD2_EMMCSDSS_IO_CLK_O", "Output clock"},
	{184, 5, "DEV_MMCSD2_EMMCSDSS_VBUS_CLK", "Input clock"},
	{184, 6, "DEV_MMCSD2_EMMCSDSS_XIN_CLK", "Input muxed clock"},
	{184, 7, "DEV_MMCSD2_EMMCSDSS_XIN_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT5_CLK", "Parent input clock option to DEV_MMCSD2_EMMCSDSS_XIN_CLK"},
	{184, 8, "DEV_MMCSD2_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD2_EMMCSDSS_XIN_CLK"},
	{163, 7, "DEV_PBIST0_CLK8_CLK", "Input clock"},
	{163, 9, "DEV_PBIST0_TCLK_CLK", "Input clock"},
	{164, 7, "DEV_PBIST1_CLK8_CLK", "Input clock"},
	{164, 9, "DEV_PBIST1_TCLK_CLK", "Input clock"},
	{168, 0, "DEV_PSC0_FW_0_CLK", "Input clock"},
	{169, 0, "DEV_PSC0_PSC_0_CLK", "Input clock"},
	{169, 1, "DEV_PSC0_PSC_0_SLOW_CLK", "Input clock"},
	{121, 0, "DEV_R5FSS0_CORE0_CPU_CLK", "Input muxed clock"},
	{121, 1, "DEV_R5FSS0_CORE0_CPU_CLK_PARENT_HSDIV1_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_R5FSS0_CORE0_CPU_CLK"},
	{121, 2, "DEV_R5FSS0_CORE0_CPU_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_R5FSS0_CORE0_CPU_CLK"},
	{121, 3, "DEV_R5FSS0_CORE0_INTERFACE_CLK", "Input clock"},
	{125, 0, "DEV_RTI0_RTI_CLK", "Input muxed clock"},
	{125, 1, "DEV_RTI0_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{125, 2, "DEV_RTI0_RTI_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{125, 3, "DEV_RTI0_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{125, 4, "DEV_RTI0_RTI_CLK_PARENT_MAIN_WWDTCLKN_SEL_OUT0_DIV_CLKOUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{125, 5, "DEV_RTI0_VBUSP_CLK", "Input clock"},
	{126, 0, "DEV_RTI1_RTI_CLK", "Input muxed clock"},
	{126, 1, "DEV_RTI1_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{126, 2, "DEV_RTI1_RTI_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{126, 3, "DEV_RTI1_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{126, 4, "DEV_RTI1_RTI_CLK_PARENT_MAIN_WWDTCLKN_SEL_OUT1_DIV_CLKOUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{126, 5, "DEV_RTI1_VBUSP_CLK", "Input clock"},
	{130, 0, "DEV_RTI15_RTI_CLK", "Input muxed clock"},
	{130, 1, "DEV_RTI15_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{130, 2, "DEV_RTI15_RTI_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{130, 3, "DEV_RTI15_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{130, 4, "DEV_RTI15_RTI_CLK_PARENT_MAIN_WWDTCLKN_SEL_OUT4_DIV_CLKOUT", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{130, 5, "DEV_RTI15_VBUSP_CLK", "Input clock"},
	{127, 0, "DEV_RTI2_RTI_CLK", "Input muxed clock"},
	{127, 1, "DEV_RTI2_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI2_RTI_CLK"},
	{127, 2, "DEV_RTI2_RTI_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_RTI2_RTI_CLK"},
	{127, 3, "DEV_RTI2_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_RTI2_RTI_CLK"},
	{127, 4, "DEV_RTI2_RTI_CLK_PARENT_MAIN_WWDTCLKN_SEL_OUT2_DIV_CLKOUT", "Parent input clock option to DEV_RTI2_RTI_CLK"},
	{127, 5, "DEV_RTI2_VBUSP_CLK", "Input clock"},
	{128, 0, "DEV_RTI3_RTI_CLK", "Input muxed clock"},
	{128, 1, "DEV_RTI3_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI3_RTI_CLK"},
	{128, 2, "DEV_RTI3_RTI_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_RTI3_RTI_CLK"},
	{128, 3, "DEV_RTI3_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_RTI3_RTI_CLK"},
	{128, 4, "DEV_RTI3_RTI_CLK_PARENT_MAIN_WWDTCLKN_SEL_OUT3_DIV_CLKOUT", "Parent input clock option to DEV_RTI3_RTI_CLK"},
	{128, 5, "DEV_RTI3_VBUSP_CLK", "Input clock"},
	{66, 0, "DEV_SA3_SS0_DMSS_ECCAGGR_0_X1_CLK", "Input clock"},
	{67, 0, "DEV_SA3_SS0_INTAGGR_0_X1_CLK", "Input clock"},
	{68, 0, "DEV_SA3_SS0_PKTDMA_0_X1_CLK", "Input clock"},
	{69, 0, "DEV_SA3_SS0_RINGACC_0_X1_CLK", "Input clock"},
	{70, 0, "DEV_SA3_SS0_SA_UL_0_PKA_IN_CLK", "Input clock"},
	{70, 1, "DEV_SA3_SS0_SA_UL_0_X1_CLK", "Input clock"},
	{70, 2, "DEV_SA3_SS0_SA_UL_0_X2_CLK", "Input clock"},
	{150, 0, "DEV_SPINLOCK0_VCLK_CLK", "Input clock"},
	{15, 0, "DEV_STM0_ATB_CLK", "Input clock"},
	{15, 1, "DEV_STM0_CORE_CLK", "Input clock"},
	{15, 2, "DEV_STM0_VBUSP_CLK", "Input clock"},
	{36, 0, "DEV_TIMER0_TIMER_HCLK_CLK", "Input clock"},
	{36, 1, "DEV_TIMER0_TIMER_PWM", "Output clock"},
	{36, 2, "DEV_TIMER0_TIMER_TCLK_CLK", "Input muxed clock"},
	{36, 3, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 4, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 5, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 6, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 7, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 8, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 10, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 11, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 12, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 13, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 14, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{37, 0, "DEV_TIMER1_TIMER_HCLK_CLK", "Input clock"},
	{37, 1, "DEV_TIMER1_TIMER_PWM", "Output clock"},
	{37, 2, "DEV_TIMER1_TIMER_TCLK_CLK", "Input muxed clock"},
	{37, 3, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 4, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 5, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 6, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 7, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 8, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 10, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 11, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 12, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 13, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 14, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{38, 0, "DEV_TIMER2_TIMER_HCLK_CLK", "Input clock"},
	{38, 1, "DEV_TIMER2_TIMER_PWM", "Output clock"},
	{38, 2, "DEV_TIMER2_TIMER_TCLK_CLK", "Input muxed clock"},
	{38, 3, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 4, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 5, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 6, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 7, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 8, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 10, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 11, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 12, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 13, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 14, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{39, 0, "DEV_TIMER3_TIMER_HCLK_CLK", "Input clock"},
	{39, 1, "DEV_TIMER3_TIMER_PWM", "Output clock"},
	{39, 2, "DEV_TIMER3_TIMER_TCLK_CLK", "Input muxed clock"},
	{39, 3, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 4, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 5, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 6, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 7, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 8, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 10, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 11, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 12, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 13, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 14, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{40, 0, "DEV_TIMER4_TIMER_HCLK_CLK", "Input clock"},
	{40, 1, "DEV_TIMER4_TIMER_PWM", "Output clock"},
	{40, 2, "DEV_TIMER4_TIMER_TCLK_CLK", "Input muxed clock"},
	{40, 3, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 4, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 5, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 6, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 7, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 8, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 10, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 11, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 12, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 13, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 14, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{41, 0, "DEV_TIMER5_TIMER_HCLK_CLK", "Input clock"},
	{41, 1, "DEV_TIMER5_TIMER_PWM", "Output clock"},
	{41, 2, "DEV_TIMER5_TIMER_TCLK_CLK", "Input muxed clock"},
	{41, 3, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 4, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 5, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 6, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 7, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 8, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 10, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 11, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 12, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 13, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 14, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{42, 0, "DEV_TIMER6_TIMER_HCLK_CLK", "Input clock"},
	{42, 1, "DEV_TIMER6_TIMER_PWM", "Output clock"},
	{42, 2, "DEV_TIMER6_TIMER_TCLK_CLK", "Input muxed clock"},
	{42, 3, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 4, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 5, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 6, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 7, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 8, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 10, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 11, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 12, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 13, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 14, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{43, 0, "DEV_TIMER7_TIMER_HCLK_CLK", "Input clock"},
	{43, 1, "DEV_TIMER7_TIMER_PWM", "Output clock"},
	{43, 2, "DEV_TIMER7_TIMER_TCLK_CLK", "Input muxed clock"},
	{43, 3, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 4, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 5, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 6, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 7, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 8, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 10, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 11, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 12, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 13, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 14, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{6, 0, "DEV_TIMESYNC_EVENT_ROUTER0_INTR_CLK", "Input clock"},
	{146, 0, "DEV_UART0_FCLK_CLK", "Input muxed clock"},
	{146, 1, "DEV_UART0_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT0", "Parent input clock option to DEV_UART0_FCLK_CLK"},
	{146, 2, "DEV_UART0_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART0_FCLK_CLK"},
	{146, 5, "DEV_UART0_VBUSP_CLK", "Input clock"},
	{152, 0, "DEV_UART1_FCLK_CLK", "Input muxed clock"},
	{152, 1, "DEV_UART1_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT1", "Parent input clock option to DEV_UART1_FCLK_CLK"},
	{152, 2, "DEV_UART1_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART1_FCLK_CLK"},
	{152, 5, "DEV_UART1_VBUSP_CLK", "Input clock"},
	{153, 0, "DEV_UART2_FCLK_CLK", "Input muxed clock"},
	{153, 1, "DEV_UART2_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT2", "Parent input clock option to DEV_UART2_FCLK_CLK"},
	{153, 2, "DEV_UART2_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART2_FCLK_CLK"},
	{153, 5, "DEV_UART2_VBUSP_CLK", "Input clock"},
	{154, 0, "DEV_UART3_FCLK_CLK", "Input muxed clock"},
	{154, 1, "DEV_UART3_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT3", "Parent input clock option to DEV_UART3_FCLK_CLK"},
	{154, 2, "DEV_UART3_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART3_FCLK_CLK"},
	{154, 5, "DEV_UART3_VBUSP_CLK", "Input clock"},
	{155, 0, "DEV_UART4_FCLK_CLK", "Input muxed clock"},
	{155, 1, "DEV_UART4_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT4", "Parent input clock option to DEV_UART4_FCLK_CLK"},
	{155, 2, "DEV_UART4_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART4_FCLK_CLK"},
	{155, 5, "DEV_UART4_VBUSP_CLK", "Input clock"},
	{156, 0, "DEV_UART5_FCLK_CLK", "Input muxed clock"},
	{156, 1, "DEV_UART5_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT5", "Parent input clock option to DEV_UART5_FCLK_CLK"},
	{156, 2, "DEV_UART5_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART5_FCLK_CLK"},
	{156, 5, "DEV_UART5_VBUSP_CLK", "Input clock"},
	{158, 0, "DEV_UART6_FCLK_CLK", "Input muxed clock"},
	{158, 1, "DEV_UART6_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT6", "Parent input clock option to DEV_UART6_FCLK_CLK"},
	{158, 2, "DEV_UART6_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART6_FCLK_CLK"},
	{158, 5, "DEV_UART6_VBUSP_CLK", "Input clock"},
	{161, 0, "DEV_USB0_BUS_CLK", "Input clock"},
	{161, 1, "DEV_USB0_CFG_CLK", "Input clock"},
	{161, 2, "DEV_USB0_USB2_APB_PCLK_CLK", "Input clock"},
	{161, 3, "DEV_USB0_USB2_REFCLOCK_CLK", "Input muxed clock"},
	{161, 4, "DEV_USB0_USB2_REFCLOCK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_USB0_USB2_REFCLOCK_CLK"},
	{161, 5, "DEV_USB0_USB2_REFCLOCK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_USB0_USB2_REFCLOCK_CLK"},
	{161, 10, "DEV_USB0_USB2_TAP_TCK", "Input clock"},
	{162, 0, "DEV_USB1_BUS_CLK", "Input clock"},
	{162, 1, "DEV_USB1_CFG_CLK", "Input clock"},
	{162, 2, "DEV_USB1_USB2_APB_PCLK_CLK", "Input clock"},
	{162, 3, "DEV_USB1_USB2_REFCLOCK_CLK", "Input muxed clock"},
	{162, 4, "DEV_USB1_USB2_REFCLOCK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_USB1_USB2_REFCLOCK_CLK"},
	{162, 5, "DEV_USB1_USB2_REFCLOCK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_USB1_USB2_REFCLOCK_CLK"},
	{162, 10, "DEV_USB1_USB2_TAP_TCK", "Input clock"},
	{176, 0, "DEV_WKUP_DEEPSLEEP_SOURCES0_CLK_12M_RC_CLK", "Input clock"},
	{64, 0, "DEV_WKUP_ESM0_CLK", "Input clock"},
	{61, 0, "DEV_WKUP_GTC0_GTC_CLK", "Input muxed clock"},
	{61, 1, "DEV_WKUP_GTC0_GTC_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT5_CLK", "Parent input clock option to DEV_WKUP_GTC0_GTC_CLK"},
	{61, 2, "DEV_WKUP_GTC0_GTC_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_WKUP_GTC0_GTC_CLK"},
	{61, 3, "DEV_WKUP_GTC0_GTC_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_WKUP_GTC0_GTC_CLK"},
	{61, 5, "DEV_WKUP_GTC0_GTC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_WKUP_GTC0_GTC_CLK"},
	{61, 6, "DEV_WKUP_GTC0_GTC_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_WKUP_GTC0_GTC_CLK"},
	{61, 7, "DEV_WKUP_GTC0_GTC_CLK_PARENT_SAM62_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_WKUP_GTC0_GTC_CLK"},
	{61, 8, "DEV_WKUP_GTC0_GTC_CLK_PARENT_SAM62_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_WKUP_GTC0_GTC_CLK"},
	{61, 9, "DEV_WKUP_GTC0_VBUSP_CLK", "Input muxed clock"},
	{61, 10, "DEV_WKUP_GTC0_VBUSP_CLK_PARENT_HSDIV1_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_GTC0_VBUSP_CLK"},
	{61, 11, "DEV_WKUP_GTC0_VBUSP_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_GTC0_VBUSP_CLK"},
	{107, 0, "DEV_WKUP_I2C0_CLK", "Input muxed clock"},
	{107, 1, "DEV_WKUP_I2C0_CLK_PARENT_HSDIV1_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_I2C0_CLK"},
	{107, 2, "DEV_WKUP_I2C0_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_I2C0_CLK"},
	{107, 3, "DEV_WKUP_I2C0_PISCL", "Input clock"},
	{107, 4, "DEV_WKUP_I2C0_PISYS_CLK", "Input clock"},
	{107, 5, "DEV_WKUP_I2C0_PORSCL", "Output clock"},
	{5, 0, "DEV_WKUP_MCU_GPIOMUX_INTROUTER0_INTR_CLK", "Input clock"},
	{165, 7, "DEV_WKUP_PBIST0_CLK8_CLK", "Input clock"},
	{140, 0, "DEV_WKUP_PSC0_CLK", "Input clock"},
	{140, 1, "DEV_WKUP_PSC0_SLOW_CLK", "Input clock"},
	{117, 0, "DEV_WKUP_RTCSS0_ANA_OSC32K_CLK", "Input muxed clock"},
	{117, 1, "DEV_WKUP_RTCSS0_ANA_OSC32K_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_WKUP_RTCSS0_ANA_OSC32K_CLK"},
	{117, 2, "DEV_WKUP_RTCSS0_ANA_OSC32K_CLK_PARENT_RTC_CLK_SEL_DIV_CLKOUT", "Parent input clock option to DEV_WKUP_RTCSS0_ANA_OSC32K_CLK"},
	{117, 6, "DEV_WKUP_RTCSS0_VCLK_CLK", "Input muxed clock"},
	{117, 7, "DEV_WKUP_RTCSS0_VCLK_CLK_PARENT_HSDIV1_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_RTCSS0_VCLK_CLK"},
	{117, 8, "DEV_WKUP_RTCSS0_VCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_RTCSS0_VCLK_CLK"},
	{132, 0, "DEV_WKUP_RTI0_RTI_CLK", "Input muxed clock"},
	{132, 1, "DEV_WKUP_RTI0_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_WKUP_RTI0_RTI_CLK"},
	{132, 2, "DEV_WKUP_RTI0_RTI_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_WKUP_RTI0_RTI_CLK"},
	{132, 3, "DEV_WKUP_RTI0_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_WKUP_RTI0_RTI_CLK"},
	{132, 4, "DEV_WKUP_RTI0_RTI_CLK_PARENT_WKUP_WWDTCLK_SEL_DIV_CLKOUT", "Parent input clock option to DEV_WKUP_RTI0_RTI_CLK"},
	{132, 5, "DEV_WKUP_RTI0_VBUSP_CLK", "Input muxed clock"},
	{132, 6, "DEV_WKUP_RTI0_VBUSP_CLK_PARENT_HSDIV1_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_RTI0_VBUSP_CLK"},
	{132, 7, "DEV_WKUP_RTI0_VBUSP_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_RTI0_VBUSP_CLK"},
	{110, 0, "DEV_WKUP_TIMER0_TIMER_HCLK_CLK", "Input muxed clock"},
	{110, 1, "DEV_WKUP_TIMER0_TIMER_HCLK_CLK_PARENT_HSDIV1_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_TIMER0_TIMER_HCLK_CLK"},
	{110, 2, "DEV_WKUP_TIMER0_TIMER_HCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_TIMER0_TIMER_HCLK_CLK"},
	{110, 4, "DEV_WKUP_TIMER0_TIMER_TCLK_CLK", "Input muxed clock"},
	{110, 5, "DEV_WKUP_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_WKUP_TIMER0_TIMER_TCLK_CLK"},
	{110, 6, "DEV_WKUP_TIMER0_TIMER_TCLK_CLK_PARENT_WKUP_CLKSEL_OUT04", "Parent input clock option to DEV_WKUP_TIMER0_TIMER_TCLK_CLK"},
	{110, 7, "DEV_WKUP_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_WKUP_TIMER0_TIMER_TCLK_CLK"},
	{110, 8, "DEV_WKUP_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_WKUP_TIMER0_TIMER_TCLK_CLK"},
	{110, 9, "DEV_WKUP_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_WKUP_TIMER0_TIMER_TCLK_CLK"},
	{110, 10, "DEV_WKUP_TIMER0_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_WKUP_TIMER0_TIMER_TCLK_CLK"},
	{110, 11, "DEV_WKUP_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_WKUP_TIMER0_TIMER_TCLK_CLK"},
	{110, 12, "DEV_WKUP_TIMER0_TIMER_TCLK_CLK_PARENT_WKUP_TIMERCLKN_SEL_OUT0_DIV_CLKOUT", "Parent input clock option to DEV_WKUP_TIMER0_TIMER_TCLK_CLK"},
	{111, 0, "DEV_WKUP_TIMER1_TIMER_HCLK_CLK", "Input muxed clock"},
	{111, 1, "DEV_WKUP_TIMER1_TIMER_HCLK_CLK_PARENT_HSDIV1_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_TIMER1_TIMER_HCLK_CLK"},
	{111, 2, "DEV_WKUP_TIMER1_TIMER_HCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_TIMER1_TIMER_HCLK_CLK"},
	{111, 4, "DEV_WKUP_TIMER1_TIMER_TCLK_CLK", "Input muxed clock"},
	{111, 5, "DEV_WKUP_TIMER1_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_WKUP_TIMER1_TIMER_TCLK_CLK"},
	{111, 6, "DEV_WKUP_TIMER1_TIMER_TCLK_CLK_PARENT_WKUP_CLKSEL_OUT04", "Parent input clock option to DEV_WKUP_TIMER1_TIMER_TCLK_CLK"},
	{111, 7, "DEV_WKUP_TIMER1_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_WKUP_TIMER1_TIMER_TCLK_CLK"},
	{111, 8, "DEV_WKUP_TIMER1_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_WKUP_TIMER1_TIMER_TCLK_CLK"},
	{111, 9, "DEV_WKUP_TIMER1_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_WKUP_TIMER1_TIMER_TCLK_CLK"},
	{111, 10, "DEV_WKUP_TIMER1_TIMER_TCLK_CLK_PARENT_CLK_32K_RC_SEL_OUT0", "Parent input clock option to DEV_WKUP_TIMER1_TIMER_TCLK_CLK"},
	{111, 11, "DEV_WKUP_TIMER1_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_WKUP_TIMER1_TIMER_TCLK_CLK"},
	{111, 12, "DEV_WKUP_TIMER1_TIMER_TCLK_CLK_PARENT_WKUP_TIMERCLKN_SEL_OUT1_DIV_CLKOUT", "Parent input clock option to DEV_WKUP_TIMER1_TIMER_TCLK_CLK"},
	{114, 0, "DEV_WKUP_UART0_FCLK_CLK", "Input clock"},
	{114, 3, "DEV_WKUP_UART0_VBUSP_CLK", "Input muxed clock"},
	{114, 4, "DEV_WKUP_UART0_VBUSP_CLK_PARENT_HSDIV1_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_UART0_VBUSP_CLK"},
	{114, 5, "DEV_WKUP_UART0_VBUSP_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_UART0_VBUSP_CLK"},
	{95, 0, "DEV_WKUP_VTM0_FIX_REF2_CLK", "Input clock"},
	{95, 1, "DEV_WKUP_VTM0_FIX_REF_CLK", "Input clock"},
	{95, 2, "DEV_WKUP_VTM0_VBUSP_CLK", "Input muxed clock"},
	{95, 3, "DEV_WKUP_VTM0_VBUSP_CLK_PARENT_HSDIV1_16FFT_MAIN_15_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_VTM0_VBUSP_CLK"},
	{95, 4, "DEV_WKUP_VTM0_VBUSP_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_WKUP_VTM0_VBUSP_CLK"},
};
