#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:resource-room-confroom@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-recurring-day.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& grep -q 'ATTENDEE;PARTSTAT=ACCEPTED' out1.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out2.tmp

   grep -q 'METHOD:REPLY' out2.tmp \
&& [ `grep 'FREEBUSY;FBTYPE=BUSY' out2.tmp | wc -l` = '3' ] \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141211T230000Z/20141212T230000Z' out2.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-recurring-day-reschedule-instance.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out3.tmp

   grep -q 'METHOD:REPLY' out3.tmp \
&& grep -q 'ATTENDEE;PARTSTAT=ACCEPTED' out3.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out4.tmp

   grep -q 'METHOD:REPLY' out4.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141114T230000Z/20141115T230000Z' out4.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141113T230000Z/20141114T230000Z' out4.tmp \
&& echo "Success" \
|| echo "Failed"
