#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:paul.boddie@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
|  tee out1.tmp \
|  grep -q "^20141126T150000Z${TAB}20141126T160000Z" \
&& echo "Success" \
|| echo "Failed"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-cancel.txt" 2>> $ERROR
echo "Cancel..."

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out2.tmp

   ! grep -q '^2' "out2.tmp" \
&& echo "Success" \
|| echo "Failed"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out3.tmp

   [ `cat "out3.tmp" | wc -l` = '3' ] \
&& grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out3.tmp" \
&& echo "Success" \
|| echo "Failed"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-recurring-instance.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out4.tmp

   [ `cat "out4.tmp" | wc -l` = '2' ] \
&& ! grep -q "^20141114T090000Z${TAB}20141114T100000Z" "out4.tmp" \
&& echo "Success" \
|| echo "Failed"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-recurring-reschedule-instance.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out5.tmp

   grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out5.tmp" \
&& ! grep -q "^20141010T090000Z${TAB}20141010T100000Z" "out5.tmp" \
&& echo "Success" \
|| echo "Failed"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out6.tmp

   ! grep -q '^2' "out6.tmp" \
&& echo "Success" \
|| echo "Failed"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-recurring-day.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out7.tmp

   [ `cat "out7.tmp" | wc -l` = '3' ] \
&& grep -q "^20141211T230000Z${TAB}20141212T230000Z" "out7.tmp" \
&& echo "Success" \
|| echo "Failed"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-recurring-day.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out8.tmp

   ! grep -q '^2' "out8.tmp" \
&& echo "Success" \
|| echo "Failed"

# Switch time zones.

echo 'Europe/Mariehamn' > "$PREFS/$USER/TZID"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out9.tmp

   [ `cat "out9.tmp" | wc -l` = '3' ] \
&& grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out9.tmp" \
&& echo "Success" \
|| echo "Failed"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out10.tmp

   ! grep -q '^2' "out10.tmp" \
&& echo "Success" \
|| echo "Failed"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-recurring-day.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out11.tmp

   [ `cat "out11.tmp" | wc -l` = '3' ] \
&& grep -q "^20141211T230000Z${TAB}20141212T230000Z" "out11.tmp" \
&& echo "Success" \
|| echo "Failed"

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-recurring-day.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out12.tmp

   ! grep -q '^2' "out12.tmp" \
&& echo "Success" \
|| echo "Failed"
