#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:resource-room-sauna@example.com"
SENDER="mailto:paul.boddie@example.com"
RIVALSENDER="mailto:vincent.vole@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"
echo 'schedule_next_available_in_freebusy' > "$PREFS/$USER/scheduling_function"
echo 'PT60S' > "$PREFS/$USER/freebusy_offers"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-sauna-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

# Let the rival sender book the resource.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-busy.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$RIVALSENDER" "freebusy" \
>  out0s.tmp

   [ `grep "event19@example.com" "out0s.tmp" | wc -l` = '5' ] \
&& grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out0s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-busy.txt" 2>> $ERROR \
| tee out1r.tmp \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& grep -q 'DTSTART;TZID=Europe/Oslo.*:20141126T160000' out1.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out1f.tmp

   [ `grep "event19@example.com" "out1f.tmp" | wc -l` = '5' ] \
&& grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out1f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the response to the rival sender.

  "$PERSON_SCRIPT" $ARGS < out1r.tmp 2>> $ERROR \
| tee out2r.tmp \
| "$SHOWMAIL" \
> out2.tmp

# Publish some conflicting periods as busy.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-publish-conflicts.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out3.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out3f.tmp

   grep -q "^20141126T160000Z${TAB}20141126T170000Z" "out3f.tmp" \
&& grep -q "^20141126T180000Z${TAB}20141126T190000Z" "out3f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule an event with the resource.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-good.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
|  tee out3s.tmp \
|  grep -q "^20141126T150000Z${TAB}20141126T154500Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource. This should cause the event to be
# proposed not just after the requested period, but also after the busy periods
# published to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-good.txt" 2>> $ERROR \
| tee out6r.tmp \
| "$SHOWMAIL" \
> out6.tmp

   grep -q 'METHOD:COUNTER' out6.tmp \
&& ! grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out6.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_offers" \
>  out6o.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T154500Z" "out6o.tmp" \
&& ! grep -q "^20141126T160000Z${TAB}20141126T164500Z" "out6o.tmp" \
&& ! grep -q "^20141126T170000Z${TAB}20141126T174500Z" "out6o.tmp" \
&& ! grep -q "^20141126T180000Z${TAB}20141126T184500Z" "out6o.tmp" \
&& ! grep -q "^20141126T190000Z${TAB}20141126T194500Z" "out6o.tmp" \
&& grep -q "^20141126T200000Z${TAB}20141126T204500Z" "out6o.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the response to the organiser.

  "$PERSON_SCRIPT" $ARGS < out6r.tmp 2>> $ERROR \
| tee out7r.tmp \
| "$SHOWMAIL" \
> out7.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out7s.tmp

   grep -q "^20141126T150000Z${TAB}20141126T154500Z" "out7s.tmp" \
&& ! grep -q "^20141126T160000Z${TAB}20141126T164500Z" "out7s.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "countered_object" "event13@example.com" "$USER" \
|  tee out7C.tmp \
|  grep -q "event13@example.com" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "requests" \
|  tee out7R.tmp \
|  grep -q 'event13@example.com' \
&& echo "Success" \
|| echo "Failed"

# Reschedule the event by accepting the counter-proposal.

  sed 's/COUNTER/REQUEST/' < out6.tmp \
| sed 's/^From: calendar/To: resource-room-sauna/' \
| sed 's/^To: paul.boddie/From: paul.boddie/' \
> out8.tmp

"$OUTGOING_SCRIPT" $ARGS < out8.tmp 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out8s.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T154500Z" "out8s.tmp" \
&& grep -q "^20141126T200000Z${TAB}20141126T204500Z" "out8s.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "countered_object" "event13@example.com" "$USER" \
>  out8C.tmp

   ! grep -q "event13@example.com" "out8C.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "requests" \
>  out8R.tmp

   ! grep -q 'event13@example.com' "out8R.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < out8.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out9.tmp

   grep -q 'METHOD:REPLY' out9.tmp \
&& grep -q 'DTSTART;TZID=Europe/Oslo.*:20141126T210000' out9.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_offers" \
>  out9o.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T154500Z" "out9o.tmp" \
&& ! grep -q "^20141126T160000Z${TAB}20141126T164500Z" "out9o.tmp" \
&& ! grep -q "^20141126T170000Z${TAB}20141126T174500Z" "out9o.tmp" \
&& ! grep -q "^20141126T180000Z${TAB}20141126T184500Z" "out9o.tmp" \
&& ! grep -q "^20141126T190000Z${TAB}20141126T194500Z" "out9o.tmp" \
&& ! grep -q "^20141126T200000Z${TAB}20141126T204500Z" "out9o.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out9f.tmp

   [ `grep "event19@example.com" "out9f.tmp" | wc -l` = '5' ] \
&& [ `grep "event13@example.com" "out9f.tmp" | wc -l` = '1' ] \
&& grep -q "^20141126T200000Z${TAB}20141126T204500Z" "out9f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test updating the event to see if the resource can handle this.

  "$RESOURCE_SCRIPT" $ARGS < out8.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out10.tmp

   grep -q 'METHOD:REPLY' out10.tmp \
&& grep -q 'DTSTART;TZID=Europe/Oslo.*:20141126T210000' out10.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_offers" \
>  out10o.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T154500Z" "out10o.tmp" \
&& ! grep -q "^20141126T160000Z${TAB}20141126T164500Z" "out10o.tmp" \
&& ! grep -q "^20141126T170000Z${TAB}20141126T174500Z" "out10o.tmp" \
&& ! grep -q "^20141126T180000Z${TAB}20141126T184500Z" "out10o.tmp" \
&& ! grep -q "^20141126T190000Z${TAB}20141126T194500Z" "out10o.tmp" \
&& ! grep -q "^20141126T200000Z${TAB}20141126T204500Z" "out10o.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out10f.tmp

   [ `grep "event19@example.com" "out10f.tmp" | wc -l` = '5' ] \
&& [ `grep "event13@example.com" "out10f.tmp" | wc -l` = '1' ] \
&& grep -q "^20141126T200000Z${TAB}20141126T204500Z" "out10f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test scheduling again with a different period. This should disregard the
# existing event periods when computing availability in order to be able to
# offer them again. Otherwise, an offer would be made for even later periods.

  sed 's/20141126T160000/20141126T161500/' < "$TEMPLATES/event-request-sauna-good.txt" \
| tee out11.tmp \
| "$RESOURCE_SCRIPT" $ARGS 2>> $ERROR \
| "$SHOWMAIL" \
> out12.tmp

   grep -q 'METHOD:COUNTER' out12.tmp \
&& grep -q 'DTSTART;TZID=Europe/Oslo.*:20141126T210000' out12.tmp \
&& echo "Success" \
|| echo "Failed"

# Note that the duration is different now.

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_offers" \
>  out12o.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T154500Z" "out12o.tmp" \
&& ! grep -q "^20141126T160000Z${TAB}20141126T164500Z" "out12o.tmp" \
&& ! grep -q "^20141126T170000Z${TAB}20141126T174500Z" "out12o.tmp" \
&& ! grep -q "^20141126T180000Z${TAB}20141126T184500Z" "out12o.tmp" \
&& ! grep -q "^20141126T190000Z${TAB}20141126T194500Z" "out12o.tmp" \
&& grep -q "^20141126T200000Z${TAB}20141126T203000Z" "out12o.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out12f.tmp

   [ `grep "event19@example.com" "out12f.tmp" | wc -l` = '5' ] \
&& [ `grep "event13@example.com" "out12f.tmp" | wc -l` = '1' ] \
&& grep -q "^20141126T200000Z${TAB}20141126T204500Z" "out12f.tmp" \
&& echo "Success" \
|| echo "Failed"
