#include <cassert>
#include <inttypes.h>
#include <string.h>

#include "Gost.h"
#include "Signature.h"

const uint8_t example2[72] =
{
	0xfb,0xe2,0xe5,0xf0,0xee,0xe3,0xc8,0x20,0xfb,0xea,0xfa,0xeb,0xef,0x20,0xff,0xfb,
	0xf0,0xe1,0xe0,0xf0,0xf5,0x20,0xe0,0xed,0x20,0xe8,0xec,0xe0,0xeb,0xe5,0xf0,0xf2,
	0xf1,0x20,0xff,0xf0,0xee,0xec,0x20,0xf1,0x20,0xfa,0xf2,0xfe,0xe5,0xe2,0x20,0x2c,
	0xe8,0xf6,0xf3,0xed,0xe2,0x20,0xe8,0xe6,0xee,0xe1,0xe8,0xf0,0xf2,0xd1,0x20,0x2c,
	0xe8,0xf0,0xf2,0xe5,0xe2,0x20,0xe5,0xd1
};


int main ()
{
	uint8_t priv[64], pub[128], signature[128];
	i2p::crypto::CreateGOSTR3410RandomKeys (i2p::crypto::eGOSTR3410TC26A512, priv, pub);
	i2p::crypto::GOSTR3410_512_Signer signer (i2p::crypto::eGOSTR3410TC26A512, priv);
	signer.Sign (example2, 72, signature);
	i2p::crypto::GOSTR3410_512_Verifier verifier (i2p::crypto::eGOSTR3410TC26A512);
	verifier.SetPublicKey (pub);
	assert (verifier.Verify (example2, 72, signature));

	i2p::crypto::CreateGOSTR3410RandomKeys (i2p::crypto::eGOSTR3410CryptoProA, priv, pub);
	i2p::crypto::GOSTR3410_256_Signer signer1 (i2p::crypto::eGOSTR3410CryptoProA, priv);
	signer1.Sign (example2, 72, signature);
	i2p::crypto::GOSTR3410_256_Verifier verifier1 (i2p::crypto::eGOSTR3410CryptoProA);
	verifier1.SetPublicKey (pub);
	assert (verifier1.Verify (example2, 72, signature));
}
