/*-
 * SPDX-FileCopyrightText: 2016, 2018 Peter Pentchev
 * SPDX-License-Identifier: BSD-3-Clause
 */

#if defined(TEST_SIGTYPE_INT)
#include <signal.h>
#elif defined(TEST_ALLOCA_H)
#include <alloca.h>
#elif defined(TEST_VASPRINTF)
#define _GNU_SOURCE
#include <stdarg.h>
#include <stdio.h>
#else
#error No option to test
#endif

#if defined(TEST_SIGTYPE_INT)
static int handler(void)
{
	return 1;
}
#endif

#if defined(TEST_VASPRINTF)
static const char *run_vasprintf(char * const dst, ...)
{
	char *res;
	int ret;
	va_list v;

	va_start(v, dst);
	ret = vasprintf(&res, "%d", v);
	va_end(v);

	return (ret == -1? "0": res);
}
#endif

int main(void)
{
	char buf[128] = "1";

#if defined(TEST_SIGTYPE_INT)
	buf[0] = '0' + (signal(SIGINT, handler) != SIG_ERR);
#elif defined(TEST_ALLOCA_H)
	buf[0] = '1';
#elif defined(TEST_VASPRINTF)
	const char * const res = run_vasprintf(buf, 1);
	buf[0] = res[0];
#else
#error No option to test
#endif

	return buf[0];
}
