# How to Contribute

We welcome pull requests from everyone. We do expect everyone to adhere to the [Mozilla Community Participation Guidelines][participation].

If you're trying to figure out what to work on, here are some places to find suitable projects: 
* [Good first bugs][goodfirstbug]: these are scoped to make it easy for first-time contributors to get their feet wet with Taskcluster code.
* [Mentored bugs][bugsahoy]: these are slightly more involved projects that may require insight or guidance from someone on the Taskcluster team.
* [Full list of open issues][issues]: everything else

If the project you're interested in working on isn't covered by a bug or issue, or you're unsure about how to proceed on an existing issue, it's a good idea to talk to someone on the Taskcluster team before you go too far down a particular path. You can find us in the #taskcluster channel on [Mozilla's IRC server][irc] to discuss. You can also simply add a comment to the issue or bug.

Once you've found an issue to work on and written a patch, submit a pull request. Some things that will increase the chance that your pull request is accepted:

* Follow our [best practices][bestpractices].
* This includes [writing or updating tests][testing].
* Write a [good commit message][commit].

Welcome to the team!

[participation]: https://www.mozilla.org/en-US/about/governance/policies/participation/
[issues]: ../../issues
[bugsahoy]: https://www.joshmatthews.net/bugsahoy/?taskcluster=1
[goodfirstbug]: http://www.joshmatthews.net/bugsahoy/?taskcluster=1&simple=1
[irc]: https://wiki.mozilla.org/IRC
[bestpractices]: https://docs.taskcluster.net/docs/manual/design/devel/best-practices
[testing]: https://docs.taskcluster.net/docs/manual/design/devel/best-practices/testing
[commit]: https://docs.taskcluster.net/docs/manual/design/devel/best-practices/commits

