#ifndef SDUMP_H
#define SDUMP_H

#include <stdlib.h>  // for size_t
#include <string.h>  // for strlen

/** returns freshly malloc()d string of input string with all non-printable
 * characters rendered as hex escape.
 * Also see env.c's visbuf() which uses some default C escape sequences instead
 * and caches its buffer.
 * CalLer must free() buffer,
 * and possibly safely erase it if used for printing passwords. */
char *sdump(const char *in, size_t len);

/** Convenience macro, same as sdump, but for C string inputs in \a in.
 * CalLer must free() buffer,
 * and possibly safely erase it if used for printing passwords. */
#define sdump_c(in) (sdump(in, strlen(in)))

#endif
