/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.FileParse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AlignFile
extends FileParse {
    int noSeqs = 0;
    int maxLength = 0;
    protected Vector seqs;
    protected Vector annotations;
    protected Hashtable properties;
    long start;
    long end;
    boolean jvSuffix = true;
    Vector newickStrings = null;

    public AlignFile() {
    }

    public AlignFile(String inFile, String type) throws IOException {
        super(inFile, type);
        this.initData();
        this.parse();
    }

    public AlignFile(FileParse source) throws IOException {
        super(source);
        this.initData();
        this.parse();
    }

    public Vector getSeqs() {
        return this.seqs;
    }

    public SequenceI[] getSeqsAsArray() {
        SequenceI[] s = new SequenceI[this.seqs.size()];
        for (int i = 0; i < this.seqs.size(); ++i) {
            s[i] = (SequenceI)this.seqs.elementAt(i);
        }
        return s;
    }

    public void addAnnotations(Alignment al) {
        this.addProperties(al);
        for (int i = 0; i < this.annotations.size(); ++i) {
            al.addAnnotation((AlignmentAnnotation)this.annotations.elementAt(i));
        }
    }

    public void addProperties(Alignment al) {
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration keys = this.properties.keys();
            Enumeration vals = this.properties.elements();
            while (keys.hasMoreElements()) {
                al.setProperty(keys.nextElement(), vals.nextElement());
            }
        }
    }

    protected void setAlignmentProperty(Object key, Object value) {
        if (key == null) {
            throw new Error("Implementation error: Cannot have null alignment property key.");
        }
        if (value == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(key, value);
    }

    protected Object getAlignmentProperty(Object key) {
        if (this.properties != null && key != null) {
            return this.properties.get(key);
        }
        return null;
    }

    protected void initData() {
        this.seqs = new Vector();
        this.annotations = new Vector();
    }

    protected void setSeqs(SequenceI[] s) {
        this.seqs = new Vector();
        for (int i = 0; i < s.length; ++i) {
            this.seqs.addElement(s[i]);
        }
    }

    public abstract void parse() throws IOException;

    public abstract String print();

    public void addJVSuffix(boolean b) {
        this.jvSuffix = b;
    }

    Sequence parseId(String id) {
        Sequence seq = null;
        int space = (id = id.trim()).indexOf(" ");
        if (space > -1) {
            seq = new Sequence(id.substring(0, space), "");
            seq.setDescription(id.substring(space + 1));
        } else {
            seq = new Sequence(id, "");
        }
        return seq;
    }

    String printId(SequenceI seq) {
        return seq.getDisplayId(this.jvSuffix);
    }

    protected void addNewickTree(String treeName, String newickString) {
        if (this.newickStrings == null) {
            this.newickStrings = new Vector();
        }
        this.newickStrings.addElement(new String[]{treeName, newickString});
    }

    protected int getTreeCount() {
        if (this.newickStrings == null) {
            return 0;
        }
        return this.newickStrings.size();
    }
}

