#include <config.h>

#ifdef HAVE_BZLIB
#include <bzlib.h>
#define TRANSFORM_UNUSED(x) x
#else
#define TRANSFORM_UNUSED(x) UNUSED(x)
#endif /* HAVE_BZLIB */

#include "transformation.h"

/*
 * Initialize
 */
static int
bzlib_initialize(UNUSED(Transformation *xform), UNUSED(int enc))
{
	return 0;
}

/*
 * Shut down.
 */
static int
bzlib_shutdown(UNUSED(Transformation *xform))
{
	return 0;
}

/*
 * Handle forks.
 */
static int
bzlib_startNewTape(UNUSED(Transformation *xform), UNUSED(struct tapebuf *tpbin),
	UNUSED(unsigned long *destlen))
{
	return 0;
}

/*
 * Start slave process.
 */
static int
bzlib_startDiskIOProcess(UNUSED(Transformation *xform))
{
	return 0;
}

/*
 * End slave process.
 */
static int
bzlib_endDiskIOProcess(Transformation *xform) {
	if (xform != NULL) {
		free(xform);
	}

	return 0;
}

/*
 * Compress a buffer.
 */
static int
bzlib_compress(TRANSFORM_UNUSED(Transformation *xform), TRANSFORM_UNUSED(struct tapebuf *tpbin), TRANSFORM_UNUSED(unsigned long *destlen),
		TRANSFORM_UNUSED(const char *src), TRANSFORM_UNUSED(int srclen)) {
#ifdef HAVE_BZLIB
	int compresult;
	unsigned int destlen2 = *destlen;
	compresult = BZ2_bzBuffToBuffCompress(
			tpbin->buf,
			&destlen2,
			(char *) src,
			srclen,
			xform->state.bzlib.complvl,
			0, 30);
	*destlen = destlen2;
	return compresult == BZ_OK ? 1 : 0;
#else
	return 1;
#endif /* HAVE_BZLIB */
}

/*
 * Decompress a buffer.
 */
static int
bzlib_decompress(UNUSED(Transformation *xform), TRANSFORM_UNUSED(struct tapebuf *tpbin),
		TRANSFORM_UNUSED(unsigned long *destlen), TRANSFORM_UNUSED(const char *src), TRANSFORM_UNUSED(int srclen), TRANSFORM_UNUSED(char **reason)) {
#ifdef HAVE_BZLIB
	int cresult;
	unsigned int destlen2 = *destlen;
	cresult = BZ2_bzBuffToBuffDecompress(tpbin->buf, &destlen2, (char *) src, srclen,
			0, 0);
	*destlen = destlen2;
	switch (cresult) {
	case BZ_OK:
		*reason = "";
		break;
	case BZ_MEM_ERROR:
		*reason = "not enough memory";
		break;
	case BZ_OUTBUFF_FULL:
		*reason = "buffer too small";
		break;
	case BZ_DATA_ERROR:
	case BZ_DATA_ERROR_MAGIC:
	case BZ_UNEXPECTED_EOF:
		*reason = "data error";
		break;
	default:
		*reason = "unknown";
	}
	return (cresult == BZ_OK) ? 1 : 0;
#else
	return 1;
#endif
}

/*
 * Factory
 */
Transformation
*transformation_bzlib_factory(int enc, TRANSFORM_UNUSED(int complvl))
{
	Transformation *t = (Transformation *) malloc(sizeof (Transformation));

	t->enc = enc;
#ifdef HAVE_BZLIB
	t->state.bzlib.complvl = complvl;
#endif

	t->name = "bzlib";
	t->mandatory = 0;
	t->initialize = &bzlib_initialize;
	t->shutdown = &bzlib_shutdown;
	t->startNewTape = &bzlib_startNewTape;
	t->startDiskIOProcess = &bzlib_startDiskIOProcess;
	t->endDiskIOProcess = &bzlib_endDiskIOProcess;
	t->compress = &bzlib_compress;
	t->decompress = &bzlib_decompress;

	return t;
}
