/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2019-2020 Broadcom
 * All rights reserved.
 */

#ifndef _TF_DEVICE_P4_H_
#define _TF_DEVICE_P4_H_

#include <cfa_resource_types.h>

#include "tf_core.h"
#include "tf_rm.h"
#include "tf_if_tbl.h"
#include "tf_global_cfg.h"

struct tf_rm_element_cfg tf_ident_p4[TF_IDENT_TYPE_MAX] = {
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_L2_CTXT_REMAP_HIGH },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_L2_CTXT_REMAP_LOW },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_PROF_FUNC },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_WC_TCAM_PROF_ID },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_EM_PROF_ID },
	/* CFA_RESOURCE_TYPE_P4_L2_FUNC */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID }
};

struct tf_rm_element_cfg tf_tcam_p4[TF_TCAM_TBL_TYPE_MAX] = {
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_L2_CTXT_TCAM_HIGH },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_L2_CTXT_TCAM_LOW },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_PROF_TCAM },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_WC_TCAM },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_SP_TCAM },
	/* CFA_RESOURCE_TYPE_P4_CT_RULE_TCAM */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	/* CFA_RESOURCE_TYPE_P4_VEB_TCAM */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID }
};

struct tf_rm_element_cfg tf_tbl_p4[TF_TBL_TYPE_MAX] = {
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_FULL_ACTION },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_MCG },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_ENCAP_8B },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_ENCAP_16B },
	/* CFA_RESOURCE_TYPE_P4_ENCAP_32B */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_ENCAP_64B },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_SP_MAC },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_SP_MAC_IPV4 },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_SP_MAC_IPV6 },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_COUNTER_64B },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_NAT_PORT },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_NAT_PORT },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_NAT_IPV4 },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_METER_PROF },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_METER },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_MIRROR },
	/* CFA_RESOURCE_TYPE_P4_UPAR */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	/* CFA_RESOURCE_TYPE_P4_EPOC */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	/* CFA_RESOURCE_TYPE_P4_METADATA */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	/* CFA_RESOURCE_TYPE_P4_CT_STATE */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	/* CFA_RESOURCE_TYPE_P4_RANGE_PROF */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	/* CFA_RESOURCE_TYPE_P4_RANGE_ENTRY */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	/* CFA_RESOURCE_TYPE_P4_LAG */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	/* CFA_RESOURCE_TYPE_P4_VNIC_SVIF */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	/* CFA_RESOURCE_TYPE_P4_EM_FBK */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	/* CFA_RESOURCE_TYPE_P4_WC_FKB */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	/* CFA_RESOURCE_TYPE_P4_EXT */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID }
};

struct tf_rm_element_cfg tf_em_ext_p4[TF_EM_TBL_TYPE_MAX] = {
	/* CFA_RESOURCE_TYPE_P4_EM_REC */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P4_TBL_SCOPE },
};

struct tf_rm_element_cfg tf_em_ext_p45[TF_EM_TBL_TYPE_MAX] = {
	/* CFA_RESOURCE_TYPE_P4_EM_REC */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
	{ TF_RM_ELEM_CFG_HCAPI_BA, CFA_RESOURCE_TYPE_P45_TBL_SCOPE },
};

struct tf_rm_element_cfg tf_em_int_p4[TF_EM_TBL_TYPE_MAX] = {
	{ TF_RM_ELEM_CFG_HCAPI, CFA_RESOURCE_TYPE_P4_EM_REC },
	/* CFA_RESOURCE_TYPE_P4_TBL_SCOPE */
	{ TF_RM_ELEM_CFG_NULL, CFA_RESOURCE_TYPE_INVALID },
};

struct tf_if_tbl_cfg tf_if_tbl_p4[TF_IF_TBL_TYPE_MAX] = {
	{ TF_IF_TBL_CFG, CFA_P4_TBL_PROF_SPIF_DFLT_L2CTXT },
	{ TF_IF_TBL_CFG, CFA_P4_TBL_PROF_PARIF_DFLT_ACT_REC_PTR },
	{ TF_IF_TBL_CFG, CFA_P4_TBL_PROF_PARIF_ERR_ACT_REC_PTR },
	{ TF_IF_TBL_CFG, CFA_P4_TBL_LKUP_PARIF_DFLT_ACT_REC_PTR },
	{ TF_IF_TBL_CFG_NULL, CFA_IF_TBL_TYPE_INVALID },
	{ TF_IF_TBL_CFG_NULL, CFA_IF_TBL_TYPE_INVALID }
};

struct tf_global_cfg_cfg tf_global_cfg_p4[TF_GLOBAL_CFG_TYPE_MAX] = {
	{ TF_GLOBAL_CFG_CFG_HCAPI, TF_TUNNEL_ENCAP },
	{ TF_GLOBAL_CFG_CFG_HCAPI, TF_ACTION_BLOCK },
};
#endif /* _TF_DEVICE_P4_H_ */
