#!/usr/bin/env python
import os
import sys
import warnings
from optparse import OptionParser

import django
from django.conf import settings
from django.core.management import call_command


def runtests(test_path='modeltranslation'):
    if not settings.configured:
        # Choose database for settings
        test_db = os.getenv('DB', 'sqlite')
        test_db_host = os.getenv('DB_HOST', 'localhost')
        DATABASES = {'default': {'ENGINE': 'django.db.backends.sqlite3', 'NAME': ':memory:'}}
        if test_db == 'mysql':
            DATABASES['default'].update(
                {
                    'ENGINE': 'django.db.backends.mysql',
                    'NAME': os.getenv('MYSQL_DATABASE', 'modeltranslation'),
                    'USER': os.getenv('MYSQL_USER', 'root'),
                    'PASSWORD': os.getenv('MYSQL_PASSWORD', 'password'),
                    'HOST': test_db_host,
                }
            )
        elif test_db == 'postgres':
            DATABASES['default'].update(
                {
                    'ENGINE': 'django.db.backends.postgresql',
                    'USER': os.getenv('POSTGRES_USER', 'postgres'),
                    'PASSWORD': os.getenv('POSTGRES_DB', 'postgres'),
                    'NAME': os.getenv('POSTGRES_DB', 'modeltranslation'),
                    'HOST': test_db_host,
                }
            )

        # Configure test environment
        settings.configure(
            DATABASES=DATABASES,
            INSTALLED_APPS=(
                'django.contrib.contenttypes',
                'django.contrib.auth',
                'modeltranslation',
            ),
            ROOT_URLCONF=None,  # tests override urlconf, but it still needs to be defined
            LANGUAGES=(('en', 'English'),),
            MIDDLEWARE_CLASSES=(),
        )

    django.setup()
    warnings.simplefilter('always', DeprecationWarning)
    failures = call_command('test', test_path, interactive=False, failfast=False, verbosity=2)

    sys.exit(bool(failures))


if __name__ == '__main__':
    parser = OptionParser()

    (options, args) = parser.parse_args()
    runtests(*args)
