----------------------------------------------------------------------
-- Compares data structures originally created in Torch against the
-- ones generated by DeepBoof in the Torch format.
--
-- Peter Abeles
----------------------------------------------------------------------



require 'torch'
require 'nn'

torch_dir = "torch_data"
boof_dir = "boof_data"

totalTests = 0
totalPassed = 0


function compareTensors( a , b )
    totalTests = totalTests + 1

    if a:nDimension() ~= b:nDimension() then
        print("Dimensions don't match")
        return false
    end

    for i=1,a:nDimension(),1
    do
        if a:size()[i] ~= b:size()[i] then
            print("shape doesn't match")
            return false
        end
    end


    if not a:equal(b) then
        print("----------- a --------------")
        print(a)
        print("----------- b --------------")
        print(b)

        print("Tensors not equal, val[1] = "..a:storage()[1].." "..b:storage()[1])
        return false
    end

    totalPassed = totalPassed + 1
    return true
end

local a = torch.load(paths.concat(torch_dir,'Tensor_F32'))
local b = torch.load(paths.concat(boof_dir, 'Tensor_F32'))
compareTensors(a,b)
local a = torch.load(paths.concat(torch_dir,'Tensor_F64'))
local b = torch.load(paths.concat(boof_dir, 'Tensor_F64'))
compareTensors(a,b)
local a = torch.load(paths.concat(torch_dir,'Tensor_U8'))
local b = torch.load(paths.concat(boof_dir, 'Tensor_U8'))
compareTensors(a,b)

print("Total tests:  "..totalTests)
print("Total passed: "..totalPassed)
