/*

implementation of debug.h

AUthor: Bob Dean
copyright (c) 1999


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/


#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <stdarg.h>

#include <dbdebug.h>


int debug_level;
static char tempstr[1024];

/***************************************************************************/
/*  Debug Functions                                                        */
/***************************************************************************/


void Error(const char*fmt, ...)
{
	va_list args;

	va_start(args, fmt);
	vsprintf(tempstr,fmt,args);
	perror(tempstr);
	va_end(args);
}


void Debug ( const char *fmt, ...)
{
	if(debug_level)
    {
		va_list args;
      
		va_start(args, fmt);
		fflush(stdout);
/* 		fprintf(stdout,"dbfsd.c: "); */
		vfprintf(stdout, fmt, args);
		fprintf(stdout,"\n");
		fflush(stdout);
		va_end(args);
    }
}


int Check_Debug()
{
	return debug_level;
}

