/* SPDX-License-Identifier: GPL-2.0-only */

#include <mainboard/gpio.h>
#include <soc/gpe.h>
#include <soc/gpio.h>

static const struct pad_config gpio_table[] = {
	/* GPIO Group GPP_A */
	PAD_CFG_NF(GPP_A0, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A1, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A2, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A3, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A4, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A5, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A6, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A7, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A8, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A9, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A10, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A11, NONE, DEEP, NF1),
	PAD_NC(GPP_A12, NONE),
	PAD_NC(GPP_A13, UP_20K),
	PAD_NC(GPP_A14, UP_20K),
	PAD_NC(GPP_A15, UP_20K),
	PAD_NC(GPP_A16, UP_20K),
	PAD_NC(GPP_A17, UP_20K),
	PAD_NC(GPP_A18, NONE),
	/* GPP_A19 - RESERVED */
	PAD_NC(GPP_A20, UP_20K),
	PAD_NC(GPP_A21, UP_20K),
	PAD_NC(GPP_A22, UP_20K),
	PAD_NC(GPP_A23, UP_20K),

	/* GPIO Group GPP_B */
	PAD_NC(GPP_B0, UP_20K),
	PAD_NC(GPP_B1, UP_20K),
	PAD_NC(GPP_B2, NONE),
	PAD_NC(GPP_B3, UP_20K),
	PAD_NC(GPP_B4, UP_20K),
	PAD_NC(GPP_B5, UP_20K),
	PAD_NC(GPP_B6, UP_20K),
	PAD_NC(GPP_B7, UP_20K),
	PAD_NC(GPP_B8, UP_20K),
	PAD_NC(GPP_B9, UP_20K),
	PAD_NC(GPP_B10, UP_20K),
	PAD_NC(GPP_B11, DN_20K),
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_B14, NONE, PLTRST, NF1), /* SPKR + JBR1 ("Top-Block Swap") */
	PAD_NC(GPP_B15, UP_20K),
	PAD_NC(GPP_B16, UP_20K),
	PAD_NC(GPP_B17, UP_20K),
	PAD_NC(GPP_B18, NONE),
	PAD_NC(GPP_B19, UP_20K),
	PAD_CFG_GPO(GPP_B20, 0, PLTRST), /* BMC POST_COMPLETE */
	PAD_NC(GPP_B21, UP_20K),
	PAD_NC(GPP_B22, NONE),
	PAD_CFG_NF(GPP_B23, NONE, DEEP, NF2),

	/* GPIO Group GPP_C */
	/* GPP_C0 - RESERVED */
	/* GPP_C1 - RESERVED */
	PAD_NC(GPP_C2, NONE),
	/* GPP_C3 - RESERVED */
	/* GPP_C4 - RESERVED */
	PAD_NC(GPP_C5, NONE),
	/* GPP_C6 - RESERVED */
	/* GPP_C7 - RESERVED */
	PAD_NC(GPP_C8, NONE),
	PAD_NC(GPP_C9, NONE),
	PAD_NC(GPP_C10, NONE),
	PAD_NC(GPP_C11, NONE),
	PAD_NC(GPP_C12, UP_20K),
	PAD_NC(GPP_C13, UP_20K),
	PAD_NC(GPP_C14, UP_20K),
	PAD_NC(GPP_C15, NONE),
	PAD_NC(GPP_C16, NONE),
	PAD_NC(GPP_C17, NONE),
	PAD_NC(GPP_C18, NONE),
	PAD_NC(GPP_C19, NONE),
	PAD_CFG_GPO(GPP_C20, 1, PLTRST), /* BMC alert CPU_THROTTLED# */
	PAD_NC(GPP_C21, NONE),
	PAD_CFG_GPI_SMI_LOW(GPP_C22, UP_20K, DEEP, EDGE_SINGLE), /* BMC SMI# */
	PAD_CFG_GPI(GPP_C23, NONE, PLTRST), /* CPU CATERR# */

	/* GPIO Group GPP_D */
	PAD_NC(GPP_D0, NONE),
	PAD_CFG_GPO_GPIO_DRIVER(GPP_D1, 1, DEEP, NONE), /* Power LEDs onboard + JF1 */
	PAD_CFG_GPI_NMI(GPP_D2, UP_20K, DEEP, EDGE_SINGLE, INVERT), /* BMC NMI# */
	PAD_NC(GPP_D3, DN_20K),
	PAD_NC(GPP_D4, UP_20K),
	PAD_NC(GPP_D5, UP_20K),
	PAD_NC(GPP_D6, UP_20K),
	PAD_NC(GPP_D7, UP_20K),
	PAD_NC(GPP_D8, UP_20K),
	PAD_NC(GPP_D9, NONE),
	PAD_NC(GPP_D10, UP_20K),
	PAD_NC(GPP_D11, UP_20K),
	PAD_NC(GPP_D12, UP_20K),
	PAD_NC(GPP_D13, UP_20K),
	PAD_NC(GPP_D14, NONE),
	PAD_NC(GPP_D15, UP_20K),
	PAD_NC(GPP_D16, UP_20K),
	PAD_NC(GPP_D17, UP_20K),
	PAD_CFG_GPO_GPIO_DRIVER(GPP_D18, 1, PLTRST, NONE), /* PERST# CPU PCIe Slots */
	PAD_CFG_GPO_GPIO_DRIVER(GPP_D19, 1, PLTRST, NONE), /* PERST# PCH PCIe Slots */
	PAD_NC(GPP_D20, UP_20K),
	PAD_NC(GPP_D21, UP_20K),
	PAD_CFG_GPI(GPP_D22, NONE, RSMRST), /* BMC enable/disable jumper JPB1 */
	PAD_NC(GPP_D23, UP_20K),

	/* GPIO Group GPP_E */
	PAD_NC(GPP_E0, UP_20K),
	PAD_NC(GPP_E1, UP_20K),
	PAD_NC(GPP_E2, UP_20K),
	PAD_NC(GPP_E3, NONE),
	PAD_NC(GPP_E4, UP_20K),
	PAD_NC(GPP_E5, UP_20K),
	PAD_CFG_GPI_NMI(GPP_E6, UP_20K, PLTRST, EDGE_SINGLE, INVERT), /* NMI# (BMC WDT + JF1) */
	PAD_NC(GPP_E7, UP_20K),
	PAD_CFG_NF(GPP_E8, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_E9, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_E10, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_E11, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_E12, NONE, DEEP, NF1),

	/* GPIO Group GPP_F */
	PAD_NC(GPP_F0, UP_20K),
	PAD_NC(GPP_F1, UP_20K),
	PAD_NC(GPP_F2, UP_20K),
	PAD_NC(GPP_F3, UP_20K),
	PAD_NC(GPP_F4, UP_20K),
	PAD_NC(GPP_F5, NONE),
	PAD_NC(GPP_F6, UP_20K),
	PAD_NC(GPP_F7, UP_20K),
	PAD_NC(GPP_F8, UP_20K),
	PAD_NC(GPP_F9, UP_20K),
	PAD_CFG_NF(GPP_F10, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F11, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F12, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F13, NONE, DEEP, NF1),
	PAD_NC(GPP_F14, UP_20K),
	PAD_CFG_NF(GPP_F15, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F16, NONE, DEEP, NF1),
	PAD_NC(GPP_F17, NONE),
	PAD_NC(GPP_F18, NONE),
	PAD_NC(GPP_F19, UP_20K),
	PAD_NC(GPP_F20, UP_20K),
	PAD_NC(GPP_F21, UP_20K),
	PAD_NC(GPP_F22, UP_20K),
	PAD_NC(GPP_F23, NONE),

	/* GPIO Group GPP_G */
	PAD_NC(GPP_G0, NONE), /* JPCIE6-A19 (DGPU_PWR_EN#) */
	PAD_NC(GPP_G1, NONE), /* JPCIE6-B32 (DGPU_PWR_OK) */
	PAD_NC(GPP_G2, NONE), /* JPCIE6-B30 (DGPU_SEL#) */
	PAD_NC(GPP_G3, NONE), /* JPCIE6-B82 (DGPU_PRSNT#) */
	PAD_NC(GPP_G4, UP_20K),
	PAD_NC(GPP_G5, UP_20K),
	PAD_NC(GPP_G6, UP_20K),
	PAD_NC(GPP_G7, UP_20K),
	PAD_NC(GPP_G8, NONE),
	PAD_NC(GPP_G9, UP_20K),
	PAD_NC(GPP_G10, UP_20K),
	PAD_NC(GPP_G11, UP_20K),
	PAD_CFG_GPI(GPP_G12, NONE, PLTRST), /* SKU_ID[0] */
	PAD_CFG_GPI(GPP_G13, NONE, PLTRST), /* SKU_ID[1] */
	PAD_CFG_GPI(GPP_G14, NONE, PLTRST), /* SKU_ID[2] */
	PAD_CFG_GPI(GPP_G15, NONE, PLTRST), /* SKU_ID[3] */
	PAD_CFG_GPI(GPP_G16, NONE, PLTRST), /* SKU_ID[4] */
	PAD_NC(GPP_G17, UP_20K),
	PAD_CFG_NF(GPP_G18, NONE, DEEP, NF1), /* BMC NMI# */
	PAD_CFG_NF(GPP_G19, NONE, DEEP, NF1), /* BMC SMI# */
	PAD_CFG_GPI(GPP_G20, NONE, PLTRST), /* JPI2C1 PWRFAIL# */
	PAD_NC(GPP_G21, UP_20K),
	PAD_NC(GPP_G22, NONE),
	PAD_NC(GPP_G23, NONE),

	/* GPIO Group GPP_H */
	PAD_NC(GPP_H0, UP_20K),
	PAD_NC(GPP_H1, NONE),
	PAD_NC(GPP_H2, UP_20K),
	PAD_NC(GPP_H3, UP_20K),
	PAD_NC(GPP_H4, UP_20K),
	PAD_NC(GPP_H5, UP_20K),
	PAD_NC(GPP_H6, UP_20K),
	PAD_NC(GPP_H7, UP_20K),
	PAD_NC(GPP_H8, UP_20K),
	PAD_NC(GPP_H9, UP_20K),
	PAD_NC(GPP_H10, NONE),
	PAD_NC(GPP_H11, UP_20K),
	PAD_NC(GPP_H12, UP_20K),
	PAD_NC(GPP_H13, NONE),
	PAD_NC(GPP_H14, NONE),
	PAD_NC(GPP_H15, NONE),
	PAD_NC(GPP_H16, NONE),
	PAD_NC(GPP_H17, NONE),
	PAD_NC(GPP_H18, NONE),
	PAD_NC(GPP_H19, UP_20K),
	PAD_NC(GPP_H20, UP_20K),
	PAD_NC(GPP_H21, UP_20K),
	PAD_NC(GPP_H22, UP_20K),
	PAD_NC(GPP_H23, NONE),

	/* GPIO Group GPP_I */
	PAD_NC(GPP_I0, NONE),
	PAD_NC(GPP_I1, NONE),
	PAD_NC(GPP_I2, NONE),
	PAD_NC(GPP_I3, NONE),
	PAD_NC(GPP_I4, NONE),
	PAD_NC(GPP_I5, NONE),
	PAD_NC(GPP_I6, UP_20K),
	PAD_NC(GPP_I7, NONE),
	PAD_NC(GPP_I8, UP_20K),
	PAD_NC(GPP_I9, NONE),
	PAD_NC(GPP_I10, UP_20K),

	/* GPIO Group GPD */
	PAD_NC(GPD0, NONE),
	PAD_NC(GPD1, NONE),
	PAD_CFG_NF(GPD2, NONE, PWROK, NF1),
	PAD_CFG_NF(GPD3, NONE, PWROK, NF1),
	PAD_CFG_NF(GPD4, NONE, PWROK, NF1),
	PAD_CFG_NF(GPD5, NONE, PWROK, NF1),
	PAD_CFG_NF(GPD6, NONE, PWROK, NF1),
	PAD_NC(GPD7, UP_20K),
	PAD_NC(GPD8, UP_20K),
	PAD_NC(GPD9, UP_20K),
	PAD_NC(GPD10, UP_20K),
	PAD_NC(GPD11, NONE),
};

void mainboard_configure_gpios(void)
{
	gpio_configure_pads(gpio_table, ARRAY_SIZE(gpio_table));
}
