#!/bin/sh
#
# Copyright (c) 2008, 2020  Peter Pentchev
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

[ -z "$CONFGET" ] && CONFGET='./confget'
[ -z "$TESTDIR" ] && TESTDIR='t'

T1="$TESTDIR/t1.ini"

echo '1..7'

if [ ! -f "$T1" ]; then
	echo "Bail out!  No test file $T1"
	exit 255
fi

v=`$CONFGET -f "$T1" -Ss a key1`
if [ "$v" = "'value1'" ]; then echo 'ok 1'; else echo "not ok 1 v is '$v'"; fi
v=`$CONFGET -f "$T1" -Ss a key3`
if [ "$v" = "'		 val'\"'\"'ue3'" ]; then echo 'ok 2'; else echo "not ok 2 v is '$v'"; fi

unset cfg_key1 cfg_key2 cfg_key3 cfg_key6
eval `$CONFGET -f "$T1" -S -p cfg_ -s a -l`
if [ "$cfg_key1" = 'value1' ]; then echo 'ok 3'; else echo "not ok 3 cfg_key1 is '$cfg_key1'"; fi
if [ "$cfg_key2" = 'value2' ]; then echo 'ok 4'; else echo "not ok 4 cfg_key2 is '$cfg_key2'"; fi
if [ "$cfg_key3" = " val'ue3" ]; then echo 'ok 5'; else echo "not ok 5 cfg_key3 is '$cfg_key3'"; fi
if [ "$cfg_key6" = 'value6' ]; then echo 'ok 6'; else echo "not ok 6 cfg_key6 is '$cfg_key6'"; fi

unset cfg_key1_value
eval `$CONFGET -f "$T1" -S -p cfg_ -P _value -s a -N key1`
if [ "$cfg_key1_value" = 'value1' ]; then echo 'ok 7'; else echo "not ok 7 cfg_key1_value is '$cfg_key1_value'"; fi
