include(manual.h)dnl
HEADER(vine_graph_log)

SECTION(NAME)
BOLD(vine_graph_log) - plots TaskVine performance logs.

SECTION(SYNOPSIS)
CODE(vine_graph_log [options] vine-perf-log)

SECTION(DESCRIPTION)

BOLD(vine_graph_log) is a script to plot some of the statistics from a
TaskVine log, as generated by CODE(vine_enable_perf_log) from the C API, or by
CODE(q.enable_perf_log) from the Python API. It assumes the availability of
CODE(gnuplot).

BOLD(vine_graph_log) generates four plots, all with CODE(timestamp) as
the independent variable:

CODE(time):
    timestamp, total_send_time, total_receive_time, total_transfer_time, and total_manager_time. (The last two generated by the script, not in the log.)

CODE(time-log):
    log-scale version of CODE(times), plus total_execute_time.

CODE(tasks):
    total_tasks_waiting, total_tasks_running, total_workers_connected, total_workers_busy, and total_cores

CODE(tasks-log):
    log-scale version of CODE(tasks), plus total_complete_tasks.

SECTION(OPTIONS)
OPTIONS_BEGIN
OPTION_ARG_SHORT(o,prefix-output)Generate prefix-output.{time,time-log,tasks,tasks-log}.PARAM(output-format). Default is PARAM(work-queue-log).
OPTION_ARG_SHORT(o,prefix-output)Generate prefix-output.{time,time-log,tasks,tasks-log}.PARAM(output-format). Default is PARAM(work-queue-log).
OPTION_ARG_SHORT(c,gnuplot-path)Specify the location of the gnuplot executable. Default is gnuplot.
OPTION_ARG_SHORT(r,range)Range of time to plot, in time units (see -u) from the start of execution. Of the form: min:max, min:, or :max.
OPTION_ARG_SHORT(T,output-format)Set output format. Default is png. If "text", then the gnuplot scripts are written instead of the images.
OPTION_ARG_SHORT(u,time-unit)Time scale to output. One of s,m,h or d, for seconds, minutes (default), hours or days.
OPTION_FLAG_SHORT(h)Show help text.
OPTIONS_END

SECTION(EXAMPLES)

General use:

LONGCODE_BEGIN
% vine_graph_log mylog
% ls mylog*.png
mylog.tasks.png mylog.tasks-log.png mylog.time.png mylog.time-log.png
LONGCODE_END

Plot up to the eleventh hour:

LONGCODE_BEGIN
% vine_graph_log -u h -r :11 mylog

LONGCODE_END
Generate script text:

LONGCODE_BEGIN
% vine_graph_log -Ttext mylog
% ls mylog*.gnuplot
mylog.tasks.png.gnuplot mylog.tasks-log.png.gnuplot mylog.time.png.gnuplot mylog.time-log.png.gnuplot
LONGCODE_END

Specify gnuplot path:

LONGCODE_BEGIN
% vine_graph_log -c/some/dir/bin/gnuplot mylog
LONGCODE_END

SECTION(BUGS)

LIST_BEGIN
LIST_ITEM(Some formats need a special setup for their gnuplot output terminal. `-T' blindly passes the output format, which may cause gnuplot to fail.)
LIST_END

SECTION(COPYRIGHT)

COPYRIGHT_BOILERPLATE

FOOTER
