{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetNormalizeVelocity: Boolean;
    procedure SetNormalizeVelocity(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdKeyValue: TMFRotation;
    { Internal wrapper for property @code(KeyValue). This wrapper API may change, we advise to access simpler @code(KeyValue) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdKeyValue: TMFRotation read FFdKeyValue;
    {  }
    procedure SetKeyValue(const Value: array of TVector4); overload;
    {  }
    procedure SetKeyValue(const Value: TVector4List); overload;

    strict private FFdNormalizeVelocity: TSFBool;
    { Internal wrapper for property @code(NormalizeVelocity). This wrapper API may change, we advise to access simpler @code(NormalizeVelocity) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalizeVelocity: TSFBool read FFdNormalizeVelocity;
    {  }
    property NormalizeVelocity: Boolean read GetNormalizeVelocity write SetNormalizeVelocity;

    strict private FEventValue_changed: TSFRotationEvent;
    {  }
    public property EventValue_changed: TSFRotationEvent read FEventValue_changed;

{$endif read_interface}

{$ifdef read_implementation}

{ TSquadOrientationInterpolatorNode ----------------------------------------------- }

procedure TSquadOrientationInterpolatorNode.SetKeyValue(const Value: array of TVector4);
begin
  FdKeyValue.Send(Value);
end;

procedure TSquadOrientationInterpolatorNode.SetKeyValue(const Value: TVector4List);
begin
  FdKeyValue.Send(Value);
end;

function TSquadOrientationInterpolatorNode.GetNormalizeVelocity: Boolean;
begin
  Result := FdNormalizeVelocity.Value;
end;

procedure TSquadOrientationInterpolatorNode.SetNormalizeVelocity(const Value: Boolean);
begin
  FdNormalizeVelocity.Send(Value);
end;

class function TSquadOrientationInterpolatorNode.ClassX3DType: String;
begin
  Result := 'SquadOrientationInterpolator';
end;

procedure TSquadOrientationInterpolatorNode.CreateNode;
begin
  inherited;

  FFdKeyValue := TMFRotation.Create(Self, True, 'keyValue', []);
   FdKeyValue.ChangeAlways := chNone;
  AddField(FFdKeyValue);

  FFdNormalizeVelocity := TSFBool.Create(Self, True, 'normalizeVelocity', false);
   FdNormalizeVelocity.ChangeAlways := chNone;
  AddField(FFdNormalizeVelocity);

  FEventValue_changed := TSFRotationEvent.Create(Self, 'value_changed', false);
  AddEvent(FEventValue_changed);
end;

{$endif read_implementation}
