{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetBaseColor: TCastleColorRGB;
    procedure SetBaseColor(const Value: TCastleColorRGB);
    function GetBaseTexture: TAbstractSingleTextureNode;
    procedure SetBaseTexture(const Value: TAbstractSingleTextureNode);
    function GetBaseTextureMapping: String;
    procedure SetBaseTextureMapping(const Value: String);
    function GetMetallic: Single;
    procedure SetMetallic(const Value: Single);
    function GetMetallicRoughnessTexture: TAbstractSingleTextureNode;
    procedure SetMetallicRoughnessTexture(const Value: TAbstractSingleTextureNode);
    function GetMetallicRoughnessTextureMapping: String;
    procedure SetMetallicRoughnessTextureMapping(const Value: String);
    function GetOcclusionStrength: Single;
    procedure SetOcclusionStrength(const Value: Single);
    function GetOcclusionTexture: TAbstractSingleTextureNode;
    procedure SetOcclusionTexture(const Value: TAbstractSingleTextureNode);
    function GetOcclusionTextureMapping: String;
    procedure SetOcclusionTextureMapping(const Value: String);
    function GetRoughness: Single;
    procedure SetRoughness(const Value: Single);
    function GetTransparency: Single;
    procedure SetTransparency(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdBaseColor: TSFColor;
    { Internal wrapper for property @link(BaseColor). This wrapper API may change, we advise to access simpler @link(BaseColor) instead. }
    public property FdBaseColor: TSFColor read FFdBaseColor;
    { The primary way to control the color of object with physical (PBR) material. }
    property BaseColor: TCastleColorRGB read GetBaseColor write SetBaseColor;

    strict private FFdBaseTexture: TSFNode;
    { Internal wrapper for property @link(BaseTexture). This wrapper API may change, we advise to access simpler @link(BaseTexture) instead. }
    public property FdBaseTexture: TSFNode read FFdBaseTexture;
    { The primary texture to control the color of object with physical (PBR) material. The RGB channel of this texture is multiplied with @link(BaseColor), and alpha channel is multiplied with the opacity (1-@link(Transparency)). }
    property BaseTexture: TAbstractSingleTextureNode read GetBaseTexture write SetBaseTexture;

    strict private FFdBaseTextureMapping: TSFString;
    { Internal wrapper for property @link(BaseTextureMapping). This wrapper API may change, we advise to access simpler @link(BaseTextureMapping) instead. }
    public property FdBaseTextureMapping: TSFString read FFdBaseTextureMapping;
    { Determines texture coordinates used by @link(BaseTexture). }
    property BaseTextureMapping: String read GetBaseTextureMapping write SetBaseTextureMapping;

    strict private FFdMetallic: TSFFloat;
    { Internal wrapper for property @link(Metallic). This wrapper API may change, we advise to access simpler @link(Metallic) instead. }
    public property FdMetallic: TSFFloat read FFdMetallic;
    { The metalness of the material; values range from 0.0 (non-metal) to 1.0 (metal). }
    property Metallic: Single read GetMetallic write SetMetallic;

    strict private FFdMetallicRoughnessTexture: TSFNode;
    { Internal wrapper for property @link(MetallicRoughnessTexture). This wrapper API may change, we advise to access simpler @link(MetallicRoughnessTexture) instead. }
    public property FdMetallicRoughnessTexture: TSFNode read FFdMetallicRoughnessTexture;
    { Control the @link(Metallic) and @link(Roughness) using a texture. The @italic(Blue) channel of this texture is multiplied with @link(Metallic). The @link(Green) channel is multiplied with @link(Roughness). The other channels are ignored. }
    property MetallicRoughnessTexture: TAbstractSingleTextureNode read GetMetallicRoughnessTexture write SetMetallicRoughnessTexture;

    strict private FFdMetallicRoughnessTextureMapping: TSFString;
    { Internal wrapper for property @link(MetallicRoughnessTextureMapping). This wrapper API may change, we advise to access simpler @link(MetallicRoughnessTextureMapping) instead. }
    public property FdMetallicRoughnessTextureMapping: TSFString read FFdMetallicRoughnessTextureMapping;
    { Determines texture coordinates used by @link(MetallicRoughnessTexture). }
    property MetallicRoughnessTextureMapping: String read GetMetallicRoughnessTextureMapping write SetMetallicRoughnessTextureMapping;

    strict private FFdOcclusionStrength: TSFFloat;
    { Internal wrapper for property @link(OcclusionStrength). This wrapper API may change, we advise to access simpler @link(OcclusionStrength) instead. }
    public property FdOcclusionStrength: TSFFloat read FFdOcclusionStrength;
    {  }
    property OcclusionStrength: Single read GetOcclusionStrength write SetOcclusionStrength;

    strict private FFdOcclusionTexture: TSFNode;
    { Internal wrapper for property @link(OcclusionTexture). This wrapper API may change, we advise to access simpler @link(OcclusionTexture) instead. }
    public property FdOcclusionTexture: TSFNode read FFdOcclusionTexture;
    {  }
    property OcclusionTexture: TAbstractSingleTextureNode read GetOcclusionTexture write SetOcclusionTexture;

    strict private FFdOcclusionTextureMapping: TSFString;
    { Internal wrapper for property @link(OcclusionTextureMapping). This wrapper API may change, we advise to access simpler @link(OcclusionTextureMapping) instead. }
    public property FdOcclusionTextureMapping: TSFString read FFdOcclusionTextureMapping;
    {  }
    property OcclusionTextureMapping: String read GetOcclusionTextureMapping write SetOcclusionTextureMapping;

    strict private FFdRoughness: TSFFloat;
    { Internal wrapper for property @link(Roughness). This wrapper API may change, we advise to access simpler @link(Roughness) instead. }
    public property FdRoughness: TSFFloat read FFdRoughness;
    { The roughness of the material; values range from 0.0 (smooth) to 1.0 (rough). }
    property Roughness: Single read GetRoughness write SetRoughness;

    strict private FFdTransparency: TSFFloat;
    { Internal wrapper for property @link(Transparency). This wrapper API may change, we advise to access simpler @link(Transparency) instead. }
    public property FdTransparency: TSFFloat read FFdTransparency;
    { Setting @name to value > 0 makes the object partially-transparent. Setting it to 1.0 makes it even invisible (but still collidable). If you want to render the object using blending (which is usually the case for partially-transparent) it is recommended to specify it explicitly using @link(TAppearanceNode.AlphaMode). }
    property Transparency: Single read GetTransparency write SetTransparency;

{$endif read_interface}

{$ifdef read_implementation}

{ TPhysicalMaterialNode ----------------------------------------------- }

function TPhysicalMaterialNode.GetBaseColor: TCastleColorRGB;
begin
  Result := FdBaseColor.Value;
end;

procedure TPhysicalMaterialNode.SetBaseColor(const Value: TCastleColorRGB);
begin
  FdBaseColor.Send(Value);
end;

function TPhysicalMaterialNode.GetBaseTexture: TAbstractSingleTextureNode;
begin
  if FdBaseTexture.Value is TAbstractSingleTextureNode then
    Result := TAbstractSingleTextureNode(FdBaseTexture.Value)
  else
    Result := nil;
end;

procedure TPhysicalMaterialNode.SetBaseTexture(const Value: TAbstractSingleTextureNode);
begin
  FdBaseTexture.Send(Value);
end;

function TPhysicalMaterialNode.GetBaseTextureMapping: String;
begin
  Result := FdBaseTextureMapping.Value;
end;

procedure TPhysicalMaterialNode.SetBaseTextureMapping(const Value: String);
begin
  FdBaseTextureMapping.Send(Value);
end;

function TPhysicalMaterialNode.GetMetallic: Single;
begin
  Result := FdMetallic.Value;
end;

procedure TPhysicalMaterialNode.SetMetallic(const Value: Single);
begin
  FdMetallic.Send(Value);
end;

function TPhysicalMaterialNode.GetMetallicRoughnessTexture: TAbstractSingleTextureNode;
begin
  if FdMetallicRoughnessTexture.Value is TAbstractSingleTextureNode then
    Result := TAbstractSingleTextureNode(FdMetallicRoughnessTexture.Value)
  else
    Result := nil;
end;

procedure TPhysicalMaterialNode.SetMetallicRoughnessTexture(const Value: TAbstractSingleTextureNode);
begin
  FdMetallicRoughnessTexture.Send(Value);
end;

function TPhysicalMaterialNode.GetMetallicRoughnessTextureMapping: String;
begin
  Result := FdMetallicRoughnessTextureMapping.Value;
end;

procedure TPhysicalMaterialNode.SetMetallicRoughnessTextureMapping(const Value: String);
begin
  FdMetallicRoughnessTextureMapping.Send(Value);
end;

function TPhysicalMaterialNode.GetOcclusionStrength: Single;
begin
  Result := FdOcclusionStrength.Value;
end;

procedure TPhysicalMaterialNode.SetOcclusionStrength(const Value: Single);
begin
  FdOcclusionStrength.Send(Value);
end;

function TPhysicalMaterialNode.GetOcclusionTexture: TAbstractSingleTextureNode;
begin
  if FdOcclusionTexture.Value is TAbstractSingleTextureNode then
    Result := TAbstractSingleTextureNode(FdOcclusionTexture.Value)
  else
    Result := nil;
end;

procedure TPhysicalMaterialNode.SetOcclusionTexture(const Value: TAbstractSingleTextureNode);
begin
  FdOcclusionTexture.Send(Value);
end;

function TPhysicalMaterialNode.GetOcclusionTextureMapping: String;
begin
  Result := FdOcclusionTextureMapping.Value;
end;

procedure TPhysicalMaterialNode.SetOcclusionTextureMapping(const Value: String);
begin
  FdOcclusionTextureMapping.Send(Value);
end;

function TPhysicalMaterialNode.GetRoughness: Single;
begin
  Result := FdRoughness.Value;
end;

procedure TPhysicalMaterialNode.SetRoughness(const Value: Single);
begin
  FdRoughness.Send(Value);
end;

function TPhysicalMaterialNode.GetTransparency: Single;
begin
  Result := FdTransparency.Value;
end;

procedure TPhysicalMaterialNode.SetTransparency(const Value: Single);
begin
  FdTransparency.Send(Value);
end;

class function TPhysicalMaterialNode.ClassX3DType: String;
begin
  Result := 'PhysicalMaterial';
end;

procedure TPhysicalMaterialNode.CreateNode;
begin
  inherited;

  FFdBaseColor := TSFColor.Create(Self, True, 'baseColor', Vector3(1, 1, 1));
   FdBaseColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBaseColor);

  FFdBaseTexture := TSFNode.Create(Self, True, 'baseTexture', [TAbstractSingleTextureNode]);
   FdBaseTexture.ChangeAlways := chEverything;
  AddField(FFdBaseTexture);

  FFdBaseTextureMapping := TSFString.Create(Self, True, 'baseTextureMapping', '');
   FdBaseTextureMapping.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBaseTextureMapping);

  FFdMetallic := TSFFloat.Create(Self, True, 'metallic', 1);
   FdMetallic.ChangeAlways := chVisibleNonGeometry;
   FdMetallic.MustBeNonnegative := true;
  AddField(FFdMetallic);

  FFdMetallicRoughnessTexture := TSFNode.Create(Self, True, 'metallicRoughnessTexture', [TAbstractSingleTextureNode]);
   FdMetallicRoughnessTexture.ChangeAlways := chEverything;
  AddField(FFdMetallicRoughnessTexture);

  FFdMetallicRoughnessTextureMapping := TSFString.Create(Self, True, 'metallicRoughnessTextureMapping', '');
   FdMetallicRoughnessTextureMapping.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMetallicRoughnessTextureMapping);

  FFdOcclusionStrength := TSFFloat.Create(Self, True, 'occlusionStrength', 1);
   FdOcclusionStrength.ChangeAlways := chVisibleNonGeometry;
   FdOcclusionStrength.MustBeNonnegative := true;
  AddField(FFdOcclusionStrength);

  FFdOcclusionTexture := TSFNode.Create(Self, True, 'occlusionTexture', [TAbstractSingleTextureNode]);
   FdOcclusionTexture.ChangeAlways := chEverything;
  AddField(FFdOcclusionTexture);

  FFdOcclusionTextureMapping := TSFString.Create(Self, True, 'occlusionTextureMapping', '');
   FdOcclusionTextureMapping.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdOcclusionTextureMapping);

  FFdRoughness := TSFFloat.Create(Self, True, 'roughness', 1);
   FdRoughness.ChangeAlways := chVisibleNonGeometry;
   FdRoughness.MustBeNonnegative := true;
  AddField(FFdRoughness);

  FFdTransparency := TSFFloat.Create(Self, True, 'transparency', 0);
   FdTransparency.ChangeAlways := chVisibleNonGeometry;
   FdTransparency.MustBeNonnegative := true;
  AddField(FFdTransparency);

  DefaultContainerField := 'material';
end;

{$endif read_implementation}
