{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetLoad: Boolean;
    procedure SetLoad(const Value: Boolean);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdLoad: TSFBool;
    { Internal wrapper for property @link(Load). This wrapper API may change, we advise to access simpler @link(Load) instead. }
    public property FdLoad: TSFBool read FFdLoad;
    {  }
    property Load: Boolean read GetLoad write SetLoad;

    strict private FFdUrl: TMFString;
    { Internal wrapper for property @link(Url). This wrapper API may change, we advise to access simpler @link(Url) instead. }
    public property FdUrl: TMFString read FFdUrl;
    {  }
    procedure SetUrl(const Value: array of string); overload;
    {  }
    procedure SetUrl(const Value: TCastleStringList); overload;

    strict private FFdBboxCenter: TSFVec3f;
    { Internal wrapper for property @link(BboxCenter). This wrapper API may change, we advise to access simpler @link(BboxCenter) instead. }
    public property FdBboxCenter: TSFVec3f read FFdBboxCenter;
    {  }
    property BBox: TBox3D read GetBBox write SetBBox;

    strict private FFdBboxSize: TSFVec3f;
    { Internal wrapper for property @link(BboxSize). This wrapper API may change, we advise to access simpler @link(BboxSize) instead. }
    public property FdBboxSize: TSFVec3f read FFdBboxSize;

{$endif read_interface}

{$ifdef read_implementation}

{ TInlineNode ----------------------------------------------- }

function TInlineNode.GetLoad: Boolean;
begin
  Result := FdLoad.Value;
end;

procedure TInlineNode.SetLoad(const Value: Boolean);
begin
  FdLoad.Send(Value);
end;

procedure TInlineNode.SetUrl(const Value: array of string);
begin
  FdUrl.Send(Value);
end;

procedure TInlineNode.SetUrl(const Value: TCastleStringList);
begin
  FdUrl.Send(Value);
end;

function TInlineNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure TInlineNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

class function TInlineNode.ClassX3DType: String;
begin
  Result := 'Inline';
end;

procedure TInlineNode.CreateNode;
begin
  inherited;

  FFdLoad := TSFBool.Create(Self, True, 'load', true);
   FdLoad.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLoad);

  FFdUrl := TMFString.Create(Self, True, 'url', []);
   FdUrl.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdUrl);

  FFdBboxCenter := TSFVec3f.Create(Self, False, 'bboxCenter', Vector3(0, 0, 0));
   FdBboxCenter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxCenter);

  FFdBboxSize := TSFVec3f.Create(Self, False, 'bboxSize', Vector3(-1, -1, -1));
   FdBboxSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxSize);
end;

{$endif read_implementation}
