{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDescription: String;
    procedure SetDescription(const Value: String);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdDescription: TSFString;
    { Internal wrapper for property @link(Description). This wrapper API may change, we advise to access simpler @link(Description) instead. }
    public property FdDescription: TSFString read FFdDescription;
    {  }
    property Description: String read GetDescription write SetDescription;

    strict private FFdParameter: TMFString;
    { Internal wrapper for property @link(Parameter). This wrapper API may change, we advise to access simpler @link(Parameter) instead. }
    public property FdParameter: TMFString read FFdParameter;
    {  }
    procedure SetParameter(const Value: array of string); overload;
    {  }
    procedure SetParameter(const Value: TCastleStringList); overload;

    strict private FFdUrl: TMFString;
    { Internal wrapper for property @link(Url). This wrapper API may change, we advise to access simpler @link(Url) instead. }
    public property FdUrl: TMFString read FFdUrl;
    {  }
    procedure SetUrl(const Value: array of string); overload;
    {  }
    procedure SetUrl(const Value: TCastleStringList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TAnchorNode ----------------------------------------------- }

function TAnchorNode.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure TAnchorNode.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

procedure TAnchorNode.SetParameter(const Value: array of string);
begin
  FdParameter.Send(Value);
end;

procedure TAnchorNode.SetParameter(const Value: TCastleStringList);
begin
  FdParameter.Send(Value);
end;

procedure TAnchorNode.SetUrl(const Value: array of string);
begin
  FdUrl.Send(Value);
end;

procedure TAnchorNode.SetUrl(const Value: TCastleStringList);
begin
  FdUrl.Send(Value);
end;

class function TAnchorNode.ClassX3DType: String;
begin
  Result := 'Anchor';
end;

procedure TAnchorNode.CreateNode;
begin
  inherited;

  FFdDescription := TSFString.Create(Self, True, 'description', '');
   FdDescription.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDescription);

  FFdParameter := TMFString.Create(Self, True, 'parameter', []);
   FdParameter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdParameter);

  FFdUrl := TMFString.Create(Self, True, 'url', []);
   FdUrl.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdUrl);
end;

{$endif read_implementation}
