-- File generated by the BNF Converter (bnfc 2.9.3).

{-# LANGUAGE PatternSynonyms #-}

-- | The abstract syntax of language BNFC.

module BNFC.Abs where

import Prelude (Char, Double, Integer, String)
import qualified Prelude as C
  ( Eq, Ord, Show, Read
  , Int, Maybe(..)
  )

data Grammar = Grammar [Def]
  deriving (C.Eq, C.Ord, C.Show, C.Read)

data Def
    = Rule Label Cat [Item]
    | Comment String
    | Comments String String
    | Internal Label Cat [Item]
    | Token Identifier Reg
    | PosToken Identifier Reg
    | Entryp [Cat]
    | Separator MinimumSize Cat String
    | Terminator MinimumSize Cat String
    | Delimiters Cat String String Separation MinimumSize
    | Coercions Identifier Integer
    | Rules Identifier [RHS]
    | Function Identifier [Arg] Exp
    | Layout [String]
    | LayoutStop [String]
    | LayoutTop
  deriving (C.Eq, C.Ord, C.Show, C.Read)

data Item = Terminal String | NTerminal Cat
  deriving (C.Eq, C.Ord, C.Show, C.Read)

data Cat = ListCat Cat | IdCat Identifier
  deriving (C.Eq, C.Ord, C.Show, C.Read)

data Label = Id Identifier | Wild | ListE | ListCons | ListOne
  deriving (C.Eq, C.Ord, C.Show, C.Read)

data Arg = Arg Identifier
  deriving (C.Eq, C.Ord, C.Show, C.Read)

data Separation = SepNone | SepTerm String | SepSepar String
  deriving (C.Eq, C.Ord, C.Show, C.Read)

data Exp
    = Cons Exp Exp
    | App Identifier [Exp]
    | Var Identifier
    | LitInt Integer
    | LitChar Char
    | LitString String
    | LitDouble Double
    | List [Exp]
  deriving (C.Eq, C.Ord, C.Show, C.Read)

data RHS = RHS [Item]
  deriving (C.Eq, C.Ord, C.Show, C.Read)

data MinimumSize = MNonempty | MEmpty
  deriving (C.Eq, C.Ord, C.Show, C.Read)

data Reg
    = RAlt Reg Reg
    | RMinus Reg Reg
    | RSeq Reg Reg
    | RStar Reg
    | RPlus Reg
    | ROpt Reg
    | REps
    | RChar Char
    | RAlts String
    | RSeqs String
    | RDigit
    | RLetter
    | RUpper
    | RLower
    | RAny
  deriving (C.Eq, C.Ord, C.Show, C.Read)

newtype Identifier = Identifier ((C.Int, C.Int), String)
  deriving (C.Eq, C.Ord, C.Show, C.Read)

-- | Start position (line, column) of something.

type BNFC'Position = C.Maybe (C.Int, C.Int)

pattern BNFC'NoPosition :: BNFC'Position
pattern BNFC'NoPosition = C.Nothing

pattern BNFC'Position :: C.Int -> C.Int -> BNFC'Position
pattern BNFC'Position line col = C.Just (line, col)

-- | Get the start position of something.

class HasPosition a where
  hasPosition :: a -> BNFC'Position

instance HasPosition Identifier where
  hasPosition (Identifier (p, _)) = C.Just p

