SET(BALLVIEW_SOURCE_DIR ${PROJECT_SOURCE_DIR}/source/APPLICATIONS/BALLVIEW)

SET(CPACK_PACKAGE_NAME "BALL")
SET(CPACK_PACKAGE_VENDOR "ball-project.org")
SET(CPACK_PACKAGE_DESCRIPTION_SUMMARY "BALL - The Biochemical Algorithms Library")
SET(CPACK_PACKAGE_VERSION "${PROJECT_VERSION}")
SET(CPACK_PACKAGE_VERSION_MAJOR "${PROJECT_VERSION_MAJOR}")
SET(CPACK_PACKAGE_VERSION_MINOR "${PROJECT_VERSION_MINOR}")
SET(CPACK_PACKAGE_VERSION_PATCH "${PROJECT_VERSION_PATCH}")
SET(CPACK_PACKAGE_INSTALL_DIRECTORY "BALL-${CPACK_PACKAGE_VERSION}")
SET(CPACK_PACKAGE_DESCRIPTION_FILE "${BALLVIEW_SOURCE_DIR}/Welcome.rtf")
SET(CPACK_RESOURCE_FILE_WELCOME "${BALLVIEW_SOURCE_DIR}/Welcome.rtf")
SET(CPACK_RESOURCE_FILE_LICENSE "${PROJECT_SOURCE_DIR}/COPYRIGHT")

IF (WIN32 AND NOT UNIX)

	SET(BALL_WIN_ARCHITECTURE "win32")
	IF (CMAKE_SIZEOF_VOID_P EQUAL 8)
		SET(CPACK_NSIS_INSTALL_ROOT "$PROGRAMFILES64")
		SET(BALL_WIN_ARCHITECTURE "win64")
	ENDIF()

	IF(MSVC10)
		SET(CPACK_PACKAGE_FILE_NAME "BALL-${PROJECT_VERSION}-${BALL_WIN_ARCHITECTURE}-msvc2010")
	ELSEIF(MSVC11)
		SET(CPACK_PACKAGE_FILE_NAME "BALL-${PROJECT_VERSION}-${BALL_WIN_ARCHITECTURE}-msvc2012")
	ELSEIF(MSVC12)
		SET(CPACK_PACKAGE_FILE_NAME "BALL-${PROJECT_VERSION}-${BALL_WIN_ARCHITECTURE}-msvc2013")
	ELSEIF(MSVC14)
		SET(CPACK_PACKAGE_FILE_NAME "BALL-${PROJECT_VERSION}-${BALL_WIN_ARCHITECTURE}-msvc2015")
	ENDIF()

	SET(CPACK_NSIS_MUI_ICON "${PROJECT_SOURCE_DIR}\\\\data\\\\graphics\\\\ballview.ico")
	SET(CPACK_NSIS_MUI_UNIICON "${PROJECT_SOURCE_DIR}\\\\data\\\\graphics\\\\ballview.ico")
	SET(CPACK_PACKAGE_ICON "${PROJECT_SOURCE_DIR}\\\\data\\\\graphics\\\\nsis_installer_header.bmp")
	SET(CPACK_NSIS_INSTALLED_ICON_NAME "bin\\\\BALLView.exe")
	IF (BALL_HAS_RTFACT)
		SET(CPACK_PACKAGE_NAME "BALL-RT")
		SET(CPACK_NSIS_DISPLAY_NAME "BALLView-RT-${CPACK_PACKAGE_VERSION}")
	ELSE()
		SET(CPACK_NSIS_DISPLAY_NAME "BALLView-${CPACK_PACKAGE_VERSION}")
	ENDIF()
	SET(CPACK_NSIS_HELP_LINK "http:\\\\\\\\www.ball-project.org")
	SET(CPACK_NSIS_URL_INFO_ABOUT "http:\\\\\\\\www.ball-project.org")
	SET(CPACK_NSIS_CONTACT "ball@bioinf.uni-sb.de")
	SET(CPACK_NSIS_EXTRA_INSTALL_COMMANDS "NOT-FOUND")
	SET(CPACK_NSIS_EXTRA_UNINSTALL_COMMANDS "NOT-FOUND")
	FILE(READ "${PROJECT_SOURCE_DIR}/cmake/NSISExtraInstallCommands.cmake" CPACK_NSIS_EXTRA_INSTALL_COMMANDS)
	FILE(READ "${PROJECT_SOURCE_DIR}/cmake/NSISExtraUninstallCommands.cmake" CPACK_NSIS_EXTRA_UNINSTALL_COMMANDS)
	IF (PYTHON_INSTALLER)
		CONFIGURE_FILE(${PROJECT_SOURCE_DIR}/cmake/NSISEmbeddedInstallers.cmake.in ${PROJECT_BINARY_DIR}/NSISEmbeddedInstallers.nsh)
		SET(CPACK_NSIS_EMBEDDED_INSTALLERS "!Include ..\\\\..\\\\..\\\\NSISEmbeddedInstallers.nsh")
	ENDIF()
	# NOTE: CPack overwrites this option, so it is currently ignored *sigh*. Thus, we use
	#       our own NSIS template
	SET(CPACK_NSIS_DEFINES "  RequestExecutionLevel highest")
	SET(CPACK_NSIS_EXTRA_DEFINES "  RequestExecutionLevel highest")

	SET(CPACK_PACKAGE_EXECUTABLES ${BALL_EXECUTABLES})
ELSEIF(APPLE)
	EXECUTE_PROCESS(COMMAND sw_vers -productVersion OUTPUT_VARIABLE SW_VERS_OUTPUT)
	STRING(FIND ${SW_VERS_OUTPUT} "." PATCH_VERSION_DELIM REVERSE)
	STRING(SUBSTRING ${SW_VERS_OUTPUT} 0 ${PATCH_VERSION_DELIM} MACOS_PRODUCT_VER)
	SET(CPACK_PACKAGE_FILE_NAME "BALLView-${PROJECT_VERSION}-macOS-${MACOS_PRODUCT_VER}")

	SET(CPACK_GENERATOR DragNDrop)
ELSE()
	SET(CPACK_STRIP_FILES "bin/BALLView bin/libBALL.so bin/libVIEW.so")
ENDIF()

INCLUDE(CPack)
