/*
 * Decompiled with CFR 0.152.
 */
package $installer$.org.aspectj;

import $installer$.org.aspectj.InstallContext;
import $installer$.org.aspectj.InstallPane;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class JarUnpacker {
    InstallContext context;
    InstallPane installPane;
    static final int BUF_SIZE = 4096;

    public JarUnpacker(InstallContext context, InstallPane installPane) {
        this.context = context;
        this.installPane = installPane;
    }

    public File makeOutputFile(String name, File outputFile) {
        int index;
        int lastIndex = 0;
        while ((index = name.indexOf(47, lastIndex)) != -1) {
            outputFile = new File(outputFile, name.substring(lastIndex, index));
            lastIndex = index + 1;
        }
        return new File(outputFile, name.substring(lastIndex));
    }

    public void writeStream(ZipInputStream zis, File outputFile) throws IOException {
        if (outputFile.exists() && !this.context.shouldOverwrite(outputFile)) {
            return;
        }
        this.installPane.progressMessage("writing " + outputFile.getAbsolutePath());
        outputFile.getParentFile().mkdirs();
        if (this.context.isTextFile(outputFile)) {
            this.writeTextStream(zis, outputFile);
        } else {
            this.writeBinaryStream(zis, outputFile);
        }
    }

    public void writeBinaryStream(ZipInputStream zis, File outputFile) throws IOException {
        byte[] buffer = new byte[4096];
        int nRead = 0;
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outputFile));
        while ((nRead = zis.read(buffer)) != -1) {
            ((OutputStream)os).write(buffer, 0, nRead);
            this.installPane.progressBytesWritten(nRead);
        }
        ((OutputStream)os).close();
    }

    public void writeTextStream(ZipInputStream zis, File outputFile) throws IOException {
        String l;
        BufferedWriter os = new BufferedWriter(new FileWriter(outputFile));
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)zis, "US-ASCII"));
        while ((l = r.readLine()) != null) {
            os.write(l);
            os.newLine();
            this.installPane.progressBytesWritten(l.length() + 1);
        }
        os.close();
    }

    public void writeEntry(ZipInputStream zis, ZipEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            return;
        }
        String name = entry.getName();
        File outputFile = this.makeOutputFile(name, outputDir);
        this.writeStream(zis, outputFile);
    }

    public void unpack(String jarName, File outputDir) throws IOException {
        ZipEntry entry;
        URL url = this.getClass().getResource(jarName);
        InputStream stream = url.openStream();
        ZipInputStream zis = new ZipInputStream(stream);
        while ((entry = zis.getNextEntry()) != null) {
            this.writeEntry(zis, entry, outputDir);
        }
        this.installPane.progressMessage("done writing");
    }
}

