#include <iostream>

using namespace std;

static const int MaxBufferSize = 1024000;

const int getMBS() { return MaxBufferSize; }

class Connection
{
public:
    int readDataIntoBuffer(int maxSize = MaxBufferSize + getMBS() );
};

int Connection::readDataIntoBuffer(int maxSize)
{
    if (maxSize > MaxBufferSize)
        return 0;

    return 10;
}

int main() {
  int x = 42;
  Connection con;

  x = con.readDataIntoBuffer();
  cout << x << endl;

  x = con.readDataIntoBuffer( 1024 );
  cout << x << endl;

  return 0;
}

aspect TestExecution {
  int gets_, builtins_, calls_;

  advice call("int Connection::readDataIntoBuffer(int)"): around() {
    gets_ = calls_ = builtins_ = 0;
    tjp->proceed();
    cout << gets_ << "x get 'const int MaxBufferSize'" << endl;
    cout << calls_ << "x call 'const int getMBS()'" << endl;
    cout << builtins_ << "x builtin 'int operator +(int,int)'" << endl;
    cout << "result: ";
  }

  advice call("const int getMBS()") : before() { calls_++; }
  advice builtin("int operator +(int,int)") : before() { builtins_++; }
  advice get("const int MaxBufferSize") : before () { gets_++; }
};
