/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.rdfpatch;

public class RDFPatchWrapper implements RDFPatch {

    private final RDFPatch other;
    protected final RDFPatch get() { return other; }

    public RDFPatchWrapper(RDFPatch other) {
        this.other = other;
    }

    @Override
    public PatchHeader header() {
        return other.header();
    }

    @Override
    public void apply(RDFChanges changes) {
        other.apply(changes);
    }

    @Override
    public boolean repeatable() {
        return other.repeatable();
    }
}
