Antimony 0.9.0
--------------

### News:
This release has a new f-rep parser and a new graph engine!

Not much has changed on the user-facing side of things, but the internals
are much spiffier (and will be easier to build on in the future).

--------------------------------------------------------------------------------

### New parser

The f-rep parser has been rewritten by @fros1y to use [lemon](http://www.hwaci.com/sw/lemon/)
and [flex](http://flex.sourceforge.net/) instead of a homebrew solution.

In this rewrite, a second way of expression math was added: infix notation
(a.k.a. the way that most people write math).  For example, instead of writing

`-+qXqYf1`

you can write

`=pow(X, 2) + pow(Y, 2) - 1;`

The leading `=` and trailing `;` indicate to the parser that this is an infix
string.

For examples of this new syntax, check out the [cylinder wrap](https://github.com/mkeeter/antimony/blob/develop/py/fab/shapes.py#L804-L824)
function.

--------------------------------------------------------------------------------

### New graph engine
The graph engine has been rewritten from the ground up as a stand-alone library
(though its design is optimized for Antimony's use-case).  It no longer uses Qt
signals and slots (or at all!), preferring the STL and C++11.

There's a slick re-evaluation optimization: when an upstream object changes,
the engine properly sequences downstream update calls to minimize the number
of times scripts and datums get re-evaluated.  In practice, I've seen a 5x
speedup on very large graphs.

--------------------------------------------------------------------------------

### Breaking changes:
Some of the changes made here are potentially breaking.  There's a transparent
migration path from older files; feel free to report bugs if it fails for you.

#### Namespaces
These changes will be find-and-replaced when older files are loaded, so things
should Just Work in most cases.
- `fab.ui` namespace has been renamed `sb.ui`
- `meta` object (which contains export functions) has been renamed `sb.export`
- `fab.color` object has been renamed `sb.color`

#### Graph changes:
It's no longer legal to connect an output datum to an input in the same script.
Previously, this was legal (but a bad idea).

Datums of type `str` must have their expressions quoted.  Previously, there was
a magic check to auto-quote them if evaluation failed.

--------------------------------------------------------------------------------

### Other features:
- `Return` key acts like tab when editing datums in an inspector.
- Unary operators (rotate, scale, etc) preserve shape color.
- More information is displayed in viewport (thanks, @joshuashort)
- User data directory is searched for nodes (thanks, @astronouth7303)
- Gradients are calculated exactly (improves rendering quality).
- `right_triangle` now supports negative widths and heights
- Keyboard arrows (up and down) adjust datum values in inspectors.
- `arctan2` operator is now available in f-reps
- Fun new nodes: volume-filling gyroids!

### Bugfixes:
- `.sb` extension is now added on Linux.
- UTF-8 is used regardless of locale settings.

### Thanks
Thanks to the following Github users for their contributions, large and small:
- @fros1y
- @joshuashort
- @astronouth7303
- @toomuchcookies
- @neilger
- @defnull
