(in-package "ACL2S")

(property ceil-<= (x :pos-rational) (<= x (ceiling x 1)))

(property y<=x^cx<cy->cx<y (x y :pos-rational)
  (implies (and (<= y x)
		(< (ceiling x 1) (ceiling y 1)))
	   (< (ceiling x 1) y)))

(property y>x^cx<cy->cx<y-lem1 (x y :pos-rational)
  (implies (and (< x y)
		(< (ceiling x 1) (ceiling y 1))
		(<= y (ceiling x 1)))
	   (equal (ceiling y 1) (ceiling x 1))))

(property y>x^cx<cy->cx<y^x<=ceilx (x y :pos-rational)
  (implies (and (< x y)
		(< (ceiling x 1) (ceiling y 1)))
	   (and (<= x (ceiling x 1))
		(< (ceiling x 1) y)))
  :hints (("Goal" :use (:instance y>x^cx<cy->cx<y-lem1 (x x) (y y)))))
	   
(property cx<cy->cx<y (x y :pos-rational)
  (implies (< (ceiling x 1) (ceiling y 1))
	   (< (ceiling x 1) y))
  :hints (("Goal" :use (:instance y>x^cx<cy->cx<y^x<=ceilx (x x) (y y))
	   :cases ((< x y) (>= x y)))))

(property ceilx/mn-lem1 (m n :pos x :pos-rational)
  (<= (ceiling (/ x (* m n)) 1)
      (ceiling (/ (ceiling (/ x m) 1) n) 1)))

(property ceilx/mn-lem2 (m n :pos x :pos-rational)
  (and (pos-rationalp (* x (/ (* m n))))
       (pos-rationalp (* (ceiling (* x (/ m)) 1) (/ n)))))

(property ceilx/mn-lem3 (m n :pos x :pos-rational)
  (implies (< (ceiling (* x (/ (* m n))) 1)
	      (ceiling (* (ceiling (* x (/ m)) 1) (/ n)) 1))
	   (< (ceiling (* x (/ (* m n))) 1)
	      (* (ceiling (* x (/ m)) 1) (/ n))))
  :hints (("Goal" :use (:instance cx<cy->cx<y
				  (x (* x (/ (* m n))))
				  (y (* (ceiling (* x (/ m)) 1) (/ n)))))))

(property ceilx/mn-lem4 (m n :pos x :pos-rational)
  (implies (< (ceiling (* x (/ (* m n))) 1)
	      (ceiling (* (ceiling (* x (/ m)) 1) (/ n))
		       1))
	   (and (<= (* x (/ (* m n)))
		    (ceiling (* x (/ (* m n))) 1))
		(< (ceiling (* x (/ (* m n))) 1)
		   (* (ceiling (* x (/ m)) 1) (/ n)))))
  :hints (("Goal" :use (:instance ceilx/mn-lem3 (m m) (n n) (x x)))))

(property ceilx/mn-lem5 (m n :pos x :pos-rational)
  (implies (< (ceiling (* x (/ (* m n))) 1)
	      (ceiling (* (ceiling (* x (/ m)) 1) (/ n))
		       1))
	   (<= (/ x m)
	       (* n (ceiling (* x (/ (* m n))) 1)))))

(property ceilx/mn-lem6 (m n :pos x :pos-rational)
  (implies (< (ceiling (* x (/ (* m n))) 1)
	      (ceiling (* (ceiling (* x (/ m)) 1) (/ n))
		       1))
	   (< (ceiling (* x (/ (* m n))) 1)
	      (* (ceiling (* x (/ m)) 1) (/ n))))
  :hints (("Goal" :use (:instance ceilx/mn-lem4 (m m) (n n) (x x)))))

(property ceilx/mn-lem7 (m n :pos x :pos-rational)
  (implies (< (ceiling (* x (/ (* m n))) 1)
	      (ceiling (* (ceiling (* x (/ m)) 1) (/ n))
		       1))
	   (< (* n (ceiling (* x (/ (* m n))) 1))
	      (ceiling (/ x m) 1)))
  :hints (("Goal" :use (:instance ceilx/mn-lem6 (m m) (n n) (x x)))))

(property ceilx/mn-prefixLems (m n :pos x :pos-rational)
  (and (< (- (ceiling (/ x m) 1) 1) (/ x m))
       (<= (/ x m) (ceiling (/ x m) 1))
       (< (/ (- (ceiling (/ x m) 1) 1) n)
	  (/ x (* m n)))
       (<= (/ x (* m n))
	   (/ (ceiling (/ x m) 1) n))
       (and (< (- (ceiling (/ x m) 1) 1) (/ x m))
                     (<= (/ x m) (ceiling (/ x m) 1))
                     (< (/ (- (ceiling (/ x m) 1) 1) n)
                        (/ x (* m n)))
                     (<= (/ x (* m n))
                         (/ (ceiling (/ x m) 1) n)))
       (<= (ceiling (/ x (* m n)) 1)
	   (ceiling (/ (ceiling (/ x m) 1) n) 1))))

(property ceilx/mn-lem8 (m n :pos x :pos-rational)
  (implies (< (ceiling (* x (/ (* m n))) 1)
	      (ceiling (* (ceiling (* x (/ m)) 1) (/ n))
		       1))
	   (and (< (+ -1 (ceiling (* x (/ m)) 1))
                        (* x (/ m)))
                     (<= (* x (/ m)) (ceiling (* x (/ m)) 1))
                     (< (* (+ -1 (ceiling (* x (/ m)) 1)) (/ n))
                        (* x (/ (* m n))))
                     (<= (* x (/ (* m n)))
                         (* (ceiling (* x (/ m)) 1) (/ n)))
                     (and (< (+ -1 (ceiling (* x (/ m)) 1))
                             (* x (/ m)))
                          (<= (* x (/ m)) (ceiling (* x (/ m)) 1))
                          (< (* (+ -1 (ceiling (* x (/ m)) 1)) (/ n))
                             (* x (/ (* m n))))
                          (<= (* x (/ (* m n)))
                              (* (ceiling (* x (/ m)) 1) (/ n))))
                     (<= (ceiling (* x (/ (* m n))) 1)
                         (ceiling (* (ceiling (* x (/ m)) 1) (/ n))
                                  1))))
  :hints (("Goal" :use (:instance ceilx/mn-prefixlems (m m)
                         (n n)
                         (x x)))))

(property ceilx/mn-lem9 (m n :pos x :pos-rational)
  (implies (< (ceiling (* x (/ (* m n))) 1)
	      (ceiling (* (ceiling (* x (/ m)) 1) (/ n))
		       1))
	   (< (ceiling (* x (/ (* m n))) 1)
	      (* (ceiling (* x (/ m)) 1) (/ n))))
  :hints (("Goal" :use
	  ((:instance ceilx/mn-lem8 (m m) (n n) (x x))
	   (:instance ceilx/mn-lem1 (m m) (n n) (x x))
	   (:instance ceilx/mn-lem3 (m m) (n n) (x x))))))

(property ceilx/mn-lem10 (m n :pos x :pos-rational)
  (implies (< (ceiling (* x (/ (* m n))) 1)
	      (ceiling (* (ceiling (* x (/ m)) 1) (/ n))
		       1))
	   (<= (/ x m) (* n (ceiling (* x (/ (* m n))) 1)))))

(property ceilx/mn-lem11 (m n :pos x :pos-rational)
  (implies (< (ceiling (* x (/ (* m n))) 1)
	      (ceiling (* (ceiling (* x (/ m)) 1) (/ n))
		       1))
	   (< (* n (ceiling (* x (/ (* m n))) 1))
	      (ceiling (/ x m) 1)))
  :hints (("Goal" :use (:instance ceilx/mn-lem9 (m m) (n n) (x x)))))

(property ceilx/mn-lems-11-pre-10 (m n :pos x :pos-rational)
  (and (implies (< (ceiling (* x (/ (* m n))) 1)
		   (ceiling (* (ceiling (* x (/ m)) 1) (/ n))
			    1))
		(and (< (* n (ceiling (* x (/ (* m n))) 1))
			(ceiling (/ x m) 1))
		     (<= (/ x m) (* n (ceiling (* x (/ (* m n))) 1)))))
       (< (- (ceiling (/ x m) 1) 1) (/ x m))
       (<= (/ x m) (ceiling (/ x m) 1))
       (< (/ (- (ceiling (/ x m) 1) 1) n)
	  (/ x (* m n)))
       (<= (/ x (* m n))
	   (/ (ceiling (/ x m) 1) n))
       (and (< (- (ceiling (/ x m) 1) 1) (/ x m))
	    (<= (/ x m) (ceiling (/ x m) 1))
	    (< (/ (- (ceiling (/ x m) 1) 1) n)
	       (/ x (* m n)))
	    (<= (/ x (* m n))
		(/ (ceiling (/ x m) 1) n)))
       (<= (ceiling (/ x (* m n)) 1)
	   (ceiling (/ (ceiling (/ x m) 1) n) 1)))
  :hints (("Goal" :use ((:instance ceilx/mn-lem11 (m m) (n n) (x x))
			(:instance ceilx/mn-prefixlems (m m) (n n) (x x))
			(:instance ceilx/mn-lem10 (m m) (n n) (x x))))))

(property ceilx/mn-lem-12 (m n :pos x :pos-rational)
  (implies
   (< (ceiling (* x (/ (* m n))) 1)
      (ceiling (* (ceiling (* x (/ m)) 1) (/ n))
	       1))
   (and
    (< (* n (ceiling (* x (/ (* m n))) 1))
       (ceiling (* x (/ m)) 1))
    (<= (* x (/ m))
	(* n (ceiling (* x (/ (* m n))) 1)))
    (< (+ -1 (ceiling (* x (/ m)) 1))
       (* x (/ m)))
    (<= (* x (/ m)) (ceiling (* x (/ m)) 1))
    (< (* (+ -1 (ceiling (* x (/ m)) 1)) (/ n))
       (* x (/ (* m n))))
    (<= (* x (/ (* m n)))
	(* (ceiling (* x (/ m)) 1) (/ n)))
    (and (< (+ -1 (ceiling (* x (/ m)) 1))
	    (* x (/ m)))
	 (<= (* x (/ m)) (ceiling (* x (/ m)) 1))
	 (< (* (+ -1 (ceiling (* x (/ m)) 1)) (/ n))
	    (* x (/ (* m n))))
	 (<= (* x (/ (* m n)))
	     (* (ceiling (* x (/ m)) 1) (/ n))))
    (<= (ceiling (* x (/ (* m n))) 1)
	(ceiling (* (ceiling (* x (/ m)) 1) (/ n))
		 1))))
  :hints (("Goal" :use (:instance ceilx/mn-lems-11-pre-10 (m m) (n n) (x x)))))

(property ceilx/mn-lem-13 (m n :pos x :pos-rational)
  (implies
   (and (< (ceiling (* x (/ (* m n))) 1)
      (ceiling (* (ceiling (* x (/ m)) 1) (/ n))
	       1))
    (< (* n (ceiling (* x (/ (* m n))) 1))
       (ceiling (* x (/ m)) 1))
    (<= (* x (/ m))
	(* n (ceiling (* x (/ (* m n))) 1)))
    (< (+ -1 (ceiling (* x (/ m)) 1))
       (* x (/ m)))
    (<= (* x (/ m)) (ceiling (* x (/ m)) 1))
    (< (* (+ -1 (ceiling (* x (/ m)) 1)) (/ n))
       (* x (/ (* m n))))
    (<= (* x (/ (* m n)))
	(* (ceiling (* x (/ m)) 1) (/ n)))
    (and (< (+ -1 (ceiling (* x (/ m)) 1))
	    (* x (/ m)))
	 (<= (* x (/ m)) (ceiling (* x (/ m)) 1))
	 (< (* (+ -1 (ceiling (* x (/ m)) 1)) (/ n))
	    (* x (/ (* m n))))
	 (<= (* x (/ (* m n)))
	     (* (ceiling (* x (/ m)) 1) (/ n))))
    (<= (ceiling (* x (/ (* m n))) 1)
	(ceiling (* (ceiling (* x (/ m)) 1) (/ n))
		 1)))
   (equal (ceiling (/ x (* m n)) 1)
	  (ceiling (/ (ceiling (/ x m) 1) n) 1))))

(property ceilx/mn-lem-14 (m n :pos x :pos-rational)
  (implies
   (< (ceiling (* x (/ (* m n))) 1)
      (ceiling (* (ceiling (* x (/ m)) 1) (/ n))
	       1))
   (equal (ceiling (/ x (* m n)) 1)
	  (ceiling (/ (ceiling (/ x m) 1) n) 1)))
  :hints (("Goal" :use
	   ((:instance ceilx/mn-lem-12 (m m) (n n) (x x))
	    (:instance ceilx/mn-lem-13 (m m) (n n) (x x))))))

(property ceilx/mn-lem-15 (m n :pos x :pos-rational)
  (implies
   (not (< (ceiling (* x (/ (* m n))) 1)
	   (ceiling (* (ceiling (* x (/ m)) 1) (/ n)) 1)))
   (equal (ceiling (/ x (* m n)) 1)
	  (ceiling (/ (ceiling (/ x m) 1) n) 1))))
   
(property ceilx/mn=ceilceilx/m/n (m n :pos x :pos-rational)
  (equal (ceiling (/ x (* m n)) 1)
	 (ceiling (/ (ceiling (/ x m) 1) n) 1))
  :hints (("Goal" :use ((:instance ceilx/mn-lem-14 (m m) (n n) (x x))
			(:instance ceilx/mn-lem-15 (m m) (n n) (x x))))))

(in-theory (disable ceilx/mn-lem1
		    ceilx/mn-lem2
		    ceilx/mn-lem3
		    ceilx/mn-lem4
		    ceilx/mn-lem5
		    ceilx/mn-lem6
		    ceilx/mn-lem7
		    ceilx/mn-lem8
		    ceilx/mn-lem9
		    ceilx/mn-lem10
		    ceilx/mn-lem11
		    ceilx/mn-lems-11-pre-10
		    ceilx/mn-lem-12
		    ceilx/mn-lem-13
		    ceilx/mn-lem-14
		    ceilx/mn-lem-15))
	    
(property divide-ineq (x y z :pos-rational)
  (implies (and (< 0 x) (<= y z))
       (<= (/ y x) (/ z x))))

(property multiply-ineq (x y z :pos-rational)
  (implies (and (< 0 x) (<= y z))
	   (<= (* y x) (* z x))))


#|
The remainder of this proof follows a proof sketch written by Ken McMillan (in 
unpublished correspondence, as part of the above-mentioned NETYS 2023 paper).
Note however that Ken's sketch skipped many intermediary steps and small details
which we naturally are forced (by the prover) to flush out in full detail here.
|#
(property step-1-kens-proof (a k :pos-rational)
  (implies (and (< a 1)
		(equal k (ceiling (/ a (- 1 a)) 1)))
	   (<= a (/ k (1+ k))))
  :hints (("Goal" :use ((:instance multiply-ineq (x (- 1 a))
                                             (y (* a (/ (+ 1 (- a)))))
                                             (z k))
			(:instance divide-ineq (x (1+ k))
                                             (y (* a (1+ k)))
                                             (z k))))))

(definecd fn (a n :pos-rational) :pos-rational
  :ic (< a 1)
  (let ((k (ceiling (/ a (- 1 a)) 1)))
    (/ (* k (expt a k)) n)))

;; Claim: k a^k / k = a^k.
(property k*a^k/k=a^k (k :pos a :pos-rational)
  (equal (/ (* k (expt a k)) k)
	 (expt a k)))

(property base-case-kens-proof-lem1 (a :pos-rational)
  (implies (< a 1) (posp (ceiling (* a (/ (+ 1 (- a)))) 1))))

(property base-case-kens-proof-lem2 (a :pos-rational)
  (implies (< a 1)
	   (equal (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
			(expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
		     (/ (ceiling (* a (/ (+ 1 (- a)))) 1)))
		  (expt a (ceiling (* a (/ (+ 1 (- a)))) 1))))
  :hints (("Goal" :use (:instance k*a^k/k=a^k
                            (k (ceiling (* a (/ (+ 1 (- a)))) 1))
                            (a a)))))

(property base-case-kens-proof-lem3 (a :pos-rational)
  (implies (< a 1)
	   (equal (fn a (ceiling (* a (/ (+ 1 (- a)))) 1))
		  (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1))
			(n (ceiling (* a (/ (+ 1 (- a)))) 1)))
		    (* (* k (expt a k)) (/ n)))))
  :hints (("Goal" :use (:instance fn-definition-rule (a a)
				  (n (ceiling (/ a (- 1 a)) 1))))))

(property base-case-kens-proof-lem4 (a :pos-rational)
  (implies (< a 1)
	   (equal (fn a (ceiling (* a (/ (+ 1 (- a)))) 1))
		  (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
			(expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
		     (/ (ceiling (* a (/ (+ 1 (- a)))) 1)))))
  :hints (("Goal" :use (:instance base-case-kens-proof-lem3 (a a)))))

(property base-case-kens-proof-lem5 (a :pos-rational)
  (implies (< a 1)
	   (implies
	    (equal (fn a (ceiling (* a (/ (+ 1 (- a)))) 1))
		   (expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
	    (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
	      (equal (fn a k) (expt a k))))))

(property div-mul-thm (x y :pos-rational)
  (implies (not (equal y 0))
	   (equal (* y (/ x y)) x)))

(property base-case-kens-proof-lem6 (a :pos-rational)
  (implies (< a 1)
	   (equal (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
			(expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
		     (/ (ceiling (* a (/ (+ 1 (- a)))) 1)))
		  (expt a (ceiling (* a (/ (+ 1 (- a)))) 1))))
  :hints (("Goal" :use (:instance div-mul-thm
				  (y (ceiling (* a (/ (+ 1 (- a)))) 1))
				  (x (expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))))))

(property base-case-kens-proof (a :pos-rational)
  (implies (< a 1)
	   (let ((k (ceiling (/ a (- 1 a)) 1)))
	     (equal (fn a k) (expt a k))))
  :hints (("Goal" :use ((:instance base-case-kens-proof-lem4 (a a))
			(:instance base-case-kens-proof-lem6 (a a))))))

(in-theory (disable base-case-kens-proof-lem1
		    base-case-kens-proof-lem2
		    base-case-kens-proof-lem3
		    base-case-kens-proof-lem4
		    base-case-kens-proof-lem5
		    base-case-kens-proof-lem6))

(property div-lem-ind-step (k n :nat)
  (implies (<= k n)
       (<= (/ k (1+ k))
           (/ n (1+ n)))))

(property repl-mul-<= (a b x z :pos-rational)
  (implies (and (<= a b)
        (<= x (* a z)))
	   (<= x (* b z))))

#|
Thm: a^{n+1} <= a * (k a^k / n) -> a^{n+1} <= k a^k / (1+n)
|#
(property incr-denom-lemma (k n :pos a :pos-rational)
  (implies (and (<= (expt a (+ 1 n))
                    (* (* k (expt a k)) (/ n) a))
		(<= a (/ n (1+ n))))
	   (<= (expt a (+ 1 n))
               (* k (expt a k) (/ (1+ n)))))
  :hints (("Goal" :use (:instance repl-mul-<= (x (expt a (+ 1 n)))
                                       (a a)
                                       (b (* n (/ (+ 1 n))))
                                       (z (* k (expt a k) (/ n)))))))

(property iskp-lem1 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (<= a (* (ceiling (/ a (- 1 a)) 1)
		    (/ (+ 1 (ceiling (/ a (- 1 a)) 1))))))
  :hints (("Goal" :use (:instance step-1-kens-proof
				  (a a)
				  (k (ceiling (/ a (- 1 a)) 1))))))

(property iskp-lem2 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (<= (/ (ceiling (/ a (- 1 a)) 1) (1+ (ceiling (/ a (- 1 a)) 1)))
	       (/ n (1+ n))))
  :hints (("Goal" :use (:instance div-lem-ind-step
				  (k (ceiling (/ a (- 1 a)) 1))
				  (n n)))))

(property iskp-lem3 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (<= (* (expt a n) a) (* (fn a n) a))))

(property iskp-lem4 (a :pos-rational n :nat)
  (equal (* (expt a n) a)
	 (expt a (1+ n))))

(property iskp-lem5 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (equal (fn a n)
		  (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
		    (* (* k (expt a k)) (/ n)))))
  :hints (("Goal" :use (:instance fn-definition-rule (a a)
				  (n n)))))

(property iskp-lem6 (a :pos-rational n :nat)
  (implies (and (< a 1) (<= (ceiling (/ a (- 1 a)) 1) n))
	   (equal (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
			(expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
		     (/ n))
		  (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
		    (* (* k (expt a k)) (/ n))))))

(property iskp-lem7 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (and (equal (fn a n)
		       (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
			 (* (* k (expt a k)) (/ n))))
		(equal (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
			     (expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
			  (/ n))
		       (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
			 (* (* k (expt a k)) (/ n))))))
  :hints (("Goal" :use ((:instance iskp-lem5 (a a) (n n))
			(:instance iskp-lem6 (a a) (n n))))))

(property iskp-lem8 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n))
		(equal (fn a n)
		       (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
			 (* (* k (expt a k)) (/ n))))
		(equal (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
			     (expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
			  (/ n))
		       (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
			 (* (* k (expt a k)) (/ n)))))
	   (equal (* (fn a n) a)
		  (* (* (ceiling (/ a (- 1 a)) 1)
			(expt a (ceiling (/ a (- 1 a)) 1)))
		     (/ n) a))))

(property iskp-lem9 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (equal (* (fn a n) a)
		  (* (* (ceiling (/ a (- 1 a)) 1)
			(expt a (ceiling (/ a (- 1 a)) 1)))
		     (/ n) a)))
  :hints (("Goal" :use ((:instance iskp-lem7 (a a) (n n))
			(:instance iskp-lem8 (a a) (n n))))))

(property iskp-lem10 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (<= (* (expt a n) a)
	       (* (fn a n) a))))

(property iskp-lem11 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n))
		(equal (fn a n)
		       (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
			 (* (* k (expt a k)) (/ n))))
		(equal (* (expt a n) a)
		       (expt a (+ 1 n)))
		(equal (* (fn a n) a)
		       (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
			     (expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
			  (/ n)
			  a))
		(<= (* (expt a n) a) (* (fn a n) a)))
	   (<= (expt a (+ 1 n))
	       (* (* (ceiling (/ a (- 1 a)) 1)
		     (expt a (ceiling (/ a (- 1 a)) 1)))
		  (/ n) a))))

(property iskp-lem12 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (and (equal (fn a n)
		       (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
			 (* (* k (expt a k)) (/ n))))
		(equal (* (expt a n) a)
		       (expt a (+ 1 n)))
		(equal (* (fn a n) a)
		       (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
			     (expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
			  (/ n)
			  a))
		(<= (* (expt a n) a) (* (fn a n) a))))
  :hints (("Goal" :use ((:instance iskp-lem5 (a a) (n n))
			(:instance iskp-lem4 (a a) (n n))
			(:instance iskp-lem9 (a a) (n n))
			(:instance iskp-lem10 (a a) (n n))))))

(property iskp-lem13 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (<= (expt a (+ 1 n))
	       (* (* (ceiling (/ a (- 1 a)) 1)
		     (expt a (ceiling (/ a (- 1 a)) 1)))
		  (/ n) a)))
  :hints (("Goal" :use ((:instance iskp-lem11 (a a) (n n))
			(:instance iskp-lem12 (a a) (n n))))))

(property iskp-lem14 (a :pos-rational n :nat)
  (implies (and (< a 1) (<= (ceiling (/ a (- 1 a)) 1) n))
	   (posp n)))

(property iskp-lem15 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (and (<= a
		    (* (ceiling (* a (/ (+ 1 (- a)))) 1)
		       (/ (+ 1 (ceiling (* a (/ (+ 1 (- a)))) 1)))))
		(<= (* (ceiling (* a (/ (+ 1 (- a)))) 1)
		       (/ (+ 1 (ceiling (* a (/ (+ 1 (- a)))) 1))))
		    (* n (/ (+ 1 n))))))
  :hints (("Goal" :use ((:instance iskp-lem2 (a a) (n n))
			(:instance iskp-lem1 (a a) (n n))))))

(property iskp-lem16 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n))
		(<= a
		    (* (ceiling (* a (/ (+ 1 (- a)))) 1)
		       (/ (+ 1 (ceiling (* a (/ (+ 1 (- a)))) 1)))))
		(<= (* (ceiling (* a (/ (+ 1 (- a)))) 1)
		       (/ (+ 1 (ceiling (* a (/ (+ 1 (- a)))) 1))))
		    (* n (/ (+ 1 n)))))
	   (<= a (/ n (1+ n)))))

(property iskp-lem17 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (<= a (/ n (1+ n))))
  :hints (("Goal" :use ((:instance iskp-lem15 (a a) (n n))
			(:instance iskp-lem16 (a a) (n n))))))

(property iskp-lem13-14-17 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (and (<= (expt a (+ 1 n))
		    (* (* (ceiling (/ a (- 1 a)) 1)
			  (expt a (ceiling (/ a (- 1 a)) 1)))
		       (/ n) a))
		(posp n)
		(<= a (/ n (1+ n)))))
  :hints (("Goal" :use ((:instance iskp-lem17 (a a) (n n))
			(:instance iskp-lem14 (a a) (n n))
			(:instance iskp-lem13 (a a) (n n)))
	   :do-not-induct t)))

(property iskp-lem18 (a :pos-rational)
  (implies (< a 1) (posp (ceiling (/ a (- 1 a)) 1))))

(property iskp-lem19 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (and (posp (ceiling (/ a (- 1 a)) 1))
		(posp n)
		(pos-rationalp a)
		(<= (expt a (+ 1 n))
		    (* (* (ceiling (/ a (- 1 a)) 1)
			  (expt a (ceiling (/ a (- 1 a)) 1)))
		       (/ n)
		       a))
		(<= a (* n (/ (+ 1 n))))))
  :hints (("Goal" :use ((:instance iskp-lem13-14-17 (a a) (n n))
			(:instance iskp-lem18 (a a)))
	   :do-not-induct t)))

(property iskp-lem20 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (<= (expt a (+ 1 n))
	       (* (ceiling (/ a (- 1 a)) 1)
		  (expt a (ceiling (/ a (- 1 a)) 1)) (/ (+ 1 n)))))
  :hints (("Goal" :use ((:instance incr-denom-lemma (a a)
				   (k (ceiling (/ a (- 1 a)) 1))
				   (n n))
			(:instance iskp-lem19 (a a))))))

(property iskp-lem21 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (equal (fn a (+ 1 n))
		  (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1))
			(n (+ 1 n)))
		    (* (* k (expt a k)) (/ n)))))
  :hints (("Goal" :use (:instance fn-definition-rule (a a)
				  (n (1+ n))))))

(property iskp-lem22 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (equal (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
			(expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
		     (/ (1+ n)))
		  (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1))
			(n (+ 1 n)))
		    (* (* k (expt a k)) (/ n)))))
  :hints (("Goal" :use ((:instance iskp-lem21 (a a) (n n))
			(:instance fn-definition-rule (a a)
				   (n (1+ n)))))))

(property iskp-lem23 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (and (<= (expt a (+ 1 n))
		    (* (ceiling (/ a (- 1 a)) 1)
		       (expt a (ceiling (/ a (- 1 a)) 1)) (/ (+ 1 n))))
		(equal (fn a (+ 1 n))
		       (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1))
			     (n (+ 1 n)))
			 (* (* k (expt a k)) (/ n))))
		(equal (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
			     (expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
			  (/ (1+ n)))
		       (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1))
			     (n (+ 1 n)))
			 (* (* k (expt a k)) (/ n))))))
  :hints (("Goal" :use ((:instance iskp-lem20 (a a) (n n))
			(:instance iskp-lem21 (a a) (n n))
			(:instance iskp-lem22 (a a) (n n))))))

(property iskp-lem24 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n))
		(<= (expt a (+ 1 n))
		    (* (ceiling (/ a (- 1 a)) 1)
		       (expt a (ceiling (/ a (- 1 a)) 1)) (/ (+ 1 n))))
		(equal (fn a (+ 1 n))
		       (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1))
			     (n (+ 1 n)))
			 (* (* k (expt a k)) (/ n))))
		(equal (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
			     (expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
			  (/ (1+ n)))
		       (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1))
			     (n (+ 1 n)))
			 (* (* k (expt a k)) (/ n)))))
	   (<= (expt a (1+ n)) (fn a (1+ n)))))

#|
Thm: [ a^n <= f_n(a, n) and ceil(a/(1-a)) <= n ] -> a^{1+n} <= f_n(a, 1+n)
|#
(property inductive-step-kens-proof (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (expt a n) (fn a n)))
	   (<= (expt a (1+ n)) (fn a (1+ n))))
  :hints (("Goal" :use ((:instance iskp-lem23 (a a) (n n))
			(:instance iskp-lem24 (a a) (n n))))))

(in-theory (disable iskp-lem1
		    iskp-lem2
		    iskp-lem3
		    iskp-lem4
		    iskp-lem5
		    iskp-lem6
		    iskp-lem7
		    iskp-lem8
		    iskp-lem9
		    iskp-lem10
		    iskp-lem11
		    iskp-lem12
		    iskp-lem13
		    iskp-lem14
		    iskp-lem15
		    iskp-lem16
		    iskp-lem17
		    iskp-lem18
		    iskp-lem19
		    iskp-lem20
		    iskp-lem21
		    iskp-lem22
		    iskp-lem23
		    iskp-lem13-14-17))

#|
This is the inductive scheme we will use to prove the inductive case for Ken's
argument.
|#
(definec induct-ken (a :pos-rational n :nat) :nat
  :ic (< a 1)
  (if (> (ceiling (/ a (- 1 a)) 1) n) 0
    (1+ (induct-ken a (- n 1)))))

(property n>=k->a^n<=fn-lem2 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (* a (/ (+ 1 (- a)))) 1) n)
		(implies (and (pos-rationalp a)
			      (natp (+ -1 n))
			      (< a 1)
			      (<= (ceiling (* a (/ (+ 1 (- a)))) 1)
				  (+ -1 n)))
			 (<= (expt a (+ -1 n)) (fn a (+ -1 n))))
		(<= (ceiling (* a (/ (+ 1 (- a)))) 1)
		    (+ -1 n)))
	   (<= (expt a (+ -1 n)) (fn a (+ -1 n)))))

(property n>=k->a^n<=fn-lem3 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (* a (/ (+ 1 (- a)))) 1) n)
		(implies (and (pos-rationalp a)
			      (natp (+ -1 n))
			      (< a 1)
			      (<= (ceiling (* a (/ (+ 1 (- a)))) 1)
				  (+ -1 n)))
			 (<= (expt a (+ -1 n)) (fn a (+ -1 n))))
		(<= (ceiling (* a (/ (+ 1 (- a)))) 1)
		    (+ -1 n)))
	   (<= (expt a (+ 1 -1 n))
	       (fn a (+ 1 -1 n))))
  :hints (("Goal" :use ((:instance n>=k->a^n<=fn-lem2 (a a) (n n))
			(:instance inductive-step-kens-proof (a a) (n (- n 1)))))))

(property n>=k->a^n<=fn-lem4 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (* a (/ (+ 1 (- a)))) 1) n)
		(implies (and (pos-rationalp a)
			      (natp (+ -1 n))
			      (< a 1)
			      (<= (ceiling (* a (/ (+ 1 (- a)))) 1)
				  (+ -1 n)))
			 (<= (expt a (+ -1 n)) (fn a (+ -1 n))))
		(> (ceiling (* a (/ (+ 1 (- a)))) 1)
		    (+ -1 n)))
	   (equal (ceiling (* a (/ (+ 1 (- a)))) 1)
		  n)))

(property n>=k->a^n<=fn-lem5 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(equal (ceiling (* a (/ (+ 1 (- a)))) 1) n))
	   (and (pos-rationalp a)
                (pos-rationalp n)
                (< a 1)))
  :hints (("Goal" :use (:instance fn-definition-rule (a a) (n n)))))

(property n>=k->a^n<=fn-lem6 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(equal (ceiling (* a (/ (+ 1 (- a)))) 1) n))
	   (equal (fn a n)
                  (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
                    (* (* k (expt a k)) (/ n)))))
  :hints (("Goal" :use ((:instance fn-definition-rule (a a) (n n))
			(:instance n>=k->a^n<=fn-lem5 (a a) (n n))))))

(property n>=k->a^n<=fn-lem7 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(equal (ceiling (* a (/ (+ 1 (- a)))) 1) n))
	   (equal (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
                    (* (* k (expt a k)) (/ n)))
                  (expt a n))))

(property n>=k->a^n<=fn-lem8 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(equal (ceiling (* a (/ (+ 1 (- a)))) 1) n)
		(equal (fn a n)
		       (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
			 (* (* k (expt a k)) (/ n))))
		(equal (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
			 (* (* k (expt a k)) (/ n)))
		       (expt a n)))
	   (equal (fn a n) (expt a n))))

(property n>=k->a^n<=fn-lem9 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(equal (ceiling (* a (/ (+ 1 (- a)))) 1) n))
	   (equal (expt a n) (fn a n)))
  :hints (("Goal" :use ((:instance n>=k->a^n<=fn-lem6 (a a) (n n))
			(:instance n>=k->a^n<=fn-lem7 (a a) (n n))
			(:instance n>=k->a^n<=fn-lem8 (a a) (n n))))))

(property n>=k->a^n<=fn-lem10 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(implies (and (pos-rationalp a)
			      (natp (+ -1 n))
			      (< a 1)
			      (<= (ceiling (* a (/ (+ 1 (- a)))) 1)
				  (+ -1 n)))
			 (<= (expt a (+ -1 n)) (fn a (+ -1 n))))
		(> (ceiling (* a (/ (+ 1 (- a)))) 1) (+ -1 n)))
	   (and (equal (expt a n) (fn a n))
		(equal (ceiling (* a (/ (+ 1 (- a)))) 1) n)))
  :hints (("Goal" :use ((:instance n>=k->a^n<=fn-lem4 (a a) (n n))
			(:instance n>=k->a^n<=fn-lem9 (a a) (n n))))))

(in-theory (disable n>=k->a^n<=fn-lem2
		    n>=k->a^n<=fn-lem3
		    n>=k->a^n<=fn-lem5
		    n>=k->a^n<=fn-lem6
		    n>=k->a^n<=fn-lem7
		    n>=k->a^n<=fn-lem8)) ;; 4, 9, 10 still enabled

(property n>=k->a^n<=fn-lem11 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(implies (and (pos-rationalp a)
			      (natp (+ -1 n))
			      (< a 1)
			      (<= (ceiling (* a (/ (+ 1 (- a)))) 1)
				  (+ -1 n)))
			 (<= (expt a (+ -1 n)) (fn a (+ -1 n))))
		(> (ceiling (* a (/ (+ 1 (- a)))) 1) (+ -1 n))
		(equal (expt a n) (fn a n))
		(equal (ceiling (* a (/ (+ 1 (- a)))) 1) n))
	   (<= (expt a n) (fn a n))))

(property n>=k->a^n<=fn-lem12 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(implies (and (pos-rationalp a)
			      (natp (+ -1 n))
			      (< a 1)
			      (<= (ceiling (* a (/ (+ 1 (- a)))) 1)
				  (+ -1 n)))
			 (<= (expt a (+ -1 n)) (fn a (+ -1 n))))
		(> (ceiling (* a (/ (+ 1 (- a)))) 1)
		    (+ -1 n)))
	   (<= (expt a n) (fn a n)))
  :hints (("Goal" :use ((:instance n>=k->a^n<=fn-lem11 (a a) (n n))
			(:instance n>=k->a^n<=fn-lem10 (a a) (n n))))))

(property n>=k->a^n<=fn-lem13 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(implies (and (pos-rationalp a)
			      (natp (+ -1 n))
			      (< a 1)
			      (<= (ceiling (* a (/ (+ 1 (- a)))) 1)
				  (+ -1 n)))
			 (<= (expt a (+ -1 n)) (fn a (+ -1 n)))))
	   (<= (expt a n) (fn a n)))
  :hints (("Goal" :cases ((<= (ceiling (* a (/ (+ 1 (- a)))) 1) (+ -1 n)))
	   :use ((:instance n>=k->a^n<=fn-lem12 (a a) (n n))
		 (:instance n>=k->a^n<=fn-lem3 (a a) (n n))))))

(in-theory (disable n>=k->a^n<=fn-lem4
		    n>=k->a^n<=fn-lem9
		    n>=k->a^n<=fn-lem10
		    n>=k->a^n<=fn-lem11
		    n>=k->a^n<=fn-lem12)) ;; 13 is still enabled, needed for next step

(property n>=k->a^n<=fn (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n))
	   (<= (expt a n) (fn a n)))
  :hints (("Goal" :induct (induct-ken a n))
	  ("Subgoal *1/" :use (:instance n>=k->a^n<=fn-lem13 (a a) (n n)))))

(in-theory (disable n>=k->a^n<=fn-lem13))

#|
Thm: 0 < b0 <= b1 -> a/b0 <= a/b1
(This is just a helper Lemma, because otherwise prover gets stuck in next proof.)
|#
(property div-<=-prop (a b0 b1 :pos-rational)
  (implies (<= b0 b1) (<= (/ a b1) (/ a b0))))

#|
Thm: The ceiling's codomain are the positive rationals.
(This is another helper Lemma for where otherwise the prover would get stuck.)
|#
(property pos-rationalp-ceil (x :pos-rational)
  (pos-rationalp (ceiling x 1)))

(property inequality-over-ceil-frac-lem1 (x y :pos-rational)
  (and (<= (/ x y) (ceiling (/ x y) 1))
       (<= (/ (ceiling (/ x y) 1))
	   (/ (/ x y)))))

(property inequality-over-ceil-frac-lem2 (x y :pos-rational)
  (<= (/ x (ceiling (/ x y) 1))
      (/ x (/ x y)))
  :hints (("Goal" :use (:instance inequality-over-ceil-frac-lem1 (x x) (y y)))))

#|
Thm: x/ceiling(x/y) <= y.
This is a very important helper lemma that explains essentially how we can pull
the y out of the ceiling-wrapped denominator ...
|#
(property inequality-over-ceil-frac (x y :pos-rational)
  (<= (/ x (ceiling (/ x y) 1)) y)
  :hints (("Goal" :use (:instance inequality-over-ceil-frac-lem2 (x x) (y y)))))

(in-theory (disable inequality-over-ceil-frac-lem1
		    inequality-over-ceil-frac-lem2))

(property a^n->0-lem1 (a e :pos-rational n :nat)
  (implies (< a 1)
	   (pos-rationalp (* (ceiling (/ a (- 1 a)) 1)
			     (expt a (ceiling (/ a (- 1 a)) 1))))))

(property a^n->0-lem2 (a e :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (ceiling (/ (* (ceiling (/ a (- 1 a)) 1)
				   (expt a (ceiling (/ a (- 1 a)) 1)))
				e)
			     1)
		    n))
	   (<= (* (* (ceiling (/ a (- 1 a)) 1)
		     (expt a (ceiling (/ a (- 1 a)) 1)))
		  (/ n))
	       (* (* (ceiling (/ a (- 1 a)) 1)
		     (expt a (ceiling (/ a (- 1 a)) 1)))
		  (/ (ceiling (/ (* (ceiling (/ a (- 1 a)) 1)
				    (expt a (ceiling (/ a (- 1 a)) 1)))
				 e)
			      1)))))
  :hints (("Goal" :use ((:instance
			div-<=-prop (a (* (ceiling (/ a (- 1 a)) 1)
					  (expt a (ceiling (/ a (- 1 a)) 1))))
			(b0 (ceiling (/ (* (ceiling (/ a (- 1 a)) 1)
					   (expt a (ceiling (/ a (- 1 a)) 1)))
					e)
				     1))
			(b1 n))
			(:instance a^n->0-lem1 (a a) (e e) (n n))
			(:instance pos-rationalp-ceil
				   (x (* (* (ceiling (/ a (- 1 a)) 1)
					    (expt a (ceiling (/ a (- 1 a)) 1)))
					 (/ e))))))))

(property a^n->0-lem3 (a e :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (ceiling (/ (* (ceiling (/ a (- 1 a)) 1)
				   (expt a (ceiling (/ a (- 1 a)) 1)))
				e)
			     1)
		    n))
	   (<= (* (* (ceiling (/ a (- 1 a)) 1)
		     (expt a (ceiling (/ a (- 1 a)) 1)))
		  (/ n))
	       (* (* (ceiling (/ a (- 1 a)) 1)
		     (expt a (ceiling (/ a (- 1 a)) 1)))
		  (/ (ceiling (* (* (ceiling (/ a (- 1 a)) 1)
				    (expt a (ceiling (/ a (- 1 a)) 1)))
				 (/ e))
			      1)))))
  :hints (("Goal" :use (:instance a^n->0-lem2 (a a) (e e) (n n)))))

(property a^n->0-lem4 (a e :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (ceiling (/ (* (ceiling (/ a (- 1 a)) 1)
				   (expt a (ceiling (/ a (- 1 a)) 1)))
				e)
			     1)
		    n))
	   (<= (* (* (ceiling (/ a (- 1 a)) 1)
		     (expt a (ceiling (/ a (- 1 a)) 1)))
		  (/ (ceiling (* (* (ceiling (/ a (- 1 a)) 1)
				    (expt a (ceiling (/ a (- 1 a)) 1)))
				 (/ e))
			      1)))
	       e))
  :hints (("Goal" :use ((:instance inequality-over-ceil-frac
				   (x (* (ceiling (/ a (- 1 a)) 1)
					 (expt a (ceiling (/ a (- 1 a)) 1))))
				   (y e))))))

(property a^n->0-lem5 (a e :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (ceiling (/ (* (ceiling (/ a (- 1 a)) 1)
				   (expt a (ceiling (/ a (- 1 a)) 1)))
				e)
			     1)
		    n))
	   (<= (expt a n) (fn a n)))
  :hints (("Goal" :use ((:instance n>=k->a^n<=fn (a a) (n n))))))

(property a^n->0-lem6 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n))
	   (equal (fn a n)
		  (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
		    (* (* k (expt a k)) (/ n)))))
  :hints (("Goal" :use (:instance fn-definition-rule (a a) (n n)))))

(property a^n->0-lem7 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n))
	   (equal (* (* (ceiling (/ a (- 1 a)) 1)
			(expt a (ceiling (/ a (- 1 a)) 1)))
		     (/ n))
		  (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
		    (* (* k (expt a k)) (/ n))))))

(property a^n->0-lem8 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(equal (* (* (ceiling (/ a (- 1 a)) 1)
			(expt a (ceiling (/ a (- 1 a)) 1)))
		     (/ n))
		  (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
		    (* (* k (expt a k)) (/ n))))
		(equal (fn a n)
		  (let ((k (ceiling (* a (/ (+ 1 (- a)))) 1)))
		    (* (* k (expt a k)) (/ n)))))
	   (equal (fn a n)
		  (* (* (ceiling (/ a (- 1 a)) 1)
			(expt a (ceiling (/ a (- 1 a)) 1)))
		     (/ n)))))

(property a^n->0-lem9 (a :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n))
	   (equal (fn a n)
		  (* (* (ceiling (/ a (- 1 a)) 1)
			(expt a (ceiling (/ a (- 1 a)) 1)))
		     (/ n))))
  :hints (("Goal" :use ((:instance a^n->0-lem6 (a a) (n n))
			(:instance a^n->0-lem7 (a a) (n n))
			(:instance a^n->0-lem8 (a a) (n n))))))


(property a^n->0-lem10 (a :pos-rational n :nat e :pos-rational)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (ceiling (/ (* (ceiling (/ a (- 1 a)) 1)
				   (expt a (ceiling (/ a (- 1 a)) 1)))
				e)
			     1)
		    n))
	   (and (<= (expt a n) (fn a n))
		(equal (fn a n)
		       (* (* (ceiling (/ a (- 1 a)) 1)
			     (expt a (ceiling (/ a (- 1 a)) 1)))
			  (/ n)))
		(<= (* (* (ceiling (/ a (- 1 a)) 1)
			  (expt a (ceiling (/ a (- 1 a)) 1)))
		       (/ (ceiling (* (* (ceiling (/ a (- 1 a)) 1)
					 (expt a (ceiling (/ a (- 1 a)) 1)))
				      (/ e))
				   1)))
		    e)
		(<= (* (* (ceiling (/ a (- 1 a)) 1)
			  (expt a (ceiling (/ a (- 1 a)) 1)))
		       (/ n))
		    (* (* (ceiling (/ a (- 1 a)) 1)
			  (expt a (ceiling (/ a (- 1 a)) 1)))
		       (/ (ceiling (* (* (ceiling (/ a (- 1 a)) 1)
					 (expt a (ceiling (/ a (- 1 a)) 1)))
				      (/ e))
				   1))))))
  :hints (("Goal" :use ((:instance n>=k->a^n<=fn (a a) (n n))
			(:instance a^n->0-lem9 (a a) (n n))
			(:instance a^n->0-lem4 (a a) (e e) (n n))
			(:instance a^n->0-lem3 (a a) (e e) (n n))))))

(property a^n->0-lem11 (a :pos-rational n :nat e :pos-rational)
  (implies (and (< a 1)
		(<= (ceiling (/ a (- 1 a)) 1) n)
		(<= (ceiling (/ (* (ceiling (/ a (- 1 a)) 1)
				   (expt a (ceiling (/ a (- 1 a)) 1)))
				e)
			     1)
		    n)
		(<= (expt a n) (fn a n))
		(equal (fn a n)
		       (* (* (ceiling (/ a (- 1 a)) 1)
			     (expt a (ceiling (/ a (- 1 a)) 1)))
			  (/ n)))
		(<= (* (* (ceiling (/ a (- 1 a)) 1)
			  (expt a (ceiling (/ a (- 1 a)) 1)))
		       (/ (ceiling (* (* (ceiling (/ a (- 1 a)) 1)
					 (expt a (ceiling (/ a (- 1 a)) 1)))
				      (/ e))
				   1)))
		    e)
		(<= (* (* (ceiling (/ a (- 1 a)) 1)
			  (expt a (ceiling (/ a (- 1 a)) 1)))
		       (/ n))
		    (* (* (ceiling (/ a (- 1 a)) 1)
			  (expt a (ceiling (/ a (- 1 a)) 1)))
		       (/ (ceiling (* (* (ceiling (/ a (- 1 a)) 1)
					 (expt a (ceiling (/ a (- 1 a)) 1)))
				      (/ e))
				   1)))))
	   (<= (expt a n) e)))

(property a^n->0 (a :pos-rational n :nat e :pos-rational)
  (implies (and (< a 1)
		;; <= d n
		(<= (ceiling (/ a (- 1 a)) 1) n)
		;; <= k n, i.e., let n exceed max(d, k) ...
		(<= (ceiling (/ (* (ceiling (/ a (- 1 a)) 1)
				   (expt a (ceiling (/ a (- 1 a)) 1)))
				e)
			     1)
		    n))
	   (<= (expt a n) e))
  :hints (("Goal" :use ((:instance a^n->0-lem10 (a a) (n n) (e e))
			(:instance a^n->0-lem11 (a a) (n n) (e e))))))

(definec delta (a e :pos-rational) :nat
  :ic (< a 1)
  (max (ceiling (/ a (- 1 a)) 1)
       (ceiling (/ (* (ceiling (/ a (- 1 a)) 1)
          (expt a (ceiling (/ a (- 1 a)) 1)))
       e)
    1)))

(property lim-a^n->0-helper (a e :pos-rational n :nat)
  (implies (and (< a 1)
		(<= (delta a e) n))
	   (<= (expt a n) e))
  :instructions
  (:pro
   (:claim (<= (max (ceiling (/ a (- 1 a)) 1)
		    (ceiling (/ (* (ceiling (/ a (- 1 a)) 1)
				   (expt a (ceiling (/ a (- 1 a)) 1)))
				e)
			     1))
	       n))
   (:claim (<= (ceiling (* a (/ (+ 1 (- a)))) 1)
	       (max (ceiling (* a (/ (+ 1 (- a)))) 1)
		    (ceiling (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
				   (expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
				(/ e))
			     1))))
   (:claim (<= (ceiling (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
			      (expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
			   (/ e))
			1)
	       (max (ceiling (* a (/ (+ 1 (- a)))) 1)
		    (ceiling (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
				   (expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
				(/ e))
			     1))))
   (:claim (<= (ceiling (* a (/ (+ 1 (- a)))) 1)
	       n))
   (:claim (<= (ceiling (* (* (ceiling (* a (/ (+ 1 (- a)))) 1)
			      (expt a (ceiling (* a (/ (+ 1 (- a)))) 1)))
			   (/ e))
			1)
	       n))
   (:drop 6 7 8)
   (:use (:instance a^n->0 (a a)
		    (e e)
		    (n n)))))

;; Rephrase the theorem using defun-sk.  Note: a, e, and n are all implicitly
;; universally quantified.
(defun-sk lim-0 (a e n)
  (declare (xargs :guard (and (pos-rationalp a)
			      (< a 1)
			      (pos-rationalp e)
			      (natp n))
		  :verify-guards t))
  (exists (d)
    (and (natp d)
	 (implies (<= d n) (<= (expt a n) e)))))

(property lim-a^n->0 (a e :pos-rational n :nat)
  :hyps (< a 1)
  (lim-0 a e n)
  :hints (("Goal" :use ((:instance lim-0-suff (d (delta a e)))
			(:instance lim-a^n->0-helper (a a)
				   (e e)
				   (n n))))))
