      SUBROUTINE PUTLST(ZLIST,NFIRST,NBLOCK,USECXN,ISPIN,ITYPE)
C
C THIS SUBROUTINE RETRIEVES NBLOCK DISTRIBUTIONS OF A PARTICULAR INTEGRA
C  LIST, BEGINNING WITH DISTRIBUTION NFIRST.  THE VALUES ARE RETURNED IN
C  VECTOR ZLIST.
C
C   OUTPUT:
C
C         ZLIST - THE TARGET VECTOR USED IN I/O OPERATIONS.
C
C   INPUT PARAMETERS:
C
C         NFIRST- THE NUMBER OF THE FIRST DISTRIBUTION WHICH WILL BE
C                 WRITTEN TO OR READ FROM DISK.
C         NBLOCK- THE NUMBER OF DISTRIBUTIONS WHICH WILL BE HANDLED.
C         USECIN- THE CACHE BUFFER WHICH IS TO BE USED FOR I/O OPERATION
C                 BEST PERFORMANCE IS ACHIEVED IF THIS IS SET TO 1 FOR
C                 T AMPLITUDE I/O AND 2 FOR INTEGRAL I/O.
C         ISPIN - THE LEFT-HAND INDEX OF THE LIST [MOIO(ISPIN,ITYPE)].
C         ITYPE - THE RIGHT-HAND INDEX OF THE LIST [MOIO(ISPIN,ITYPE)].
C
C  MOIO PARAMETERS (FROM COMMON BLOCK /LISTS/):
C
C        >>>ALL OF THESE VALUES ARE COMPUTED BY ROUTINE UPDMOI<<<
C
C         MOIO(ISPIN,ITYPE)  - THE PHYSICAL RECORD NUMBER ON WHICH
C                              LIST ITYPE[ISPIN] BEGINS.
C         MOIOWD(ISPIN,ITYPE)- THE WORD ADDRESS AT WHICH LIST
C                              ITYPE[ISPIN] BEGINS.
C         MOIODS(ISPIN,ITYPE)- THE NUMBER OF TOTAL DISTRIBUTIONS
C                              IN LIST ITYPE[ISPIN].
C         MOIOSZ(ISPIN,ITYPE)- THE SIZE OF THE INDIVIDUAL DISTRIBUTIONS
C                              IN LIST ITYPE[ISPIN] (IN *FLOATING-POINT*
C                              WORDS.
C         MOIOFL(ISPIN,ITYPE)- THE FILE ON WHICH THE LIST RESIDES.
C
CEND
      IMPLICIT INTEGER (A-Z)
      DIMENSION ZLIST(1)
      COMMON / / ICORE(1)
      COMMON /LISTS/ MOIO(10,500),MOIOWD(10,500),MOIOSZ(10,500),
     &               MOIODS(10,500),MOIOFL(10,500)
      COMMON /MACHSP/ IINTLN,IFLTLN,IINTFP,IALONE,IBITWD
      COMMON /FILES/ LUOUT,MOINTS
      COMMON /FILSPC/ ILNBUF,IPRCLN,IPRCWD
      COMMON /IOPOS/ ICRSIZ,ICHCSZ,IOFFX(2),LENREC
      COMMON /FLAGS/ IFLAGS(100)
      COMMON /AUXCACHE/ QUIKGET(10,500)
C
cjp
#include "bwcc.com"
      if(bwgossip) write(6,*)'debug PUTLST iref',iref,' : ',
     +         nfirst,nblock,usecxn,ispin,itype,' file: '
     +    ,moiofl(ispin,itype)
      IF(QUIKGET(ISPIN,ITYPE).NE.0)THEN
       CALL PUTFAST(ZLIST,NFIRST,NBLOCK,ISPIN,ITYPE)
       RETURN
      ENDIF
C
C MAKE SURE THAT THE LAST DISTRIBUTION REQUESTED IS NOT BEYOND THE
C  END OF THE LIST.
C
      IF(NFIRST+NBLOCK-1.GT.MOIODS(ISPIN,ITYPE))THEN
       WRITE(LUOUT,2000)ISPIN,ITYPE,NFIRST+NBLOCK-1,MOIODS(ISPIN,ITYPE)
2000   FORMAT(T3,'@PUTLST-F, Error reading list [',I2,',',I3,']',/,
     &        T3,'           Distribution ',I9,' requested, but ',
     &           'only ',I9,' are available.')
       CALL ERREX
      ENDIF
C
C DETERMINE WHICH FILE THIS LIST LIVES ON
C
      FILE=MOIOFL(ISPIN,ITYPE)
C
C COMPUTE THE NUMBER OF WORDS ASKED FOR.
C
      NWORDS=NBLOCK*MOIOSZ(ISPIN,ITYPE)*IINTFP
C
C FIND ADDRESS OF THE FIRST ELEMENT OF THE LIST.
C
      NRECST=MOIO(ISPIN,ITYPE)
      NWRDST=MOIOWD(ISPIN,ITYPE)
C
C FIND WORD OFFSET TO THE FIRST ELEMENT THAT WE WANT.
C
      NRECF=NRECST
      NOFFF=(NFIRST-1)*MOIOSZ(ISPIN,ITYPE)*IINTFP
      NWRDF=NWRDST+NOFFF
      IF(NWRDF.GT.IPRCWD)THEN
       INCREM=(NWRDF-1)/IPRCWD
       NWRDF=NWRDF-IPRCWD*INCREM
       NRECF=NRECST+INCREM
      ENDIF
C
C LOOP OVER THE RECORDS WHICH ARE TO CONTAIN THE DISTRIBUTIONS IN ZLIST
C  AND DUMP THEM.
C
      IREC=NRECF
      IOFF=1
1     NGET=MIN(NWORDS,IPRCWD-NWRDF+1)
cjp debug
c	if(bwgossip.and.ioff.gt.1) write(6,*)'putlst more phys records'
      CALL DUMP(ZLIST(IOFF),FILE,IREC,NWRDF,NGET)
      IREC=IREC+1
      NWORDS=NWORDS-NGET
      NWRDF=1
      IOFF=IOFF+NGET
      IF(NWORDS.NE.0)GOTO 1
      RETURN
      END
