/***********************license start***************
 * Copyright (c) 2003-2010  Cavium Networks (support@cavium.com). All rights
 * reserved.
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.

 *   * Neither the name of Cavium Networks nor the names of
 *     its contributors may be used to endorse or promote products
 *     derived from this software without specific prior written
 *     permission.

 * This Software, including technical data, may be subject to U.S. export  control
 * laws, including the U.S. Export Administration Act and its  associated
 * regulations, and may be subject to export or import  regulations in other
 * countries.

 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND CAVIUM  NETWORKS MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE, INCLUDING ITS CONDITION, ITS CONFORMITY TO ANY REPRESENTATION OR
 * DESCRIPTION, OR THE EXISTENCE OF ANY LATENT OR PATENT DEFECTS, AND CAVIUM
 * SPECIFICALLY DISCLAIMS ALL IMPLIED (IF ANY) WARRANTIES OF TITLE,
 * MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE, LACK OF
 * VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR
 * CORRESPONDENCE TO DESCRIPTION. THE ENTIRE  RISK ARISING OUT OF USE OR
 * PERFORMANCE OF THE SOFTWARE LIES WITH YOU.
 ***********************license end**************************************/


/**
 * cvmx-pexp-defs.h
 *
 * Configuration and status register (CSR) definitions for
 * OCTEON PEXP.
 *
 * <hr>$Revision$<hr>
 */
#ifndef __CVMX_PEXP_DEFS_H__
#define __CVMX_PEXP_DEFS_H__

#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_BAR1_INDEXX(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_NPEI_BAR1_INDEXX(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000008000ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_NPEI_BAR1_INDEXX(offset) (CVMX_ADD_IO_SEG(0x00011F0000008000ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_BIST_STATUS CVMX_PEXP_NPEI_BIST_STATUS_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_BIST_STATUS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_BIST_STATUS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008580ull);
}
#else
#define CVMX_PEXP_NPEI_BIST_STATUS (CVMX_ADD_IO_SEG(0x00011F0000008580ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_BIST_STATUS2 CVMX_PEXP_NPEI_BIST_STATUS2_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_BIST_STATUS2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_BIST_STATUS2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008680ull);
}
#else
#define CVMX_PEXP_NPEI_BIST_STATUS2 (CVMX_ADD_IO_SEG(0x00011F0000008680ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_CTL_PORT0 CVMX_PEXP_NPEI_CTL_PORT0_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_CTL_PORT0_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_CTL_PORT0 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008250ull);
}
#else
#define CVMX_PEXP_NPEI_CTL_PORT0 (CVMX_ADD_IO_SEG(0x00011F0000008250ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_CTL_PORT1 CVMX_PEXP_NPEI_CTL_PORT1_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_CTL_PORT1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_CTL_PORT1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008260ull);
}
#else
#define CVMX_PEXP_NPEI_CTL_PORT1 (CVMX_ADD_IO_SEG(0x00011F0000008260ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_CTL_STATUS CVMX_PEXP_NPEI_CTL_STATUS_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_CTL_STATUS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_CTL_STATUS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008570ull);
}
#else
#define CVMX_PEXP_NPEI_CTL_STATUS (CVMX_ADD_IO_SEG(0x00011F0000008570ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_CTL_STATUS2 CVMX_PEXP_NPEI_CTL_STATUS2_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_CTL_STATUS2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_CTL_STATUS2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BC00ull);
}
#else
#define CVMX_PEXP_NPEI_CTL_STATUS2 (CVMX_ADD_IO_SEG(0x00011F000000BC00ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_DATA_OUT_CNT CVMX_PEXP_NPEI_DATA_OUT_CNT_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_DATA_OUT_CNT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_DATA_OUT_CNT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000085F0ull);
}
#else
#define CVMX_PEXP_NPEI_DATA_OUT_CNT (CVMX_ADD_IO_SEG(0x00011F00000085F0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_DBG_DATA CVMX_PEXP_NPEI_DBG_DATA_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_DBG_DATA_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_DBG_DATA not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008510ull);
}
#else
#define CVMX_PEXP_NPEI_DBG_DATA (CVMX_ADD_IO_SEG(0x00011F0000008510ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_DBG_SELECT CVMX_PEXP_NPEI_DBG_SELECT_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_DBG_SELECT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_DBG_SELECT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008500ull);
}
#else
#define CVMX_PEXP_NPEI_DBG_SELECT (CVMX_ADD_IO_SEG(0x00011F0000008500ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_DMA0_INT_LEVEL CVMX_PEXP_NPEI_DMA0_INT_LEVEL_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_DMA0_INT_LEVEL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_DMA0_INT_LEVEL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000085C0ull);
}
#else
#define CVMX_PEXP_NPEI_DMA0_INT_LEVEL (CVMX_ADD_IO_SEG(0x00011F00000085C0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_DMA1_INT_LEVEL CVMX_PEXP_NPEI_DMA1_INT_LEVEL_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_DMA1_INT_LEVEL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_DMA1_INT_LEVEL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000085D0ull);
}
#else
#define CVMX_PEXP_NPEI_DMA1_INT_LEVEL (CVMX_ADD_IO_SEG(0x00011F00000085D0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_DMAX_COUNTS(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 4))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 4)))))
		cvmx_warn("CVMX_PEXP_NPEI_DMAX_COUNTS(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000008450ull) + ((offset) & 7) * 16;
}
#else
#define CVMX_PEXP_NPEI_DMAX_COUNTS(offset) (CVMX_ADD_IO_SEG(0x00011F0000008450ull) + ((offset) & 7) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_DMAX_DBELL(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 4))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 4)))))
		cvmx_warn("CVMX_PEXP_NPEI_DMAX_DBELL(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F00000083B0ull) + ((offset) & 7) * 16;
}
#else
#define CVMX_PEXP_NPEI_DMAX_DBELL(offset) (CVMX_ADD_IO_SEG(0x00011F00000083B0ull) + ((offset) & 7) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_DMAX_IBUFF_SADDR(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 4))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 4)))))
		cvmx_warn("CVMX_PEXP_NPEI_DMAX_IBUFF_SADDR(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000008400ull) + ((offset) & 7) * 16;
}
#else
#define CVMX_PEXP_NPEI_DMAX_IBUFF_SADDR(offset) (CVMX_ADD_IO_SEG(0x00011F0000008400ull) + ((offset) & 7) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_DMAX_NADDR(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 4))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 4)))))
		cvmx_warn("CVMX_PEXP_NPEI_DMAX_NADDR(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F00000084A0ull) + ((offset) & 7) * 16;
}
#else
#define CVMX_PEXP_NPEI_DMAX_NADDR(offset) (CVMX_ADD_IO_SEG(0x00011F00000084A0ull) + ((offset) & 7) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_DMA_CNTS CVMX_PEXP_NPEI_DMA_CNTS_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_DMA_CNTS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_DMA_CNTS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000085E0ull);
}
#else
#define CVMX_PEXP_NPEI_DMA_CNTS (CVMX_ADD_IO_SEG(0x00011F00000085E0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_DMA_CONTROL CVMX_PEXP_NPEI_DMA_CONTROL_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_DMA_CONTROL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_DMA_CONTROL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000083A0ull);
}
#else
#define CVMX_PEXP_NPEI_DMA_CONTROL (CVMX_ADD_IO_SEG(0x00011F00000083A0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_DMA_PCIE_REQ_NUM CVMX_PEXP_NPEI_DMA_PCIE_REQ_NUM_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_DMA_PCIE_REQ_NUM_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_DMA_PCIE_REQ_NUM not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000085B0ull);
}
#else
#define CVMX_PEXP_NPEI_DMA_PCIE_REQ_NUM (CVMX_ADD_IO_SEG(0x00011F00000085B0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_DMA_STATE1 CVMX_PEXP_NPEI_DMA_STATE1_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_DMA_STATE1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX)))
		cvmx_warn("CVMX_PEXP_NPEI_DMA_STATE1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000086C0ull);
}
#else
#define CVMX_PEXP_NPEI_DMA_STATE1 (CVMX_ADD_IO_SEG(0x00011F00000086C0ull))
#endif
#define CVMX_PEXP_NPEI_DMA_STATE1_P1 (CVMX_ADD_IO_SEG(0x00011F0000008680ull))
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_DMA_STATE2 CVMX_PEXP_NPEI_DMA_STATE2_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_DMA_STATE2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX)))
		cvmx_warn("CVMX_PEXP_NPEI_DMA_STATE2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000086D0ull);
}
#else
#define CVMX_PEXP_NPEI_DMA_STATE2 (CVMX_ADD_IO_SEG(0x00011F00000086D0ull))
#endif
#define CVMX_PEXP_NPEI_DMA_STATE2_P1 (CVMX_ADD_IO_SEG(0x00011F0000008690ull))
#define CVMX_PEXP_NPEI_DMA_STATE3_P1 (CVMX_ADD_IO_SEG(0x00011F00000086A0ull))
#define CVMX_PEXP_NPEI_DMA_STATE4_P1 (CVMX_ADD_IO_SEG(0x00011F00000086B0ull))
#define CVMX_PEXP_NPEI_DMA_STATE5_P1 (CVMX_ADD_IO_SEG(0x00011F00000086C0ull))
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_INT_A_ENB CVMX_PEXP_NPEI_INT_A_ENB_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_INT_A_ENB_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_INT_A_ENB not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008560ull);
}
#else
#define CVMX_PEXP_NPEI_INT_A_ENB (CVMX_ADD_IO_SEG(0x00011F0000008560ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_INT_A_ENB2 CVMX_PEXP_NPEI_INT_A_ENB2_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_INT_A_ENB2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_INT_A_ENB2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BCE0ull);
}
#else
#define CVMX_PEXP_NPEI_INT_A_ENB2 (CVMX_ADD_IO_SEG(0x00011F000000BCE0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_INT_A_SUM CVMX_PEXP_NPEI_INT_A_SUM_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_INT_A_SUM_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_INT_A_SUM not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008550ull);
}
#else
#define CVMX_PEXP_NPEI_INT_A_SUM (CVMX_ADD_IO_SEG(0x00011F0000008550ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_INT_ENB CVMX_PEXP_NPEI_INT_ENB_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_INT_ENB_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_INT_ENB not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008540ull);
}
#else
#define CVMX_PEXP_NPEI_INT_ENB (CVMX_ADD_IO_SEG(0x00011F0000008540ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_INT_ENB2 CVMX_PEXP_NPEI_INT_ENB2_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_INT_ENB2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_INT_ENB2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BCD0ull);
}
#else
#define CVMX_PEXP_NPEI_INT_ENB2 (CVMX_ADD_IO_SEG(0x00011F000000BCD0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_INT_INFO CVMX_PEXP_NPEI_INT_INFO_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_INT_INFO_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_INT_INFO not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008590ull);
}
#else
#define CVMX_PEXP_NPEI_INT_INFO (CVMX_ADD_IO_SEG(0x00011F0000008590ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_INT_SUM CVMX_PEXP_NPEI_INT_SUM_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_INT_SUM_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_INT_SUM not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008530ull);
}
#else
#define CVMX_PEXP_NPEI_INT_SUM (CVMX_ADD_IO_SEG(0x00011F0000008530ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_INT_SUM2 CVMX_PEXP_NPEI_INT_SUM2_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_INT_SUM2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_INT_SUM2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BCC0ull);
}
#else
#define CVMX_PEXP_NPEI_INT_SUM2 (CVMX_ADD_IO_SEG(0x00011F000000BCC0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_LAST_WIN_RDATA0 CVMX_PEXP_NPEI_LAST_WIN_RDATA0_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_LAST_WIN_RDATA0_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_LAST_WIN_RDATA0 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008600ull);
}
#else
#define CVMX_PEXP_NPEI_LAST_WIN_RDATA0 (CVMX_ADD_IO_SEG(0x00011F0000008600ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_LAST_WIN_RDATA1 CVMX_PEXP_NPEI_LAST_WIN_RDATA1_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_LAST_WIN_RDATA1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_LAST_WIN_RDATA1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008610ull);
}
#else
#define CVMX_PEXP_NPEI_LAST_WIN_RDATA1 (CVMX_ADD_IO_SEG(0x00011F0000008610ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MEM_ACCESS_CTL CVMX_PEXP_NPEI_MEM_ACCESS_CTL_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MEM_ACCESS_CTL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MEM_ACCESS_CTL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000084F0ull);
}
#else
#define CVMX_PEXP_NPEI_MEM_ACCESS_CTL (CVMX_ADD_IO_SEG(0x00011F00000084F0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_MEM_ACCESS_SUBIDX(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && (((offset >= 12) && (offset <= 27)))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && (((offset >= 12) && (offset <= 27))))))
		cvmx_warn("CVMX_PEXP_NPEI_MEM_ACCESS_SUBIDX(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000008280ull) + ((offset) & 31) * 16 - 16*12;
}
#else
#define CVMX_PEXP_NPEI_MEM_ACCESS_SUBIDX(offset) (CVMX_ADD_IO_SEG(0x00011F0000008280ull) + ((offset) & 31) * 16 - 16*12)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_ENB0 CVMX_PEXP_NPEI_MSI_ENB0_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_ENB0_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_ENB0 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BC50ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_ENB0 (CVMX_ADD_IO_SEG(0x00011F000000BC50ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_ENB1 CVMX_PEXP_NPEI_MSI_ENB1_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_ENB1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_ENB1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BC60ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_ENB1 (CVMX_ADD_IO_SEG(0x00011F000000BC60ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_ENB2 CVMX_PEXP_NPEI_MSI_ENB2_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_ENB2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_ENB2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BC70ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_ENB2 (CVMX_ADD_IO_SEG(0x00011F000000BC70ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_ENB3 CVMX_PEXP_NPEI_MSI_ENB3_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_ENB3_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_ENB3 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BC80ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_ENB3 (CVMX_ADD_IO_SEG(0x00011F000000BC80ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_RCV0 CVMX_PEXP_NPEI_MSI_RCV0_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_RCV0_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_RCV0 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BC10ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_RCV0 (CVMX_ADD_IO_SEG(0x00011F000000BC10ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_RCV1 CVMX_PEXP_NPEI_MSI_RCV1_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_RCV1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_RCV1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BC20ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_RCV1 (CVMX_ADD_IO_SEG(0x00011F000000BC20ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_RCV2 CVMX_PEXP_NPEI_MSI_RCV2_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_RCV2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_RCV2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BC30ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_RCV2 (CVMX_ADD_IO_SEG(0x00011F000000BC30ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_RCV3 CVMX_PEXP_NPEI_MSI_RCV3_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_RCV3_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_RCV3 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BC40ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_RCV3 (CVMX_ADD_IO_SEG(0x00011F000000BC40ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_RD_MAP CVMX_PEXP_NPEI_MSI_RD_MAP_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_RD_MAP_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_RD_MAP not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BCA0ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_RD_MAP (CVMX_ADD_IO_SEG(0x00011F000000BCA0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_W1C_ENB0 CVMX_PEXP_NPEI_MSI_W1C_ENB0_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_W1C_ENB0_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_W1C_ENB0 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BCF0ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_W1C_ENB0 (CVMX_ADD_IO_SEG(0x00011F000000BCF0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_W1C_ENB1 CVMX_PEXP_NPEI_MSI_W1C_ENB1_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_W1C_ENB1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_W1C_ENB1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BD00ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_W1C_ENB1 (CVMX_ADD_IO_SEG(0x00011F000000BD00ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_W1C_ENB2 CVMX_PEXP_NPEI_MSI_W1C_ENB2_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_W1C_ENB2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_W1C_ENB2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BD10ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_W1C_ENB2 (CVMX_ADD_IO_SEG(0x00011F000000BD10ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_W1C_ENB3 CVMX_PEXP_NPEI_MSI_W1C_ENB3_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_W1C_ENB3_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_W1C_ENB3 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BD20ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_W1C_ENB3 (CVMX_ADD_IO_SEG(0x00011F000000BD20ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_W1S_ENB0 CVMX_PEXP_NPEI_MSI_W1S_ENB0_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_W1S_ENB0_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_W1S_ENB0 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BD30ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_W1S_ENB0 (CVMX_ADD_IO_SEG(0x00011F000000BD30ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_W1S_ENB1 CVMX_PEXP_NPEI_MSI_W1S_ENB1_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_W1S_ENB1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_W1S_ENB1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BD40ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_W1S_ENB1 (CVMX_ADD_IO_SEG(0x00011F000000BD40ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_W1S_ENB2 CVMX_PEXP_NPEI_MSI_W1S_ENB2_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_W1S_ENB2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_W1S_ENB2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BD50ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_W1S_ENB2 (CVMX_ADD_IO_SEG(0x00011F000000BD50ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_W1S_ENB3 CVMX_PEXP_NPEI_MSI_W1S_ENB3_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_W1S_ENB3_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_W1S_ENB3 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BD60ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_W1S_ENB3 (CVMX_ADD_IO_SEG(0x00011F000000BD60ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_MSI_WR_MAP CVMX_PEXP_NPEI_MSI_WR_MAP_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_MSI_WR_MAP_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_MSI_WR_MAP not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BC90ull);
}
#else
#define CVMX_PEXP_NPEI_MSI_WR_MAP (CVMX_ADD_IO_SEG(0x00011F000000BC90ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PCIE_CREDIT_CNT CVMX_PEXP_NPEI_PCIE_CREDIT_CNT_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PCIE_CREDIT_CNT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PCIE_CREDIT_CNT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BD70ull);
}
#else
#define CVMX_PEXP_NPEI_PCIE_CREDIT_CNT (CVMX_ADD_IO_SEG(0x00011F000000BD70ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PCIE_MSI_RCV CVMX_PEXP_NPEI_PCIE_MSI_RCV_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PCIE_MSI_RCV_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PCIE_MSI_RCV not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000BCB0ull);
}
#else
#define CVMX_PEXP_NPEI_PCIE_MSI_RCV (CVMX_ADD_IO_SEG(0x00011F000000BCB0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PCIE_MSI_RCV_B1 CVMX_PEXP_NPEI_PCIE_MSI_RCV_B1_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PCIE_MSI_RCV_B1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PCIE_MSI_RCV_B1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008650ull);
}
#else
#define CVMX_PEXP_NPEI_PCIE_MSI_RCV_B1 (CVMX_ADD_IO_SEG(0x00011F0000008650ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PCIE_MSI_RCV_B2 CVMX_PEXP_NPEI_PCIE_MSI_RCV_B2_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PCIE_MSI_RCV_B2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PCIE_MSI_RCV_B2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008660ull);
}
#else
#define CVMX_PEXP_NPEI_PCIE_MSI_RCV_B2 (CVMX_ADD_IO_SEG(0x00011F0000008660ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PCIE_MSI_RCV_B3 CVMX_PEXP_NPEI_PCIE_MSI_RCV_B3_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PCIE_MSI_RCV_B3_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PCIE_MSI_RCV_B3 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008670ull);
}
#else
#define CVMX_PEXP_NPEI_PCIE_MSI_RCV_B3 (CVMX_ADD_IO_SEG(0x00011F0000008670ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_PKTX_CNTS(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_NPEI_PKTX_CNTS(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F000000A400ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_NPEI_PKTX_CNTS(offset) (CVMX_ADD_IO_SEG(0x00011F000000A400ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_PKTX_INSTR_BADDR(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_NPEI_PKTX_INSTR_BADDR(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F000000A800ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_NPEI_PKTX_INSTR_BADDR(offset) (CVMX_ADD_IO_SEG(0x00011F000000A800ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_PKTX_INSTR_BAOFF_DBELL(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_NPEI_PKTX_INSTR_BAOFF_DBELL(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F000000AC00ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_NPEI_PKTX_INSTR_BAOFF_DBELL(offset) (CVMX_ADD_IO_SEG(0x00011F000000AC00ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_PKTX_INSTR_FIFO_RSIZE(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_NPEI_PKTX_INSTR_FIFO_RSIZE(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F000000B000ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_NPEI_PKTX_INSTR_FIFO_RSIZE(offset) (CVMX_ADD_IO_SEG(0x00011F000000B000ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_PKTX_INSTR_HEADER(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_NPEI_PKTX_INSTR_HEADER(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F000000B400ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_NPEI_PKTX_INSTR_HEADER(offset) (CVMX_ADD_IO_SEG(0x00011F000000B400ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_PKTX_IN_BP(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_NPEI_PKTX_IN_BP(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F000000B800ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_NPEI_PKTX_IN_BP(offset) (CVMX_ADD_IO_SEG(0x00011F000000B800ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_PKTX_SLIST_BADDR(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_NPEI_PKTX_SLIST_BADDR(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000009400ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_NPEI_PKTX_SLIST_BADDR(offset) (CVMX_ADD_IO_SEG(0x00011F0000009400ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_PKTX_SLIST_BAOFF_DBELL(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_NPEI_PKTX_SLIST_BAOFF_DBELL(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000009800ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_NPEI_PKTX_SLIST_BAOFF_DBELL(offset) (CVMX_ADD_IO_SEG(0x00011F0000009800ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_PKTX_SLIST_FIFO_RSIZE(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_NPEI_PKTX_SLIST_FIFO_RSIZE(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000009C00ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_NPEI_PKTX_SLIST_FIFO_RSIZE(offset) (CVMX_ADD_IO_SEG(0x00011F0000009C00ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_CNT_INT CVMX_PEXP_NPEI_PKT_CNT_INT_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_CNT_INT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_CNT_INT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009110ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_CNT_INT (CVMX_ADD_IO_SEG(0x00011F0000009110ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_CNT_INT_ENB CVMX_PEXP_NPEI_PKT_CNT_INT_ENB_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_CNT_INT_ENB_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_CNT_INT_ENB not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009130ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_CNT_INT_ENB (CVMX_ADD_IO_SEG(0x00011F0000009130ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_DATA_OUT_ES CVMX_PEXP_NPEI_PKT_DATA_OUT_ES_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_DATA_OUT_ES_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_DATA_OUT_ES not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000090B0ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_DATA_OUT_ES (CVMX_ADD_IO_SEG(0x00011F00000090B0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_DATA_OUT_NS CVMX_PEXP_NPEI_PKT_DATA_OUT_NS_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_DATA_OUT_NS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_DATA_OUT_NS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000090A0ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_DATA_OUT_NS (CVMX_ADD_IO_SEG(0x00011F00000090A0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_DATA_OUT_ROR CVMX_PEXP_NPEI_PKT_DATA_OUT_ROR_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_DATA_OUT_ROR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_DATA_OUT_ROR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009090ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_DATA_OUT_ROR (CVMX_ADD_IO_SEG(0x00011F0000009090ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_DPADDR CVMX_PEXP_NPEI_PKT_DPADDR_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_DPADDR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_DPADDR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009080ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_DPADDR (CVMX_ADD_IO_SEG(0x00011F0000009080ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_INPUT_CONTROL CVMX_PEXP_NPEI_PKT_INPUT_CONTROL_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_INPUT_CONTROL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_INPUT_CONTROL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009150ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_INPUT_CONTROL (CVMX_ADD_IO_SEG(0x00011F0000009150ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_INSTR_ENB CVMX_PEXP_NPEI_PKT_INSTR_ENB_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_INSTR_ENB_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_INSTR_ENB not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009000ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_INSTR_ENB (CVMX_ADD_IO_SEG(0x00011F0000009000ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_INSTR_RD_SIZE CVMX_PEXP_NPEI_PKT_INSTR_RD_SIZE_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_INSTR_RD_SIZE_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_INSTR_RD_SIZE not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009190ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_INSTR_RD_SIZE (CVMX_ADD_IO_SEG(0x00011F0000009190ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_INSTR_SIZE CVMX_PEXP_NPEI_PKT_INSTR_SIZE_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_INSTR_SIZE_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_INSTR_SIZE not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009020ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_INSTR_SIZE (CVMX_ADD_IO_SEG(0x00011F0000009020ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_INT_LEVELS CVMX_PEXP_NPEI_PKT_INT_LEVELS_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_INT_LEVELS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_INT_LEVELS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009100ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_INT_LEVELS (CVMX_ADD_IO_SEG(0x00011F0000009100ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_IN_BP CVMX_PEXP_NPEI_PKT_IN_BP_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_IN_BP_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_IN_BP not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000086B0ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_IN_BP (CVMX_ADD_IO_SEG(0x00011F00000086B0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_NPEI_PKT_IN_DONEX_CNTS(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN52XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN56XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_IN_DONEX_CNTS(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F000000A000ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_NPEI_PKT_IN_DONEX_CNTS(offset) (CVMX_ADD_IO_SEG(0x00011F000000A000ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_IN_INSTR_COUNTS CVMX_PEXP_NPEI_PKT_IN_INSTR_COUNTS_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_IN_INSTR_COUNTS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_IN_INSTR_COUNTS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000086A0ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_IN_INSTR_COUNTS (CVMX_ADD_IO_SEG(0x00011F00000086A0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_IN_PCIE_PORT CVMX_PEXP_NPEI_PKT_IN_PCIE_PORT_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_IN_PCIE_PORT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_IN_PCIE_PORT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000091A0ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_IN_PCIE_PORT (CVMX_ADD_IO_SEG(0x00011F00000091A0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_IPTR CVMX_PEXP_NPEI_PKT_IPTR_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_IPTR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_IPTR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009070ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_IPTR (CVMX_ADD_IO_SEG(0x00011F0000009070ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_OUTPUT_WMARK CVMX_PEXP_NPEI_PKT_OUTPUT_WMARK_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_OUTPUT_WMARK_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_OUTPUT_WMARK not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009160ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_OUTPUT_WMARK (CVMX_ADD_IO_SEG(0x00011F0000009160ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_OUT_BMODE CVMX_PEXP_NPEI_PKT_OUT_BMODE_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_OUT_BMODE_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_OUT_BMODE not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000090D0ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_OUT_BMODE (CVMX_ADD_IO_SEG(0x00011F00000090D0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_OUT_ENB CVMX_PEXP_NPEI_PKT_OUT_ENB_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_OUT_ENB_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_OUT_ENB not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009010ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_OUT_ENB (CVMX_ADD_IO_SEG(0x00011F0000009010ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_PCIE_PORT CVMX_PEXP_NPEI_PKT_PCIE_PORT_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_PCIE_PORT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_PCIE_PORT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000090E0ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_PCIE_PORT (CVMX_ADD_IO_SEG(0x00011F00000090E0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_PORT_IN_RST CVMX_PEXP_NPEI_PKT_PORT_IN_RST_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_PORT_IN_RST_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_PORT_IN_RST not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008690ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_PORT_IN_RST (CVMX_ADD_IO_SEG(0x00011F0000008690ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_SLIST_ES CVMX_PEXP_NPEI_PKT_SLIST_ES_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_SLIST_ES_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_SLIST_ES not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009050ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_SLIST_ES (CVMX_ADD_IO_SEG(0x00011F0000009050ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_SLIST_ID_SIZE CVMX_PEXP_NPEI_PKT_SLIST_ID_SIZE_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_SLIST_ID_SIZE_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_SLIST_ID_SIZE not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009180ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_SLIST_ID_SIZE (CVMX_ADD_IO_SEG(0x00011F0000009180ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_SLIST_NS CVMX_PEXP_NPEI_PKT_SLIST_NS_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_SLIST_NS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_SLIST_NS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009040ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_SLIST_NS (CVMX_ADD_IO_SEG(0x00011F0000009040ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_SLIST_ROR CVMX_PEXP_NPEI_PKT_SLIST_ROR_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_SLIST_ROR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_SLIST_ROR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009030ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_SLIST_ROR (CVMX_ADD_IO_SEG(0x00011F0000009030ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_TIME_INT CVMX_PEXP_NPEI_PKT_TIME_INT_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_TIME_INT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_TIME_INT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009120ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_TIME_INT (CVMX_ADD_IO_SEG(0x00011F0000009120ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_PKT_TIME_INT_ENB CVMX_PEXP_NPEI_PKT_TIME_INT_ENB_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_PKT_TIME_INT_ENB_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_PKT_TIME_INT_ENB not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000009140ull);
}
#else
#define CVMX_PEXP_NPEI_PKT_TIME_INT_ENB (CVMX_ADD_IO_SEG(0x00011F0000009140ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_RSL_INT_BLOCKS CVMX_PEXP_NPEI_RSL_INT_BLOCKS_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_RSL_INT_BLOCKS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_RSL_INT_BLOCKS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008520ull);
}
#else
#define CVMX_PEXP_NPEI_RSL_INT_BLOCKS (CVMX_ADD_IO_SEG(0x00011F0000008520ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_SCRATCH_1 CVMX_PEXP_NPEI_SCRATCH_1_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_SCRATCH_1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_SCRATCH_1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008270ull);
}
#else
#define CVMX_PEXP_NPEI_SCRATCH_1 (CVMX_ADD_IO_SEG(0x00011F0000008270ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_STATE1 CVMX_PEXP_NPEI_STATE1_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_STATE1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_STATE1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008620ull);
}
#else
#define CVMX_PEXP_NPEI_STATE1 (CVMX_ADD_IO_SEG(0x00011F0000008620ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_STATE2 CVMX_PEXP_NPEI_STATE2_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_STATE2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_STATE2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008630ull);
}
#else
#define CVMX_PEXP_NPEI_STATE2 (CVMX_ADD_IO_SEG(0x00011F0000008630ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_STATE3 CVMX_PEXP_NPEI_STATE3_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_STATE3_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_STATE3 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008640ull);
}
#else
#define CVMX_PEXP_NPEI_STATE3 (CVMX_ADD_IO_SEG(0x00011F0000008640ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_NPEI_WINDOW_CTL CVMX_PEXP_NPEI_WINDOW_CTL_FUNC()
static inline uint64_t CVMX_PEXP_NPEI_WINDOW_CTL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN52XX) || OCTEON_IS_MODEL(OCTEON_CN56XX)))
		cvmx_warn("CVMX_PEXP_NPEI_WINDOW_CTL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000008380ull);
}
#else
#define CVMX_PEXP_NPEI_WINDOW_CTL (CVMX_ADD_IO_SEG(0x00011F0000008380ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_BIST_STATUS CVMX_PEXP_SLI_BIST_STATUS_FUNC()
static inline uint64_t CVMX_PEXP_SLI_BIST_STATUS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_BIST_STATUS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000010580ull);
}
#else
#define CVMX_PEXP_SLI_BIST_STATUS (CVMX_ADD_IO_SEG(0x00011F0000010580ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_CTL_PORTX(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 1)))))
		cvmx_warn("CVMX_PEXP_SLI_CTL_PORTX(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000010050ull) + ((offset) & 1) * 16;
}
#else
#define CVMX_PEXP_SLI_CTL_PORTX(offset) (CVMX_ADD_IO_SEG(0x00011F0000010050ull) + ((offset) & 1) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_CTL_STATUS CVMX_PEXP_SLI_CTL_STATUS_FUNC()
static inline uint64_t CVMX_PEXP_SLI_CTL_STATUS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_CTL_STATUS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000010570ull);
}
#else
#define CVMX_PEXP_SLI_CTL_STATUS (CVMX_ADD_IO_SEG(0x00011F0000010570ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_DATA_OUT_CNT CVMX_PEXP_SLI_DATA_OUT_CNT_FUNC()
static inline uint64_t CVMX_PEXP_SLI_DATA_OUT_CNT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_DATA_OUT_CNT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000105F0ull);
}
#else
#define CVMX_PEXP_SLI_DATA_OUT_CNT (CVMX_ADD_IO_SEG(0x00011F00000105F0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_DBG_DATA CVMX_PEXP_SLI_DBG_DATA_FUNC()
static inline uint64_t CVMX_PEXP_SLI_DBG_DATA_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_DBG_DATA not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000010310ull);
}
#else
#define CVMX_PEXP_SLI_DBG_DATA (CVMX_ADD_IO_SEG(0x00011F0000010310ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_DBG_SELECT CVMX_PEXP_SLI_DBG_SELECT_FUNC()
static inline uint64_t CVMX_PEXP_SLI_DBG_SELECT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_DBG_SELECT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000010300ull);
}
#else
#define CVMX_PEXP_SLI_DBG_SELECT (CVMX_ADD_IO_SEG(0x00011F0000010300ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_DMAX_CNT(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 1)))))
		cvmx_warn("CVMX_PEXP_SLI_DMAX_CNT(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000010400ull) + ((offset) & 1) * 16;
}
#else
#define CVMX_PEXP_SLI_DMAX_CNT(offset) (CVMX_ADD_IO_SEG(0x00011F0000010400ull) + ((offset) & 1) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_DMAX_INT_LEVEL(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 1)))))
		cvmx_warn("CVMX_PEXP_SLI_DMAX_INT_LEVEL(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F00000103E0ull) + ((offset) & 1) * 16;
}
#else
#define CVMX_PEXP_SLI_DMAX_INT_LEVEL(offset) (CVMX_ADD_IO_SEG(0x00011F00000103E0ull) + ((offset) & 1) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_DMAX_TIM(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 1)))))
		cvmx_warn("CVMX_PEXP_SLI_DMAX_TIM(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000010420ull) + ((offset) & 1) * 16;
}
#else
#define CVMX_PEXP_SLI_DMAX_TIM(offset) (CVMX_ADD_IO_SEG(0x00011F0000010420ull) + ((offset) & 1) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_INT_ENB_CIU CVMX_PEXP_SLI_INT_ENB_CIU_FUNC()
static inline uint64_t CVMX_PEXP_SLI_INT_ENB_CIU_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_INT_ENB_CIU not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013CD0ull);
}
#else
#define CVMX_PEXP_SLI_INT_ENB_CIU (CVMX_ADD_IO_SEG(0x00011F0000013CD0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_INT_ENB_PORTX(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 1)))))
		cvmx_warn("CVMX_PEXP_SLI_INT_ENB_PORTX(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000010340ull) + ((offset) & 1) * 16;
}
#else
#define CVMX_PEXP_SLI_INT_ENB_PORTX(offset) (CVMX_ADD_IO_SEG(0x00011F0000010340ull) + ((offset) & 1) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_INT_SUM CVMX_PEXP_SLI_INT_SUM_FUNC()
static inline uint64_t CVMX_PEXP_SLI_INT_SUM_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_INT_SUM not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000010330ull);
}
#else
#define CVMX_PEXP_SLI_INT_SUM (CVMX_ADD_IO_SEG(0x00011F0000010330ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_LAST_WIN_RDATA0 CVMX_PEXP_SLI_LAST_WIN_RDATA0_FUNC()
static inline uint64_t CVMX_PEXP_SLI_LAST_WIN_RDATA0_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_LAST_WIN_RDATA0 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000010600ull);
}
#else
#define CVMX_PEXP_SLI_LAST_WIN_RDATA0 (CVMX_ADD_IO_SEG(0x00011F0000010600ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_LAST_WIN_RDATA1 CVMX_PEXP_SLI_LAST_WIN_RDATA1_FUNC()
static inline uint64_t CVMX_PEXP_SLI_LAST_WIN_RDATA1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_LAST_WIN_RDATA1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000010610ull);
}
#else
#define CVMX_PEXP_SLI_LAST_WIN_RDATA1 (CVMX_ADD_IO_SEG(0x00011F0000010610ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MAC_CREDIT_CNT CVMX_PEXP_SLI_MAC_CREDIT_CNT_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MAC_CREDIT_CNT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MAC_CREDIT_CNT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013D70ull);
}
#else
#define CVMX_PEXP_SLI_MAC_CREDIT_CNT (CVMX_ADD_IO_SEG(0x00011F0000013D70ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MEM_ACCESS_CTL CVMX_PEXP_SLI_MEM_ACCESS_CTL_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MEM_ACCESS_CTL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MEM_ACCESS_CTL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000102F0ull);
}
#else
#define CVMX_PEXP_SLI_MEM_ACCESS_CTL (CVMX_ADD_IO_SEG(0x00011F00000102F0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_MEM_ACCESS_SUBIDX(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && (((offset >= 12) && (offset <= 27))))))
		cvmx_warn("CVMX_PEXP_SLI_MEM_ACCESS_SUBIDX(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F00000100E0ull) + ((offset) & 31) * 16 - 16*12;
}
#else
#define CVMX_PEXP_SLI_MEM_ACCESS_SUBIDX(offset) (CVMX_ADD_IO_SEG(0x00011F00000100E0ull) + ((offset) & 31) * 16 - 16*12)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_ENB0 CVMX_PEXP_SLI_MSI_ENB0_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_ENB0_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_ENB0 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013C50ull);
}
#else
#define CVMX_PEXP_SLI_MSI_ENB0 (CVMX_ADD_IO_SEG(0x00011F0000013C50ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_ENB1 CVMX_PEXP_SLI_MSI_ENB1_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_ENB1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_ENB1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013C60ull);
}
#else
#define CVMX_PEXP_SLI_MSI_ENB1 (CVMX_ADD_IO_SEG(0x00011F0000013C60ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_ENB2 CVMX_PEXP_SLI_MSI_ENB2_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_ENB2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_ENB2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013C70ull);
}
#else
#define CVMX_PEXP_SLI_MSI_ENB2 (CVMX_ADD_IO_SEG(0x00011F0000013C70ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_ENB3 CVMX_PEXP_SLI_MSI_ENB3_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_ENB3_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_ENB3 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013C80ull);
}
#else
#define CVMX_PEXP_SLI_MSI_ENB3 (CVMX_ADD_IO_SEG(0x00011F0000013C80ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_RCV0 CVMX_PEXP_SLI_MSI_RCV0_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_RCV0_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_RCV0 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013C10ull);
}
#else
#define CVMX_PEXP_SLI_MSI_RCV0 (CVMX_ADD_IO_SEG(0x00011F0000013C10ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_RCV1 CVMX_PEXP_SLI_MSI_RCV1_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_RCV1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_RCV1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013C20ull);
}
#else
#define CVMX_PEXP_SLI_MSI_RCV1 (CVMX_ADD_IO_SEG(0x00011F0000013C20ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_RCV2 CVMX_PEXP_SLI_MSI_RCV2_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_RCV2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_RCV2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013C30ull);
}
#else
#define CVMX_PEXP_SLI_MSI_RCV2 (CVMX_ADD_IO_SEG(0x00011F0000013C30ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_RCV3 CVMX_PEXP_SLI_MSI_RCV3_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_RCV3_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_RCV3 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013C40ull);
}
#else
#define CVMX_PEXP_SLI_MSI_RCV3 (CVMX_ADD_IO_SEG(0x00011F0000013C40ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_RD_MAP CVMX_PEXP_SLI_MSI_RD_MAP_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_RD_MAP_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_RD_MAP not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013CA0ull);
}
#else
#define CVMX_PEXP_SLI_MSI_RD_MAP (CVMX_ADD_IO_SEG(0x00011F0000013CA0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_W1C_ENB0 CVMX_PEXP_SLI_MSI_W1C_ENB0_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_W1C_ENB0_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_W1C_ENB0 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013CF0ull);
}
#else
#define CVMX_PEXP_SLI_MSI_W1C_ENB0 (CVMX_ADD_IO_SEG(0x00011F0000013CF0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_W1C_ENB1 CVMX_PEXP_SLI_MSI_W1C_ENB1_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_W1C_ENB1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_W1C_ENB1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013D00ull);
}
#else
#define CVMX_PEXP_SLI_MSI_W1C_ENB1 (CVMX_ADD_IO_SEG(0x00011F0000013D00ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_W1C_ENB2 CVMX_PEXP_SLI_MSI_W1C_ENB2_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_W1C_ENB2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_W1C_ENB2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013D10ull);
}
#else
#define CVMX_PEXP_SLI_MSI_W1C_ENB2 (CVMX_ADD_IO_SEG(0x00011F0000013D10ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_W1C_ENB3 CVMX_PEXP_SLI_MSI_W1C_ENB3_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_W1C_ENB3_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_W1C_ENB3 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013D20ull);
}
#else
#define CVMX_PEXP_SLI_MSI_W1C_ENB3 (CVMX_ADD_IO_SEG(0x00011F0000013D20ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_W1S_ENB0 CVMX_PEXP_SLI_MSI_W1S_ENB0_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_W1S_ENB0_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_W1S_ENB0 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013D30ull);
}
#else
#define CVMX_PEXP_SLI_MSI_W1S_ENB0 (CVMX_ADD_IO_SEG(0x00011F0000013D30ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_W1S_ENB1 CVMX_PEXP_SLI_MSI_W1S_ENB1_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_W1S_ENB1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_W1S_ENB1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013D40ull);
}
#else
#define CVMX_PEXP_SLI_MSI_W1S_ENB1 (CVMX_ADD_IO_SEG(0x00011F0000013D40ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_W1S_ENB2 CVMX_PEXP_SLI_MSI_W1S_ENB2_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_W1S_ENB2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_W1S_ENB2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013D50ull);
}
#else
#define CVMX_PEXP_SLI_MSI_W1S_ENB2 (CVMX_ADD_IO_SEG(0x00011F0000013D50ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_W1S_ENB3 CVMX_PEXP_SLI_MSI_W1S_ENB3_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_W1S_ENB3_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_W1S_ENB3 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013D60ull);
}
#else
#define CVMX_PEXP_SLI_MSI_W1S_ENB3 (CVMX_ADD_IO_SEG(0x00011F0000013D60ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_MSI_WR_MAP CVMX_PEXP_SLI_MSI_WR_MAP_FUNC()
static inline uint64_t CVMX_PEXP_SLI_MSI_WR_MAP_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_MSI_WR_MAP not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013C90ull);
}
#else
#define CVMX_PEXP_SLI_MSI_WR_MAP (CVMX_ADD_IO_SEG(0x00011F0000013C90ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PCIE_MSI_RCV CVMX_PEXP_SLI_PCIE_MSI_RCV_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PCIE_MSI_RCV_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PCIE_MSI_RCV not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000013CB0ull);
}
#else
#define CVMX_PEXP_SLI_PCIE_MSI_RCV (CVMX_ADD_IO_SEG(0x00011F0000013CB0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PCIE_MSI_RCV_B1 CVMX_PEXP_SLI_PCIE_MSI_RCV_B1_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PCIE_MSI_RCV_B1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PCIE_MSI_RCV_B1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000010650ull);
}
#else
#define CVMX_PEXP_SLI_PCIE_MSI_RCV_B1 (CVMX_ADD_IO_SEG(0x00011F0000010650ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PCIE_MSI_RCV_B2 CVMX_PEXP_SLI_PCIE_MSI_RCV_B2_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PCIE_MSI_RCV_B2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PCIE_MSI_RCV_B2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000010660ull);
}
#else
#define CVMX_PEXP_SLI_PCIE_MSI_RCV_B2 (CVMX_ADD_IO_SEG(0x00011F0000010660ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PCIE_MSI_RCV_B3 CVMX_PEXP_SLI_PCIE_MSI_RCV_B3_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PCIE_MSI_RCV_B3_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PCIE_MSI_RCV_B3 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000010670ull);
}
#else
#define CVMX_PEXP_SLI_PCIE_MSI_RCV_B3 (CVMX_ADD_IO_SEG(0x00011F0000010670ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_PKTX_CNTS(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_SLI_PKTX_CNTS(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000012400ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_SLI_PKTX_CNTS(offset) (CVMX_ADD_IO_SEG(0x00011F0000012400ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_PKTX_INSTR_BADDR(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_SLI_PKTX_INSTR_BADDR(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000012800ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_SLI_PKTX_INSTR_BADDR(offset) (CVMX_ADD_IO_SEG(0x00011F0000012800ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_PKTX_INSTR_BAOFF_DBELL(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_SLI_PKTX_INSTR_BAOFF_DBELL(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000012C00ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_SLI_PKTX_INSTR_BAOFF_DBELL(offset) (CVMX_ADD_IO_SEG(0x00011F0000012C00ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_PKTX_INSTR_FIFO_RSIZE(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_SLI_PKTX_INSTR_FIFO_RSIZE(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000013000ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_SLI_PKTX_INSTR_FIFO_RSIZE(offset) (CVMX_ADD_IO_SEG(0x00011F0000013000ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_PKTX_INSTR_HEADER(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_SLI_PKTX_INSTR_HEADER(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000013400ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_SLI_PKTX_INSTR_HEADER(offset) (CVMX_ADD_IO_SEG(0x00011F0000013400ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_PKTX_IN_BP(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_SLI_PKTX_IN_BP(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000013800ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_SLI_PKTX_IN_BP(offset) (CVMX_ADD_IO_SEG(0x00011F0000013800ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_PKTX_OUT_SIZE(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_SLI_PKTX_OUT_SIZE(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000010C00ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_SLI_PKTX_OUT_SIZE(offset) (CVMX_ADD_IO_SEG(0x00011F0000010C00ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_PKTX_SLIST_BADDR(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_SLI_PKTX_SLIST_BADDR(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000011400ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_SLI_PKTX_SLIST_BADDR(offset) (CVMX_ADD_IO_SEG(0x00011F0000011400ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_PKTX_SLIST_BAOFF_DBELL(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_SLI_PKTX_SLIST_BAOFF_DBELL(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000011800ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_SLI_PKTX_SLIST_BAOFF_DBELL(offset) (CVMX_ADD_IO_SEG(0x00011F0000011800ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_PKTX_SLIST_FIFO_RSIZE(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_SLI_PKTX_SLIST_FIFO_RSIZE(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000011C00ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_SLI_PKTX_SLIST_FIFO_RSIZE(offset) (CVMX_ADD_IO_SEG(0x00011F0000011C00ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_CNT_INT CVMX_PEXP_SLI_PKT_CNT_INT_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_CNT_INT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_CNT_INT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011130ull);
}
#else
#define CVMX_PEXP_SLI_PKT_CNT_INT (CVMX_ADD_IO_SEG(0x00011F0000011130ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_CNT_INT_ENB CVMX_PEXP_SLI_PKT_CNT_INT_ENB_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_CNT_INT_ENB_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_CNT_INT_ENB not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011150ull);
}
#else
#define CVMX_PEXP_SLI_PKT_CNT_INT_ENB (CVMX_ADD_IO_SEG(0x00011F0000011150ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_CTL CVMX_PEXP_SLI_PKT_CTL_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_CTL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_CTL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011220ull);
}
#else
#define CVMX_PEXP_SLI_PKT_CTL (CVMX_ADD_IO_SEG(0x00011F0000011220ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_DATA_OUT_ES CVMX_PEXP_SLI_PKT_DATA_OUT_ES_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_DATA_OUT_ES_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_DATA_OUT_ES not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000110B0ull);
}
#else
#define CVMX_PEXP_SLI_PKT_DATA_OUT_ES (CVMX_ADD_IO_SEG(0x00011F00000110B0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_DATA_OUT_NS CVMX_PEXP_SLI_PKT_DATA_OUT_NS_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_DATA_OUT_NS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_DATA_OUT_NS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000110A0ull);
}
#else
#define CVMX_PEXP_SLI_PKT_DATA_OUT_NS (CVMX_ADD_IO_SEG(0x00011F00000110A0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_DATA_OUT_ROR CVMX_PEXP_SLI_PKT_DATA_OUT_ROR_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_DATA_OUT_ROR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_DATA_OUT_ROR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011090ull);
}
#else
#define CVMX_PEXP_SLI_PKT_DATA_OUT_ROR (CVMX_ADD_IO_SEG(0x00011F0000011090ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_DPADDR CVMX_PEXP_SLI_PKT_DPADDR_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_DPADDR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_DPADDR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011080ull);
}
#else
#define CVMX_PEXP_SLI_PKT_DPADDR (CVMX_ADD_IO_SEG(0x00011F0000011080ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_INPUT_CONTROL CVMX_PEXP_SLI_PKT_INPUT_CONTROL_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_INPUT_CONTROL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_INPUT_CONTROL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011170ull);
}
#else
#define CVMX_PEXP_SLI_PKT_INPUT_CONTROL (CVMX_ADD_IO_SEG(0x00011F0000011170ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_INSTR_ENB CVMX_PEXP_SLI_PKT_INSTR_ENB_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_INSTR_ENB_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_INSTR_ENB not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011000ull);
}
#else
#define CVMX_PEXP_SLI_PKT_INSTR_ENB (CVMX_ADD_IO_SEG(0x00011F0000011000ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_INSTR_RD_SIZE CVMX_PEXP_SLI_PKT_INSTR_RD_SIZE_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_INSTR_RD_SIZE_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_INSTR_RD_SIZE not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000111A0ull);
}
#else
#define CVMX_PEXP_SLI_PKT_INSTR_RD_SIZE (CVMX_ADD_IO_SEG(0x00011F00000111A0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_INSTR_SIZE CVMX_PEXP_SLI_PKT_INSTR_SIZE_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_INSTR_SIZE_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_INSTR_SIZE not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011020ull);
}
#else
#define CVMX_PEXP_SLI_PKT_INSTR_SIZE (CVMX_ADD_IO_SEG(0x00011F0000011020ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_INT_LEVELS CVMX_PEXP_SLI_PKT_INT_LEVELS_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_INT_LEVELS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_INT_LEVELS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011120ull);
}
#else
#define CVMX_PEXP_SLI_PKT_INT_LEVELS (CVMX_ADD_IO_SEG(0x00011F0000011120ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_IN_BP CVMX_PEXP_SLI_PKT_IN_BP_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_IN_BP_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_IN_BP not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011210ull);
}
#else
#define CVMX_PEXP_SLI_PKT_IN_BP (CVMX_ADD_IO_SEG(0x00011F0000011210ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_PKT_IN_DONEX_CNTS(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_PEXP_SLI_PKT_IN_DONEX_CNTS(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000012000ull) + ((offset) & 31) * 16;
}
#else
#define CVMX_PEXP_SLI_PKT_IN_DONEX_CNTS(offset) (CVMX_ADD_IO_SEG(0x00011F0000012000ull) + ((offset) & 31) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_IN_INSTR_COUNTS CVMX_PEXP_SLI_PKT_IN_INSTR_COUNTS_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_IN_INSTR_COUNTS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_IN_INSTR_COUNTS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011200ull);
}
#else
#define CVMX_PEXP_SLI_PKT_IN_INSTR_COUNTS (CVMX_ADD_IO_SEG(0x00011F0000011200ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_IN_PCIE_PORT CVMX_PEXP_SLI_PKT_IN_PCIE_PORT_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_IN_PCIE_PORT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_IN_PCIE_PORT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000111B0ull);
}
#else
#define CVMX_PEXP_SLI_PKT_IN_PCIE_PORT (CVMX_ADD_IO_SEG(0x00011F00000111B0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_IPTR CVMX_PEXP_SLI_PKT_IPTR_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_IPTR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_IPTR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011070ull);
}
#else
#define CVMX_PEXP_SLI_PKT_IPTR (CVMX_ADD_IO_SEG(0x00011F0000011070ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_OUTPUT_WMARK CVMX_PEXP_SLI_PKT_OUTPUT_WMARK_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_OUTPUT_WMARK_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_OUTPUT_WMARK not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011180ull);
}
#else
#define CVMX_PEXP_SLI_PKT_OUTPUT_WMARK (CVMX_ADD_IO_SEG(0x00011F0000011180ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_OUT_BMODE CVMX_PEXP_SLI_PKT_OUT_BMODE_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_OUT_BMODE_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_OUT_BMODE not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000110D0ull);
}
#else
#define CVMX_PEXP_SLI_PKT_OUT_BMODE (CVMX_ADD_IO_SEG(0x00011F00000110D0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_OUT_ENB CVMX_PEXP_SLI_PKT_OUT_ENB_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_OUT_ENB_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_OUT_ENB not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011010ull);
}
#else
#define CVMX_PEXP_SLI_PKT_OUT_ENB (CVMX_ADD_IO_SEG(0x00011F0000011010ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_PCIE_PORT CVMX_PEXP_SLI_PKT_PCIE_PORT_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_PCIE_PORT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_PCIE_PORT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000110E0ull);
}
#else
#define CVMX_PEXP_SLI_PKT_PCIE_PORT (CVMX_ADD_IO_SEG(0x00011F00000110E0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_PORT_IN_RST CVMX_PEXP_SLI_PKT_PORT_IN_RST_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_PORT_IN_RST_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_PORT_IN_RST not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000111F0ull);
}
#else
#define CVMX_PEXP_SLI_PKT_PORT_IN_RST (CVMX_ADD_IO_SEG(0x00011F00000111F0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_SLIST_ES CVMX_PEXP_SLI_PKT_SLIST_ES_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_SLIST_ES_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_SLIST_ES not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011050ull);
}
#else
#define CVMX_PEXP_SLI_PKT_SLIST_ES (CVMX_ADD_IO_SEG(0x00011F0000011050ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_SLIST_NS CVMX_PEXP_SLI_PKT_SLIST_NS_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_SLIST_NS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_SLIST_NS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011040ull);
}
#else
#define CVMX_PEXP_SLI_PKT_SLIST_NS (CVMX_ADD_IO_SEG(0x00011F0000011040ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_SLIST_ROR CVMX_PEXP_SLI_PKT_SLIST_ROR_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_SLIST_ROR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_SLIST_ROR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011030ull);
}
#else
#define CVMX_PEXP_SLI_PKT_SLIST_ROR (CVMX_ADD_IO_SEG(0x00011F0000011030ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_TIME_INT CVMX_PEXP_SLI_PKT_TIME_INT_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_TIME_INT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_TIME_INT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011140ull);
}
#else
#define CVMX_PEXP_SLI_PKT_TIME_INT (CVMX_ADD_IO_SEG(0x00011F0000011140ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_PKT_TIME_INT_ENB CVMX_PEXP_SLI_PKT_TIME_INT_ENB_FUNC()
static inline uint64_t CVMX_PEXP_SLI_PKT_TIME_INT_ENB_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_PKT_TIME_INT_ENB not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000011160ull);
}
#else
#define CVMX_PEXP_SLI_PKT_TIME_INT_ENB (CVMX_ADD_IO_SEG(0x00011F0000011160ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_PEXP_SLI_S2M_PORTX_CTL(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN63XX) && ((offset <= 1)))))
		cvmx_warn("CVMX_PEXP_SLI_S2M_PORTX_CTL(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000013D80ull) + ((offset) & 1) * 16;
}
#else
#define CVMX_PEXP_SLI_S2M_PORTX_CTL(offset) (CVMX_ADD_IO_SEG(0x00011F0000013D80ull) + ((offset) & 1) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_SCRATCH_1 CVMX_PEXP_SLI_SCRATCH_1_FUNC()
static inline uint64_t CVMX_PEXP_SLI_SCRATCH_1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_SCRATCH_1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000103C0ull);
}
#else
#define CVMX_PEXP_SLI_SCRATCH_1 (CVMX_ADD_IO_SEG(0x00011F00000103C0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_SCRATCH_2 CVMX_PEXP_SLI_SCRATCH_2_FUNC()
static inline uint64_t CVMX_PEXP_SLI_SCRATCH_2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_SCRATCH_2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000103D0ull);
}
#else
#define CVMX_PEXP_SLI_SCRATCH_2 (CVMX_ADD_IO_SEG(0x00011F00000103D0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_STATE1 CVMX_PEXP_SLI_STATE1_FUNC()
static inline uint64_t CVMX_PEXP_SLI_STATE1_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_STATE1 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000010620ull);
}
#else
#define CVMX_PEXP_SLI_STATE1 (CVMX_ADD_IO_SEG(0x00011F0000010620ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_STATE2 CVMX_PEXP_SLI_STATE2_FUNC()
static inline uint64_t CVMX_PEXP_SLI_STATE2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_STATE2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000010630ull);
}
#else
#define CVMX_PEXP_SLI_STATE2 (CVMX_ADD_IO_SEG(0x00011F0000010630ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_STATE3 CVMX_PEXP_SLI_STATE3_FUNC()
static inline uint64_t CVMX_PEXP_SLI_STATE3_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_STATE3 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000010640ull);
}
#else
#define CVMX_PEXP_SLI_STATE3 (CVMX_ADD_IO_SEG(0x00011F0000010640ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_PEXP_SLI_WINDOW_CTL CVMX_PEXP_SLI_WINDOW_CTL_FUNC()
static inline uint64_t CVMX_PEXP_SLI_WINDOW_CTL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN63XX)))
		cvmx_warn("CVMX_PEXP_SLI_WINDOW_CTL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000102E0ull);
}
#else
#define CVMX_PEXP_SLI_WINDOW_CTL (CVMX_ADD_IO_SEG(0x00011F00000102E0ull))
#endif

#endif
