/*-
 * Copyright (c) 2013, 2014 Andrew Turner
 * Copyright (c) 2021 The FreeBSD Foundation
 *
 * Portions of this software were developed by Andrew Turner
 * under sponsorship from the FreeBSD Foundation.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _MACHINE_HYPERVISOR_H_
#define	_MACHINE_HYPERVISOR_H_

#include <machine/_armreg.h>

/*
 * These registers are only useful when in hypervisor context,
 * e.g. specific to EL2, or controlling the hypervisor.
 */

/* CNTHCTL_EL2 - Counter-timer Hypervisor Control register */
/* Valid if HCR_EL2.E2H == 0 */
#define	CNTHCTL_EL1PCTEN_SHIFT		0
#define	CNTHCTL_EL1PCTEN_MASK		(0x1ul << CNTHCTL_E2H_EL1PCTEN_SHIFT)
#define	 CNTHCTL_EL1PCTEN_TRAP		(0x0ul << CNTHCTL_E2H_EL1PCTEN_SHIFT)
#define	 CNTHCTL_EL1PCTEN_NOTRAP	(0x1ul << CNTHCTL_EL1PCTEN_SHIFT)
#define	CNTHCTL_EL1PCEN_SHIFT		1
#define	CNTHCTL_EL1PCEN_MASK		(0x1ul << CNTHCTL_EL1PCEN_SHIFT)
#define	 CNTHCTL_EL1PCEN_TRAP		(0x0ul << CNTHCTL_EL1PCEN_SHIFT)
#define	 CNTHCTL_EL1PCEN_NOTRAP		(0x1ul << CNTHCTL_EL1PCEN_SHIFT)
/* Valid if HCR_EL2.E2H == 1 */
#define	CNTHCTL_E2H_EL0PCTEN_SHIFT	0
#define	CNTHCTL_E2H_EL0PCTEN_MASK	(0x1ul << CNTHCTL_E2H_EL0PCTEN_SHIFT)
#define	 CNTHCTL_E2H_EL0PCTEN_TRAP	(0x0ul << CNTHCTL_E2H_EL0PCTEN_SHIFT)
#define	 CNTHCTL_E2H_EL0PCTEN_NOTRAP	(0x1ul << CNTHCTL_E2H_EL0PCTEN_SHIFT)
#define	CNTHCTL_E2H_EL0VCTEN_SHIFT	1
#define	CNTHCTL_E2H_EL0VCTEN_MASK	(0x1ul << CNTHCTL_E2H_EL0VCTEN_SHIFT)
#define	 CNTHCTL_E2H_EL0VCTEN_TRAP	(0x0ul << CNTHCTL_E2H_EL0VCTEN_SHIFT)
#define	 CNTHCTL_E2H_EL0VCTEN_NOTRAP	(0x1ul << CNTHCTL_E2H_EL0VCTEN_SHIFT)
#define	CNTHCTL_E2H_EL0VTEN_SHIFT	8
#define	CNTHCTL_E2H_EL0VTEN_MASK	(0x1ul << CNTHCTL_E2H_EL0VTEN_SHIFT)
#define	 CNTHCTL_E2H_EL0VTEN_TRAP	(0x0ul << CNTHCTL_E2H_EL0VTEN_SHIFT)
#define	 CNTHCTL_E2H_EL0VTEN_NOTRAP	(0x1ul << CNTHCTL_E2H_EL0VTEN_SHIFT)
#define	CNTHCTL_E2H_EL0PTEN_SHIFT	9
#define	CNTHCTL_E2H_EL0PTEN_MASK	(0x1ul << CNTHCTL_E2H_EL0PTEN_SHIFT)
#define	 CNTHCTL_E2H_EL0PTEN_TRAP	(0x0ul << CNTHCTL_E2H_EL0PTEN_SHIFT)
#define	 CNTHCTL_E2H_EL0PTEN_NOTRAP	(0x1ul << CNTHCTL_E2H_EL0PTEN_SHIFT)
#define	CNTHCTL_E2H_EL1PCTEN_SHIFT	10
#define	CNTHCTL_E2H_EL1PCTEN_MASK	(0x1ul << CNTHCTL_E2H_EL1PCTEN_SHIFT)
#define	 CNTHCTL_E2H_EL1PCTEN_TRAP	(0x0ul << CNTHCTL_E2H_EL1PCTEN_SHIFT)
#define	 CNTHCTL_E2H_EL1PCTEN_NOTRAP	(0x1ul << CNTHCTL_E2H_EL1PCTEN_SHIFT)
#define	CNTHCTL_E2H_EL1PTEN_SHIFT	11
#define	CNTHCTL_E2H_EL1PTEN_MASK	(0x1ul << CNTHCTL_E2H_EL1PTEN_SHIFT)
#define	 CNTHCTL_E2H_EL1PTEN_TRAP	(0x0ul << CNTHCTL_E2H_EL1PTEN_SHIFT)
#define	 CNTHCTL_E2H_EL1PTEN_NOTRAP	(0x1ul << CNTHCTL_E2H_EL1PTEN_SHIFT)
/* Unconditionally valid */
#define	CNTHCTL_EVNTEN_SHIFT		2
#define	CNTHCTL_EVNTEN_MASK		(0x1ul << CNTHCTL_EVNTEN_SHIFT)
#define	 CNTHCTL_EVNTEN_DIS		(0x0ul << CNTHCTL_EVNTEN_SHIFT)
#define	 CNTHCTL_EVNTEN_EN		(0x1ul << CNTHCTL_EVNTEN_SHIFT)
#define	CNTHCTL_EVNTDIR_SHIFT		3
#define	CNTHCTL_EVNTDIR_MASK		(0x1ul << CNTHCTL_EVNTDIR_SHIFT)
#define	 CNTHCTL_EVNTDIR_HIGH		(0x0ul << CNTHCTL_EVNTDIR_SHIFT)
#define	 CNTHCTL_EVNTDIR_LOW		(0x1ul << CNTHCTL_EVNTDIR_SHIFT)
#define	CNTHCTL_EVNTI_SHIFT		4
#define	CNTHCTL_EVNTI_MASK		(0xful << CNTHCTL_EVNTI_SHIFT)
#define	CNTHCTL_ECV_SHIFT		12
#define	CNTHCTL_ECV_MASK		(0x1ul << CNTHCTL_ECV_SHIFT)
#define	 CNTHCTL_ECV_DIS		(0x0ul << CNTHCTL_ECV_SHIFT)
#define	 CNTHCTL_ECV_EN			(0x1ul << CNTHCTL_ECV_SHIFT)
#define	CNTHCTL_EL1TVT_SHIFT		13
#define	CNTHCTL_EL1TVT_MASK		(0x1ul << CNTHCTL_EL1TVT_SHIFT)
#define	 CNTHCTL_EL1TVT_NOTRAP		(0x0ul << CNTHCTL_EL1TVT_SHIFT)
#define	 CNTHCTL_EL1TVT_TRAP		(0x1ul << CNTHCTL_EL1TVT_SHIFT)
#define	CNTHCTL_EL1TVCT_SHIFT		14
#define	CNTHCTL_EL1TVCT_MASK		(0x1ul << CNTHCTL_EL1TVCT_SHIFT)
#define	 CNTHCTL_EL1TVCT_NOTRAP		(0x0ul << CNTHCTL_EL1TVCT_SHIFT)
#define	 CNTHCTL_EL1TVCT_TRAP		(0x1ul << CNTHCTL_EL1TVCT_SHIFT)
#define	CNTHCTL_EL1NVPCT_SHIFT		15
#define	CNTHCTL_EL1NVPCT_MASK		(0x1ul << CNTHCTL_EL1NVPCT_SHIFT)
#define	 CNTHCTL_EL1NVPCT_NOTRAP	(0x0ul << CNTHCTL_EL1NVPCT_SHIFT)
#define	 CNTHCTL_EL1NVPCT_TRAP		(0x1ul << CNTHCTL_EL1NVPCT_SHIFT)
#define	CNTHCTL_EL1NVVCT_SHIFT		16
#define	CNTHCTL_EL1NVVCT_MASK		(0x1ul << CNTHCTL_EL1NVVCT_SHIFT)
#define	 CNTHCTL_EL1NVVCT_NOTRAP	(0x0ul << CNTHCTL_EL1NVVCT_SHIFT)
#define	 CNTHCTL_EL1NVVCT_TRAP		(0x1ul << CNTHCTL_EL1NVVCT_SHIFT)
#define	CNTHCTL_EVNTIS_SHIFT		17
#define	CNTHCTL_EVNTIS_MASK		(0x1ul << CNTHCTL_EVNTIS_SHIFT)
#define	CNTHCTL_CNTVMASK_SHIFT		18
#define	CNTHCTL_CNTVMASK_MASK		(0x1ul << CNTHCTL_CNTVMASK_SHIFT)
#define	CNTHCTL_CNTPMASK_SHIFT		19
#define	CNTHCTL_CNTPMASK_MASK		(0x1ul << CNTHCTL_CNTPMASK_SHIFT)

/* CNTPOFF_EL2 - Counter-timer Physical Offset Register */
#define	CNTPOFF_EL2_REG			MRS_REG_ALT_NAME(CNTPOFF_EL2)
#define	CNTPOFF_EL2_op0			3
#define	CNTPOFF_EL2_op1			4
#define	CNTPOFF_EL2_CRn			14
#define	CNTPOFF_EL2_CRm			0
#define	CNTPOFF_EL2_op2			6

/* CPTR_EL2 - Architecture feature trap register */
/* Valid if HCR_EL2.E2H == 0 */
#define	CPTR_TRAP_ALL		0xc01037ff /* Enable all traps */
#define	CPTR_RES0		0x7fefc800
#define	CPTR_RES1		0x000032ff
#define	CPTR_TZ			0x00000100
#define	CPTR_TFP		0x00000400
#define	CPTR_TTA		0x00100000
/* Valid if HCR_EL2.E2H == 1 */
#define	CPTR_E2H_TRAP_ALL	0xd0000000
#define	CPTR_E2H_ZPEN		0x00030000
#define	CPTR_E2H_FPEN		0x00300000
#define	CPTR_E2H_TTA		0x10000000
/* Unconditionally valid */
#define	CPTR_TCPAC		0x80000000

/* HAFGRTR_EL2 */
#define	HAFGRTR_EL2_REG			MRS_REG_ALT_NAME(HAFGRTR_EL2)
#define	HAFGRTR_EL2_op0			3
#define	HAFGRTR_EL2_op1			4
#define	HAFGRTR_EL2_CRn			3
#define	HAFGRTR_EL2_CRm			1
#define	HAFGRTR_EL2_op2			6
#define	HAFGRTR_EL2_TRAP_ALL		UL(0x0003fffffffe001f)

/* HCR_EL2 - Hypervisor Config Register */
#define	HCR_VM				(UL(0x1) << 0)
#define	HCR_SWIO			(UL(0x1) << 1)
#define	HCR_PTW				(UL(0x1) << 2)
#define	HCR_FMO				(UL(0x1) << 3)
#define	HCR_IMO				(UL(0x1) << 4)
#define	HCR_AMO				(UL(0x1) << 5)
#define	HCR_VF				(UL(0x1) << 6)
#define	HCR_VI				(UL(0x1) << 7)
#define	HCR_VSE				(UL(0x1) << 8)
#define	HCR_FB				(UL(0x1) << 9)
#define	HCR_BSU_MASK			(UL(0x3) << 10)
#define	 HCR_BSU_IS			(UL(0x1) << 10)
#define	 HCR_BSU_OS			(UL(0x2) << 10)
#define	 HCR_BSU_FS			(UL(0x3) << 10)
#define	HCR_DC				(UL(0x1) << 12)
#define	HCR_TWI				(UL(0x1) << 13)
#define	HCR_TWE				(UL(0x1) << 14)
#define	HCR_TID0			(UL(0x1) << 15)
#define	HCR_TID1			(UL(0x1) << 16)
#define	HCR_TID2			(UL(0x1) << 17)
#define	HCR_TID3			(UL(0x1) << 18)
#define	HCR_TSC				(UL(0x1) << 19)
#define	HCR_TIDCP			(UL(0x1) << 20)
#define	HCR_TACR			(UL(0x1) << 21)
#define	HCR_TSW				(UL(0x1) << 22)
#define	HCR_TPCP			(UL(0x1) << 23)
#define	HCR_TPU				(UL(0x1) << 24)
#define	HCR_TTLB			(UL(0x1) << 25)
#define	HCR_TVM				(UL(0x1) << 26)
#define	HCR_TGE				(UL(0x1) << 27)
#define	HCR_TDZ				(UL(0x1) << 28)
#define	HCR_HCD				(UL(0x1) << 29)
#define	HCR_TRVM			(UL(0x1) << 30)
#define	HCR_RW				(UL(0x1) << 31)
#define	HCR_CD				(UL(0x1) << 32)
#define	HCR_ID				(UL(0x1) << 33)
#define	HCR_E2H				(UL(0x1) << 34)
#define	HCR_TLOR			(UL(0x1) << 35)
#define	HCR_TERR			(UL(0x1) << 36)
#define	HCR_TEA				(UL(0x1) << 37)
#define	HCR_MIOCNCE			(UL(0x1) << 38)
/* Bit 39 is reserved */
#define	HCR_APK				(UL(0x1) << 40)
#define	HCR_API				(UL(0x1) << 41)
#define	HCR_NV				(UL(0x1) << 42)
#define	HCR_NV1				(UL(0x1) << 43)
#define	HCR_AT				(UL(0x1) << 44)
#define	HCR_NV2				(UL(0x1) << 45)
#define	HCR_FWB				(UL(0x1) << 46)
#define	HCR_FIEN			(UL(0x1) << 47)
/* Bit 48 is reserved */
#define	HCR_TID4			(UL(0x1) << 49)
#define	HCR_TICAB			(UL(0x1) << 50)
#define	HCR_AMVOFFEN			(UL(0x1) << 51)
#define	HCR_TOCU			(UL(0x1) << 52)
#define	HCR_EnSCXT			(UL(0x1) << 53)
#define	HCR_TTLBIS			(UL(0x1) << 54)
#define	HCR_TTLBOS			(UL(0x1) << 55)
#define	HCR_ATA				(UL(0x1) << 56)
#define	HCR_DCT				(UL(0x1) << 57)
#define	HCR_TID5			(UL(0x1) << 58)
#define	HCR_TWEDEn			(UL(0x1) << 59)
#define	HCR_TWEDEL_MASK			(UL(0xf) << 60)

/* HCRX_EL2 - Extended Hypervisor Configuration Register */
#define HCRX_EL2_REG		MRS_REG_ALT_NAME(HCRX_EL2)
#define HCRX_EL2_op0		3
#define HCRX_EL2_op1		4
#define HCRX_EL2_CRn		1
#define HCRX_EL2_CRm		2
#define HCRX_EL2_op2		2

#define HCRX_EnAS0			(UL(0x1) << 0)
#define HCRX_EnALS			(UL(0x1) << 1)
#define HCRX_EnASR			(UL(0x1) << 2)
#define HCRX_FnXS			(UL(0x1) << 3)
#define HCRX_FGTnXS			(UL(0x1) << 4)
#define HCRX_SMPME			(UL(0x1) << 5)
#define HCRX_TALLINT			(UL(0x1) << 6)
#define HCRX_VINMI			(UL(0x1) << 7)
#define HCRX_VFNMI			(UL(0x1) << 8)
#define HCRX_CMOW			(UL(0x1) << 9)
#define HCRX_MCE2			(UL(0x1) << 10)
#define HCRX_MSCEn			(UL(0x1) << 11)
/* Bits 12 & 13 are reserved */
#define HCRX_TCR2En			(UL(0x1) << 14)
#define HCRX_SCTLR2En			(UL(0x1) << 15)
#define HCRX_PTTWI			(UL(0x1) << 16)
#define HCRX_D128En			(UL(0x1) << 17)
#define HCRX_EnSNERR			(UL(0x1) << 18)
#define HCRX_TMEA			(UL(0x1) << 19)
#define HCRX_EnSDERR			(UL(0x1) << 20)
#define HCRX_EnIDCP128			(UL(0x1) << 21)
#define HCRX_GCSEn			(UL(0x1) << 22)
#define HCRX_EnFPM			(UL(0x1) << 23)
#define HCRX_PACMEn			(UL(0x1) << 24)
/* Bit 25 is reserved */
#define HCRX_SRMASKEn			(UL(0x1) << 26)

/* HDFGRTR2_EL2 */
#define	HDFGRTR2_EL2_REG		MRS_REG_ALT_NAME(HDFGRTR2_EL2)
#define	HDFGRTR2_EL2_op0		3
#define	HDFGRTR2_EL2_op1		4
#define	HDFGRTR2_EL2_CRn		3
#define	HDFGRTR2_EL2_CRm		1
#define	HDFGRTR2_EL2_op2		0
#define	HDFGRTR2_EL2_nMDSTEPOP_EL1_SHIFT 23
#define	HDFGRTR2_EL2_nMDSTEPOP_EL1_MASK	(UL(0x1) << HDFGRTR2_EL2_nMDSTEPOP_EL1_SHIFT)
#define	HDFGRTR2_EL2_nMDSTEPOP_EL1_VAL(x) ((x) & HDFGRTR2_EL2_nMDSTEPOP_EL1_MASK)
#define	 HDFGRTR2_EL2_nMDSTEPOP_EL1_TRAP (UL(0x0) << HDFGRTR2_EL2_nMDSTEPOP_EL1_SHIFT)
#define	 HDFGRTR2_EL2_nMDSTEPOP_EL1_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nMDSTEPOP_EL1_SHIFT)
#define	HDFGRTR2_EL2_nTRBMPAM_EL1_SHIFT	22
#define	HDFGRTR2_EL2_nTRBMPAM_EL1_MASK	(UL(0x1) << HDFGRTR2_EL2_nTRBMPAM_EL1_SHIFT)
#define	HDFGRTR2_EL2_nTRBMPAM_EL1_VAL(x) ((x) & HDFGRTR2_EL2_nTRBMPAM_EL1_MASK)
#define	 HDFGRTR2_EL2_nTRBMPAM_EL1_TRAP	(UL(0x0) << HDFGRTR2_EL2_nTRBMPAM_EL1_SHIFT)
#define	 HDFGRTR2_EL2_nTRBMPAM_EL1_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nTRBMPAM_EL1_SHIFT)
#define	HDFGRTR2_EL2_nTRCITECR_EL1_SHIFT 20
#define	HDFGRTR2_EL2_nTRCITECR_EL1_MASK	(UL(0x1) << HDFGRTR2_EL2_nTRCITECR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nTRCITECR_EL1_VAL(x) ((x) & HDFGRTR2_EL2_nTRCITECR_EL1_MASK)
#define	 HDFGRTR2_EL2_nTRCITECR_EL1_TRAP (UL(0x0) << HDFGRTR2_EL2_nTRCITECR_EL1_SHIFT)
#define	 HDFGRTR2_EL2_nTRCITECR_EL1_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nTRCITECR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nPMSDSFR_EL1_SHIFT	19
#define	HDFGRTR2_EL2_nPMSDSFR_EL1_MASK	(UL(0x1) << HDFGRTR2_EL2_nPMSDSFR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nPMSDSFR_EL1_VAL(x) ((x) & HDFGRTR2_EL2_nPMSDSFR_EL1_MASK)
#define	 HDFGRTR2_EL2_nPMSDSFR_EL1_TRAP	(UL(0x0) << HDFGRTR2_EL2_nPMSDSFR_EL1_SHIFT)
#define	 HDFGRTR2_EL2_nPMSDSFR_EL1_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nPMSDSFR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nSPMDEVAFF_EL1_SHIFT 18
#define	HDFGRTR2_EL2_nSPMDEVAFF_EL1_MASK (UL(0x1) << HDFGRTR2_EL2_nSPMDEVAFF_EL1_SHIFT)
#define	HDFGRTR2_EL2_nSPMDEVAFF_EL1_VAL(x) ((x) & HDFGRTR2_EL2_nSPMDEVAFF_EL1_MASK)
#define	 HDFGRTR2_EL2_nSPMDEVAFF_EL1_TRAP (UL(0x0) << HDFGRTR2_EL2_nSPMDEVAFF_EL1_SHIFT)
#define	 HDFGRTR2_EL2_nSPMDEVAFF_EL1_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nSPMDEVAFF_EL1_SHIFT)
#define	HDFGRTR2_EL2_nSPMID_SHIFT	17
#define	HDFGRTR2_EL2_nSPMID_MASK	(UL(0x1) << HDFGRTR2_EL2_nSPMID_SHIFT)
#define	HDFGRTR2_EL2_nSPMID_VAL(x)	((x) & HDFGRTR2_EL2_nSPMID_MASK)
#define	 HDFGRTR2_EL2_nSPMID_TRAP	(UL(0x0) << HDFGRTR2_EL2_nSPMID_SHIFT)
#define	 HDFGRTR2_EL2_nSPMID_NOTRAP	(UL(0x1) << HDFGRTR2_EL2_nSPMID_SHIFT)
#define	HDFGRTR2_EL2_nSPMSCR_EL1_SHIFT	16
#define	HDFGRTR2_EL2_nSPMSCR_EL1_MASK	(UL(0x1) << HDFGRTR2_EL2_nSPMSCR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nSPMSCR_EL1_VAL(x)	((x) & HDFGRTR2_EL2_nSPMSCR_EL1_MASK)
#define	 HDFGRTR2_EL2_nSPMSCR_EL1_TRAP	(UL(0x0) << HDFGRTR2_EL2_nSPMSCR_EL1_SHIFT)
#define	 HDFGRTR2_EL2_nSPMSCR_EL1_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nSPMSCR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nSPMACCESSR_EL1_SHIFT 15
#define	HDFGRTR2_EL2_nSPMACCESSR_EL1_MASK (UL(0x1) << HDFGRTR2_EL2_nSPMACCESSR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nSPMACCESSR_EL1_VAL(x) ((x) & HDFGRTR2_EL2_nSPMACCESSR_EL1_MASK)
#define	 HDFGRTR2_EL2_nSPMACCESSR_EL1_TRAP (UL(0x0) << HDFGRTR2_EL2_nSPMACCESSR_EL1_SHIFT)
#define	 HDFGRTR2_EL2_nSPMACCESSR_EL1_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nSPMACCESSR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nSPMCR_EL0_SHIFT	14
#define	HDFGRTR2_EL2_nSPMCR_EL0_MASK	(UL(0x1) << HDFGRTR2_EL2_nSPMCR_EL0_SHIFT)
#define	HDFGRTR2_EL2_nSPMCR_EL0_VAL(x)	((x) & HDFGRTR2_EL2_nSPMCR_EL0_MASK)
#define	 HDFGRTR2_EL2_nSPMCR_EL0_TRAP	(UL(0x0) << HDFGRTR2_EL2_nSPMCR_EL0_SHIFT)
#define	 HDFGRTR2_EL2_nSPMCR_EL0_NOTRAP	(UL(0x1) << HDFGRTR2_EL2_nSPMCR_EL0_SHIFT)
#define	HDFGRTR2_EL2_nSPMOVS_SHIFT	13
#define	HDFGRTR2_EL2_nSPMOVS_MASK	(UL(0x1) << HDFGRTR2_EL2_nSPMOVS_SHIFT)
#define	HDFGRTR2_EL2_nSPMOVS_VAL(x)	((x) & HDFGRTR2_EL2_nSPMOVS_MASK)
#define	 HDFGRTR2_EL2_nSPMOVS_TRAP	(UL(0x0) << HDFGRTR2_EL2_nSPMOVS_SHIFT)
#define	 HDFGRTR2_EL2_nSPMOVS_NOTRAP	(UL(0x1) << HDFGRTR2_EL2_nSPMOVS_SHIFT)
#define	HDFGRTR2_EL2_nSPMINTEN_SHIFT	12
#define	HDFGRTR2_EL2_nSPMINTEN_MASK	(UL(0x1) << HDFGRTR2_EL2_nSPMINTEN_SHIFT)
#define	HDFGRTR2_EL2_nSPMINTEN_VAL(x)	((x) & HDFGRTR2_EL2_nSPMINTEN_MASK)
#define	 HDFGRTR2_EL2_nSPMINTEN_TRAP	(UL(0x0) << HDFGRTR2_EL2_nSPMINTEN_SHIFT)
#define	 HDFGRTR2_EL2_nSPMINTEN_NOTRAP	(UL(0x1) << HDFGRTR2_EL2_nSPMINTEN_SHIFT)
#define	HDFGRTR2_EL2_nSPMCNTEN_SHIFT	11
#define	HDFGRTR2_EL2_nSPMCNTEN_MASK	(UL(0x1) << HDFGRTR2_EL2_nSPMCNTEN_SHIFT)
#define	HDFGRTR2_EL2_nSPMCNTEN_VAL(x)	((x) & HDFGRTR2_EL2_nSPMCNTEN_MASK)
#define	 HDFGRTR2_EL2_nSPMCNTEN_TRAP	(UL(0x0) << HDFGRTR2_EL2_nSPMCNTEN_SHIFT)
#define	 HDFGRTR2_EL2_nSPMCNTEN_NOTRAP	(UL(0x1) << HDFGRTR2_EL2_nSPMCNTEN_SHIFT)
#define	HDFGRTR2_EL2_nSPMSELR_EL0_SHIFT	10
#define	HDFGRTR2_EL2_nSPMSELR_EL0_MASK	(UL(0x1) << HDFGRTR2_EL2_nSPMSELR_EL0_SHIFT)
#define	HDFGRTR2_EL2_nSPMSELR_EL0_VAL(x) ((x) & HDFGRTR2_EL2_nSPMSELR_EL0_MASK)
#define	 HDFGRTR2_EL2_nSPMSELR_EL0_TRAP	(UL(0x0) << HDFGRTR2_EL2_nSPMSELR_EL0_SHIFT)
#define	 HDFGRTR2_EL2_nSPMSELR_EL0_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nSPMSELR_EL0_SHIFT)
#define	HDFGRTR2_EL2_nSPMEVTYPERn_EL0_SHIFT 9
#define	HDFGRTR2_EL2_nSPMEVTYPERn_EL0_MASK (UL(0x1) << HDFGRTR2_EL2_nSPMEVTYPERn_EL0_SHIFT)
#define	HDFGRTR2_EL2_nSPMEVTYPERn_EL0_VAL(x) ((x) & HDFGRTR2_EL2_nSPMEVTYPERn_EL0_MASK)
#define	 HDFGRTR2_EL2_nSPMEVTYPERn_EL0_TRAP (UL(0x0) << HDFGRTR2_EL2_nSPMEVTYPERn_EL0_SHIFT)
#define	 HDFGRTR2_EL2_nSPMEVTYPERn_EL0_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nSPMEVTYPERn_EL0_SHIFT)
#define	HDFGRTR2_EL2_nSPMEVCNTRn_EL0_SHIFT 8
#define	HDFGRTR2_EL2_nSPMEVCNTRn_EL0_MASK (UL(0x1) << HDFGRTR2_EL2_nSPMEVCNTRn_EL0_SHIFT)
#define	HDFGRTR2_EL2_nSPMEVCNTRn_EL0_VAL(x) ((x) & HDFGRTR2_EL2_nSPMEVCNTRn_EL0_MASK)
#define	 HDFGRTR2_EL2_nSPMEVCNTRn_EL0_TRAP (UL(0x0) << HDFGRTR2_EL2_nSPMEVCNTRn_EL0_SHIFT)
#define	 HDFGRTR2_EL2_nSPMEVCNTRn_EL0_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nSPMEVCNTRn_EL0_SHIFT)
#define	HDFGRTR2_EL2_nPMSSCR_EL1_SHIFT	7
#define	HDFGRTR2_EL2_nPMSSCR_EL1_MASK	(UL(0x1) << HDFGRTR2_EL2_nPMSSCR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nPMSSCR_EL1_VAL(x)	((x) & HDFGRTR2_EL2_nPMSSCR_EL1_MASK)
#define	 HDFGRTR2_EL2_nPMSSCR_EL1_TRAP	(UL(0x0) << HDFGRTR2_EL2_nPMSSCR_EL1_SHIFT)
#define	 HDFGRTR2_EL2_nPMSSCR_EL1_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nPMSSCR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nPMSSDATA_SHIFT	6
#define	HDFGRTR2_EL2_nPMSSDATA_MASK	(UL(0x1) << HDFGRTR2_EL2_nPMSSDATA_SHIFT)
#define	HDFGRTR2_EL2_nPMSSDATA_VAL(x)	((x) & HDFGRTR2_EL2_nPMSSDATA_MASK)
#define	 HDFGRTR2_EL2_nPMSSDATA_TRAP	(UL(0x0) << HDFGRTR2_EL2_nPMSSDATA_SHIFT)
#define	 HDFGRTR2_EL2_nPMSSDATA_NOTRAP	(UL(0x1) << HDFGRTR2_EL2_nPMSSDATA_SHIFT)
#define	HDFGRTR2_EL2_nMDSELR_EL1_SHIFT	5
#define	HDFGRTR2_EL2_nMDSELR_EL1_MASK	(UL(0x1) << HDFGRTR2_EL2_nMDSELR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nMDSELR_EL1_VAL(x)	((x) & HDFGRTR2_EL2_nMDSELR_EL1_MASK)
#define	 HDFGRTR2_EL2_nMDSELR_EL1_TRAP	(UL(0x0) << HDFGRTR2_EL2_nMDSELR_EL1_SHIFT)
#define	 HDFGRTR2_EL2_nMDSELR_EL1_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nMDSELR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nPMUACR_EL1_SHIFT	4
#define	HDFGRTR2_EL2_nPMUACR_EL1_MASK	(UL(0x1) << HDFGRTR2_EL2_nPMUACR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nPMUACR_EL1_VAL(x)	((x) & HDFGRTR2_EL2_nPMUACR_EL1_MASK)
#define	 HDFGRTR2_EL2_nPMUACR_EL1_TRAP	(UL(0x0) << HDFGRTR2_EL2_nPMUACR_EL1_SHIFT)
#define	 HDFGRTR2_EL2_nPMUACR_EL1_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nPMUACR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nPMICFILTR_EL0_SHIFT 3
#define	HDFGRTR2_EL2_nPMICFILTR_EL0_MASK (UL(0x1) << HDFGRTR2_EL2_nPMICFILTR_EL0_SHIFT)
#define	HDFGRTR2_EL2_nPMICFILTR_EL0_VAL(x) ((x) & HDFGRTR2_EL2_nPMICFILTR_EL0_MASK)
#define	 HDFGRTR2_EL2_nPMICFILTR_EL0_TRAP (UL(0x0) << HDFGRTR2_EL2_nPMICFILTR_EL0_SHIFT)
#define	 HDFGRTR2_EL2_nPMICFILTR_EL0_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nPMICFILTR_EL0_SHIFT)
#define	HDFGRTR2_EL2_nPMICNTR_EL0_SHIFT	2
#define	HDFGRTR2_EL2_nPMICNTR_EL0_MASK	(UL(0x1) << HDFGRTR2_EL2_nPMICNTR_EL0_SHIFT)
#define	HDFGRTR2_EL2_nPMICNTR_EL0_VAL(x) ((x) & HDFGRTR2_EL2_nPMICNTR_EL0_MASK)
#define	 HDFGRTR2_EL2_nPMICNTR_EL0_TRAP	(UL(0x0) << HDFGRTR2_EL2_nPMICNTR_EL0_SHIFT)
#define	 HDFGRTR2_EL2_nPMICNTR_EL0_NOTRAP (UL(0x1) << HDFGRTR2_EL2_nPMICNTR_EL0_SHIFT)
#define	HDFGRTR2_EL2_nPMIAR_EL1_SHIFT	1
#define	HDFGRTR2_EL2_nPMIAR_EL1_MASK	(UL(0x1) << HDFGRTR2_EL2_nPMIAR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nPMIAR_EL1_VAL(x)	((x) & HDFGRTR2_EL2_nPMIAR_EL1_MASK)
#define	 HDFGRTR2_EL2_nPMIAR_EL1_TRAP	(UL(0x0) << HDFGRTR2_EL2_nPMIAR_EL1_SHIFT)
#define	 HDFGRTR2_EL2_nPMIAR_EL1_NOTRAP	(UL(0x1) << HDFGRTR2_EL2_nPMIAR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nPMECR_EL1_SHIFT	0
#define	HDFGRTR2_EL2_nPMECR_EL1_MASK	(UL(0x1) << HDFGRTR2_EL2_nPMECR_EL1_SHIFT)
#define	HDFGRTR2_EL2_nPMECR_EL1_VAL(x)	((x) & HDFGRTR2_EL2_nPMECR_EL1_MASK)
#define	 HDFGRTR2_EL2_nPMECR_EL1_TRAP	(UL(0x0) << HDFGRTR2_EL2_nPMECR_EL1_SHIFT)
#define	 HDFGRTR2_EL2_nPMECR_EL1_NOTRAP	(UL(0x1) << HDFGRTR2_EL2_nPMECR_EL1_SHIFT)

/* HDFGRTR_EL2 */
#define	HDFGRTR_EL2_REG			MRS_REG_ALT_NAME(HDFGRTR_EL2)
#define	HDFGRTR_EL2_op0			3
#define	HDFGRTR_EL2_op1			4
#define	HDFGRTR_EL2_CRn			3
#define	HDFGRTR_EL2_CRm			1
#define	HDFGRTR_EL2_op2			4
#define	HDFGRTR_EL2_PMBIDR_EL1_SHIFT	63
#define	HDFGRTR_EL2_PMBIDR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_PMBIDR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMBIDR_EL1_VAL(x)	((x) & HDFGRTR_EL2_PMBIDR_EL1_MASK)
#define	 HDFGRTR_EL2_PMBIDR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMBIDR_EL1_SHIFT)
#define	 HDFGRTR_EL2_PMBIDR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_PMBIDR_EL1_SHIFT)
#define	HDFGRTR_EL2_nPMSNEVFR_EL1_SHIFT	62
#define	HDFGRTR_EL2_nPMSNEVFR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_nPMSNEVFR_EL1_SHIFT)
#define	HDFGRTR_EL2_nPMSNEVFR_EL1_VAL(x) ((x) & HDFGRTR_EL2_nPMSNEVFR_EL1_MASK)
#define	 HDFGRTR_EL2_nPMSNEVFR_EL1_TRAP (UL(0x0) << HDFGRTR_EL2_nPMSNEVFR_EL1_SHIFT)
#define	 HDFGRTR_EL2_nPMSNEVFR_EL1_NOTRAP (UL(0x1) << HDFGRTR_EL2_nPMSNEVFR_EL1_SHIFT)
#define	HDFGRTR_EL2_nBRBDATA_SHIFT	61
#define	HDFGRTR_EL2_nBRBDATA_MASK	(UL(0x1) << HDFGRTR_EL2_nBRBDATA_SHIFT)
#define	HDFGRTR_EL2_nBRBDATA_VAL(x)	((x) & HDFGRTR_EL2_nBRBDATA_MASK)
#define	 HDFGRTR_EL2_nBRBDATA_TRAP	(UL(0x0) << HDFGRTR_EL2_nBRBDATA_SHIFT)
#define	 HDFGRTR_EL2_nBRBDATA_NOTRAP	(UL(0x1) << HDFGRTR_EL2_nBRBDATA_SHIFT)
#define	HDFGRTR_EL2_nBRBCTL_SHIFT	60
#define	HDFGRTR_EL2_nBRBCTL_MASK	(UL(0x1) << HDFGRTR_EL2_nBRBCTL_SHIFT)
#define	HDFGRTR_EL2_nBRBCTL_VAL(x)	((x) & HDFGRTR_EL2_nBRBCTL_MASK)
#define	 HDFGRTR_EL2_nBRBCTL_TRAP	(UL(0x0) << HDFGRTR_EL2_nBRBCTL_SHIFT)
#define	 HDFGRTR_EL2_nBRBCTL_NOTRAP	(UL(0x1) << HDFGRTR_EL2_nBRBCTL_SHIFT)
#define	HDFGRTR_EL2_nBRBIDR_SHIFT	59
#define	HDFGRTR_EL2_nBRBIDR_MASK	(UL(0x1) << HDFGRTR_EL2_nBRBIDR_SHIFT)
#define	HDFGRTR_EL2_nBRBIDR_VAL(x)	((x) & HDFGRTR_EL2_nBRBIDR_MASK)
#define	 HDFGRTR_EL2_nBRBIDR_TRAP	(UL(0x0) << HDFGRTR_EL2_nBRBIDR_SHIFT)
#define	 HDFGRTR_EL2_nBRBIDR_NOTRAP	(UL(0x1) << HDFGRTR_EL2_nBRBIDR_SHIFT)
#define	HDFGRTR_EL2_PMCEIDn_EL0_SHIFT	58
#define	HDFGRTR_EL2_PMCEIDn_EL0_MASK	(UL(0x1) << HDFGRTR_EL2_PMCEIDn_EL0_SHIFT)
#define	HDFGRTR_EL2_PMCEIDn_EL0_VAL(x)	((x) & HDFGRTR_EL2_PMCEIDn_EL0_MASK)
#define	 HDFGRTR_EL2_PMCEIDn_EL0_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMCEIDn_EL0_SHIFT)
#define	 HDFGRTR_EL2_PMCEIDn_EL0_TRAP	(UL(0x1) << HDFGRTR_EL2_PMCEIDn_EL0_SHIFT)
#define	HDFGRTR_EL2_PMUSERENR_EL0_SHIFT	57
#define	HDFGRTR_EL2_PMUSERENR_EL0_MASK	(UL(0x1) << HDFGRTR_EL2_PMUSERENR_EL0_SHIFT)
#define	HDFGRTR_EL2_PMUSERENR_EL0_VAL(x) ((x) & HDFGRTR_EL2_PMUSERENR_EL0_MASK)
#define	 HDFGRTR_EL2_PMUSERENR_EL0_NOTRAP (UL(0x0) << HDFGRTR_EL2_PMUSERENR_EL0_SHIFT)
#define	 HDFGRTR_EL2_PMUSERENR_EL0_TRAP	(UL(0x1) << HDFGRTR_EL2_PMUSERENR_EL0_SHIFT)
#define	HDFGRTR_EL2_TRBTRG_EL1_SHIFT	56
#define	HDFGRTR_EL2_TRBTRG_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_TRBTRG_EL1_SHIFT)
#define	HDFGRTR_EL2_TRBTRG_EL1_VAL(x)	((x) & HDFGRTR_EL2_TRBTRG_EL1_MASK)
#define	 HDFGRTR_EL2_TRBTRG_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRBTRG_EL1_SHIFT)
#define	 HDFGRTR_EL2_TRBTRG_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_TRBTRG_EL1_SHIFT)
#define	HDFGRTR_EL2_TRBSR_EL1_SHIFT	55
#define	HDFGRTR_EL2_TRBSR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_TRBSR_EL1_SHIFT)
#define	HDFGRTR_EL2_TRBSR_EL1_VAL(x)	((x) & HDFGRTR_EL2_TRBSR_EL1_MASK)
#define	 HDFGRTR_EL2_TRBSR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRBSR_EL1_SHIFT)
#define	 HDFGRTR_EL2_TRBSR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_TRBSR_EL1_SHIFT)
#define	HDFGRTR_EL2_TRBPTR_EL1_SHIFT	54
#define	HDFGRTR_EL2_TRBPTR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_TRBPTR_EL1_SHIFT)
#define	HDFGRTR_EL2_TRBPTR_EL1_VAL(x)	((x) & HDFGRTR_EL2_TRBPTR_EL1_MASK)
#define	 HDFGRTR_EL2_TRBPTR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRBPTR_EL1_SHIFT)
#define	 HDFGRTR_EL2_TRBPTR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_TRBPTR_EL1_SHIFT)
#define	HDFGRTR_EL2_TRBMAR_EL1_SHIFT	53
#define	HDFGRTR_EL2_TRBMAR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_TRBMAR_EL1_SHIFT)
#define	HDFGRTR_EL2_TRBMAR_EL1_VAL(x)	((x) & HDFGRTR_EL2_TRBMAR_EL1_MASK)
#define	 HDFGRTR_EL2_TRBMAR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRBMAR_EL1_SHIFT)
#define	 HDFGRTR_EL2_TRBMAR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_TRBMAR_EL1_SHIFT)
#define	HDFGRTR_EL2_TRBLIMITR_EL1_SHIFT	52
#define	HDFGRTR_EL2_TRBLIMITR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_TRBLIMITR_EL1_SHIFT)
#define	HDFGRTR_EL2_TRBLIMITR_EL1_VAL(x) ((x) & HDFGRTR_EL2_TRBLIMITR_EL1_MASK)
#define	 HDFGRTR_EL2_TRBLIMITR_EL1_NOTRAP (UL(0x0) << HDFGRTR_EL2_TRBLIMITR_EL1_SHIFT)
#define	 HDFGRTR_EL2_TRBLIMITR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_TRBLIMITR_EL1_SHIFT)
#define	HDFGRTR_EL2_TRBIDR_EL1_SHIFT	51
#define	HDFGRTR_EL2_TRBIDR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_TRBIDR_EL1_SHIFT)
#define	HDFGRTR_EL2_TRBIDR_EL1_VAL(x)	((x) & HDFGRTR_EL2_TRBIDR_EL1_MASK)
#define	 HDFGRTR_EL2_TRBIDR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRBIDR_EL1_SHIFT)
#define	 HDFGRTR_EL2_TRBIDR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_TRBIDR_EL1_SHIFT)
#define	HDFGRTR_EL2_TRBBASER_EL1_SHIFT	50
#define	HDFGRTR_EL2_TRBBASER_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_TRBBASER_EL1_SHIFT)
#define	HDFGRTR_EL2_TRBBASER_EL1_VAL(x)	((x) & HDFGRTR_EL2_TRBBASER_EL1_MASK)
#define	 HDFGRTR_EL2_TRBBASER_EL1_NOTRAP (UL(0x0) << HDFGRTR_EL2_TRBBASER_EL1_SHIFT)
#define	 HDFGRTR_EL2_TRBBASER_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_TRBBASER_EL1_SHIFT)
#define	HDFGRTR_EL2_TRCVICTLR_SHIFT	48
#define	HDFGRTR_EL2_TRCVICTLR_MASK	(UL(0x1) << HDFGRTR_EL2_TRCVICTLR_SHIFT)
#define	HDFGRTR_EL2_TRCVICTLR_VAL(x)	((x) & HDFGRTR_EL2_TRCVICTLR_MASK)
#define	 HDFGRTR_EL2_TRCVICTLR_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRCVICTLR_SHIFT)
#define	 HDFGRTR_EL2_TRCVICTLR_TRAP	(UL(0x1) << HDFGRTR_EL2_TRCVICTLR_SHIFT)
#define	HDFGRTR_EL2_TRCSTATR_SHIFT	47
#define	HDFGRTR_EL2_TRCSTATR_MASK	(UL(0x1) << HDFGRTR_EL2_TRCSTATR_SHIFT)
#define	HDFGRTR_EL2_TRCSTATR_VAL(x)	((x) & HDFGRTR_EL2_TRCSTATR_MASK)
#define	 HDFGRTR_EL2_TRCSTATR_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRCSTATR_SHIFT)
#define	 HDFGRTR_EL2_TRCSTATR_TRAP	(UL(0x1) << HDFGRTR_EL2_TRCSTATR_SHIFT)
#define	HDFGRTR_EL2_TRCSSCSRn_SHIFT	46
#define	HDFGRTR_EL2_TRCSSCSRn_MASK	(UL(0x1) << HDFGRTR_EL2_TRCSSCSRn_SHIFT)
#define	HDFGRTR_EL2_TRCSSCSRn_VAL(x)	((x) & HDFGRTR_EL2_TRCSSCSRn_MASK)
#define	 HDFGRTR_EL2_TRCSSCSRn_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRCSSCSRn_SHIFT)
#define	 HDFGRTR_EL2_TRCSSCSRn_TRAP	(UL(0x1) << HDFGRTR_EL2_TRCSSCSRn_SHIFT)
#define	HDFGRTR_EL2_TRCSEQSTR_SHIFT	45
#define	HDFGRTR_EL2_TRCSEQSTR_MASK	(UL(0x1) << HDFGRTR_EL2_TRCSEQSTR_SHIFT)
#define	HDFGRTR_EL2_TRCSEQSTR_VAL(x)	((x) & HDFGRTR_EL2_TRCSEQSTR_MASK)
#define	 HDFGRTR_EL2_TRCSEQSTR_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRCSEQSTR_SHIFT)
#define	 HDFGRTR_EL2_TRCSEQSTR_TRAP	(UL(0x1) << HDFGRTR_EL2_TRCSEQSTR_SHIFT)
#define	HDFGRTR_EL2_TRCPRGCTLR_SHIFT	44
#define	HDFGRTR_EL2_TRCPRGCTLR_MASK	(UL(0x1) << HDFGRTR_EL2_TRCPRGCTLR_SHIFT)
#define	HDFGRTR_EL2_TRCPRGCTLR_VAL(x)	((x) & HDFGRTR_EL2_TRCPRGCTLR_MASK)
#define	 HDFGRTR_EL2_TRCPRGCTLR_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRCPRGCTLR_SHIFT)
#define	 HDFGRTR_EL2_TRCPRGCTLR_TRAP	(UL(0x1) << HDFGRTR_EL2_TRCPRGCTLR_SHIFT)
#define	HDFGRTR_EL2_TRCOSLSR_SHIFT	43
#define	HDFGRTR_EL2_TRCOSLSR_MASK	(UL(0x1) << HDFGRTR_EL2_TRCOSLSR_SHIFT)
#define	HDFGRTR_EL2_TRCOSLSR_VAL(x)	((x) & HDFGRTR_EL2_TRCOSLSR_MASK)
#define	 HDFGRTR_EL2_TRCOSLSR_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRCOSLSR_SHIFT)
#define	 HDFGRTR_EL2_TRCOSLSR_TRAP	(UL(0x1) << HDFGRTR_EL2_TRCOSLSR_SHIFT)
#define	HDFGRTR_EL2_TRCIMSPECn_SHIFT	41
#define	HDFGRTR_EL2_TRCIMSPECn_MASK	(UL(0x1) << HDFGRTR_EL2_TRCIMSPECn_SHIFT)
#define	HDFGRTR_EL2_TRCIMSPECn_VAL(x)	((x) & HDFGRTR_EL2_TRCIMSPECn_MASK)
#define	 HDFGRTR_EL2_TRCIMSPECn_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRCIMSPECn_SHIFT)
#define	 HDFGRTR_EL2_TRCIMSPECn_TRAP	(UL(0x1) << HDFGRTR_EL2_TRCIMSPECn_SHIFT)
#define	HDFGRTR_EL2_TRCID_SHIFT		40
#define	HDFGRTR_EL2_TRCID_MASK		(UL(0x1) << HDFGRTR_EL2_TRCID_SHIFT)
#define	HDFGRTR_EL2_TRCID_VAL(x)	((x) & HDFGRTR_EL2_TRCID_MASK)
#define	 HDFGRTR_EL2_TRCID_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRCID_SHIFT)
#define	 HDFGRTR_EL2_TRCID_TRAP		(UL(0x1) << HDFGRTR_EL2_TRCID_SHIFT)
#define	HDFGRTR_EL2_TRCCNTVRn_SHIFT	37
#define	HDFGRTR_EL2_TRCCNTVRn_MASK	(UL(0x1) << HDFGRTR_EL2_TRCCNTVRn_SHIFT)
#define	HDFGRTR_EL2_TRCCNTVRn_VAL(x)	((x) & HDFGRTR_EL2_TRCCNTVRn_MASK)
#define	 HDFGRTR_EL2_TRCCNTVRn_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRCCNTVRn_SHIFT)
#define	 HDFGRTR_EL2_TRCCNTVRn_TRAP	(UL(0x1) << HDFGRTR_EL2_TRCCNTVRn_SHIFT)
#define	HDFGRTR_EL2_TRCCLAIM_SHIFT	36
#define	HDFGRTR_EL2_TRCCLAIM_MASK	(UL(0x1) << HDFGRTR_EL2_TRCCLAIM_SHIFT)
#define	HDFGRTR_EL2_TRCCLAIM_VAL(x)	((x) & HDFGRTR_EL2_TRCCLAIM_MASK)
#define	 HDFGRTR_EL2_TRCCLAIM_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRCCLAIM_SHIFT)
#define	 HDFGRTR_EL2_TRCCLAIM_TRAP	(UL(0x1) << HDFGRTR_EL2_TRCCLAIM_SHIFT)
#define	HDFGRTR_EL2_TRCAUXCTLR_SHIFT	35
#define	HDFGRTR_EL2_TRCAUXCTLR_MASK	(UL(0x1) << HDFGRTR_EL2_TRCAUXCTLR_SHIFT)
#define	HDFGRTR_EL2_TRCAUXCTLR_VAL(x)	((x) & HDFGRTR_EL2_TRCAUXCTLR_MASK)
#define	 HDFGRTR_EL2_TRCAUXCTLR_NOTRAP	(UL(0x0) << HDFGRTR_EL2_TRCAUXCTLR_SHIFT)
#define	 HDFGRTR_EL2_TRCAUXCTLR_TRAP	(UL(0x1) << HDFGRTR_EL2_TRCAUXCTLR_SHIFT)
#define	HDFGRTR_EL2_TRCAUTHSTATUS_SHIFT	34
#define	HDFGRTR_EL2_TRCAUTHSTATUS_MASK	(UL(0x1) << HDFGRTR_EL2_TRCAUTHSTATUS_SHIFT)
#define	HDFGRTR_EL2_TRCAUTHSTATUS_VAL(x) ((x) & HDFGRTR_EL2_TRCAUTHSTATUS_MASK)
#define	 HDFGRTR_EL2_TRCAUTHSTATUS_NOTRAP (UL(0x0) << HDFGRTR_EL2_TRCAUTHSTATUS_SHIFT)
#define	 HDFGRTR_EL2_TRCAUTHSTATUS_TRAP	(UL(0x1) << HDFGRTR_EL2_TRCAUTHSTATUS_SHIFT)
#define	HDFGRTR_EL2_TRC_SHIFT		33
#define	HDFGRTR_EL2_TRC_MASK		(UL(0x1) << HDFGRTR_EL2_TRC_SHIFT)
#define	HDFGRTR_EL2_TRC_VAL(x)		((x) & HDFGRTR_EL2_TRC_MASK)
#define	 HDFGRTR_EL2_TRC_NOTRAP		(UL(0x0) << HDFGRTR_EL2_TRC_SHIFT)
#define	 HDFGRTR_EL2_TRC_TRAP		(UL(0x1) << HDFGRTR_EL2_TRC_SHIFT)
#define	HDFGRTR_EL2_PMSLATFR_EL1_SHIFT	32
#define	HDFGRTR_EL2_PMSLATFR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_PMSLATFR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSLATFR_EL1_VAL(x)	((x) & HDFGRTR_EL2_PMSLATFR_EL1_MASK)
#define	 HDFGRTR_EL2_PMSLATFR_EL1_NOTRAP (UL(0x0) << HDFGRTR_EL2_PMSLATFR_EL1_SHIFT)
#define	 HDFGRTR_EL2_PMSLATFR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_PMSLATFR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSIRR_EL1_SHIFT	31
#define	HDFGRTR_EL2_PMSIRR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_PMSIRR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSIRR_EL1_VAL(x)	((x) & HDFGRTR_EL2_PMSIRR_EL1_MASK)
#define	 HDFGRTR_EL2_PMSIRR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMSIRR_EL1_SHIFT)
#define	 HDFGRTR_EL2_PMSIRR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_PMSIRR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSIDR_EL1_SHIFT	30
#define	HDFGRTR_EL2_PMSIDR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_PMSIDR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSIDR_EL1_VAL(x)	((x) & HDFGRTR_EL2_PMSIDR_EL1_MASK)
#define	 HDFGRTR_EL2_PMSIDR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMSIDR_EL1_SHIFT)
#define	 HDFGRTR_EL2_PMSIDR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_PMSIDR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSICR_EL1_SHIFT	29
#define	HDFGRTR_EL2_PMSICR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_PMSICR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSICR_EL1_VAL(x)	((x) & HDFGRTR_EL2_PMSICR_EL1_MASK)
#define	 HDFGRTR_EL2_PMSICR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMSICR_EL1_SHIFT)
#define	 HDFGRTR_EL2_PMSICR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_PMSICR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSFCR_EL1_SHIFT	28
#define	HDFGRTR_EL2_PMSFCR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_PMSFCR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSFCR_EL1_VAL(x)	((x) & HDFGRTR_EL2_PMSFCR_EL1_MASK)
#define	 HDFGRTR_EL2_PMSFCR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMSFCR_EL1_SHIFT)
#define	 HDFGRTR_EL2_PMSFCR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_PMSFCR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSEVFR_EL1_SHIFT	27
#define	HDFGRTR_EL2_PMSEVFR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_PMSEVFR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSEVFR_EL1_VAL(x)	((x) & HDFGRTR_EL2_PMSEVFR_EL1_MASK)
#define	 HDFGRTR_EL2_PMSEVFR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMSEVFR_EL1_SHIFT)
#define	 HDFGRTR_EL2_PMSEVFR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_PMSEVFR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSCR_EL1_SHIFT	26
#define	HDFGRTR_EL2_PMSCR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_PMSCR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSCR_EL1_VAL(x)	((x) & HDFGRTR_EL2_PMSCR_EL1_MASK)
#define	 HDFGRTR_EL2_PMSCR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMSCR_EL1_SHIFT)
#define	 HDFGRTR_EL2_PMSCR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_PMSCR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMBSR_EL1_SHIFT	25
#define	HDFGRTR_EL2_PMBSR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_PMBSR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMBSR_EL1_VAL(x)	((x) & HDFGRTR_EL2_PMBSR_EL1_MASK)
#define	 HDFGRTR_EL2_PMBSR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMBSR_EL1_SHIFT)
#define	 HDFGRTR_EL2_PMBSR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_PMBSR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMBPTR_EL1_SHIFT	24
#define	HDFGRTR_EL2_PMBPTR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_PMBPTR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMBPTR_EL1_VAL(x)	((x) & HDFGRTR_EL2_PMBPTR_EL1_MASK)
#define	 HDFGRTR_EL2_PMBPTR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMBPTR_EL1_SHIFT)
#define	 HDFGRTR_EL2_PMBPTR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_PMBPTR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMBLIMITR_EL1_SHIFT	23
#define	HDFGRTR_EL2_PMBLIMITR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_PMBLIMITR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMBLIMITR_EL1_VAL(x) ((x) & HDFGRTR_EL2_PMBLIMITR_EL1_MASK)
#define	 HDFGRTR_EL2_PMBLIMITR_EL1_NOTRAP (UL(0x0) << HDFGRTR_EL2_PMBLIMITR_EL1_SHIFT)
#define	 HDFGRTR_EL2_PMBLIMITR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_PMBLIMITR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMMIR_EL1_SHIFT	22
#define	HDFGRTR_EL2_PMMIR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_PMMIR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMMIR_EL1_VAL(x)	((x) & HDFGRTR_EL2_PMMIR_EL1_MASK)
#define	 HDFGRTR_EL2_PMMIR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMMIR_EL1_SHIFT)
#define	 HDFGRTR_EL2_PMMIR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_PMMIR_EL1_SHIFT)
#define	HDFGRTR_EL2_PMSELR_EL0_SHIFT	19
#define	HDFGRTR_EL2_PMSELR_EL0_MASK	(UL(0x1) << HDFGRTR_EL2_PMSELR_EL0_SHIFT)
#define	HDFGRTR_EL2_PMSELR_EL0_VAL(x)	((x) & HDFGRTR_EL2_PMSELR_EL0_MASK)
#define	 HDFGRTR_EL2_PMSELR_EL0_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMSELR_EL0_SHIFT)
#define	 HDFGRTR_EL2_PMSELR_EL0_TRAP	(UL(0x1) << HDFGRTR_EL2_PMSELR_EL0_SHIFT)
#define	HDFGRTR_EL2_PMOVS_SHIFT		18
#define	HDFGRTR_EL2_PMOVS_MASK		(UL(0x1) << HDFGRTR_EL2_PMOVS_SHIFT)
#define	HDFGRTR_EL2_PMOVS_VAL(x)	((x) & HDFGRTR_EL2_PMOVS_MASK)
#define	 HDFGRTR_EL2_PMOVS_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMOVS_SHIFT)
#define	 HDFGRTR_EL2_PMOVS_TRAP		(UL(0x1) << HDFGRTR_EL2_PMOVS_SHIFT)
#define	HDFGRTR_EL2_PMINTEN_SHIFT	17
#define	HDFGRTR_EL2_PMINTEN_MASK	(UL(0x1) << HDFGRTR_EL2_PMINTEN_SHIFT)
#define	HDFGRTR_EL2_PMINTEN_VAL(x)	((x) & HDFGRTR_EL2_PMINTEN_MASK)
#define	 HDFGRTR_EL2_PMINTEN_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMINTEN_SHIFT)
#define	 HDFGRTR_EL2_PMINTEN_TRAP	(UL(0x1) << HDFGRTR_EL2_PMINTEN_SHIFT)
#define	HDFGRTR_EL2_PMCNTEN_SHIFT	16
#define	HDFGRTR_EL2_PMCNTEN_MASK	(UL(0x1) << HDFGRTR_EL2_PMCNTEN_SHIFT)
#define	HDFGRTR_EL2_PMCNTEN_VAL(x)	((x) & HDFGRTR_EL2_PMCNTEN_MASK)
#define	 HDFGRTR_EL2_PMCNTEN_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMCNTEN_SHIFT)
#define	 HDFGRTR_EL2_PMCNTEN_TRAP	(UL(0x1) << HDFGRTR_EL2_PMCNTEN_SHIFT)
#define	HDFGRTR_EL2_PMCCNTR_EL0_SHIFT	15
#define	HDFGRTR_EL2_PMCCNTR_EL0_MASK	(UL(0x1) << HDFGRTR_EL2_PMCCNTR_EL0_SHIFT)
#define	HDFGRTR_EL2_PMCCNTR_EL0_VAL(x)	((x) & HDFGRTR_EL2_PMCCNTR_EL0_MASK)
#define	 HDFGRTR_EL2_PMCCNTR_EL0_NOTRAP	(UL(0x0) << HDFGRTR_EL2_PMCCNTR_EL0_SHIFT)
#define	 HDFGRTR_EL2_PMCCNTR_EL0_TRAP	(UL(0x1) << HDFGRTR_EL2_PMCCNTR_EL0_SHIFT)
#define	HDFGRTR_EL2_PMCCFILTR_EL0_SHIFT	14
#define	HDFGRTR_EL2_PMCCFILTR_EL0_MASK	(UL(0x1) << HDFGRTR_EL2_PMCCFILTR_EL0_SHIFT)
#define	HDFGRTR_EL2_PMCCFILTR_EL0_VAL(x) ((x) & HDFGRTR_EL2_PMCCFILTR_EL0_MASK)
#define	 HDFGRTR_EL2_PMCCFILTR_EL0_NOTRAP (UL(0x0) << HDFGRTR_EL2_PMCCFILTR_EL0_SHIFT)
#define	 HDFGRTR_EL2_PMCCFILTR_EL0_TRAP	(UL(0x1) << HDFGRTR_EL2_PMCCFILTR_EL0_SHIFT)
#define	HDFGRTR_EL2_PMEVTYPERn_EL0_SHIFT 13
#define	HDFGRTR_EL2_PMEVTYPERn_EL0_MASK	(UL(0x1) << HDFGRTR_EL2_PMEVTYPERn_EL0_SHIFT)
#define	HDFGRTR_EL2_PMEVTYPERn_EL0_VAL(x) ((x) & HDFGRTR_EL2_PMEVTYPERn_EL0_MASK)
#define	 HDFGRTR_EL2_PMEVTYPERn_EL0_NOTRAP (UL(0x0) << HDFGRTR_EL2_PMEVTYPERn_EL0_SHIFT)
#define	 HDFGRTR_EL2_PMEVTYPERn_EL0_TRAP (UL(0x1) << HDFGRTR_EL2_PMEVTYPERn_EL0_SHIFT)
#define	HDFGRTR_EL2_PMEVCNTRn_EL0_SHIFT	12
#define	HDFGRTR_EL2_PMEVCNTRn_EL0_MASK	(UL(0x1) << HDFGRTR_EL2_PMEVCNTRn_EL0_SHIFT)
#define	HDFGRTR_EL2_PMEVCNTRn_EL0_VAL(x) ((x) & HDFGRTR_EL2_PMEVCNTRn_EL0_MASK)
#define	 HDFGRTR_EL2_PMEVCNTRn_EL0_NOTRAP (UL(0x0) << HDFGRTR_EL2_PMEVCNTRn_EL0_SHIFT)
#define	 HDFGRTR_EL2_PMEVCNTRn_EL0_TRAP	(UL(0x1) << HDFGRTR_EL2_PMEVCNTRn_EL0_SHIFT)
#define	HDFGRTR_EL2_OSDLR_EL1_SHIFT	11
#define	HDFGRTR_EL2_OSDLR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_OSDLR_EL1_SHIFT)
#define	HDFGRTR_EL2_OSDLR_EL1_VAL(x)	((x) & HDFGRTR_EL2_OSDLR_EL1_MASK)
#define	 HDFGRTR_EL2_OSDLR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_OSDLR_EL1_SHIFT)
#define	 HDFGRTR_EL2_OSDLR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_OSDLR_EL1_SHIFT)
#define	HDFGRTR_EL2_OSECCR_EL1_SHIFT	10
#define	HDFGRTR_EL2_OSECCR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_OSECCR_EL1_SHIFT)
#define	HDFGRTR_EL2_OSECCR_EL1_VAL(x)	((x) & HDFGRTR_EL2_OSECCR_EL1_MASK)
#define	 HDFGRTR_EL2_OSECCR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_OSECCR_EL1_SHIFT)
#define	 HDFGRTR_EL2_OSECCR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_OSECCR_EL1_SHIFT)
#define	HDFGRTR_EL2_OSLSR_EL1_SHIFT	9
#define	HDFGRTR_EL2_OSLSR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_OSLSR_EL1_SHIFT)
#define	HDFGRTR_EL2_OSLSR_EL1_VAL(x)	((x) & HDFGRTR_EL2_OSLSR_EL1_MASK)
#define	 HDFGRTR_EL2_OSLSR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_OSLSR_EL1_SHIFT)
#define	 HDFGRTR_EL2_OSLSR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_OSLSR_EL1_SHIFT)
#define	HDFGRTR_EL2_DBGPRCR_EL1_SHIFT	7
#define	HDFGRTR_EL2_DBGPRCR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_DBGPRCR_EL1_SHIFT)
#define	HDFGRTR_EL2_DBGPRCR_EL1_VAL(x)	((x) & HDFGRTR_EL2_DBGPRCR_EL1_MASK)
#define	 HDFGRTR_EL2_DBGPRCR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_DBGPRCR_EL1_SHIFT)
#define	 HDFGRTR_EL2_DBGPRCR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_DBGPRCR_EL1_SHIFT)
#define	HDFGRTR_EL2_DBGAUTHSTATUS_EL1_SHIFT 6
#define	HDFGRTR_EL2_DBGAUTHSTATUS_EL1_MASK (UL(0x1) << HDFGRTR_EL2_DBGAUTHSTATUS_EL1_SHIFT)
#define	HDFGRTR_EL2_DBGAUTHSTATUS_EL1_VAL(x) ((x) & HDFGRTR_EL2_DBGAUTHSTATUS_EL1_MASK)
#define	 HDFGRTR_EL2_DBGAUTHSTATUS_EL1_NOTRAP (UL(0x0) << HDFGRTR_EL2_DBGAUTHSTATUS_EL1_SHIFT)
#define	 HDFGRTR_EL2_DBGAUTHSTATUS_EL1_TRAP (UL(0x1) << HDFGRTR_EL2_DBGAUTHSTATUS_EL1_SHIFT)
#define	HDFGRTR_EL2_DBGCLAIM_SHIFT	5
#define	HDFGRTR_EL2_DBGCLAIM_MASK	(UL(0x1) << HDFGRTR_EL2_DBGCLAIM_SHIFT)
#define	HDFGRTR_EL2_DBGCLAIM_VAL(x)	((x) & HDFGRTR_EL2_DBGCLAIM_MASK)
#define	 HDFGRTR_EL2_DBGCLAIM_NOTRAP	(UL(0x0) << HDFGRTR_EL2_DBGCLAIM_SHIFT)
#define	 HDFGRTR_EL2_DBGCLAIM_TRAP	(UL(0x1) << HDFGRTR_EL2_DBGCLAIM_SHIFT)
#define	HDFGRTR_EL2_MDSCR_EL1_SHIFT	4
#define	HDFGRTR_EL2_MDSCR_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_MDSCR_EL1_SHIFT)
#define	HDFGRTR_EL2_MDSCR_EL1_VAL(x)	((x) & HDFGRTR_EL2_MDSCR_EL1_MASK)
#define	 HDFGRTR_EL2_MDSCR_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_MDSCR_EL1_SHIFT)
#define	 HDFGRTR_EL2_MDSCR_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_MDSCR_EL1_SHIFT)
#define	HDFGRTR_EL2_DBGWVRn_EL1_SHIFT	3
#define	HDFGRTR_EL2_DBGWVRn_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_DBGWVRn_EL1_SHIFT)
#define	HDFGRTR_EL2_DBGWVRn_EL1_VAL(x)	((x) & HDFGRTR_EL2_DBGWVRn_EL1_MASK)
#define	 HDFGRTR_EL2_DBGWVRn_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_DBGWVRn_EL1_SHIFT)
#define	 HDFGRTR_EL2_DBGWVRn_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_DBGWVRn_EL1_SHIFT)
#define	HDFGRTR_EL2_DBGWCRn_EL1_SHIFT	2
#define	HDFGRTR_EL2_DBGWCRn_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_DBGWCRn_EL1_SHIFT)
#define	HDFGRTR_EL2_DBGWCRn_EL1_VAL(x)	((x) & HDFGRTR_EL2_DBGWCRn_EL1_MASK)
#define	 HDFGRTR_EL2_DBGWCRn_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_DBGWCRn_EL1_SHIFT)
#define	 HDFGRTR_EL2_DBGWCRn_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_DBGWCRn_EL1_SHIFT)
#define	HDFGRTR_EL2_DBGBVRn_EL1_SHIFT	1
#define	HDFGRTR_EL2_DBGBVRn_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_DBGBVRn_EL1_SHIFT)
#define	HDFGRTR_EL2_DBGBVRn_EL1_VAL(x)	((x) & HDFGRTR_EL2_DBGBVRn_EL1_MASK)
#define	 HDFGRTR_EL2_DBGBVRn_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_DBGBVRn_EL1_SHIFT)
#define	 HDFGRTR_EL2_DBGBVRn_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_DBGBVRn_EL1_SHIFT)
#define	HDFGRTR_EL2_DBGBCRn_EL1_SHIFT	0
#define	HDFGRTR_EL2_DBGBCRn_EL1_MASK	(UL(0x1) << HDFGRTR_EL2_DBGBCRn_EL1_SHIFT)
#define	HDFGRTR_EL2_DBGBCRn_EL1_VAL(x)	((x) & HDFGRTR_EL2_DBGBCRn_EL1_MASK)
#define	 HDFGRTR_EL2_DBGBCRn_EL1_NOTRAP	(UL(0x0) << HDFGRTR_EL2_DBGBCRn_EL1_SHIFT)
#define	 HDFGRTR_EL2_DBGBCRn_EL1_TRAP	(UL(0x1) << HDFGRTR_EL2_DBGBCRn_EL1_SHIFT)

/* HDFGWTR2_EL2 */
#define	HDFGWTR2_EL2_REG		MRS_REG_ALT_NAME(HDFGWTR2_EL2)
#define	HDFGWTR2_EL2_op0		3
#define	HDFGWTR2_EL2_op1		4
#define	HDFGWTR2_EL2_CRn		3
#define	HDFGWTR2_EL2_CRm		1
#define	HDFGWTR2_EL2_op2		1
#define	HDFGWTR2_EL2_nMDSTEPOP_EL1_SHIFT 23
#define	HDFGWTR2_EL2_nMDSTEPOP_EL1_MASK	(UL(0x1) << HDFGWTR2_EL2_nMDSTEPOP_EL1_SHIFT)
#define	HDFGWTR2_EL2_nMDSTEPOP_EL1_VAL(x) ((x) & HDFGWTR2_EL2_nMDSTEPOP_EL1_MASK)
#define	 HDFGWTR2_EL2_nMDSTEPOP_EL1_TRAP (UL(0x0) << HDFGWTR2_EL2_nMDSTEPOP_EL1_SHIFT)
#define	 HDFGWTR2_EL2_nMDSTEPOP_EL1_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nMDSTEPOP_EL1_SHIFT)
#define	HDFGWTR2_EL2_nTRBMPAM_EL1_SHIFT	22
#define	HDFGWTR2_EL2_nTRBMPAM_EL1_MASK	(UL(0x1) << HDFGWTR2_EL2_nTRBMPAM_EL1_SHIFT)
#define	HDFGWTR2_EL2_nTRBMPAM_EL1_VAL(x) ((x) & HDFGWTR2_EL2_nTRBMPAM_EL1_MASK)
#define	 HDFGWTR2_EL2_nTRBMPAM_EL1_TRAP	(UL(0x0) << HDFGWTR2_EL2_nTRBMPAM_EL1_SHIFT)
#define	 HDFGWTR2_EL2_nTRBMPAM_EL1_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nTRBMPAM_EL1_SHIFT)
#define	HDFGWTR2_EL2_nPMZR_EL0_SHIFT	21
#define	HDFGWTR2_EL2_nPMZR_EL0_MASK	(UL(0x1) << HDFGWTR2_EL2_nPMZR_EL0_SHIFT)
#define	HDFGWTR2_EL2_nPMZR_EL0_VAL(x)	((x) & HDFGWTR2_EL2_nPMZR_EL0_MASK)
#define	 HDFGWTR2_EL2_nPMZR_EL0_TRAP	(UL(0x0) << HDFGWTR2_EL2_nPMZR_EL0_SHIFT)
#define	 HDFGWTR2_EL2_nPMZR_EL0_NOTRAP	(UL(0x1) << HDFGWTR2_EL2_nPMZR_EL0_SHIFT)
#define	HDFGWTR2_EL2_nTRCITECR_EL1_SHIFT 20
#define	HDFGWTR2_EL2_nTRCITECR_EL1_MASK	(UL(0x1) << HDFGWTR2_EL2_nTRCITECR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nTRCITECR_EL1_VAL(x) ((x) & HDFGWTR2_EL2_nTRCITECR_EL1_MASK)
#define	 HDFGWTR2_EL2_nTRCITECR_EL1_TRAP (UL(0x0) << HDFGWTR2_EL2_nTRCITECR_EL1_SHIFT)
#define	 HDFGWTR2_EL2_nTRCITECR_EL1_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nTRCITECR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nPMSDSFR_EL1_SHIFT	19
#define	HDFGWTR2_EL2_nPMSDSFR_EL1_MASK	(UL(0x1) << HDFGWTR2_EL2_nPMSDSFR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nPMSDSFR_EL1_VAL(x) ((x) & HDFGWTR2_EL2_nPMSDSFR_EL1_MASK)
#define	 HDFGWTR2_EL2_nPMSDSFR_EL1_TRAP	(UL(0x0) << HDFGWTR2_EL2_nPMSDSFR_EL1_SHIFT)
#define	 HDFGWTR2_EL2_nPMSDSFR_EL1_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nPMSDSFR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nSPMSCR_EL1_SHIFT	16
#define	HDFGWTR2_EL2_nSPMSCR_EL1_MASK	(UL(0x1) << HDFGWTR2_EL2_nSPMSCR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nSPMSCR_EL1_VAL(x)	((x) & HDFGWTR2_EL2_nSPMSCR_EL1_MASK)
#define	 HDFGWTR2_EL2_nSPMSCR_EL1_TRAP	(UL(0x0) << HDFGWTR2_EL2_nSPMSCR_EL1_SHIFT)
#define	 HDFGWTR2_EL2_nSPMSCR_EL1_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nSPMSCR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nSPMACCESSR_EL1_SHIFT 15
#define	HDFGWTR2_EL2_nSPMACCESSR_EL1_MASK (UL(0x1) << HDFGWTR2_EL2_nSPMACCESSR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nSPMACCESSR_EL1_VAL(x) ((x) & HDFGWTR2_EL2_nSPMACCESSR_EL1_MASK)
#define	 HDFGWTR2_EL2_nSPMACCESSR_EL1_TRAP (UL(0x0) << HDFGWTR2_EL2_nSPMACCESSR_EL1_SHIFT)
#define	 HDFGWTR2_EL2_nSPMACCESSR_EL1_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nSPMACCESSR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nSPMCR_EL0_SHIFT	14
#define	HDFGWTR2_EL2_nSPMCR_EL0_MASK	(UL(0x1) << HDFGWTR2_EL2_nSPMCR_EL0_SHIFT)
#define	HDFGWTR2_EL2_nSPMCR_EL0_VAL(x)	((x) & HDFGWTR2_EL2_nSPMCR_EL0_MASK)
#define	 HDFGWTR2_EL2_nSPMCR_EL0_TRAP	(UL(0x0) << HDFGWTR2_EL2_nSPMCR_EL0_SHIFT)
#define	 HDFGWTR2_EL2_nSPMCR_EL0_NOTRAP	(UL(0x1) << HDFGWTR2_EL2_nSPMCR_EL0_SHIFT)
#define	HDFGWTR2_EL2_nSPMOVS_SHIFT	13
#define	HDFGWTR2_EL2_nSPMOVS_MASK	(UL(0x1) << HDFGWTR2_EL2_nSPMOVS_SHIFT)
#define	HDFGWTR2_EL2_nSPMOVS_VAL(x)	((x) & HDFGWTR2_EL2_nSPMOVS_MASK)
#define	 HDFGWTR2_EL2_nSPMOVS_TRAP	(UL(0x0) << HDFGWTR2_EL2_nSPMOVS_SHIFT)
#define	 HDFGWTR2_EL2_nSPMOVS_NOTRAP	(UL(0x1) << HDFGWTR2_EL2_nSPMOVS_SHIFT)
#define	HDFGWTR2_EL2_nSPMINTEN_SHIFT	12
#define	HDFGWTR2_EL2_nSPMINTEN_MASK	(UL(0x1) << HDFGWTR2_EL2_nSPMINTEN_SHIFT)
#define	HDFGWTR2_EL2_nSPMINTEN_VAL(x)	((x) & HDFGWTR2_EL2_nSPMINTEN_MASK)
#define	 HDFGWTR2_EL2_nSPMINTEN_TRAP	(UL(0x0) << HDFGWTR2_EL2_nSPMINTEN_SHIFT)
#define	 HDFGWTR2_EL2_nSPMINTEN_NOTRAP	(UL(0x1) << HDFGWTR2_EL2_nSPMINTEN_SHIFT)
#define	HDFGWTR2_EL2_nSPMCNTEN_SHIFT	11
#define	HDFGWTR2_EL2_nSPMCNTEN_MASK	(UL(0x1) << HDFGWTR2_EL2_nSPMCNTEN_SHIFT)
#define	HDFGWTR2_EL2_nSPMCNTEN_VAL(x)	((x) & HDFGWTR2_EL2_nSPMCNTEN_MASK)
#define	 HDFGWTR2_EL2_nSPMCNTEN_TRAP	(UL(0x0) << HDFGWTR2_EL2_nSPMCNTEN_SHIFT)
#define	 HDFGWTR2_EL2_nSPMCNTEN_NOTRAP	(UL(0x1) << HDFGWTR2_EL2_nSPMCNTEN_SHIFT)
#define	HDFGWTR2_EL2_nSPMSELR_EL0_SHIFT	10
#define	HDFGWTR2_EL2_nSPMSELR_EL0_MASK	(UL(0x1) << HDFGWTR2_EL2_nSPMSELR_EL0_SHIFT)
#define	HDFGWTR2_EL2_nSPMSELR_EL0_VAL(x) ((x) & HDFGWTR2_EL2_nSPMSELR_EL0_MASK)
#define	 HDFGWTR2_EL2_nSPMSELR_EL0_TRAP	(UL(0x0) << HDFGWTR2_EL2_nSPMSELR_EL0_SHIFT)
#define	 HDFGWTR2_EL2_nSPMSELR_EL0_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nSPMSELR_EL0_SHIFT)
#define	HDFGWTR2_EL2_nSPMEVTYPERn_EL0_SHIFT 9
#define	HDFGWTR2_EL2_nSPMEVTYPERn_EL0_MASK (UL(0x1) << HDFGWTR2_EL2_nSPMEVTYPERn_EL0_SHIFT)
#define	HDFGWTR2_EL2_nSPMEVTYPERn_EL0_VAL(x) ((x) & HDFGWTR2_EL2_nSPMEVTYPERn_EL0_MASK)
#define	 HDFGWTR2_EL2_nSPMEVTYPERn_EL0_TRAP (UL(0x0) << HDFGWTR2_EL2_nSPMEVTYPERn_EL0_SHIFT)
#define	 HDFGWTR2_EL2_nSPMEVTYPERn_EL0_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nSPMEVTYPERn_EL0_SHIFT)
#define	HDFGWTR2_EL2_nSPMEVCNTRn_EL0_SHIFT 8
#define	HDFGWTR2_EL2_nSPMEVCNTRn_EL0_MASK (UL(0x1) << HDFGWTR2_EL2_nSPMEVCNTRn_EL0_SHIFT)
#define	HDFGWTR2_EL2_nSPMEVCNTRn_EL0_VAL(x) ((x) & HDFGWTR2_EL2_nSPMEVCNTRn_EL0_MASK)
#define	 HDFGWTR2_EL2_nSPMEVCNTRn_EL0_TRAP (UL(0x0) << HDFGWTR2_EL2_nSPMEVCNTRn_EL0_SHIFT)
#define	 HDFGWTR2_EL2_nSPMEVCNTRn_EL0_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nSPMEVCNTRn_EL0_SHIFT)
#define	HDFGWTR2_EL2_nPMSSCR_EL1_SHIFT	7
#define	HDFGWTR2_EL2_nPMSSCR_EL1_MASK	(UL(0x1) << HDFGWTR2_EL2_nPMSSCR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nPMSSCR_EL1_VAL(x)	((x) & HDFGWTR2_EL2_nPMSSCR_EL1_MASK)
#define	 HDFGWTR2_EL2_nPMSSCR_EL1_TRAP	(UL(0x0) << HDFGWTR2_EL2_nPMSSCR_EL1_SHIFT)
#define	 HDFGWTR2_EL2_nPMSSCR_EL1_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nPMSSCR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nMDSELR_EL1_SHIFT	5
#define	HDFGWTR2_EL2_nMDSELR_EL1_MASK	(UL(0x1) << HDFGWTR2_EL2_nMDSELR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nMDSELR_EL1_VAL(x)	((x) & HDFGWTR2_EL2_nMDSELR_EL1_MASK)
#define	 HDFGWTR2_EL2_nMDSELR_EL1_TRAP	(UL(0x0) << HDFGWTR2_EL2_nMDSELR_EL1_SHIFT)
#define	 HDFGWTR2_EL2_nMDSELR_EL1_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nMDSELR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nPMUACR_EL1_SHIFT	4
#define	HDFGWTR2_EL2_nPMUACR_EL1_MASK	(UL(0x1) << HDFGWTR2_EL2_nPMUACR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nPMUACR_EL1_VAL(x)	((x) & HDFGWTR2_EL2_nPMUACR_EL1_MASK)
#define	 HDFGWTR2_EL2_nPMUACR_EL1_TRAP	(UL(0x0) << HDFGWTR2_EL2_nPMUACR_EL1_SHIFT)
#define	 HDFGWTR2_EL2_nPMUACR_EL1_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nPMUACR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nPMICFILTR_EL0_SHIFT 3
#define	HDFGWTR2_EL2_nPMICFILTR_EL0_MASK (UL(0x1) << HDFGWTR2_EL2_nPMICFILTR_EL0_SHIFT)
#define	HDFGWTR2_EL2_nPMICFILTR_EL0_VAL(x) ((x) & HDFGWTR2_EL2_nPMICFILTR_EL0_MASK)
#define	 HDFGWTR2_EL2_nPMICFILTR_EL0_TRAP (UL(0x0) << HDFGWTR2_EL2_nPMICFILTR_EL0_SHIFT)
#define	 HDFGWTR2_EL2_nPMICFILTR_EL0_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nPMICFILTR_EL0_SHIFT)
#define	HDFGWTR2_EL2_nPMICNTR_EL0_SHIFT	2
#define	HDFGWTR2_EL2_nPMICNTR_EL0_MASK	(UL(0x1) << HDFGWTR2_EL2_nPMICNTR_EL0_SHIFT)
#define	HDFGWTR2_EL2_nPMICNTR_EL0_VAL(x) ((x) & HDFGWTR2_EL2_nPMICNTR_EL0_MASK)
#define	 HDFGWTR2_EL2_nPMICNTR_EL0_TRAP	(UL(0x0) << HDFGWTR2_EL2_nPMICNTR_EL0_SHIFT)
#define	 HDFGWTR2_EL2_nPMICNTR_EL0_NOTRAP (UL(0x1) << HDFGWTR2_EL2_nPMICNTR_EL0_SHIFT)
#define	HDFGWTR2_EL2_nPMIAR_EL1_SHIFT	1
#define	HDFGWTR2_EL2_nPMIAR_EL1_MASK	(UL(0x1) << HDFGWTR2_EL2_nPMIAR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nPMIAR_EL1_VAL(x)	((x) & HDFGWTR2_EL2_nPMIAR_EL1_MASK)
#define	 HDFGWTR2_EL2_nPMIAR_EL1_TRAP	(UL(0x0) << HDFGWTR2_EL2_nPMIAR_EL1_SHIFT)
#define	 HDFGWTR2_EL2_nPMIAR_EL1_NOTRAP	(UL(0x1) << HDFGWTR2_EL2_nPMIAR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nPMECR_EL1_SHIFT	0
#define	HDFGWTR2_EL2_nPMECR_EL1_MASK	(UL(0x1) << HDFGWTR2_EL2_nPMECR_EL1_SHIFT)
#define	HDFGWTR2_EL2_nPMECR_EL1_VAL(x)	((x) & HDFGWTR2_EL2_nPMECR_EL1_MASK)
#define	 HDFGWTR2_EL2_nPMECR_EL1_TRAP	(UL(0x0) << HDFGWTR2_EL2_nPMECR_EL1_SHIFT)
#define	 HDFGWTR2_EL2_nPMECR_EL1_NOTRAP	(UL(0x1) << HDFGWTR2_EL2_nPMECR_EL1_SHIFT)

/* HDFGWTR_EL2 */
#define	HDFGWTR_EL2_REG			MRS_REG_ALT_NAME(HDFGWTR_EL2)
#define	HDFGWTR_EL2_op0			3
#define	HDFGWTR_EL2_op1			4
#define	HDFGWTR_EL2_CRn			3
#define	HDFGWTR_EL2_CRm			1
#define	HDFGWTR_EL2_op2			5
#define	HDFGWTR_EL2_nPMSNEVFR_EL1_SHIFT	62
#define	HDFGWTR_EL2_nPMSNEVFR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_nPMSNEVFR_EL1_SHIFT)
#define	HDFGWTR_EL2_nPMSNEVFR_EL1_VAL(x) ((x) & HDFGWTR_EL2_nPMSNEVFR_EL1_MASK)
#define	 HDFGWTR_EL2_nPMSNEVFR_EL1_TRAP	(UL(0x0) << HDFGWTR_EL2_nPMSNEVFR_EL1_SHIFT)
#define	 HDFGWTR_EL2_nPMSNEVFR_EL1_NOTRAP (UL(0x1) << HDFGWTR_EL2_nPMSNEVFR_EL1_SHIFT)
#define	HDFGWTR_EL2_nBRBDATA_SHIFT	61
#define	HDFGWTR_EL2_nBRBDATA_MASK	(UL(0x1) << HDFGWTR_EL2_nBRBDATA_SHIFT)
#define	HDFGWTR_EL2_nBRBDATA_VAL(x)	((x) & HDFGWTR_EL2_nBRBDATA_MASK)
#define	 HDFGWTR_EL2_nBRBDATA_TRAP	(UL(0x0) << HDFGWTR_EL2_nBRBDATA_SHIFT)
#define	 HDFGWTR_EL2_nBRBDATA_NOTRAP	(UL(0x1) << HDFGWTR_EL2_nBRBDATA_SHIFT)
#define	HDFGWTR_EL2_nBRBCTL_SHIFT	60
#define	HDFGWTR_EL2_nBRBCTL_MASK	(UL(0x1) << HDFGWTR_EL2_nBRBCTL_SHIFT)
#define	HDFGWTR_EL2_nBRBCTL_VAL(x)	((x) & HDFGWTR_EL2_nBRBCTL_MASK)
#define	 HDFGWTR_EL2_nBRBCTL_TRAP	(UL(0x0) << HDFGWTR_EL2_nBRBCTL_SHIFT)
#define	 HDFGWTR_EL2_nBRBCTL_NOTRAP	(UL(0x1) << HDFGWTR_EL2_nBRBCTL_SHIFT)
#define	HDFGWTR_EL2_PMUSERENR_EL0_SHIFT	57
#define	HDFGWTR_EL2_PMUSERENR_EL0_MASK	(UL(0x1) << HDFGWTR_EL2_PMUSERENR_EL0_SHIFT)
#define	HDFGWTR_EL2_PMUSERENR_EL0_VAL(x) ((x) & HDFGWTR_EL2_PMUSERENR_EL0_MASK)
#define	 HDFGWTR_EL2_PMUSERENR_EL0_NOTRAP (UL(0x0) << HDFGWTR_EL2_PMUSERENR_EL0_SHIFT)
#define	 HDFGWTR_EL2_PMUSERENR_EL0_TRAP	(UL(0x1) << HDFGWTR_EL2_PMUSERENR_EL0_SHIFT)
#define	HDFGWTR_EL2_TRBTRG_EL1_SHIFT	56
#define	HDFGWTR_EL2_TRBTRG_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_TRBTRG_EL1_SHIFT)
#define	HDFGWTR_EL2_TRBTRG_EL1_VAL(x)	((x) & HDFGWTR_EL2_TRBTRG_EL1_MASK)
#define	 HDFGWTR_EL2_TRBTRG_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRBTRG_EL1_SHIFT)
#define	 HDFGWTR_EL2_TRBTRG_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_TRBTRG_EL1_SHIFT)
#define	HDFGWTR_EL2_TRBSR_EL1_SHIFT	55
#define	HDFGWTR_EL2_TRBSR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_TRBSR_EL1_SHIFT)
#define	HDFGWTR_EL2_TRBSR_EL1_VAL(x)	((x) & HDFGWTR_EL2_TRBSR_EL1_MASK)
#define	 HDFGWTR_EL2_TRBSR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRBSR_EL1_SHIFT)
#define	 HDFGWTR_EL2_TRBSR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_TRBSR_EL1_SHIFT)
#define	HDFGWTR_EL2_TRBPTR_EL1_SHIFT	54
#define	HDFGWTR_EL2_TRBPTR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_TRBPTR_EL1_SHIFT)
#define	HDFGWTR_EL2_TRBPTR_EL1_VAL(x)	((x) & HDFGWTR_EL2_TRBPTR_EL1_MASK)
#define	 HDFGWTR_EL2_TRBPTR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRBPTR_EL1_SHIFT)
#define	 HDFGWTR_EL2_TRBPTR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_TRBPTR_EL1_SHIFT)
#define	HDFGWTR_EL2_TRBMAR_EL1_SHIFT	53
#define	HDFGWTR_EL2_TRBMAR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_TRBMAR_EL1_SHIFT)
#define	HDFGWTR_EL2_TRBMAR_EL1_VAL(x)	((x) & HDFGWTR_EL2_TRBMAR_EL1_MASK)
#define	 HDFGWTR_EL2_TRBMAR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRBMAR_EL1_SHIFT)
#define	 HDFGWTR_EL2_TRBMAR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_TRBMAR_EL1_SHIFT)
#define	HDFGWTR_EL2_TRBLIMITR_EL1_SHIFT	52
#define	HDFGWTR_EL2_TRBLIMITR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_TRBLIMITR_EL1_SHIFT)
#define	HDFGWTR_EL2_TRBLIMITR_EL1_VAL(x) ((x) & HDFGWTR_EL2_TRBLIMITR_EL1_MASK)
#define	 HDFGWTR_EL2_TRBLIMITR_EL1_NOTRAP (UL(0x0) << HDFGWTR_EL2_TRBLIMITR_EL1_SHIFT)
#define	 HDFGWTR_EL2_TRBLIMITR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_TRBLIMITR_EL1_SHIFT)
#define	HDFGWTR_EL2_TRBBASER_EL1_SHIFT	50
#define	HDFGWTR_EL2_TRBBASER_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_TRBBASER_EL1_SHIFT)
#define	HDFGWTR_EL2_TRBBASER_EL1_VAL(x)	((x) & HDFGWTR_EL2_TRBBASER_EL1_MASK)
#define	 HDFGWTR_EL2_TRBBASER_EL1_NOTRAP (UL(0x0) << HDFGWTR_EL2_TRBBASER_EL1_SHIFT)
#define	 HDFGWTR_EL2_TRBBASER_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_TRBBASER_EL1_SHIFT)
#define	HDFGWTR_EL2_TRFCR_EL1_SHIFT	49
#define	HDFGWTR_EL2_TRFCR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_TRFCR_EL1_SHIFT)
#define	HDFGWTR_EL2_TRFCR_EL1_VAL(x)	((x) & HDFGWTR_EL2_TRFCR_EL1_MASK)
#define	 HDFGWTR_EL2_TRFCR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRFCR_EL1_SHIFT)
#define	 HDFGWTR_EL2_TRFCR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_TRFCR_EL1_SHIFT)
#define	HDFGWTR_EL2_TRCVICTLR_SHIFT	48
#define	HDFGWTR_EL2_TRCVICTLR_MASK	(UL(0x1) << HDFGWTR_EL2_TRCVICTLR_SHIFT)
#define	HDFGWTR_EL2_TRCVICTLR_VAL(x)	((x) & HDFGWTR_EL2_TRCVICTLR_MASK)
#define	 HDFGWTR_EL2_TRCVICTLR_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRCVICTLR_SHIFT)
#define	 HDFGWTR_EL2_TRCVICTLR_TRAP	(UL(0x1) << HDFGWTR_EL2_TRCVICTLR_SHIFT)
#define	HDFGWTR_EL2_TRCSSCSRn_SHIFT	46
#define	HDFGWTR_EL2_TRCSSCSRn_MASK	(UL(0x1) << HDFGWTR_EL2_TRCSSCSRn_SHIFT)
#define	HDFGWTR_EL2_TRCSSCSRn_VAL(x)	((x) & HDFGWTR_EL2_TRCSSCSRn_MASK)
#define	 HDFGWTR_EL2_TRCSSCSRn_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRCSSCSRn_SHIFT)
#define	 HDFGWTR_EL2_TRCSSCSRn_TRAP	(UL(0x1) << HDFGWTR_EL2_TRCSSCSRn_SHIFT)
#define	HDFGWTR_EL2_TRCSEQSTR_SHIFT	45
#define	HDFGWTR_EL2_TRCSEQSTR_MASK	(UL(0x1) << HDFGWTR_EL2_TRCSEQSTR_SHIFT)
#define	HDFGWTR_EL2_TRCSEQSTR_VAL(x)	((x) & HDFGWTR_EL2_TRCSEQSTR_MASK)
#define	 HDFGWTR_EL2_TRCSEQSTR_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRCSEQSTR_SHIFT)
#define	 HDFGWTR_EL2_TRCSEQSTR_TRAP	(UL(0x1) << HDFGWTR_EL2_TRCSEQSTR_SHIFT)
#define	HDFGWTR_EL2_TRCPRGCTLR_SHIFT	44
#define	HDFGWTR_EL2_TRCPRGCTLR_MASK	(UL(0x1) << HDFGWTR_EL2_TRCPRGCTLR_SHIFT)
#define	HDFGWTR_EL2_TRCPRGCTLR_VAL(x)	((x) & HDFGWTR_EL2_TRCPRGCTLR_MASK)
#define	 HDFGWTR_EL2_TRCPRGCTLR_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRCPRGCTLR_SHIFT)
#define	 HDFGWTR_EL2_TRCPRGCTLR_TRAP	(UL(0x1) << HDFGWTR_EL2_TRCPRGCTLR_SHIFT)
#define	HDFGWTR_EL2_TRCOSLAR_SHIFT	42
#define	HDFGWTR_EL2_TRCOSLAR_MASK	(UL(0x1) << HDFGWTR_EL2_TRCOSLAR_SHIFT)
#define	HDFGWTR_EL2_TRCOSLAR_VAL(x)	((x) & HDFGWTR_EL2_TRCOSLAR_MASK)
#define	 HDFGWTR_EL2_TRCOSLAR_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRCOSLAR_SHIFT)
#define	 HDFGWTR_EL2_TRCOSLAR_TRAP	(UL(0x1) << HDFGWTR_EL2_TRCOSLAR_SHIFT)
#define	HDFGWTR_EL2_TRCIMSPECn_SHIFT	41
#define	HDFGWTR_EL2_TRCIMSPECn_MASK	(UL(0x1) << HDFGWTR_EL2_TRCIMSPECn_SHIFT)
#define	HDFGWTR_EL2_TRCIMSPECn_VAL(x)	((x) & HDFGWTR_EL2_TRCIMSPECn_MASK)
#define	 HDFGWTR_EL2_TRCIMSPECn_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRCIMSPECn_SHIFT)
#define	 HDFGWTR_EL2_TRCIMSPECn_TRAP	(UL(0x1) << HDFGWTR_EL2_TRCIMSPECn_SHIFT)
#define	HDFGWTR_EL2_TRCCNTVRn_SHIFT	37
#define	HDFGWTR_EL2_TRCCNTVRn_MASK	(UL(0x1) << HDFGWTR_EL2_TRCCNTVRn_SHIFT)
#define	HDFGWTR_EL2_TRCCNTVRn_VAL(x)	((x) & HDFGWTR_EL2_TRCCNTVRn_MASK)
#define	 HDFGWTR_EL2_TRCCNTVRn_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRCCNTVRn_SHIFT)
#define	 HDFGWTR_EL2_TRCCNTVRn_TRAP	(UL(0x1) << HDFGWTR_EL2_TRCCNTVRn_SHIFT)
#define	HDFGWTR_EL2_TRCCLAIM_SHIFT	36
#define	HDFGWTR_EL2_TRCCLAIM_MASK	(UL(0x1) << HDFGWTR_EL2_TRCCLAIM_SHIFT)
#define	HDFGWTR_EL2_TRCCLAIM_VAL(x)	((x) & HDFGWTR_EL2_TRCCLAIM_MASK)
#define	 HDFGWTR_EL2_TRCCLAIM_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRCCLAIM_SHIFT)
#define	 HDFGWTR_EL2_TRCCLAIM_TRAP	(UL(0x1) << HDFGWTR_EL2_TRCCLAIM_SHIFT)
#define	HDFGWTR_EL2_TRCAUXCTLR_SHIFT	35
#define	HDFGWTR_EL2_TRCAUXCTLR_MASK	(UL(0x1) << HDFGWTR_EL2_TRCAUXCTLR_SHIFT)
#define	HDFGWTR_EL2_TRCAUXCTLR_VAL(x)	((x) & HDFGWTR_EL2_TRCAUXCTLR_MASK)
#define	 HDFGWTR_EL2_TRCAUXCTLR_NOTRAP	(UL(0x0) << HDFGWTR_EL2_TRCAUXCTLR_SHIFT)
#define	 HDFGWTR_EL2_TRCAUXCTLR_TRAP	(UL(0x1) << HDFGWTR_EL2_TRCAUXCTLR_SHIFT)
#define	HDFGWTR_EL2_TRC_SHIFT		33
#define	HDFGWTR_EL2_TRC_MASK		(UL(0x1) << HDFGWTR_EL2_TRC_SHIFT)
#define	HDFGWTR_EL2_TRC_VAL(x)		((x) & HDFGWTR_EL2_TRC_MASK)
#define	 HDFGWTR_EL2_TRC_NOTRAP		(UL(0x0) << HDFGWTR_EL2_TRC_SHIFT)
#define	 HDFGWTR_EL2_TRC_TRAP		(UL(0x1) << HDFGWTR_EL2_TRC_SHIFT)
#define	HDFGWTR_EL2_PMSLATFR_EL1_SHIFT	32
#define	HDFGWTR_EL2_PMSLATFR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_PMSLATFR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMSLATFR_EL1_VAL(x)	((x) & HDFGWTR_EL2_PMSLATFR_EL1_MASK)
#define	 HDFGWTR_EL2_PMSLATFR_EL1_NOTRAP (UL(0x0) << HDFGWTR_EL2_PMSLATFR_EL1_SHIFT)
#define	 HDFGWTR_EL2_PMSLATFR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_PMSLATFR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMSIRR_EL1_SHIFT	31
#define	HDFGWTR_EL2_PMSIRR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_PMSIRR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMSIRR_EL1_VAL(x)	((x) & HDFGWTR_EL2_PMSIRR_EL1_MASK)
#define	 HDFGWTR_EL2_PMSIRR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMSIRR_EL1_SHIFT)
#define	 HDFGWTR_EL2_PMSIRR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_PMSIRR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMSICR_EL1_SHIFT	29
#define	HDFGWTR_EL2_PMSICR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_PMSICR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMSICR_EL1_VAL(x)	((x) & HDFGWTR_EL2_PMSICR_EL1_MASK)
#define	 HDFGWTR_EL2_PMSICR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMSICR_EL1_SHIFT)
#define	 HDFGWTR_EL2_PMSICR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_PMSICR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMSFCR_EL1_SHIFT	28
#define	HDFGWTR_EL2_PMSFCR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_PMSFCR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMSFCR_EL1_VAL(x)	((x) & HDFGWTR_EL2_PMSFCR_EL1_MASK)
#define	 HDFGWTR_EL2_PMSFCR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMSFCR_EL1_SHIFT)
#define	 HDFGWTR_EL2_PMSFCR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_PMSFCR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMSEVFR_EL1_SHIFT	27
#define	HDFGWTR_EL2_PMSEVFR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_PMSEVFR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMSEVFR_EL1_VAL(x)	((x) & HDFGWTR_EL2_PMSEVFR_EL1_MASK)
#define	 HDFGWTR_EL2_PMSEVFR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMSEVFR_EL1_SHIFT)
#define	 HDFGWTR_EL2_PMSEVFR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_PMSEVFR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMSCR_EL1_SHIFT	26
#define	HDFGWTR_EL2_PMSCR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_PMSCR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMSCR_EL1_VAL(x)	((x) & HDFGWTR_EL2_PMSCR_EL1_MASK)
#define	 HDFGWTR_EL2_PMSCR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMSCR_EL1_SHIFT)
#define	 HDFGWTR_EL2_PMSCR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_PMSCR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMBSR_EL1_SHIFT	25
#define	HDFGWTR_EL2_PMBSR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_PMBSR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMBSR_EL1_VAL(x)	((x) & HDFGWTR_EL2_PMBSR_EL1_MASK)
#define	 HDFGWTR_EL2_PMBSR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMBSR_EL1_SHIFT)
#define	 HDFGWTR_EL2_PMBSR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_PMBSR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMBPTR_EL1_SHIFT	24
#define	HDFGWTR_EL2_PMBPTR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_PMBPTR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMBPTR_EL1_VAL(x)	((x) & HDFGWTR_EL2_PMBPTR_EL1_MASK)
#define	 HDFGWTR_EL2_PMBPTR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMBPTR_EL1_SHIFT)
#define	 HDFGWTR_EL2_PMBPTR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_PMBPTR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMBLIMITR_EL1_SHIFT	23
#define	HDFGWTR_EL2_PMBLIMITR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_PMBLIMITR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMBLIMITR_EL1_VAL(x) ((x) & HDFGWTR_EL2_PMBLIMITR_EL1_MASK)
#define	 HDFGWTR_EL2_PMBLIMITR_EL1_NOTRAP (UL(0x0) << HDFGWTR_EL2_PMBLIMITR_EL1_SHIFT)
#define	 HDFGWTR_EL2_PMBLIMITR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_PMBLIMITR_EL1_SHIFT)
#define	HDFGWTR_EL2_PMCR_EL0_SHIFT	21
#define	HDFGWTR_EL2_PMCR_EL0_MASK	(UL(0x1) << HDFGWTR_EL2_PMCR_EL0_SHIFT)
#define	HDFGWTR_EL2_PMCR_EL0_VAL(x)	((x) & HDFGWTR_EL2_PMCR_EL0_MASK)
#define	 HDFGWTR_EL2_PMCR_EL0_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMCR_EL0_SHIFT)
#define	 HDFGWTR_EL2_PMCR_EL0_TRAP	(UL(0x1) << HDFGWTR_EL2_PMCR_EL0_SHIFT)
#define	HDFGWTR_EL2_PMSWINC_EL0_SHIFT	20
#define	HDFGWTR_EL2_PMSWINC_EL0_MASK	(UL(0x1) << HDFGWTR_EL2_PMSWINC_EL0_SHIFT)
#define	HDFGWTR_EL2_PMSWINC_EL0_VAL(x)	((x) & HDFGWTR_EL2_PMSWINC_EL0_MASK)
#define	 HDFGWTR_EL2_PMSWINC_EL0_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMSWINC_EL0_SHIFT)
#define	 HDFGWTR_EL2_PMSWINC_EL0_TRAP	(UL(0x1) << HDFGWTR_EL2_PMSWINC_EL0_SHIFT)
#define	HDFGWTR_EL2_PMSELR_EL0_SHIFT	19
#define	HDFGWTR_EL2_PMSELR_EL0_MASK	(UL(0x1) << HDFGWTR_EL2_PMSELR_EL0_SHIFT)
#define	HDFGWTR_EL2_PMSELR_EL0_VAL(x)	((x) & HDFGWTR_EL2_PMSELR_EL0_MASK)
#define	 HDFGWTR_EL2_PMSELR_EL0_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMSELR_EL0_SHIFT)
#define	 HDFGWTR_EL2_PMSELR_EL0_TRAP	(UL(0x1) << HDFGWTR_EL2_PMSELR_EL0_SHIFT)
#define	HDFGWTR_EL2_PMOVS_SHIFT		18
#define	HDFGWTR_EL2_PMOVS_MASK		(UL(0x1) << HDFGWTR_EL2_PMOVS_SHIFT)
#define	HDFGWTR_EL2_PMOVS_VAL(x)	((x) & HDFGWTR_EL2_PMOVS_MASK)
#define	 HDFGWTR_EL2_PMOVS_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMOVS_SHIFT)
#define	 HDFGWTR_EL2_PMOVS_TRAP		(UL(0x1) << HDFGWTR_EL2_PMOVS_SHIFT)
#define	HDFGWTR_EL2_PMINTEN_SHIFT	17
#define	HDFGWTR_EL2_PMINTEN_MASK	(UL(0x1) << HDFGWTR_EL2_PMINTEN_SHIFT)
#define	HDFGWTR_EL2_PMINTEN_VAL(x)	((x) & HDFGWTR_EL2_PMINTEN_MASK)
#define	 HDFGWTR_EL2_PMINTEN_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMINTEN_SHIFT)
#define	 HDFGWTR_EL2_PMINTEN_TRAP	(UL(0x1) << HDFGWTR_EL2_PMINTEN_SHIFT)
#define	HDFGWTR_EL2_PMCNTEN_SHIFT	16
#define	HDFGWTR_EL2_PMCNTEN_MASK	(UL(0x1) << HDFGWTR_EL2_PMCNTEN_SHIFT)
#define	HDFGWTR_EL2_PMCNTEN_VAL(x)	((x) & HDFGWTR_EL2_PMCNTEN_MASK)
#define	 HDFGWTR_EL2_PMCNTEN_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMCNTEN_SHIFT)
#define	 HDFGWTR_EL2_PMCNTEN_TRAP	(UL(0x1) << HDFGWTR_EL2_PMCNTEN_SHIFT)
#define	HDFGWTR_EL2_PMCCNTR_EL0_SHIFT	15
#define	HDFGWTR_EL2_PMCCNTR_EL0_MASK	(UL(0x1) << HDFGWTR_EL2_PMCCNTR_EL0_SHIFT)
#define	HDFGWTR_EL2_PMCCNTR_EL0_VAL(x)	((x) & HDFGWTR_EL2_PMCCNTR_EL0_MASK)
#define	 HDFGWTR_EL2_PMCCNTR_EL0_NOTRAP	(UL(0x0) << HDFGWTR_EL2_PMCCNTR_EL0_SHIFT)
#define	 HDFGWTR_EL2_PMCCNTR_EL0_TRAP	(UL(0x1) << HDFGWTR_EL2_PMCCNTR_EL0_SHIFT)
#define	HDFGWTR_EL2_PMCCFILTR_EL0_SHIFT	14
#define	HDFGWTR_EL2_PMCCFILTR_EL0_MASK	(UL(0x1) << HDFGWTR_EL2_PMCCFILTR_EL0_SHIFT)
#define	HDFGWTR_EL2_PMCCFILTR_EL0_VAL(x) ((x) & HDFGWTR_EL2_PMCCFILTR_EL0_MASK)
#define	 HDFGWTR_EL2_PMCCFILTR_EL0_NOTRAP (UL(0x0) << HDFGWTR_EL2_PMCCFILTR_EL0_SHIFT)
#define	 HDFGWTR_EL2_PMCCFILTR_EL0_TRAP	(UL(0x1) << HDFGWTR_EL2_PMCCFILTR_EL0_SHIFT)
#define	HDFGWTR_EL2_PMEVTYPERn_EL0_SHIFT 13
#define	HDFGWTR_EL2_PMEVTYPERn_EL0_MASK	(UL(0x1) << HDFGWTR_EL2_PMEVTYPERn_EL0_SHIFT)
#define	HDFGWTR_EL2_PMEVTYPERn_EL0_VAL(x) ((x) & HDFGWTR_EL2_PMEVTYPERn_EL0_MASK)
#define	 HDFGWTR_EL2_PMEVTYPERn_EL0_NOTRAP (UL(0x0) << HDFGWTR_EL2_PMEVTYPERn_EL0_SHIFT)
#define	 HDFGWTR_EL2_PMEVTYPERn_EL0_TRAP (UL(0x1) << HDFGWTR_EL2_PMEVTYPERn_EL0_SHIFT)
#define	HDFGWTR_EL2_PMEVCNTRn_EL0_SHIFT	12
#define	HDFGWTR_EL2_PMEVCNTRn_EL0_MASK	(UL(0x1) << HDFGWTR_EL2_PMEVCNTRn_EL0_SHIFT)
#define	HDFGWTR_EL2_PMEVCNTRn_EL0_VAL(x) ((x) & HDFGWTR_EL2_PMEVCNTRn_EL0_MASK)
#define	 HDFGWTR_EL2_PMEVCNTRn_EL0_NOTRAP (UL(0x0) << HDFGWTR_EL2_PMEVCNTRn_EL0_SHIFT)
#define	 HDFGWTR_EL2_PMEVCNTRn_EL0_TRAP	(UL(0x1) << HDFGWTR_EL2_PMEVCNTRn_EL0_SHIFT)
#define	HDFGWTR_EL2_OSDLR_EL1_SHIFT	11
#define	HDFGWTR_EL2_OSDLR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_OSDLR_EL1_SHIFT)
#define	HDFGWTR_EL2_OSDLR_EL1_VAL(x)	((x) & HDFGWTR_EL2_OSDLR_EL1_MASK)
#define	 HDFGWTR_EL2_OSDLR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_OSDLR_EL1_SHIFT)
#define	 HDFGWTR_EL2_OSDLR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_OSDLR_EL1_SHIFT)
#define	HDFGWTR_EL2_OSECCR_EL1_SHIFT	10
#define	HDFGWTR_EL2_OSECCR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_OSECCR_EL1_SHIFT)
#define	HDFGWTR_EL2_OSECCR_EL1_VAL(x)	((x) & HDFGWTR_EL2_OSECCR_EL1_MASK)
#define	 HDFGWTR_EL2_OSECCR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_OSECCR_EL1_SHIFT)
#define	 HDFGWTR_EL2_OSECCR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_OSECCR_EL1_SHIFT)
#define	HDFGWTR_EL2_OSLAR_EL1_SHIFT	8
#define	HDFGWTR_EL2_OSLAR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_OSLAR_EL1_SHIFT)
#define	HDFGWTR_EL2_OSLAR_EL1_VAL(x)	((x) & HDFGWTR_EL2_OSLAR_EL1_MASK)
#define	 HDFGWTR_EL2_OSLAR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_OSLAR_EL1_SHIFT)
#define	 HDFGWTR_EL2_OSLAR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_OSLAR_EL1_SHIFT)
#define	HDFGWTR_EL2_DBGPRCR_EL1_SHIFT	7
#define	HDFGWTR_EL2_DBGPRCR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_DBGPRCR_EL1_SHIFT)
#define	HDFGWTR_EL2_DBGPRCR_EL1_VAL(x)	((x) & HDFGWTR_EL2_DBGPRCR_EL1_MASK)
#define	 HDFGWTR_EL2_DBGPRCR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_DBGPRCR_EL1_SHIFT)
#define	 HDFGWTR_EL2_DBGPRCR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_DBGPRCR_EL1_SHIFT)
#define	HDFGWTR_EL2_DBGCLAIM_SHIFT	5
#define	HDFGWTR_EL2_DBGCLAIM_MASK	(UL(0x1) << HDFGWTR_EL2_DBGCLAIM_SHIFT)
#define	HDFGWTR_EL2_DBGCLAIM_VAL(x)	((x) & HDFGWTR_EL2_DBGCLAIM_MASK)
#define	 HDFGWTR_EL2_DBGCLAIM_NOTRAP	(UL(0x0) << HDFGWTR_EL2_DBGCLAIM_SHIFT)
#define	 HDFGWTR_EL2_DBGCLAIM_TRAP	(UL(0x1) << HDFGWTR_EL2_DBGCLAIM_SHIFT)
#define	HDFGWTR_EL2_MDSCR_EL1_SHIFT	4
#define	HDFGWTR_EL2_MDSCR_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_MDSCR_EL1_SHIFT)
#define	HDFGWTR_EL2_MDSCR_EL1_VAL(x)	((x) & HDFGWTR_EL2_MDSCR_EL1_MASK)
#define	 HDFGWTR_EL2_MDSCR_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_MDSCR_EL1_SHIFT)
#define	 HDFGWTR_EL2_MDSCR_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_MDSCR_EL1_SHIFT)
#define	HDFGWTR_EL2_DBGWVRn_EL1_SHIFT	3
#define	HDFGWTR_EL2_DBGWVRn_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_DBGWVRn_EL1_SHIFT)
#define	HDFGWTR_EL2_DBGWVRn_EL1_VAL(x)	((x) & HDFGWTR_EL2_DBGWVRn_EL1_MASK)
#define	 HDFGWTR_EL2_DBGWVRn_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_DBGWVRn_EL1_SHIFT)
#define	 HDFGWTR_EL2_DBGWVRn_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_DBGWVRn_EL1_SHIFT)
#define	HDFGWTR_EL2_DBGWCRn_EL1_SHIFT	2
#define	HDFGWTR_EL2_DBGWCRn_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_DBGWCRn_EL1_SHIFT)
#define	HDFGWTR_EL2_DBGWCRn_EL1_VAL(x)	((x) & HDFGWTR_EL2_DBGWCRn_EL1_MASK)
#define	 HDFGWTR_EL2_DBGWCRn_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_DBGWCRn_EL1_SHIFT)
#define	 HDFGWTR_EL2_DBGWCRn_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_DBGWCRn_EL1_SHIFT)
#define	HDFGWTR_EL2_DBGBVRn_EL1_SHIFT	1
#define	HDFGWTR_EL2_DBGBVRn_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_DBGBVRn_EL1_SHIFT)
#define	HDFGWTR_EL2_DBGBVRn_EL1_VAL(x)	((x) & HDFGWTR_EL2_DBGBVRn_EL1_MASK)
#define	 HDFGWTR_EL2_DBGBVRn_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_DBGBVRn_EL1_SHIFT)
#define	 HDFGWTR_EL2_DBGBVRn_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_DBGBVRn_EL1_SHIFT)
#define	HDFGWTR_EL2_DBGBCRn_EL1_SHIFT	0
#define	HDFGWTR_EL2_DBGBCRn_EL1_MASK	(UL(0x1) << HDFGWTR_EL2_DBGBCRn_EL1_SHIFT)
#define	HDFGWTR_EL2_DBGBCRn_EL1_VAL(x)	((x) & HDFGWTR_EL2_DBGBCRn_EL1_MASK)
#define	 HDFGWTR_EL2_DBGBCRn_EL1_NOTRAP	(UL(0x0) << HDFGWTR_EL2_DBGBCRn_EL1_SHIFT)
#define	 HDFGWTR_EL2_DBGBCRn_EL1_TRAP	(UL(0x1) << HDFGWTR_EL2_DBGBCRn_EL1_SHIFT)

/* HFGITR2_EL2 */
#define	HFGITR2_EL2_REG			MRS_REG_ALT_NAME(HFGITR2_EL2)
#define	HFGITR2_EL2_op0			3
#define	HFGITR2_EL2_op1			4
#define	HFGITR2_EL2_CRn			3
#define	HFGITR2_EL2_CRm			1
#define	HFGITR2_EL2_op2			7

/* HFGITR_EL2 */
#define	HFGITR_EL2_REG			MRS_REG_ALT_NAME(HFGITR_EL2)
#define	HFGITR_EL2_op0			3
#define	HFGITR_EL2_op1			4
#define	HFGITR_EL2_CRn			1
#define	HFGITR_EL2_CRm			1
#define	HFGITR_EL2_op2			6
#define	HFGITR_EL2_ATS1E1A_SHIFT	62
#define	HFGITR_EL2_ATS1E1A_MASK		(UL(0x1) << HFGITR_EL2_ATS1E1A_SHIFT)
#define	HFGITR_EL2_ATS1E1A_VAL(x)	((x) & HFGITR_EL2_ATS1E1A_MASK)
#define	 HFGITR_EL2_ATS1E1A_NOTRAP	(UL(0x0) << HFGITR_EL2_ATS1E1A_SHIFT)
#define	 HFGITR_EL2_ATS1E1A_TRAP	(UL(0x1) << HFGITR_EL2_ATS1E1A_SHIFT)
#define	HFGITR_EL2_COSPRCTX_SHIFT	60
#define	HFGITR_EL2_COSPRCTX_MASK	(UL(0x1) << HFGITR_EL2_COSPRCTX_SHIFT)
#define	HFGITR_EL2_COSPRCTX_VAL(x)	((x) & HFGITR_EL2_COSPRCTX_MASK)
#define	 HFGITR_EL2_COSPRCTX_NOTRAP	(UL(0x0) << HFGITR_EL2_COSPRCTX_SHIFT)
#define	 HFGITR_EL2_COSPRCTX_TRAP	(UL(0x1) << HFGITR_EL2_COSPRCTX_SHIFT)
#define	HFGITR_EL2_nGCSEPP_SHIFT	59
#define	HFGITR_EL2_nGCSEPP_MASK		(UL(0x1) << HFGITR_EL2_nGCSEPP_SHIFT)
#define	HFGITR_EL2_nGCSEPP_VAL(x)	((x) & HFGITR_EL2_nGCSEPP_MASK)
#define	 HFGITR_EL2_nGCSEPP_TRAP	(UL(0x0) << HFGITR_EL2_nGCSEPP_SHIFT)
#define	 HFGITR_EL2_nGCSEPP_NOTRAP	(UL(0x1) << HFGITR_EL2_nGCSEPP_SHIFT)
#define	HFGITR_EL2_nGCSSTR_EL1_SHIFT	58
#define	HFGITR_EL2_nGCSSTR_EL1_MASK	(UL(0x1) << HFGITR_EL2_nGCSSTR_EL1_SHIFT)
#define	HFGITR_EL2_nGCSSTR_EL1_VAL(x)	((x) & HFGITR_EL2_nGCSSTR_EL1_MASK)
#define	 HFGITR_EL2_nGCSSTR_EL1_TRAP	(UL(0x0) << HFGITR_EL2_nGCSSTR_EL1_SHIFT)
#define	 HFGITR_EL2_nGCSSTR_EL1_NOTRAP	(UL(0x1) << HFGITR_EL2_nGCSSTR_EL1_SHIFT)
#define	HFGITR_EL2_nGCSPUSHM_EL1_SHIFT	57
#define	HFGITR_EL2_nGCSPUSHM_EL1_MASK	(UL(0x1) << HFGITR_EL2_nGCSPUSHM_EL1_SHIFT)
#define	HFGITR_EL2_nGCSPUSHM_EL1_VAL(x)	((x) & HFGITR_EL2_nGCSPUSHM_EL1_MASK)
#define	 HFGITR_EL2_nGCSPUSHM_EL1_TRAP	(UL(0x0) << HFGITR_EL2_nGCSPUSHM_EL1_SHIFT)
#define	 HFGITR_EL2_nGCSPUSHM_EL1_NOTRAP (UL(0x1) << HFGITR_EL2_nGCSPUSHM_EL1_SHIFT)
#define	HFGITR_EL2_nBRBIALL_SHIFT	56
#define	HFGITR_EL2_nBRBIALL_MASK	(UL(0x1) << HFGITR_EL2_nBRBIALL_SHIFT)
#define	HFGITR_EL2_nBRBIALL_VAL(x)	((x) & HFGITR_EL2_nBRBIALL_MASK)
#define	 HFGITR_EL2_nBRBIALL_TRAP	(UL(0x0) << HFGITR_EL2_nBRBIALL_SHIFT)
#define	 HFGITR_EL2_nBRBIALL_NOTRAP	(UL(0x1) << HFGITR_EL2_nBRBIALL_SHIFT)
#define	HFGITR_EL2_nBRBINJ_SHIFT	55
#define	HFGITR_EL2_nBRBINJ_MASK		(UL(0x1) << HFGITR_EL2_nBRBINJ_SHIFT)
#define	HFGITR_EL2_nBRBINJ_VAL(x)	((x) & HFGITR_EL2_nBRBINJ_MASK)
#define	 HFGITR_EL2_nBRBINJ_TRAP	(UL(0x0) << HFGITR_EL2_nBRBINJ_SHIFT)
#define	 HFGITR_EL2_nBRBINJ_NOTRAP	(UL(0x1) << HFGITR_EL2_nBRBINJ_SHIFT)
#define	HFGITR_EL2_DCCVAC_SHIFT		54
#define	HFGITR_EL2_DCCVAC_MASK		(UL(0x1) << HFGITR_EL2_DCCVAC_SHIFT)
#define	HFGITR_EL2_DCCVAC_VAL(x)	((x) & HFGITR_EL2_DCCVAC_MASK)
#define	 HFGITR_EL2_DCCVAC_NOTRAP	(UL(0x0) << HFGITR_EL2_DCCVAC_SHIFT)
#define	 HFGITR_EL2_DCCVAC_TRAP		(UL(0x1) << HFGITR_EL2_DCCVAC_SHIFT)
#define	HFGITR_EL2_SVC_EL1_SHIFT	53
#define	HFGITR_EL2_SVC_EL1_MASK		(UL(0x1) << HFGITR_EL2_SVC_EL1_SHIFT)
#define	HFGITR_EL2_SVC_EL1_VAL(x)	((x) & HFGITR_EL2_SVC_EL1_MASK)
#define	 HFGITR_EL2_SVC_EL1_NOTRAP	(UL(0x0) << HFGITR_EL2_SVC_EL1_SHIFT)
#define	 HFGITR_EL2_SVC_EL1_TRAP	(UL(0x1) << HFGITR_EL2_SVC_EL1_SHIFT)
#define	HFGITR_EL2_SVC_EL0_SHIFT	52
#define	HFGITR_EL2_SVC_EL0_MASK		(UL(0x1) << HFGITR_EL2_SVC_EL0_SHIFT)
#define	HFGITR_EL2_SVC_EL0_VAL(x)	((x) & HFGITR_EL2_SVC_EL0_MASK)
#define	 HFGITR_EL2_SVC_EL0_NOTRAP	(UL(0x0) << HFGITR_EL2_SVC_EL0_SHIFT)
#define	 HFGITR_EL2_SVC_EL0_TRAP	(UL(0x1) << HFGITR_EL2_SVC_EL0_SHIFT)
#define	HFGITR_EL2_ERET_SHIFT		51
#define	HFGITR_EL2_ERET_MASK		(UL(0x1) << HFGITR_EL2_ERET_SHIFT)
#define	HFGITR_EL2_ERET_VAL(x)		((x) & HFGITR_EL2_ERET_MASK)
#define	 HFGITR_EL2_ERET_NOTRAP		(UL(0x0) << HFGITR_EL2_ERET_SHIFT)
#define	 HFGITR_EL2_ERET_TRAP		(UL(0x1) << HFGITR_EL2_ERET_SHIFT)
#define	HFGITR_EL2_CPPRCTX_SHIFT	50
#define	HFGITR_EL2_CPPRCTX_MASK		(UL(0x1) << HFGITR_EL2_CPPRCTX_SHIFT)
#define	HFGITR_EL2_CPPRCTX_VAL(x)	((x) & HFGITR_EL2_CPPRCTX_MASK)
#define	 HFGITR_EL2_CPPRCTX_NOTRAP	(UL(0x0) << HFGITR_EL2_CPPRCTX_SHIFT)
#define	 HFGITR_EL2_CPPRCTX_TRAP	(UL(0x1) << HFGITR_EL2_CPPRCTX_SHIFT)
#define	HFGITR_EL2_DVPRCTX_SHIFT	49
#define	HFGITR_EL2_DVPRCTX_MASK		(UL(0x1) << HFGITR_EL2_DVPRCTX_SHIFT)
#define	HFGITR_EL2_DVPRCTX_VAL(x)	((x) & HFGITR_EL2_DVPRCTX_MASK)
#define	 HFGITR_EL2_DVPRCTX_NOTRAP	(UL(0x0) << HFGITR_EL2_DVPRCTX_SHIFT)
#define	 HFGITR_EL2_DVPRCTX_TRAP	(UL(0x1) << HFGITR_EL2_DVPRCTX_SHIFT)
#define	HFGITR_EL2_CFPRCTX_SHIFT	48
#define	HFGITR_EL2_CFPRCTX_MASK		(UL(0x1) << HFGITR_EL2_CFPRCTX_SHIFT)
#define	HFGITR_EL2_CFPRCTX_VAL(x)	((x) & HFGITR_EL2_CFPRCTX_MASK)
#define	 HFGITR_EL2_CFPRCTX_NOTRAP	(UL(0x0) << HFGITR_EL2_CFPRCTX_SHIFT)
#define	 HFGITR_EL2_CFPRCTX_TRAP	(UL(0x1) << HFGITR_EL2_CFPRCTX_SHIFT)
#define	HFGITR_EL2_TLBIVAALE1_SHIFT	47
#define	HFGITR_EL2_TLBIVAALE1_MASK	(UL(0x1) << HFGITR_EL2_TLBIVAALE1_SHIFT)
#define	HFGITR_EL2_TLBIVAALE1_VAL(x)	((x) & HFGITR_EL2_TLBIVAALE1_MASK)
#define	 HFGITR_EL2_TLBIVAALE1_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIVAALE1_SHIFT)
#define	 HFGITR_EL2_TLBIVAALE1_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVAALE1_SHIFT)
#define	HFGITR_EL2_TLBIVALE1_SHIFT	46
#define	HFGITR_EL2_TLBIVALE1_MASK	(UL(0x1) << HFGITR_EL2_TLBIVALE1_SHIFT)
#define	HFGITR_EL2_TLBIVALE1_VAL(x)	((x) & HFGITR_EL2_TLBIVALE1_MASK)
#define	 HFGITR_EL2_TLBIVALE1_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIVALE1_SHIFT)
#define	 HFGITR_EL2_TLBIVALE1_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVALE1_SHIFT)
#define	HFGITR_EL2_TLBIVAAE1_SHIFT	45
#define	HFGITR_EL2_TLBIVAAE1_MASK	(UL(0x1) << HFGITR_EL2_TLBIVAAE1_SHIFT)
#define	HFGITR_EL2_TLBIVAAE1_VAL(x)	((x) & HFGITR_EL2_TLBIVAAE1_MASK)
#define	 HFGITR_EL2_TLBIVAAE1_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIVAAE1_SHIFT)
#define	 HFGITR_EL2_TLBIVAAE1_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVAAE1_SHIFT)
#define	HFGITR_EL2_TLBIASIDE1_SHIFT	44
#define	HFGITR_EL2_TLBIASIDE1_MASK	(UL(0x1) << HFGITR_EL2_TLBIASIDE1_SHIFT)
#define	HFGITR_EL2_TLBIASIDE1_VAL(x)	((x) & HFGITR_EL2_TLBIASIDE1_MASK)
#define	 HFGITR_EL2_TLBIASIDE1_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIASIDE1_SHIFT)
#define	 HFGITR_EL2_TLBIASIDE1_TRAP	(UL(0x1) << HFGITR_EL2_TLBIASIDE1_SHIFT)
#define	HFGITR_EL2_TLBIVAE1_SHIFT	43
#define	HFGITR_EL2_TLBIVAE1_MASK	(UL(0x1) << HFGITR_EL2_TLBIVAE1_SHIFT)
#define	HFGITR_EL2_TLBIVAE1_VAL(x)	((x) & HFGITR_EL2_TLBIVAE1_MASK)
#define	 HFGITR_EL2_TLBIVAE1_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIVAE1_SHIFT)
#define	 HFGITR_EL2_TLBIVAE1_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVAE1_SHIFT)
#define	HFGITR_EL2_TLBIVMALLE1_SHIFT	42
#define	HFGITR_EL2_TLBIVMALLE1_MASK	(UL(0x1) << HFGITR_EL2_TLBIVMALLE1_SHIFT)
#define	HFGITR_EL2_TLBIVMALLE1_VAL(x)	((x) & HFGITR_EL2_TLBIVMALLE1_MASK)
#define	 HFGITR_EL2_TLBIVMALLE1_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIVMALLE1_SHIFT)
#define	 HFGITR_EL2_TLBIVMALLE1_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVMALLE1_SHIFT)
#define	HFGITR_EL2_TLBIRVAALE1_SHIFT	41
#define	HFGITR_EL2_TLBIRVAALE1_MASK	(UL(0x1) << HFGITR_EL2_TLBIRVAALE1_SHIFT)
#define	HFGITR_EL2_TLBIRVAALE1_VAL(x)	((x) & HFGITR_EL2_TLBIRVAALE1_MASK)
#define	 HFGITR_EL2_TLBIRVAALE1_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIRVAALE1_SHIFT)
#define	 HFGITR_EL2_TLBIRVAALE1_TRAP	(UL(0x1) << HFGITR_EL2_TLBIRVAALE1_SHIFT)
#define	HFGITR_EL2_TLBIRVALE1_SHIFT	40
#define	HFGITR_EL2_TLBIRVALE1_MASK	(UL(0x1) << HFGITR_EL2_TLBIRVALE1_SHIFT)
#define	HFGITR_EL2_TLBIRVALE1_VAL(x)	((x) & HFGITR_EL2_TLBIRVALE1_MASK)
#define	 HFGITR_EL2_TLBIRVALE1_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIRVALE1_SHIFT)
#define	 HFGITR_EL2_TLBIRVALE1_TRAP	(UL(0x1) << HFGITR_EL2_TLBIRVALE1_SHIFT)
#define	HFGITR_EL2_TLBIRVAAE1_SHIFT	39
#define	HFGITR_EL2_TLBIRVAAE1_MASK	(UL(0x1) << HFGITR_EL2_TLBIRVAAE1_SHIFT)
#define	HFGITR_EL2_TLBIRVAAE1_VAL(x)	((x) & HFGITR_EL2_TLBIRVAAE1_MASK)
#define	 HFGITR_EL2_TLBIRVAAE1_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIRVAAE1_SHIFT)
#define	 HFGITR_EL2_TLBIRVAAE1_TRAP	(UL(0x1) << HFGITR_EL2_TLBIRVAAE1_SHIFT)
#define	HFGITR_EL2_TLBIRVAE1_SHIFT	38
#define	HFGITR_EL2_TLBIRVAE1_MASK	(UL(0x1) << HFGITR_EL2_TLBIRVAE1_SHIFT)
#define	HFGITR_EL2_TLBIRVAE1_VAL(x)	((x) & HFGITR_EL2_TLBIRVAE1_MASK)
#define	 HFGITR_EL2_TLBIRVAE1_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIRVAE1_SHIFT)
#define	 HFGITR_EL2_TLBIRVAE1_TRAP	(UL(0x1) << HFGITR_EL2_TLBIRVAE1_SHIFT)
#define	HFGITR_EL2_TLBIRVAALE1IS_SHIFT	37
#define	HFGITR_EL2_TLBIRVAALE1IS_MASK	(UL(0x1) << HFGITR_EL2_TLBIRVAALE1IS_SHIFT)
#define	HFGITR_EL2_TLBIRVAALE1IS_VAL(x)	((x) & HFGITR_EL2_TLBIRVAALE1IS_MASK)
#define	 HFGITR_EL2_TLBIRVAALE1IS_NOTRAP (UL(0x0) << HFGITR_EL2_TLBIRVAALE1IS_SHIFT)
#define	 HFGITR_EL2_TLBIRVAALE1IS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIRVAALE1IS_SHIFT)
#define	HFGITR_EL2_TLBIRVALE1IS_SHIFT	36
#define	HFGITR_EL2_TLBIRVALE1IS_MASK	(UL(0x1) << HFGITR_EL2_TLBIRVALE1IS_SHIFT)
#define	HFGITR_EL2_TLBIRVALE1IS_VAL(x)	((x) & HFGITR_EL2_TLBIRVALE1IS_MASK)
#define	 HFGITR_EL2_TLBIRVALE1IS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIRVALE1IS_SHIFT)
#define	 HFGITR_EL2_TLBIRVALE1IS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIRVALE1IS_SHIFT)
#define	HFGITR_EL2_TLBIRVAAE1IS_SHIFT	35
#define	HFGITR_EL2_TLBIRVAAE1IS_MASK	(UL(0x1) << HFGITR_EL2_TLBIRVAAE1IS_SHIFT)
#define	HFGITR_EL2_TLBIRVAAE1IS_VAL(x)	((x) & HFGITR_EL2_TLBIRVAAE1IS_MASK)
#define	 HFGITR_EL2_TLBIRVAAE1IS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIRVAAE1IS_SHIFT)
#define	 HFGITR_EL2_TLBIRVAAE1IS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIRVAAE1IS_SHIFT)
#define	HFGITR_EL2_TLBIRVAE1IS_SHIFT	34
#define	HFGITR_EL2_TLBIRVAE1IS_MASK	(UL(0x1) << HFGITR_EL2_TLBIRVAE1IS_SHIFT)
#define	HFGITR_EL2_TLBIRVAE1IS_VAL(x)	((x) & HFGITR_EL2_TLBIRVAE1IS_MASK)
#define	 HFGITR_EL2_TLBIRVAE1IS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIRVAE1IS_SHIFT)
#define	 HFGITR_EL2_TLBIRVAE1IS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIRVAE1IS_SHIFT)
#define	HFGITR_EL2_TLBIVAALE1IS_SHIFT	33
#define	HFGITR_EL2_TLBIVAALE1IS_MASK	(UL(0x1) << HFGITR_EL2_TLBIVAALE1IS_SHIFT)
#define	HFGITR_EL2_TLBIVAALE1IS_VAL(x)	((x) & HFGITR_EL2_TLBIVAALE1IS_MASK)
#define	 HFGITR_EL2_TLBIVAALE1IS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIVAALE1IS_SHIFT)
#define	 HFGITR_EL2_TLBIVAALE1IS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVAALE1IS_SHIFT)
#define	HFGITR_EL2_TLBIVALE1IS_SHIFT	32
#define	HFGITR_EL2_TLBIVALE1IS_MASK	(UL(0x1) << HFGITR_EL2_TLBIVALE1IS_SHIFT)
#define	HFGITR_EL2_TLBIVALE1IS_VAL(x)	((x) & HFGITR_EL2_TLBIVALE1IS_MASK)
#define	 HFGITR_EL2_TLBIVALE1IS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIVALE1IS_SHIFT)
#define	 HFGITR_EL2_TLBIVALE1IS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVALE1IS_SHIFT)
#define	HFGITR_EL2_TLBIVAAE1IS_SHIFT	31
#define	HFGITR_EL2_TLBIVAAE1IS_MASK	(UL(0x1) << HFGITR_EL2_TLBIVAAE1IS_SHIFT)
#define	HFGITR_EL2_TLBIVAAE1IS_VAL(x)	((x) & HFGITR_EL2_TLBIVAAE1IS_MASK)
#define	 HFGITR_EL2_TLBIVAAE1IS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIVAAE1IS_SHIFT)
#define	 HFGITR_EL2_TLBIVAAE1IS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVAAE1IS_SHIFT)
#define	HFGITR_EL2_TLBIASIDE1IS_SHIFT	30
#define	HFGITR_EL2_TLBIASIDE1IS_MASK	(UL(0x1) << HFGITR_EL2_TLBIASIDE1IS_SHIFT)
#define	HFGITR_EL2_TLBIASIDE1IS_VAL(x)	((x) & HFGITR_EL2_TLBIASIDE1IS_MASK)
#define	 HFGITR_EL2_TLBIASIDE1IS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIASIDE1IS_SHIFT)
#define	 HFGITR_EL2_TLBIASIDE1IS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIASIDE1IS_SHIFT)
#define	HFGITR_EL2_TLBIVAE1IS_SHIFT	29
#define	HFGITR_EL2_TLBIVAE1IS_MASK	(UL(0x1) << HFGITR_EL2_TLBIVAE1IS_SHIFT)
#define	HFGITR_EL2_TLBIVAE1IS_VAL(x)	((x) & HFGITR_EL2_TLBIVAE1IS_MASK)
#define	 HFGITR_EL2_TLBIVAE1IS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIVAE1IS_SHIFT)
#define	 HFGITR_EL2_TLBIVAE1IS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVAE1IS_SHIFT)
#define	HFGITR_EL2_TLBIVMALLE1IS_SHIFT	28
#define	HFGITR_EL2_TLBIVMALLE1IS_MASK	(UL(0x1) << HFGITR_EL2_TLBIVMALLE1IS_SHIFT)
#define	HFGITR_EL2_TLBIVMALLE1IS_VAL(x)	((x) & HFGITR_EL2_TLBIVMALLE1IS_MASK)
#define	 HFGITR_EL2_TLBIVMALLE1IS_NOTRAP (UL(0x0) << HFGITR_EL2_TLBIVMALLE1IS_SHIFT)
#define	 HFGITR_EL2_TLBIVMALLE1IS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVMALLE1IS_SHIFT)
#define	HFGITR_EL2_TLBIRVAALE1OS_SHIFT	27
#define	HFGITR_EL2_TLBIRVAALE1OS_MASK	(UL(0x1) << HFGITR_EL2_TLBIRVAALE1OS_SHIFT)
#define	HFGITR_EL2_TLBIRVAALE1OS_VAL(x)	((x) & HFGITR_EL2_TLBIRVAALE1OS_MASK)
#define	 HFGITR_EL2_TLBIRVAALE1OS_NOTRAP (UL(0x0) << HFGITR_EL2_TLBIRVAALE1OS_SHIFT)
#define	 HFGITR_EL2_TLBIRVAALE1OS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIRVAALE1OS_SHIFT)
#define	HFGITR_EL2_TLBIRVALE1OS_SHIFT	26
#define	HFGITR_EL2_TLBIRVALE1OS_MASK	(UL(0x1) << HFGITR_EL2_TLBIRVALE1OS_SHIFT)
#define	HFGITR_EL2_TLBIRVALE1OS_VAL(x)	((x) & HFGITR_EL2_TLBIRVALE1OS_MASK)
#define	 HFGITR_EL2_TLBIRVALE1OS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIRVALE1OS_SHIFT)
#define	 HFGITR_EL2_TLBIRVALE1OS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIRVALE1OS_SHIFT)
#define	HFGITR_EL2_TLBIRVAAE1OS_SHIFT	25
#define	HFGITR_EL2_TLBIRVAAE1OS_MASK	(UL(0x1) << HFGITR_EL2_TLBIRVAAE1OS_SHIFT)
#define	HFGITR_EL2_TLBIRVAAE1OS_VAL(x)	((x) & HFGITR_EL2_TLBIRVAAE1OS_MASK)
#define	 HFGITR_EL2_TLBIRVAAE1OS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIRVAAE1OS_SHIFT)
#define	 HFGITR_EL2_TLBIRVAAE1OS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIRVAAE1OS_SHIFT)
#define	HFGITR_EL2_TLBIRVAE1OS_SHIFT	24
#define	HFGITR_EL2_TLBIRVAE1OS_MASK	(UL(0x1) << HFGITR_EL2_TLBIRVAE1OS_SHIFT)
#define	HFGITR_EL2_TLBIRVAE1OS_VAL(x)	((x) & HFGITR_EL2_TLBIRVAE1OS_MASK)
#define	 HFGITR_EL2_TLBIRVAE1OS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIRVAE1OS_SHIFT)
#define	 HFGITR_EL2_TLBIRVAE1OS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIRVAE1OS_SHIFT)
#define	HFGITR_EL2_TLBIVAALE1OS_SHIFT	23
#define	HFGITR_EL2_TLBIVAALE1OS_MASK	(UL(0x1) << HFGITR_EL2_TLBIVAALE1OS_SHIFT)
#define	HFGITR_EL2_TLBIVAALE1OS_VAL(x)	((x) & HFGITR_EL2_TLBIVAALE1OS_MASK)
#define	 HFGITR_EL2_TLBIVAALE1OS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIVAALE1OS_SHIFT)
#define	 HFGITR_EL2_TLBIVAALE1OS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVAALE1OS_SHIFT)
#define	HFGITR_EL2_TLBIVALE1OS_SHIFT	22
#define	HFGITR_EL2_TLBIVALE1OS_MASK	(UL(0x1) << HFGITR_EL2_TLBIVALE1OS_SHIFT)
#define	HFGITR_EL2_TLBIVALE1OS_VAL(x)	((x) & HFGITR_EL2_TLBIVALE1OS_MASK)
#define	 HFGITR_EL2_TLBIVALE1OS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIVALE1OS_SHIFT)
#define	 HFGITR_EL2_TLBIVALE1OS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVALE1OS_SHIFT)
#define	HFGITR_EL2_TLBIVAAE1OS_SHIFT	21
#define	HFGITR_EL2_TLBIVAAE1OS_MASK	(UL(0x1) << HFGITR_EL2_TLBIVAAE1OS_SHIFT)
#define	HFGITR_EL2_TLBIVAAE1OS_VAL(x)	((x) & HFGITR_EL2_TLBIVAAE1OS_MASK)
#define	 HFGITR_EL2_TLBIVAAE1OS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIVAAE1OS_SHIFT)
#define	 HFGITR_EL2_TLBIVAAE1OS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVAAE1OS_SHIFT)
#define	HFGITR_EL2_TLBIASIDE1OS_SHIFT	20
#define	HFGITR_EL2_TLBIASIDE1OS_MASK	(UL(0x1) << HFGITR_EL2_TLBIASIDE1OS_SHIFT)
#define	HFGITR_EL2_TLBIASIDE1OS_VAL(x)	((x) & HFGITR_EL2_TLBIASIDE1OS_MASK)
#define	 HFGITR_EL2_TLBIASIDE1OS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIASIDE1OS_SHIFT)
#define	 HFGITR_EL2_TLBIASIDE1OS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIASIDE1OS_SHIFT)
#define	HFGITR_EL2_TLBIVAE1OS_SHIFT	19
#define	HFGITR_EL2_TLBIVAE1OS_MASK	(UL(0x1) << HFGITR_EL2_TLBIVAE1OS_SHIFT)
#define	HFGITR_EL2_TLBIVAE1OS_VAL(x)	((x) & HFGITR_EL2_TLBIVAE1OS_MASK)
#define	 HFGITR_EL2_TLBIVAE1OS_NOTRAP	(UL(0x0) << HFGITR_EL2_TLBIVAE1OS_SHIFT)
#define	 HFGITR_EL2_TLBIVAE1OS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVAE1OS_SHIFT)
#define	HFGITR_EL2_TLBIVMALLE1OS_SHIFT	18
#define	HFGITR_EL2_TLBIVMALLE1OS_MASK	(UL(0x1) << HFGITR_EL2_TLBIVMALLE1OS_SHIFT)
#define	HFGITR_EL2_TLBIVMALLE1OS_VAL(x)	((x) & HFGITR_EL2_TLBIVMALLE1OS_MASK)
#define	 HFGITR_EL2_TLBIVMALLE1OS_NOTRAP (UL(0x0) << HFGITR_EL2_TLBIVMALLE1OS_SHIFT)
#define	 HFGITR_EL2_TLBIVMALLE1OS_TRAP	(UL(0x1) << HFGITR_EL2_TLBIVMALLE1OS_SHIFT)
#define	HFGITR_EL2_ATS1E1WP_SHIFT	17
#define	HFGITR_EL2_ATS1E1WP_MASK	(UL(0x1) << HFGITR_EL2_ATS1E1WP_SHIFT)
#define	HFGITR_EL2_ATS1E1WP_VAL(x)	((x) & HFGITR_EL2_ATS1E1WP_MASK)
#define	 HFGITR_EL2_ATS1E1WP_NOTRAP	(UL(0x0) << HFGITR_EL2_ATS1E1WP_SHIFT)
#define	 HFGITR_EL2_ATS1E1WP_TRAP	(UL(0x1) << HFGITR_EL2_ATS1E1WP_SHIFT)
#define	HFGITR_EL2_ATS1E1RP_SHIFT	16
#define	HFGITR_EL2_ATS1E1RP_MASK	(UL(0x1) << HFGITR_EL2_ATS1E1RP_SHIFT)
#define	HFGITR_EL2_ATS1E1RP_VAL(x)	((x) & HFGITR_EL2_ATS1E1RP_MASK)
#define	 HFGITR_EL2_ATS1E1RP_NOTRAP	(UL(0x0) << HFGITR_EL2_ATS1E1RP_SHIFT)
#define	 HFGITR_EL2_ATS1E1RP_TRAP	(UL(0x1) << HFGITR_EL2_ATS1E1RP_SHIFT)
#define	HFGITR_EL2_ATS1E0W_SHIFT	15
#define	HFGITR_EL2_ATS1E0W_MASK		(UL(0x1) << HFGITR_EL2_ATS1E0W_SHIFT)
#define	HFGITR_EL2_ATS1E0W_VAL(x)	((x) & HFGITR_EL2_ATS1E0W_MASK)
#define	 HFGITR_EL2_ATS1E0W_NOTRAP	(UL(0x0) << HFGITR_EL2_ATS1E0W_SHIFT)
#define	 HFGITR_EL2_ATS1E0W_TRAP	(UL(0x1) << HFGITR_EL2_ATS1E0W_SHIFT)
#define	HFGITR_EL2_ATS1E0R_SHIFT	14
#define	HFGITR_EL2_ATS1E0R_MASK		(UL(0x1) << HFGITR_EL2_ATS1E0R_SHIFT)
#define	HFGITR_EL2_ATS1E0R_VAL(x)	((x) & HFGITR_EL2_ATS1E0R_MASK)
#define	 HFGITR_EL2_ATS1E0R_NOTRAP	(UL(0x0) << HFGITR_EL2_ATS1E0R_SHIFT)
#define	 HFGITR_EL2_ATS1E0R_TRAP	(UL(0x1) << HFGITR_EL2_ATS1E0R_SHIFT)
#define	HFGITR_EL2_ATS1E1W_SHIFT	13
#define	HFGITR_EL2_ATS1E1W_MASK		(UL(0x1) << HFGITR_EL2_ATS1E1W_SHIFT)
#define	HFGITR_EL2_ATS1E1W_VAL(x)	((x) & HFGITR_EL2_ATS1E1W_MASK)
#define	 HFGITR_EL2_ATS1E1W_NOTRAP	(UL(0x0) << HFGITR_EL2_ATS1E1W_SHIFT)
#define	 HFGITR_EL2_ATS1E1W_TRAP	(UL(0x1) << HFGITR_EL2_ATS1E1W_SHIFT)
#define	HFGITR_EL2_ATS1E1R_SHIFT	12
#define	HFGITR_EL2_ATS1E1R_MASK		(UL(0x1) << HFGITR_EL2_ATS1E1R_SHIFT)
#define	HFGITR_EL2_ATS1E1R_VAL(x)	((x) & HFGITR_EL2_ATS1E1R_MASK)
#define	 HFGITR_EL2_ATS1E1R_NOTRAP	(UL(0x0) << HFGITR_EL2_ATS1E1R_SHIFT)
#define	 HFGITR_EL2_ATS1E1R_TRAP	(UL(0x1) << HFGITR_EL2_ATS1E1R_SHIFT)
#define	HFGITR_EL2_DCZVA_SHIFT		11
#define	HFGITR_EL2_DCZVA_MASK		(UL(0x1) << HFGITR_EL2_DCZVA_SHIFT)
#define	HFGITR_EL2_DCZVA_VAL(x)		((x) & HFGITR_EL2_DCZVA_MASK)
#define	 HFGITR_EL2_DCZVA_NOTRAP	(UL(0x0) << HFGITR_EL2_DCZVA_SHIFT)
#define	 HFGITR_EL2_DCZVA_TRAP		(UL(0x1) << HFGITR_EL2_DCZVA_SHIFT)
#define	HFGITR_EL2_DCCIVAC_SHIFT	10
#define	HFGITR_EL2_DCCIVAC_MASK		(UL(0x1) << HFGITR_EL2_DCCIVAC_SHIFT)
#define	HFGITR_EL2_DCCIVAC_VAL(x)	((x) & HFGITR_EL2_DCCIVAC_MASK)
#define	 HFGITR_EL2_DCCIVAC_NOTRAP	(UL(0x0) << HFGITR_EL2_DCCIVAC_SHIFT)
#define	 HFGITR_EL2_DCCIVAC_TRAP	(UL(0x1) << HFGITR_EL2_DCCIVAC_SHIFT)
#define	HFGITR_EL2_DCCVADP_SHIFT	9
#define	HFGITR_EL2_DCCVADP_MASK		(UL(0x1) << HFGITR_EL2_DCCVADP_SHIFT)
#define	HFGITR_EL2_DCCVADP_VAL(x)	((x) & HFGITR_EL2_DCCVADP_MASK)
#define	 HFGITR_EL2_DCCVADP_NOTRAP	(UL(0x0) << HFGITR_EL2_DCCVADP_SHIFT)
#define	 HFGITR_EL2_DCCVADP_TRAP	(UL(0x1) << HFGITR_EL2_DCCVADP_SHIFT)
#define	HFGITR_EL2_DCCVAP_SHIFT		8
#define	HFGITR_EL2_DCCVAP_MASK		(UL(0x1) << HFGITR_EL2_DCCVAP_SHIFT)
#define	HFGITR_EL2_DCCVAP_VAL(x)	((x) & HFGITR_EL2_DCCVAP_MASK)
#define	 HFGITR_EL2_DCCVAP_NOTRAP	(UL(0x0) << HFGITR_EL2_DCCVAP_SHIFT)
#define	 HFGITR_EL2_DCCVAP_TRAP		(UL(0x1) << HFGITR_EL2_DCCVAP_SHIFT)
#define	HFGITR_EL2_DCCVAU_SHIFT		7
#define	HFGITR_EL2_DCCVAU_MASK		(UL(0x1) << HFGITR_EL2_DCCVAU_SHIFT)
#define	HFGITR_EL2_DCCVAU_VAL(x)	((x) & HFGITR_EL2_DCCVAU_MASK)
#define	 HFGITR_EL2_DCCVAU_NOTRAP	(UL(0x0) << HFGITR_EL2_DCCVAU_SHIFT)
#define	 HFGITR_EL2_DCCVAU_TRAP		(UL(0x1) << HFGITR_EL2_DCCVAU_SHIFT)
#define	HFGITR_EL2_DCCISW_SHIFT		6
#define	HFGITR_EL2_DCCISW_MASK		(UL(0x1) << HFGITR_EL2_DCCISW_SHIFT)
#define	HFGITR_EL2_DCCISW_VAL(x)	((x) & HFGITR_EL2_DCCISW_MASK)
#define	 HFGITR_EL2_DCCISW_NOTRAP	(UL(0x0) << HFGITR_EL2_DCCISW_SHIFT)
#define	 HFGITR_EL2_DCCISW_TRAP		(UL(0x1) << HFGITR_EL2_DCCISW_SHIFT)
#define	HFGITR_EL2_DCCSW_SHIFT		5
#define	HFGITR_EL2_DCCSW_MASK		(UL(0x1) << HFGITR_EL2_DCCSW_SHIFT)
#define	HFGITR_EL2_DCCSW_VAL(x)		((x) & HFGITR_EL2_DCCSW_MASK)
#define	 HFGITR_EL2_DCCSW_NOTRAP	(UL(0x0) << HFGITR_EL2_DCCSW_SHIFT)
#define	 HFGITR_EL2_DCCSW_TRAP		(UL(0x1) << HFGITR_EL2_DCCSW_SHIFT)
#define	HFGITR_EL2_DCISW_SHIFT		4
#define	HFGITR_EL2_DCISW_MASK		(UL(0x1) << HFGITR_EL2_DCISW_SHIFT)
#define	HFGITR_EL2_DCISW_VAL(x)		((x) & HFGITR_EL2_DCISW_MASK)
#define	 HFGITR_EL2_DCISW_NOTRAP	(UL(0x0) << HFGITR_EL2_DCISW_SHIFT)
#define	 HFGITR_EL2_DCISW_TRAP		(UL(0x1) << HFGITR_EL2_DCISW_SHIFT)
#define	HFGITR_EL2_DCIVAC_SHIFT		3
#define	HFGITR_EL2_DCIVAC_MASK		(UL(0x1) << HFGITR_EL2_DCIVAC_SHIFT)
#define	HFGITR_EL2_DCIVAC_VAL(x)	((x) & HFGITR_EL2_DCIVAC_MASK)
#define	 HFGITR_EL2_DCIVAC_NOTRAP	(UL(0x0) << HFGITR_EL2_DCIVAC_SHIFT)
#define	 HFGITR_EL2_DCIVAC_TRAP		(UL(0x1) << HFGITR_EL2_DCIVAC_SHIFT)
#define	HFGITR_EL2_ICIVAU_SHIFT		2
#define	HFGITR_EL2_ICIVAU_MASK		(UL(0x1) << HFGITR_EL2_ICIVAU_SHIFT)
#define	HFGITR_EL2_ICIVAU_VAL(x)	((x) & HFGITR_EL2_ICIVAU_MASK)
#define	 HFGITR_EL2_ICIVAU_NOTRAP	(UL(0x0) << HFGITR_EL2_ICIVAU_SHIFT)
#define	 HFGITR_EL2_ICIVAU_TRAP		(UL(0x1) << HFGITR_EL2_ICIVAU_SHIFT)
#define	HFGITR_EL2_ICIALLU_SHIFT	1
#define	HFGITR_EL2_ICIALLU_MASK		(UL(0x1) << HFGITR_EL2_ICIALLU_SHIFT)
#define	HFGITR_EL2_ICIALLU_VAL(x)	((x) & HFGITR_EL2_ICIALLU_MASK)
#define	 HFGITR_EL2_ICIALLU_NOTRAP	(UL(0x0) << HFGITR_EL2_ICIALLU_SHIFT)
#define	 HFGITR_EL2_ICIALLU_TRAP	(UL(0x1) << HFGITR_EL2_ICIALLU_SHIFT)
#define	HFGITR_EL2_ICIALLUIS_SHIFT	0
#define	HFGITR_EL2_ICIALLUIS_MASK	(UL(0x1) << HFGITR_EL2_ICIALLUIS_SHIFT)
#define	HFGITR_EL2_ICIALLUIS_VAL(x)	((x) & HFGITR_EL2_ICIALLUIS_MASK)
#define	 HFGITR_EL2_ICIALLUIS_NOTRAP	(UL(0x0) << HFGITR_EL2_ICIALLUIS_SHIFT)
#define	 HFGITR_EL2_ICIALLUIS_TRAP	(UL(0x1) << HFGITR_EL2_ICIALLUIS_SHIFT)

/* HFGRTR2_EL2 */
#define	HFGRTR2_EL2_REG			MRS_REG_ALT_NAME(HFGRTR2_EL2)
#define	HFGRTR2_EL2_op0			3
#define	HFGRTR2_EL2_op1			4
#define	HFGRTR2_EL2_CRn			3
#define	HFGRTR2_EL2_CRm			1
#define	HFGRTR2_EL2_op2			2
#define	HFGRTR2_EL2_nRCWSMASK_EL1_SHIFT	2
#define	HFGRTR2_EL2_nRCWSMASK_EL1_MASK	(UL(0x1) << HFGRTR2_EL2_nRCWSMASK_EL1_SHIFT)
#define	HFGRTR2_EL2_nRCWSMASK_EL1_VAL(x) ((x) & HFGRTR2_EL2_nRCWSMASK_EL1_MASK)
#define	 HFGRTR2_EL2_nRCWSMASK_EL1_TRAP	(UL(0x0) << HFGRTR2_EL2_nRCWSMASK_EL1_SHIFT)
#define	 HFGRTR2_EL2_nRCWSMASK_EL1_NOTRAP (UL(0x1) << HFGRTR2_EL2_nRCWSMASK_EL1_SHIFT)
#define	HFGRTR2_EL2_nERXGSR_EL1_SHIFT	1
#define	HFGRTR2_EL2_nERXGSR_EL1_MASK	(UL(0x1) << HFGRTR2_EL2_nERXGSR_EL1_SHIFT)
#define	HFGRTR2_EL2_nERXGSR_EL1_VAL(x)	((x) & HFGRTR2_EL2_nERXGSR_EL1_MASK)
#define	 HFGRTR2_EL2_nERXGSR_EL1_TRAP	(UL(0x0) << HFGRTR2_EL2_nERXGSR_EL1_SHIFT)
#define	 HFGRTR2_EL2_nERXGSR_EL1_NOTRAP	(UL(0x1) << HFGRTR2_EL2_nERXGSR_EL1_SHIFT)
#define	HFGRTR2_EL2_nPFAR_EL1_SHIFT	0
#define	HFGRTR2_EL2_nPFAR_EL1_MASK	(UL(0x1) << HFGRTR2_EL2_nPFAR_EL1_SHIFT)
#define	HFGRTR2_EL2_nPFAR_EL1_VAL(x)	((x) & HFGRTR2_EL2_nPFAR_EL1_MASK)
#define	 HFGRTR2_EL2_nPFAR_EL1_TRAP	(UL(0x0) << HFGRTR2_EL2_nPFAR_EL1_SHIFT)
#define	 HFGRTR2_EL2_nPFAR_EL1_NOTRAP	(UL(0x1) << HFGRTR2_EL2_nPFAR_EL1_SHIFT)

/* HFGRTR_EL2 */
#define	HFGRTR_EL2_REG			MRS_REG_ALT_NAME(HFGRTR_EL2)
#define	HFGRTR_EL2_op0			3
#define	HFGRTR_EL2_op1			4
#define	HFGRTR_EL2_CRn			1
#define	HFGRTR_EL2_CRm			1
#define	HFGRTR_EL2_op2			4
#define	HFGRTR_EL2_nAMAIR2_EL1_SHIFT	63
#define	HFGRTR_EL2_nAMAIR2_EL1_MASK	(UL(0x1) << HFGRTR_EL2_nAMAIR2_EL1_SHIFT)
#define	HFGRTR_EL2_nAMAIR2_EL1_VAL(x)	((x) & HFGRTR_EL2_nAMAIR2_EL1_MASK)
#define	 HFGRTR_EL2_nAMAIR2_EL1_TRAP	(UL(0x0) << HFGRTR_EL2_nAMAIR2_EL1_SHIFT)
#define	 HFGRTR_EL2_nAMAIR2_EL1_NOTRAP	(UL(0x1) << HFGRTR_EL2_nAMAIR2_EL1_SHIFT)
#define	HFGRTR_EL2_nMAIR2_EL1_SHIFT	62
#define	HFGRTR_EL2_nMAIR2_EL1_MASK	(UL(0x1) << HFGRTR_EL2_nMAIR2_EL1_SHIFT)
#define	HFGRTR_EL2_nMAIR2_EL1_VAL(x)	((x) & HFGRTR_EL2_nMAIR2_EL1_MASK)
#define	 HFGRTR_EL2_nMAIR2_EL1_TRAP	(UL(0x0) << HFGRTR_EL2_nMAIR2_EL1_SHIFT)
#define	 HFGRTR_EL2_nMAIR2_EL1_NOTRAP	(UL(0x1) << HFGRTR_EL2_nMAIR2_EL1_SHIFT)
#define	HFGRTR_EL2_nS2POR_EL1_SHIFT	61
#define	HFGRTR_EL2_nS2POR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_nS2POR_EL1_SHIFT)
#define	HFGRTR_EL2_nS2POR_EL1_VAL(x)	((x) & HFGRTR_EL2_nS2POR_EL1_MASK)
#define	 HFGRTR_EL2_nS2POR_EL1_TRAP	(UL(0x0) << HFGRTR_EL2_nS2POR_EL1_SHIFT)
#define	 HFGRTR_EL2_nS2POR_EL1_NOTRAP	(UL(0x1) << HFGRTR_EL2_nS2POR_EL1_SHIFT)
#define	HFGRTR_EL2_nPOR_EL1_SHIFT	60
#define	HFGRTR_EL2_nPOR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_nPOR_EL1_SHIFT)
#define	HFGRTR_EL2_nPOR_EL1_VAL(x)	((x) & HFGRTR_EL2_nPOR_EL1_MASK)
#define	 HFGRTR_EL2_nPOR_EL1_TRAP	(UL(0x0) << HFGRTR_EL2_nPOR_EL1_SHIFT)
#define	 HFGRTR_EL2_nPOR_EL1_NOTRAP	(UL(0x1) << HFGRTR_EL2_nPOR_EL1_SHIFT)
#define	HFGRTR_EL2_nPOR_EL0_SHIFT	59
#define	HFGRTR_EL2_nPOR_EL0_MASK	(UL(0x1) << HFGRTR_EL2_nPOR_EL0_SHIFT)
#define	HFGRTR_EL2_nPOR_EL0_VAL(x)	((x) & HFGRTR_EL2_nPOR_EL0_MASK)
#define	 HFGRTR_EL2_nPOR_EL0_TRAP	(UL(0x0) << HFGRTR_EL2_nPOR_EL0_SHIFT)
#define	 HFGRTR_EL2_nPOR_EL0_NOTRAP	(UL(0x1) << HFGRTR_EL2_nPOR_EL0_SHIFT)
#define	HFGRTR_EL2_nPIR_EL1_SHIFT	58
#define	HFGRTR_EL2_nPIR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_nPIR_EL1_SHIFT)
#define	HFGRTR_EL2_nPIR_EL1_VAL(x)	((x) & HFGRTR_EL2_nPIR_EL1_MASK)
#define	 HFGRTR_EL2_nPIR_EL1_TRAP	(UL(0x0) << HFGRTR_EL2_nPIR_EL1_SHIFT)
#define	 HFGRTR_EL2_nPIR_EL1_NOTRAP	(UL(0x1) << HFGRTR_EL2_nPIR_EL1_SHIFT)
#define	HFGRTR_EL2_nPIRE0_EL1_SHIFT	57
#define	HFGRTR_EL2_nPIRE0_EL1_MASK	(UL(0x1) << HFGRTR_EL2_nPIRE0_EL1_SHIFT)
#define	HFGRTR_EL2_nPIRE0_EL1_VAL(x)	((x) & HFGRTR_EL2_nPIRE0_EL1_MASK)
#define	 HFGRTR_EL2_nPIRE0_EL1_TRAP	(UL(0x0) << HFGRTR_EL2_nPIRE0_EL1_SHIFT)
#define	 HFGRTR_EL2_nPIRE0_EL1_NOTRAP	(UL(0x1) << HFGRTR_EL2_nPIRE0_EL1_SHIFT)
#define	HFGRTR_EL2_nRCWMASK_EL1_SHIFT	56
#define	HFGRTR_EL2_nRCWMASK_EL1_MASK	(UL(0x1) << HFGRTR_EL2_nRCWMASK_EL1_SHIFT)
#define	HFGRTR_EL2_nRCWMASK_EL1_VAL(x)	((x) & HFGRTR_EL2_nRCWMASK_EL1_MASK)
#define	 HFGRTR_EL2_nRCWMASK_EL1_TRAP	(UL(0x0) << HFGRTR_EL2_nRCWMASK_EL1_SHIFT)
#define	 HFGRTR_EL2_nRCWMASK_EL1_NOTRAP	(UL(0x1) << HFGRTR_EL2_nRCWMASK_EL1_SHIFT)
#define	HFGRTR_EL2_nTPIDR2_EL0_SHIFT	55
#define	HFGRTR_EL2_nTPIDR2_EL0_MASK	(UL(0x1) << HFGRTR_EL2_nTPIDR2_EL0_SHIFT)
#define	HFGRTR_EL2_nTPIDR2_EL0_VAL(x)	((x) & HFGRTR_EL2_nTPIDR2_EL0_MASK)
#define	 HFGRTR_EL2_nTPIDR2_EL0_TRAP	(UL(0x0) << HFGRTR_EL2_nTPIDR2_EL0_SHIFT)
#define	 HFGRTR_EL2_nTPIDR2_EL0_NOTRAP	(UL(0x1) << HFGRTR_EL2_nTPIDR2_EL0_SHIFT)
#define	HFGRTR_EL2_nSMPRI_EL1_SHIFT	54
#define	HFGRTR_EL2_nSMPRI_EL1_MASK	(UL(0x1) << HFGRTR_EL2_nSMPRI_EL1_SHIFT)
#define	HFGRTR_EL2_nSMPRI_EL1_VAL(x)	((x) & HFGRTR_EL2_nSMPRI_EL1_MASK)
#define	 HFGRTR_EL2_nSMPRI_EL1_TRAP	(UL(0x0) << HFGRTR_EL2_nSMPRI_EL1_SHIFT)
#define	 HFGRTR_EL2_nSMPRI_EL1_NOTRAP	(UL(0x1) << HFGRTR_EL2_nSMPRI_EL1_SHIFT)
#define	HFGRTR_EL2_nGCS_EL1_SHIFT	53
#define	HFGRTR_EL2_nGCS_EL1_MASK	(UL(0x1) << HFGRTR_EL2_nGCS_EL1_SHIFT)
#define	HFGRTR_EL2_nGCS_EL1_VAL(x)	((x) & HFGRTR_EL2_nGCS_EL1_MASK)
#define	 HFGRTR_EL2_nGCS_EL1_TRAP	(UL(0x0) << HFGRTR_EL2_nGCS_EL1_SHIFT)
#define	 HFGRTR_EL2_nGCS_EL1_NOTRAP	(UL(0x1) << HFGRTR_EL2_nGCS_EL1_SHIFT)
#define	HFGRTR_EL2_nGCS_EL0_SHIFT	52
#define	HFGRTR_EL2_nGCS_EL0_MASK	(UL(0x1) << HFGRTR_EL2_nGCS_EL0_SHIFT)
#define	HFGRTR_EL2_nGCS_EL0_VAL(x)	((x) & HFGRTR_EL2_nGCS_EL0_MASK)
#define	 HFGRTR_EL2_nGCS_EL0_TRAP	(UL(0x0) << HFGRTR_EL2_nGCS_EL0_SHIFT)
#define	 HFGRTR_EL2_nGCS_EL0_NOTRAP	(UL(0x1) << HFGRTR_EL2_nGCS_EL0_SHIFT)
#define	HFGRTR_EL2_nACCDATA_EL1_SHIFT	50
#define	HFGRTR_EL2_nACCDATA_EL1_MASK	(UL(0x1) << HFGRTR_EL2_nACCDATA_EL1_SHIFT)
#define	HFGRTR_EL2_nACCDATA_EL1_VAL(x)	((x) & HFGRTR_EL2_nACCDATA_EL1_MASK)
#define	 HFGRTR_EL2_nACCDATA_EL1_TRAP	(UL(0x0) << HFGRTR_EL2_nACCDATA_EL1_SHIFT)
#define	 HFGRTR_EL2_nACCDATA_EL1_NOTRAP	(UL(0x1) << HFGRTR_EL2_nACCDATA_EL1_SHIFT)
#define	HFGRTR_EL2_ERXADDR_EL1_SHIFT	49
#define	HFGRTR_EL2_ERXADDR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_ERXADDR_EL1_SHIFT)
#define	HFGRTR_EL2_ERXADDR_EL1_VAL(x)	((x) & HFGRTR_EL2_ERXADDR_EL1_MASK)
#define	 HFGRTR_EL2_ERXADDR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_ERXADDR_EL1_SHIFT)
#define	 HFGRTR_EL2_ERXADDR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_ERXADDR_EL1_SHIFT)
#define	HFGRTR_EL2_ERXPFGCDN_EL1_SHIFT	48
#define	HFGRTR_EL2_ERXPFGCDN_EL1_MASK	(UL(0x1) << HFGRTR_EL2_ERXPFGCDN_EL1_SHIFT)
#define	HFGRTR_EL2_ERXPFGCDN_EL1_VAL(x)	((x) & HFGRTR_EL2_ERXPFGCDN_EL1_MASK)
#define	 HFGRTR_EL2_ERXPFGCDN_EL1_NOTRAP (UL(0x0) << HFGRTR_EL2_ERXPFGCDN_EL1_SHIFT)
#define	 HFGRTR_EL2_ERXPFGCDN_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_ERXPFGCDN_EL1_SHIFT)
#define	HFGRTR_EL2_ERXPFGCTL_EL1_SHIFT	47
#define	HFGRTR_EL2_ERXPFGCTL_EL1_MASK	(UL(0x1) << HFGRTR_EL2_ERXPFGCTL_EL1_SHIFT)
#define	HFGRTR_EL2_ERXPFGCTL_EL1_VAL(x)	((x) & HFGRTR_EL2_ERXPFGCTL_EL1_MASK)
#define	 HFGRTR_EL2_ERXPFGCTL_EL1_NOTRAP (UL(0x0) << HFGRTR_EL2_ERXPFGCTL_EL1_SHIFT)
#define	 HFGRTR_EL2_ERXPFGCTL_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_ERXPFGCTL_EL1_SHIFT)
#define	HFGRTR_EL2_ERXPFGF_EL1_SHIFT	46
#define	HFGRTR_EL2_ERXPFGF_EL1_MASK	(UL(0x1) << HFGRTR_EL2_ERXPFGF_EL1_SHIFT)
#define	HFGRTR_EL2_ERXPFGF_EL1_VAL(x)	((x) & HFGRTR_EL2_ERXPFGF_EL1_MASK)
#define	 HFGRTR_EL2_ERXPFGF_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_ERXPFGF_EL1_SHIFT)
#define	 HFGRTR_EL2_ERXPFGF_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_ERXPFGF_EL1_SHIFT)
#define	HFGRTR_EL2_ERXMISCn_EL1_SHIFT	45
#define	HFGRTR_EL2_ERXMISCn_EL1_MASK	(UL(0x1) << HFGRTR_EL2_ERXMISCn_EL1_SHIFT)
#define	HFGRTR_EL2_ERXMISCn_EL1_VAL(x)	((x) & HFGRTR_EL2_ERXMISCn_EL1_MASK)
#define	 HFGRTR_EL2_ERXMISCn_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_ERXMISCn_EL1_SHIFT)
#define	 HFGRTR_EL2_ERXMISCn_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_ERXMISCn_EL1_SHIFT)
#define	HFGRTR_EL2_ERXSTATUS_EL1_SHIFT	44
#define	HFGRTR_EL2_ERXSTATUS_EL1_MASK	(UL(0x1) << HFGRTR_EL2_ERXSTATUS_EL1_SHIFT)
#define	HFGRTR_EL2_ERXSTATUS_EL1_VAL(x)	((x) & HFGRTR_EL2_ERXSTATUS_EL1_MASK)
#define	 HFGRTR_EL2_ERXSTATUS_EL1_NOTRAP (UL(0x0) << HFGRTR_EL2_ERXSTATUS_EL1_SHIFT)
#define	 HFGRTR_EL2_ERXSTATUS_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_ERXSTATUS_EL1_SHIFT)
#define	HFGRTR_EL2_ERXCTLR_EL1_SHIFT	43
#define	HFGRTR_EL2_ERXCTLR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_ERXCTLR_EL1_SHIFT)
#define	HFGRTR_EL2_ERXCTLR_EL1_VAL(x)	((x) & HFGRTR_EL2_ERXCTLR_EL1_MASK)
#define	 HFGRTR_EL2_ERXCTLR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_ERXCTLR_EL1_SHIFT)
#define	 HFGRTR_EL2_ERXCTLR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_ERXCTLR_EL1_SHIFT)
#define	HFGRTR_EL2_ERXFR_EL1_SHIFT	42
#define	HFGRTR_EL2_ERXFR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_ERXFR_EL1_SHIFT)
#define	HFGRTR_EL2_ERXFR_EL1_VAL(x)	((x) & HFGRTR_EL2_ERXFR_EL1_MASK)
#define	 HFGRTR_EL2_ERXFR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_ERXFR_EL1_SHIFT)
#define	 HFGRTR_EL2_ERXFR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_ERXFR_EL1_SHIFT)
#define	HFGRTR_EL2_ERRSELR_EL1_SHIFT	41
#define	HFGRTR_EL2_ERRSELR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_ERRSELR_EL1_SHIFT)
#define	HFGRTR_EL2_ERRSELR_EL1_VAL(x)	((x) & HFGRTR_EL2_ERRSELR_EL1_MASK)
#define	 HFGRTR_EL2_ERRSELR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_ERRSELR_EL1_SHIFT)
#define	 HFGRTR_EL2_ERRSELR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_ERRSELR_EL1_SHIFT)
#define	HFGRTR_EL2_ERRIDR_EL1_SHIFT	40
#define	HFGRTR_EL2_ERRIDR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_ERRIDR_EL1_SHIFT)
#define	HFGRTR_EL2_ERRIDR_EL1_VAL(x)	((x) & HFGRTR_EL2_ERRIDR_EL1_MASK)
#define	 HFGRTR_EL2_ERRIDR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_ERRIDR_EL1_SHIFT)
#define	 HFGRTR_EL2_ERRIDR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_ERRIDR_EL1_SHIFT)
#define	HFGRTR_EL2_ICC_IGRPENn_EL1_SHIFT 39
#define	HFGRTR_EL2_ICC_IGRPENn_EL1_MASK	(UL(0x1) << HFGRTR_EL2_ICC_IGRPENn_EL1_SHIFT)
#define	HFGRTR_EL2_ICC_IGRPENn_EL1_VAL(x) ((x) & HFGRTR_EL2_ICC_IGRPENn_EL1_MASK)
#define	 HFGRTR_EL2_ICC_IGRPENn_EL1_NOTRAP (UL(0x0) << HFGRTR_EL2_ICC_IGRPENn_EL1_SHIFT)
#define	 HFGRTR_EL2_ICC_IGRPENn_EL1_TRAP (UL(0x1) << HFGRTR_EL2_ICC_IGRPENn_EL1_SHIFT)
#define	HFGRTR_EL2_VBAR_EL1_SHIFT	38
#define	HFGRTR_EL2_VBAR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_VBAR_EL1_SHIFT)
#define	HFGRTR_EL2_VBAR_EL1_VAL(x)	((x) & HFGRTR_EL2_VBAR_EL1_MASK)
#define	 HFGRTR_EL2_VBAR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_VBAR_EL1_SHIFT)
#define	 HFGRTR_EL2_VBAR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_VBAR_EL1_SHIFT)
#define	HFGRTR_EL2_TTBR1_EL1_SHIFT	37
#define	HFGRTR_EL2_TTBR1_EL1_MASK	(UL(0x1) << HFGRTR_EL2_TTBR1_EL1_SHIFT)
#define	HFGRTR_EL2_TTBR1_EL1_VAL(x)	((x) & HFGRTR_EL2_TTBR1_EL1_MASK)
#define	 HFGRTR_EL2_TTBR1_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_TTBR1_EL1_SHIFT)
#define	 HFGRTR_EL2_TTBR1_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_TTBR1_EL1_SHIFT)
#define	HFGRTR_EL2_TTBR0_EL1_SHIFT	36
#define	HFGRTR_EL2_TTBR0_EL1_MASK	(UL(0x1) << HFGRTR_EL2_TTBR0_EL1_SHIFT)
#define	HFGRTR_EL2_TTBR0_EL1_VAL(x)	((x) & HFGRTR_EL2_TTBR0_EL1_MASK)
#define	 HFGRTR_EL2_TTBR0_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_TTBR0_EL1_SHIFT)
#define	 HFGRTR_EL2_TTBR0_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_TTBR0_EL1_SHIFT)
#define	HFGRTR_EL2_TPIDR_EL0_SHIFT	35
#define	HFGRTR_EL2_TPIDR_EL0_MASK	(UL(0x1) << HFGRTR_EL2_TPIDR_EL0_SHIFT)
#define	HFGRTR_EL2_TPIDR_EL0_VAL(x)	((x) & HFGRTR_EL2_TPIDR_EL0_MASK)
#define	 HFGRTR_EL2_TPIDR_EL0_NOTRAP	(UL(0x0) << HFGRTR_EL2_TPIDR_EL0_SHIFT)
#define	 HFGRTR_EL2_TPIDR_EL0_TRAP	(UL(0x1) << HFGRTR_EL2_TPIDR_EL0_SHIFT)
#define	HFGRTR_EL2_TPIDRRO_EL0_SHIFT	34
#define	HFGRTR_EL2_TPIDRRO_EL0_MASK	(UL(0x1) << HFGRTR_EL2_TPIDRRO_EL0_SHIFT)
#define	HFGRTR_EL2_TPIDRRO_EL0_VAL(x)	((x) & HFGRTR_EL2_TPIDRRO_EL0_MASK)
#define	 HFGRTR_EL2_TPIDRRO_EL0_NOTRAP	(UL(0x0) << HFGRTR_EL2_TPIDRRO_EL0_SHIFT)
#define	 HFGRTR_EL2_TPIDRRO_EL0_TRAP	(UL(0x1) << HFGRTR_EL2_TPIDRRO_EL0_SHIFT)
#define	HFGRTR_EL2_TPIDR_EL1_SHIFT	33
#define	HFGRTR_EL2_TPIDR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_TPIDR_EL1_SHIFT)
#define	HFGRTR_EL2_TPIDR_EL1_VAL(x)	((x) & HFGRTR_EL2_TPIDR_EL1_MASK)
#define	 HFGRTR_EL2_TPIDR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_TPIDR_EL1_SHIFT)
#define	 HFGRTR_EL2_TPIDR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_TPIDR_EL1_SHIFT)
#define	HFGRTR_EL2_TCR_EL1_SHIFT	32
#define	HFGRTR_EL2_TCR_EL1_MASK		(UL(0x1) << HFGRTR_EL2_TCR_EL1_SHIFT)
#define	HFGRTR_EL2_TCR_EL1_VAL(x)	((x) & HFGRTR_EL2_TCR_EL1_MASK)
#define	 HFGRTR_EL2_TCR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_TCR_EL1_SHIFT)
#define	 HFGRTR_EL2_TCR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_TCR_EL1_SHIFT)
#define	HFGRTR_EL2_SCXTNUM_EL0_SHIFT	31
#define	HFGRTR_EL2_SCXTNUM_EL0_MASK	(UL(0x1) << HFGRTR_EL2_SCXTNUM_EL0_SHIFT)
#define	HFGRTR_EL2_SCXTNUM_EL0_VAL(x)	((x) & HFGRTR_EL2_SCXTNUM_EL0_MASK)
#define	 HFGRTR_EL2_SCXTNUM_EL0_NOTRAP	(UL(0x0) << HFGRTR_EL2_SCXTNUM_EL0_SHIFT)
#define	 HFGRTR_EL2_SCXTNUM_EL0_TRAP	(UL(0x1) << HFGRTR_EL2_SCXTNUM_EL0_SHIFT)
#define	HFGRTR_EL2_SCXTNUM_EL1_SHIFT	30
#define	HFGRTR_EL2_SCXTNUM_EL1_MASK	(UL(0x1) << HFGRTR_EL2_SCXTNUM_EL1_SHIFT)
#define	HFGRTR_EL2_SCXTNUM_EL1_VAL(x)	((x) & HFGRTR_EL2_SCXTNUM_EL1_MASK)
#define	 HFGRTR_EL2_SCXTNUM_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_SCXTNUM_EL1_SHIFT)
#define	 HFGRTR_EL2_SCXTNUM_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_SCXTNUM_EL1_SHIFT)
#define	HFGRTR_EL2_SCTLR_EL1_SHIFT	29
#define	HFGRTR_EL2_SCTLR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_SCTLR_EL1_SHIFT)
#define	HFGRTR_EL2_SCTLR_EL1_VAL(x)	((x) & HFGRTR_EL2_SCTLR_EL1_MASK)
#define	 HFGRTR_EL2_SCTLR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_SCTLR_EL1_SHIFT)
#define	 HFGRTR_EL2_SCTLR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_SCTLR_EL1_SHIFT)
#define	HFGRTR_EL2_REVIDR_EL1_SHIFT	28
#define	HFGRTR_EL2_REVIDR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_REVIDR_EL1_SHIFT)
#define	HFGRTR_EL2_REVIDR_EL1_VAL(x)	((x) & HFGRTR_EL2_REVIDR_EL1_MASK)
#define	 HFGRTR_EL2_REVIDR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_REVIDR_EL1_SHIFT)
#define	 HFGRTR_EL2_REVIDR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_REVIDR_EL1_SHIFT)
#define	HFGRTR_EL2_PAR_EL1_SHIFT	27
#define	HFGRTR_EL2_PAR_EL1_MASK		(UL(0x1) << HFGRTR_EL2_PAR_EL1_SHIFT)
#define	HFGRTR_EL2_PAR_EL1_VAL(x)	((x) & HFGRTR_EL2_PAR_EL1_MASK)
#define	 HFGRTR_EL2_PAR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_PAR_EL1_SHIFT)
#define	 HFGRTR_EL2_PAR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_PAR_EL1_SHIFT)
#define	HFGRTR_EL2_MPIDR_EL1_SHIFT	26
#define	HFGRTR_EL2_MPIDR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_MPIDR_EL1_SHIFT)
#define	HFGRTR_EL2_MPIDR_EL1_VAL(x)	((x) & HFGRTR_EL2_MPIDR_EL1_MASK)
#define	 HFGRTR_EL2_MPIDR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_MPIDR_EL1_SHIFT)
#define	 HFGRTR_EL2_MPIDR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_MPIDR_EL1_SHIFT)
#define	HFGRTR_EL2_MIDR_EL1_SHIFT	25
#define	HFGRTR_EL2_MIDR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_MIDR_EL1_SHIFT)
#define	HFGRTR_EL2_MIDR_EL1_VAL(x)	((x) & HFGRTR_EL2_MIDR_EL1_MASK)
#define	 HFGRTR_EL2_MIDR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_MIDR_EL1_SHIFT)
#define	 HFGRTR_EL2_MIDR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_MIDR_EL1_SHIFT)
#define	HFGRTR_EL2_MAIR_EL1_SHIFT	24
#define	HFGRTR_EL2_MAIR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_MAIR_EL1_SHIFT)
#define	HFGRTR_EL2_MAIR_EL1_VAL(x)	((x) & HFGRTR_EL2_MAIR_EL1_MASK)
#define	 HFGRTR_EL2_MAIR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_MAIR_EL1_SHIFT)
#define	 HFGRTR_EL2_MAIR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_MAIR_EL1_SHIFT)
#define	HFGRTR_EL2_LORSA_EL1_SHIFT	23
#define	HFGRTR_EL2_LORSA_EL1_MASK	(UL(0x1) << HFGRTR_EL2_LORSA_EL1_SHIFT)
#define	HFGRTR_EL2_LORSA_EL1_VAL(x)	((x) & HFGRTR_EL2_LORSA_EL1_MASK)
#define	 HFGRTR_EL2_LORSA_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_LORSA_EL1_SHIFT)
#define	 HFGRTR_EL2_LORSA_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_LORSA_EL1_SHIFT)
#define	HFGRTR_EL2_LORN_EL1_SHIFT	22
#define	HFGRTR_EL2_LORN_EL1_MASK	(UL(0x1) << HFGRTR_EL2_LORN_EL1_SHIFT)
#define	HFGRTR_EL2_LORN_EL1_VAL(x)	((x) & HFGRTR_EL2_LORN_EL1_MASK)
#define	 HFGRTR_EL2_LORN_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_LORN_EL1_SHIFT)
#define	 HFGRTR_EL2_LORN_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_LORN_EL1_SHIFT)
#define	HFGRTR_EL2_LORID_EL1_SHIFT	21
#define	HFGRTR_EL2_LORID_EL1_MASK	(UL(0x1) << HFGRTR_EL2_LORID_EL1_SHIFT)
#define	HFGRTR_EL2_LORID_EL1_VAL(x)	((x) & HFGRTR_EL2_LORID_EL1_MASK)
#define	 HFGRTR_EL2_LORID_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_LORID_EL1_SHIFT)
#define	 HFGRTR_EL2_LORID_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_LORID_EL1_SHIFT)
#define	HFGRTR_EL2_LOREA_EL1_SHIFT	20
#define	HFGRTR_EL2_LOREA_EL1_MASK	(UL(0x1) << HFGRTR_EL2_LOREA_EL1_SHIFT)
#define	HFGRTR_EL2_LOREA_EL1_VAL(x)	((x) & HFGRTR_EL2_LOREA_EL1_MASK)
#define	 HFGRTR_EL2_LOREA_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_LOREA_EL1_SHIFT)
#define	 HFGRTR_EL2_LOREA_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_LOREA_EL1_SHIFT)
#define	HFGRTR_EL2_LORC_EL1_SHIFT	19
#define	HFGRTR_EL2_LORC_EL1_MASK	(UL(0x1) << HFGRTR_EL2_LORC_EL1_SHIFT)
#define	HFGRTR_EL2_LORC_EL1_VAL(x)	((x) & HFGRTR_EL2_LORC_EL1_MASK)
#define	 HFGRTR_EL2_LORC_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_LORC_EL1_SHIFT)
#define	 HFGRTR_EL2_LORC_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_LORC_EL1_SHIFT)
#define	HFGRTR_EL2_ISR_EL1_SHIFT	18
#define	HFGRTR_EL2_ISR_EL1_MASK		(UL(0x1) << HFGRTR_EL2_ISR_EL1_SHIFT)
#define	HFGRTR_EL2_ISR_EL1_VAL(x)	((x) & HFGRTR_EL2_ISR_EL1_MASK)
#define	 HFGRTR_EL2_ISR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_ISR_EL1_SHIFT)
#define	 HFGRTR_EL2_ISR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_ISR_EL1_SHIFT)
#define	HFGRTR_EL2_FAR_EL1_SHIFT	17
#define	HFGRTR_EL2_FAR_EL1_MASK		(UL(0x1) << HFGRTR_EL2_FAR_EL1_SHIFT)
#define	HFGRTR_EL2_FAR_EL1_VAL(x)	((x) & HFGRTR_EL2_FAR_EL1_MASK)
#define	 HFGRTR_EL2_FAR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_FAR_EL1_SHIFT)
#define	 HFGRTR_EL2_FAR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_FAR_EL1_SHIFT)
#define	HFGRTR_EL2_ESR_EL1_SHIFT	16
#define	HFGRTR_EL2_ESR_EL1_MASK		(UL(0x1) << HFGRTR_EL2_ESR_EL1_SHIFT)
#define	HFGRTR_EL2_ESR_EL1_VAL(x)	((x) & HFGRTR_EL2_ESR_EL1_MASK)
#define	 HFGRTR_EL2_ESR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_ESR_EL1_SHIFT)
#define	 HFGRTR_EL2_ESR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_ESR_EL1_SHIFT)
#define	HFGRTR_EL2_DCZID_EL0_SHIFT	15
#define	HFGRTR_EL2_DCZID_EL0_MASK	(UL(0x1) << HFGRTR_EL2_DCZID_EL0_SHIFT)
#define	HFGRTR_EL2_DCZID_EL0_VAL(x)	((x) & HFGRTR_EL2_DCZID_EL0_MASK)
#define	 HFGRTR_EL2_DCZID_EL0_NOTRAP	(UL(0x0) << HFGRTR_EL2_DCZID_EL0_SHIFT)
#define	 HFGRTR_EL2_DCZID_EL0_TRAP	(UL(0x1) << HFGRTR_EL2_DCZID_EL0_SHIFT)
#define	HFGRTR_EL2_CTR_EL0_SHIFT	14
#define	HFGRTR_EL2_CTR_EL0_MASK		(UL(0x1) << HFGRTR_EL2_CTR_EL0_SHIFT)
#define	HFGRTR_EL2_CTR_EL0_VAL(x)	((x) & HFGRTR_EL2_CTR_EL0_MASK)
#define	 HFGRTR_EL2_CTR_EL0_NOTRAP	(UL(0x0) << HFGRTR_EL2_CTR_EL0_SHIFT)
#define	 HFGRTR_EL2_CTR_EL0_TRAP	(UL(0x1) << HFGRTR_EL2_CTR_EL0_SHIFT)
#define	HFGRTR_EL2_CSSELR_EL1_SHIFT	13
#define	HFGRTR_EL2_CSSELR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_CSSELR_EL1_SHIFT)
#define	HFGRTR_EL2_CSSELR_EL1_VAL(x)	((x) & HFGRTR_EL2_CSSELR_EL1_MASK)
#define	 HFGRTR_EL2_CSSELR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_CSSELR_EL1_SHIFT)
#define	 HFGRTR_EL2_CSSELR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_CSSELR_EL1_SHIFT)
#define	HFGRTR_EL2_CPACR_EL1_SHIFT	12
#define	HFGRTR_EL2_CPACR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_CPACR_EL1_SHIFT)
#define	HFGRTR_EL2_CPACR_EL1_VAL(x)	((x) & HFGRTR_EL2_CPACR_EL1_MASK)
#define	 HFGRTR_EL2_CPACR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_CPACR_EL1_SHIFT)
#define	 HFGRTR_EL2_CPACR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_CPACR_EL1_SHIFT)
#define	HFGRTR_EL2_CONTEXTIDR_EL1_SHIFT	11
#define	HFGRTR_EL2_CONTEXTIDR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_CONTEXTIDR_EL1_SHIFT)
#define	HFGRTR_EL2_CONTEXTIDR_EL1_VAL(x) ((x) & HFGRTR_EL2_CONTEXTIDR_EL1_MASK)
#define	 HFGRTR_EL2_CONTEXTIDR_EL1_NOTRAP (UL(0x0) << HFGRTR_EL2_CONTEXTIDR_EL1_SHIFT)
#define	 HFGRTR_EL2_CONTEXTIDR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_CONTEXTIDR_EL1_SHIFT)
#define	HFGRTR_EL2_CLIDR_EL1_SHIFT	10
#define	HFGRTR_EL2_CLIDR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_CLIDR_EL1_SHIFT)
#define	HFGRTR_EL2_CLIDR_EL1_VAL(x)	((x) & HFGRTR_EL2_CLIDR_EL1_MASK)
#define	 HFGRTR_EL2_CLIDR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_CLIDR_EL1_SHIFT)
#define	 HFGRTR_EL2_CLIDR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_CLIDR_EL1_SHIFT)
#define	HFGRTR_EL2_CCSIDR_EL1_SHIFT	9
#define	HFGRTR_EL2_CCSIDR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_CCSIDR_EL1_SHIFT)
#define	HFGRTR_EL2_CCSIDR_EL1_VAL(x)	((x) & HFGRTR_EL2_CCSIDR_EL1_MASK)
#define	 HFGRTR_EL2_CCSIDR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_CCSIDR_EL1_SHIFT)
#define	 HFGRTR_EL2_CCSIDR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_CCSIDR_EL1_SHIFT)
#define	HFGRTR_EL2_APIBKey_SHIFT	8
#define	HFGRTR_EL2_APIBKey_MASK		(UL(0x1) << HFGRTR_EL2_APIBKey_SHIFT)
#define	HFGRTR_EL2_APIBKey_VAL(x)	((x) & HFGRTR_EL2_APIBKey_MASK)
#define	 HFGRTR_EL2_APIBKey_NOTRAP	(UL(0x0) << HFGRTR_EL2_APIBKey_SHIFT)
#define	 HFGRTR_EL2_APIBKey_TRAP	(UL(0x1) << HFGRTR_EL2_APIBKey_SHIFT)
#define	HFGRTR_EL2_APIAKey_SHIFT	7
#define	HFGRTR_EL2_APIAKey_MASK		(UL(0x1) << HFGRTR_EL2_APIAKey_SHIFT)
#define	HFGRTR_EL2_APIAKey_VAL(x)	((x) & HFGRTR_EL2_APIAKey_MASK)
#define	 HFGRTR_EL2_APIAKey_NOTRAP	(UL(0x0) << HFGRTR_EL2_APIAKey_SHIFT)
#define	 HFGRTR_EL2_APIAKey_TRAP	(UL(0x1) << HFGRTR_EL2_APIAKey_SHIFT)
#define	HFGRTR_EL2_APGAKey_SHIFT	6
#define	HFGRTR_EL2_APGAKey_MASK		(UL(0x1) << HFGRTR_EL2_APGAKey_SHIFT)
#define	HFGRTR_EL2_APGAKey_VAL(x)	((x) & HFGRTR_EL2_APGAKey_MASK)
#define	 HFGRTR_EL2_APGAKey_NOTRAP	(UL(0x0) << HFGRTR_EL2_APGAKey_SHIFT)
#define	 HFGRTR_EL2_APGAKey_TRAP	(UL(0x1) << HFGRTR_EL2_APGAKey_SHIFT)
#define	HFGRTR_EL2_APDBKey_SHIFT	5
#define	HFGRTR_EL2_APDBKey_MASK		(UL(0x1) << HFGRTR_EL2_APDBKey_SHIFT)
#define	HFGRTR_EL2_APDBKey_VAL(x)	((x) & HFGRTR_EL2_APDBKey_MASK)
#define	 HFGRTR_EL2_APDBKey_NOTRAP	(UL(0x0) << HFGRTR_EL2_APDBKey_SHIFT)
#define	 HFGRTR_EL2_APDBKey_TRAP	(UL(0x1) << HFGRTR_EL2_APDBKey_SHIFT)
#define	HFGRTR_EL2_APDAKey_SHIFT	4
#define	HFGRTR_EL2_APDAKey_MASK		(UL(0x1) << HFGRTR_EL2_APDAKey_SHIFT)
#define	HFGRTR_EL2_APDAKey_VAL(x)	((x) & HFGRTR_EL2_APDAKey_MASK)
#define	 HFGRTR_EL2_APDAKey_NOTRAP	(UL(0x0) << HFGRTR_EL2_APDAKey_SHIFT)
#define	 HFGRTR_EL2_APDAKey_TRAP	(UL(0x1) << HFGRTR_EL2_APDAKey_SHIFT)
#define	HFGRTR_EL2_AMAIR_EL1_SHIFT	3
#define	HFGRTR_EL2_AMAIR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_AMAIR_EL1_SHIFT)
#define	HFGRTR_EL2_AMAIR_EL1_VAL(x)	((x) & HFGRTR_EL2_AMAIR_EL1_MASK)
#define	 HFGRTR_EL2_AMAIR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_AMAIR_EL1_SHIFT)
#define	 HFGRTR_EL2_AMAIR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_AMAIR_EL1_SHIFT)
#define	HFGRTR_EL2_AIDR_EL1_SHIFT	2
#define	HFGRTR_EL2_AIDR_EL1_MASK	(UL(0x1) << HFGRTR_EL2_AIDR_EL1_SHIFT)
#define	HFGRTR_EL2_AIDR_EL1_VAL(x)	((x) & HFGRTR_EL2_AIDR_EL1_MASK)
#define	 HFGRTR_EL2_AIDR_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_AIDR_EL1_SHIFT)
#define	 HFGRTR_EL2_AIDR_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_AIDR_EL1_SHIFT)
#define	HFGRTR_EL2_AFSR1_EL1_SHIFT	1
#define	HFGRTR_EL2_AFSR1_EL1_MASK	(UL(0x1) << HFGRTR_EL2_AFSR1_EL1_SHIFT)
#define	HFGRTR_EL2_AFSR1_EL1_VAL(x)	((x) & HFGRTR_EL2_AFSR1_EL1_MASK)
#define	 HFGRTR_EL2_AFSR1_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_AFSR1_EL1_SHIFT)
#define	 HFGRTR_EL2_AFSR1_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_AFSR1_EL1_SHIFT)
#define	HFGRTR_EL2_AFSR0_EL1_SHIFT	0
#define	HFGRTR_EL2_AFSR0_EL1_MASK	(UL(0x1) << HFGRTR_EL2_AFSR0_EL1_SHIFT)
#define	HFGRTR_EL2_AFSR0_EL1_VAL(x)	((x) & HFGRTR_EL2_AFSR0_EL1_MASK)
#define	 HFGRTR_EL2_AFSR0_EL1_NOTRAP	(UL(0x0) << HFGRTR_EL2_AFSR0_EL1_SHIFT)
#define	 HFGRTR_EL2_AFSR0_EL1_TRAP	(UL(0x1) << HFGRTR_EL2_AFSR0_EL1_SHIFT)

/* HFGWTR2_EL2 */
#define	HFGWTR2_EL2_REG			MRS_REG_ALT_NAME(HFGWTR2_EL2)
#define	HFGWTR2_EL2_op0			3
#define	HFGWTR2_EL2_op1			4
#define	HFGWTR2_EL2_CRn			3
#define	HFGWTR2_EL2_CRm			1
#define	HFGWTR2_EL2_op2			3
#define	HFGWTR2_EL2_nRCWSMASK_EL1_SHIFT	2
#define	HFGWTR2_EL2_nRCWSMASK_EL1_MASK	(UL(0x1) << HFGWTR2_EL2_nRCWSMASK_EL1_SHIFT)
#define	HFGWTR2_EL2_nRCWSMASK_EL1_VAL(x) ((x) & HFGWTR2_EL2_nRCWSMASK_EL1_MASK)
#define	 HFGWTR2_EL2_nRCWSMASK_EL1_TRAP	(UL(0x0) << HFGWTR2_EL2_nRCWSMASK_EL1_SHIFT)
#define	 HFGWTR2_EL2_nRCWSMASK_EL1_NOTRAP (UL(0x1) << HFGWTR2_EL2_nRCWSMASK_EL1_SHIFT)
#define	HFGWTR2_EL2_nPFAR_EL1_SHIFT	0
#define	HFGWTR2_EL2_nPFAR_EL1_MASK	(UL(0x1) << HFGWTR2_EL2_nPFAR_EL1_SHIFT)
#define	HFGWTR2_EL2_nPFAR_EL1_VAL(x)	((x) & HFGWTR2_EL2_nPFAR_EL1_MASK)
#define	 HFGWTR2_EL2_nPFAR_EL1_TRAP	(UL(0x0) << HFGWTR2_EL2_nPFAR_EL1_SHIFT)
#define	 HFGWTR2_EL2_nPFAR_EL1_NOTRAP	(UL(0x1) << HFGWTR2_EL2_nPFAR_EL1_SHIFT)

/* HFGWTR_EL2 */
#define	HFGWTR_EL2_REG			MRS_REG_ALT_NAME(HFGWTR_EL2)
#define	HFGWTR_EL2_op0			3
#define	HFGWTR_EL2_op1			4
#define	HFGWTR_EL2_CRn			1
#define	HFGWTR_EL2_CRm			1
#define	HFGWTR_EL2_op2			5
#define	HFGWTR_EL2_nAMAIR2_EL1_SHIFT	63
#define	HFGWTR_EL2_nAMAIR2_EL1_MASK	(UL(0x1) << HFGWTR_EL2_nAMAIR2_EL1_SHIFT)
#define	HFGWTR_EL2_nAMAIR2_EL1_VAL(x)	((x) & HFGWTR_EL2_nAMAIR2_EL1_MASK)
#define	 HFGWTR_EL2_nAMAIR2_EL1_TRAP	(UL(0x0) << HFGWTR_EL2_nAMAIR2_EL1_SHIFT)
#define	 HFGWTR_EL2_nAMAIR2_EL1_NOTRAP	(UL(0x1) << HFGWTR_EL2_nAMAIR2_EL1_SHIFT)
#define	HFGWTR_EL2_nMAIR2_EL1_SHIFT	62
#define	HFGWTR_EL2_nMAIR2_EL1_MASK	(UL(0x1) << HFGWTR_EL2_nMAIR2_EL1_SHIFT)
#define	HFGWTR_EL2_nMAIR2_EL1_VAL(x)	((x) & HFGWTR_EL2_nMAIR2_EL1_MASK)
#define	 HFGWTR_EL2_nMAIR2_EL1_TRAP	(UL(0x0) << HFGWTR_EL2_nMAIR2_EL1_SHIFT)
#define	 HFGWTR_EL2_nMAIR2_EL1_NOTRAP	(UL(0x1) << HFGWTR_EL2_nMAIR2_EL1_SHIFT)
#define	HFGWTR_EL2_nS2POR_EL1_SHIFT	61
#define	HFGWTR_EL2_nS2POR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_nS2POR_EL1_SHIFT)
#define	HFGWTR_EL2_nS2POR_EL1_VAL(x)	((x) & HFGWTR_EL2_nS2POR_EL1_MASK)
#define	 HFGWTR_EL2_nS2POR_EL1_TRAP	(UL(0x0) << HFGWTR_EL2_nS2POR_EL1_SHIFT)
#define	 HFGWTR_EL2_nS2POR_EL1_NOTRAP	(UL(0x1) << HFGWTR_EL2_nS2POR_EL1_SHIFT)
#define	HFGWTR_EL2_nPOR_EL1_SHIFT	60
#define	HFGWTR_EL2_nPOR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_nPOR_EL1_SHIFT)
#define	HFGWTR_EL2_nPOR_EL1_VAL(x)	((x) & HFGWTR_EL2_nPOR_EL1_MASK)
#define	 HFGWTR_EL2_nPOR_EL1_TRAP	(UL(0x0) << HFGWTR_EL2_nPOR_EL1_SHIFT)
#define	 HFGWTR_EL2_nPOR_EL1_NOTRAP	(UL(0x1) << HFGWTR_EL2_nPOR_EL1_SHIFT)
#define	HFGWTR_EL2_nPOR_EL0_SHIFT	59
#define	HFGWTR_EL2_nPOR_EL0_MASK	(UL(0x1) << HFGWTR_EL2_nPOR_EL0_SHIFT)
#define	HFGWTR_EL2_nPOR_EL0_VAL(x)	((x) & HFGWTR_EL2_nPOR_EL0_MASK)
#define	 HFGWTR_EL2_nPOR_EL0_TRAP	(UL(0x0) << HFGWTR_EL2_nPOR_EL0_SHIFT)
#define	 HFGWTR_EL2_nPOR_EL0_NOTRAP	(UL(0x1) << HFGWTR_EL2_nPOR_EL0_SHIFT)
#define	HFGWTR_EL2_nPIR_EL1_SHIFT	58
#define	HFGWTR_EL2_nPIR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_nPIR_EL1_SHIFT)
#define	HFGWTR_EL2_nPIR_EL1_VAL(x)	((x) & HFGWTR_EL2_nPIR_EL1_MASK)
#define	 HFGWTR_EL2_nPIR_EL1_TRAP	(UL(0x0) << HFGWTR_EL2_nPIR_EL1_SHIFT)
#define	 HFGWTR_EL2_nPIR_EL1_NOTRAP	(UL(0x1) << HFGWTR_EL2_nPIR_EL1_SHIFT)
#define	HFGWTR_EL2_nPIRE0_EL1_SHIFT	57
#define	HFGWTR_EL2_nPIRE0_EL1_MASK	(UL(0x1) << HFGWTR_EL2_nPIRE0_EL1_SHIFT)
#define	HFGWTR_EL2_nPIRE0_EL1_VAL(x)	((x) & HFGWTR_EL2_nPIRE0_EL1_MASK)
#define	 HFGWTR_EL2_nPIRE0_EL1_TRAP	(UL(0x0) << HFGWTR_EL2_nPIRE0_EL1_SHIFT)
#define	 HFGWTR_EL2_nPIRE0_EL1_NOTRAP	(UL(0x1) << HFGWTR_EL2_nPIRE0_EL1_SHIFT)
#define	HFGWTR_EL2_nRCWMASK_EL1_SHIFT	56
#define	HFGWTR_EL2_nRCWMASK_EL1_MASK	(UL(0x1) << HFGWTR_EL2_nRCWMASK_EL1_SHIFT)
#define	HFGWTR_EL2_nRCWMASK_EL1_VAL(x)	((x) & HFGWTR_EL2_nRCWMASK_EL1_MASK)
#define	 HFGWTR_EL2_nRCWMASK_EL1_TRAP	(UL(0x0) << HFGWTR_EL2_nRCWMASK_EL1_SHIFT)
#define	 HFGWTR_EL2_nRCWMASK_EL1_NOTRAP	(UL(0x1) << HFGWTR_EL2_nRCWMASK_EL1_SHIFT)
#define	HFGWTR_EL2_nTPIDR2_EL0_SHIFT	55
#define	HFGWTR_EL2_nTPIDR2_EL0_MASK	(UL(0x1) << HFGWTR_EL2_nTPIDR2_EL0_SHIFT)
#define	HFGWTR_EL2_nTPIDR2_EL0_VAL(x)	((x) & HFGWTR_EL2_nTPIDR2_EL0_MASK)
#define	 HFGWTR_EL2_nTPIDR2_EL0_TRAP	(UL(0x0) << HFGWTR_EL2_nTPIDR2_EL0_SHIFT)
#define	 HFGWTR_EL2_nTPIDR2_EL0_NOTRAP	(UL(0x1) << HFGWTR_EL2_nTPIDR2_EL0_SHIFT)
#define	HFGWTR_EL2_nSMPRI_EL1_SHIFT	54
#define	HFGWTR_EL2_nSMPRI_EL1_MASK	(UL(0x1) << HFGWTR_EL2_nSMPRI_EL1_SHIFT)
#define	HFGWTR_EL2_nSMPRI_EL1_VAL(x)	((x) & HFGWTR_EL2_nSMPRI_EL1_MASK)
#define	 HFGWTR_EL2_nSMPRI_EL1_TRAP	(UL(0x0) << HFGWTR_EL2_nSMPRI_EL1_SHIFT)
#define	 HFGWTR_EL2_nSMPRI_EL1_NOTRAP	(UL(0x1) << HFGWTR_EL2_nSMPRI_EL1_SHIFT)
#define	HFGWTR_EL2_nGCS_EL1_SHIFT	53
#define	HFGWTR_EL2_nGCS_EL1_MASK	(UL(0x1) << HFGWTR_EL2_nGCS_EL1_SHIFT)
#define	HFGWTR_EL2_nGCS_EL1_VAL(x)	((x) & HFGWTR_EL2_nGCS_EL1_MASK)
#define	 HFGWTR_EL2_nGCS_EL1_TRAP	(UL(0x0) << HFGWTR_EL2_nGCS_EL1_SHIFT)
#define	 HFGWTR_EL2_nGCS_EL1_NOTRAP	(UL(0x1) << HFGWTR_EL2_nGCS_EL1_SHIFT)
#define	HFGWTR_EL2_nGCS_EL0_SHIFT	52
#define	HFGWTR_EL2_nGCS_EL0_MASK	(UL(0x1) << HFGWTR_EL2_nGCS_EL0_SHIFT)
#define	HFGWTR_EL2_nGCS_EL0_VAL(x)	((x) & HFGWTR_EL2_nGCS_EL0_MASK)
#define	 HFGWTR_EL2_nGCS_EL0_TRAP	(UL(0x0) << HFGWTR_EL2_nGCS_EL0_SHIFT)
#define	 HFGWTR_EL2_nGCS_EL0_NOTRAP	(UL(0x1) << HFGWTR_EL2_nGCS_EL0_SHIFT)
#define	HFGWTR_EL2_nACCDATA_EL1_SHIFT	50
#define	HFGWTR_EL2_nACCDATA_EL1_MASK	(UL(0x1) << HFGWTR_EL2_nACCDATA_EL1_SHIFT)
#define	HFGWTR_EL2_nACCDATA_EL1_VAL(x)	((x) & HFGWTR_EL2_nACCDATA_EL1_MASK)
#define	 HFGWTR_EL2_nACCDATA_EL1_TRAP	(UL(0x0) << HFGWTR_EL2_nACCDATA_EL1_SHIFT)
#define	 HFGWTR_EL2_nACCDATA_EL1_NOTRAP	(UL(0x1) << HFGWTR_EL2_nACCDATA_EL1_SHIFT)
#define	HFGWTR_EL2_ERXADDR_EL1_SHIFT	49
#define	HFGWTR_EL2_ERXADDR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_ERXADDR_EL1_SHIFT)
#define	HFGWTR_EL2_ERXADDR_EL1_VAL(x)	((x) & HFGWTR_EL2_ERXADDR_EL1_MASK)
#define	 HFGWTR_EL2_ERXADDR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_ERXADDR_EL1_SHIFT)
#define	 HFGWTR_EL2_ERXADDR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_ERXADDR_EL1_SHIFT)
#define	HFGWTR_EL2_ERXPFGCDN_EL1_SHIFT	48
#define	HFGWTR_EL2_ERXPFGCDN_EL1_MASK	(UL(0x1) << HFGWTR_EL2_ERXPFGCDN_EL1_SHIFT)
#define	HFGWTR_EL2_ERXPFGCDN_EL1_VAL(x)	((x) & HFGWTR_EL2_ERXPFGCDN_EL1_MASK)
#define	 HFGWTR_EL2_ERXPFGCDN_EL1_NOTRAP (UL(0x0) << HFGWTR_EL2_ERXPFGCDN_EL1_SHIFT)
#define	 HFGWTR_EL2_ERXPFGCDN_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_ERXPFGCDN_EL1_SHIFT)
#define	HFGWTR_EL2_ERXPFGCTL_EL1_SHIFT	47
#define	HFGWTR_EL2_ERXPFGCTL_EL1_MASK	(UL(0x1) << HFGWTR_EL2_ERXPFGCTL_EL1_SHIFT)
#define	HFGWTR_EL2_ERXPFGCTL_EL1_VAL(x)	((x) & HFGWTR_EL2_ERXPFGCTL_EL1_MASK)
#define	 HFGWTR_EL2_ERXPFGCTL_EL1_NOTRAP (UL(0x0) << HFGWTR_EL2_ERXPFGCTL_EL1_SHIFT)
#define	 HFGWTR_EL2_ERXPFGCTL_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_ERXPFGCTL_EL1_SHIFT)
#define	HFGWTR_EL2_ERXMISCn_EL1_SHIFT	45
#define	HFGWTR_EL2_ERXMISCn_EL1_MASK	(UL(0x1) << HFGWTR_EL2_ERXMISCn_EL1_SHIFT)
#define	HFGWTR_EL2_ERXMISCn_EL1_VAL(x)	((x) & HFGWTR_EL2_ERXMISCn_EL1_MASK)
#define	 HFGWTR_EL2_ERXMISCn_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_ERXMISCn_EL1_SHIFT)
#define	 HFGWTR_EL2_ERXMISCn_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_ERXMISCn_EL1_SHIFT)
#define	HFGWTR_EL2_ERXSTATUS_EL1_SHIFT	44
#define	HFGWTR_EL2_ERXSTATUS_EL1_MASK	(UL(0x1) << HFGWTR_EL2_ERXSTATUS_EL1_SHIFT)
#define	HFGWTR_EL2_ERXSTATUS_EL1_VAL(x)	((x) & HFGWTR_EL2_ERXSTATUS_EL1_MASK)
#define	 HFGWTR_EL2_ERXSTATUS_EL1_NOTRAP (UL(0x0) << HFGWTR_EL2_ERXSTATUS_EL1_SHIFT)
#define	 HFGWTR_EL2_ERXSTATUS_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_ERXSTATUS_EL1_SHIFT)
#define	HFGWTR_EL2_ERXCTLR_EL1_SHIFT	43
#define	HFGWTR_EL2_ERXCTLR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_ERXCTLR_EL1_SHIFT)
#define	HFGWTR_EL2_ERXCTLR_EL1_VAL(x)	((x) & HFGWTR_EL2_ERXCTLR_EL1_MASK)
#define	 HFGWTR_EL2_ERXCTLR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_ERXCTLR_EL1_SHIFT)
#define	 HFGWTR_EL2_ERXCTLR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_ERXCTLR_EL1_SHIFT)
#define	HFGWTR_EL2_ERRSELR_EL1_SHIFT	41
#define	HFGWTR_EL2_ERRSELR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_ERRSELR_EL1_SHIFT)
#define	HFGWTR_EL2_ERRSELR_EL1_VAL(x)	((x) & HFGWTR_EL2_ERRSELR_EL1_MASK)
#define	 HFGWTR_EL2_ERRSELR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_ERRSELR_EL1_SHIFT)
#define	 HFGWTR_EL2_ERRSELR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_ERRSELR_EL1_SHIFT)
#define	HFGWTR_EL2_ICC_IGRPENn_EL1_SHIFT 39
#define	HFGWTR_EL2_ICC_IGRPENn_EL1_MASK	(UL(0x1) << HFGWTR_EL2_ICC_IGRPENn_EL1_SHIFT)
#define	HFGWTR_EL2_ICC_IGRPENn_EL1_VAL(x) ((x) & HFGWTR_EL2_ICC_IGRPENn_EL1_MASK)
#define	 HFGWTR_EL2_ICC_IGRPENn_EL1_NOTRAP (UL(0x0) << HFGWTR_EL2_ICC_IGRPENn_EL1_SHIFT)
#define	 HFGWTR_EL2_ICC_IGRPENn_EL1_TRAP (UL(0x1) << HFGWTR_EL2_ICC_IGRPENn_EL1_SHIFT)
#define	HFGWTR_EL2_VBAR_EL1_SHIFT	38
#define	HFGWTR_EL2_VBAR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_VBAR_EL1_SHIFT)
#define	HFGWTR_EL2_VBAR_EL1_VAL(x)	((x) & HFGWTR_EL2_VBAR_EL1_MASK)
#define	 HFGWTR_EL2_VBAR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_VBAR_EL1_SHIFT)
#define	 HFGWTR_EL2_VBAR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_VBAR_EL1_SHIFT)
#define	HFGWTR_EL2_TTBR1_EL1_SHIFT	37
#define	HFGWTR_EL2_TTBR1_EL1_MASK	(UL(0x1) << HFGWTR_EL2_TTBR1_EL1_SHIFT)
#define	HFGWTR_EL2_TTBR1_EL1_VAL(x)	((x) & HFGWTR_EL2_TTBR1_EL1_MASK)
#define	 HFGWTR_EL2_TTBR1_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_TTBR1_EL1_SHIFT)
#define	 HFGWTR_EL2_TTBR1_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_TTBR1_EL1_SHIFT)
#define	HFGWTR_EL2_TTBR0_EL1_SHIFT	36
#define	HFGWTR_EL2_TTBR0_EL1_MASK	(UL(0x1) << HFGWTR_EL2_TTBR0_EL1_SHIFT)
#define	HFGWTR_EL2_TTBR0_EL1_VAL(x)	((x) & HFGWTR_EL2_TTBR0_EL1_MASK)
#define	 HFGWTR_EL2_TTBR0_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_TTBR0_EL1_SHIFT)
#define	 HFGWTR_EL2_TTBR0_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_TTBR0_EL1_SHIFT)
#define	HFGWTR_EL2_TPIDR_EL0_SHIFT	35
#define	HFGWTR_EL2_TPIDR_EL0_MASK	(UL(0x1) << HFGWTR_EL2_TPIDR_EL0_SHIFT)
#define	HFGWTR_EL2_TPIDR_EL0_VAL(x)	((x) & HFGWTR_EL2_TPIDR_EL0_MASK)
#define	 HFGWTR_EL2_TPIDR_EL0_NOTRAP	(UL(0x0) << HFGWTR_EL2_TPIDR_EL0_SHIFT)
#define	 HFGWTR_EL2_TPIDR_EL0_TRAP	(UL(0x1) << HFGWTR_EL2_TPIDR_EL0_SHIFT)
#define	HFGWTR_EL2_TPIDRRO_EL0_SHIFT	34
#define	HFGWTR_EL2_TPIDRRO_EL0_MASK	(UL(0x1) << HFGWTR_EL2_TPIDRRO_EL0_SHIFT)
#define	HFGWTR_EL2_TPIDRRO_EL0_VAL(x)	((x) & HFGWTR_EL2_TPIDRRO_EL0_MASK)
#define	 HFGWTR_EL2_TPIDRRO_EL0_NOTRAP	(UL(0x0) << HFGWTR_EL2_TPIDRRO_EL0_SHIFT)
#define	 HFGWTR_EL2_TPIDRRO_EL0_TRAP	(UL(0x1) << HFGWTR_EL2_TPIDRRO_EL0_SHIFT)
#define	HFGWTR_EL2_TPIDR_EL1_SHIFT	33
#define	HFGWTR_EL2_TPIDR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_TPIDR_EL1_SHIFT)
#define	HFGWTR_EL2_TPIDR_EL1_VAL(x)	((x) & HFGWTR_EL2_TPIDR_EL1_MASK)
#define	 HFGWTR_EL2_TPIDR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_TPIDR_EL1_SHIFT)
#define	 HFGWTR_EL2_TPIDR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_TPIDR_EL1_SHIFT)
#define	HFGWTR_EL2_TCR_EL1_SHIFT	32
#define	HFGWTR_EL2_TCR_EL1_MASK		(UL(0x1) << HFGWTR_EL2_TCR_EL1_SHIFT)
#define	HFGWTR_EL2_TCR_EL1_VAL(x)	((x) & HFGWTR_EL2_TCR_EL1_MASK)
#define	 HFGWTR_EL2_TCR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_TCR_EL1_SHIFT)
#define	 HFGWTR_EL2_TCR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_TCR_EL1_SHIFT)
#define	HFGWTR_EL2_SCXTNUM_EL0_SHIFT	31
#define	HFGWTR_EL2_SCXTNUM_EL0_MASK	(UL(0x1) << HFGWTR_EL2_SCXTNUM_EL0_SHIFT)
#define	HFGWTR_EL2_SCXTNUM_EL0_VAL(x)	((x) & HFGWTR_EL2_SCXTNUM_EL0_MASK)
#define	 HFGWTR_EL2_SCXTNUM_EL0_NOTRAP	(UL(0x0) << HFGWTR_EL2_SCXTNUM_EL0_SHIFT)
#define	 HFGWTR_EL2_SCXTNUM_EL0_TRAP	(UL(0x1) << HFGWTR_EL2_SCXTNUM_EL0_SHIFT)
#define	HFGWTR_EL2_SCXTNUM_EL1_SHIFT	30
#define	HFGWTR_EL2_SCXTNUM_EL1_MASK	(UL(0x1) << HFGWTR_EL2_SCXTNUM_EL1_SHIFT)
#define	HFGWTR_EL2_SCXTNUM_EL1_VAL(x)	((x) & HFGWTR_EL2_SCXTNUM_EL1_MASK)
#define	 HFGWTR_EL2_SCXTNUM_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_SCXTNUM_EL1_SHIFT)
#define	 HFGWTR_EL2_SCXTNUM_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_SCXTNUM_EL1_SHIFT)
#define	HFGWTR_EL2_SCTLR_EL1_SHIFT	29
#define	HFGWTR_EL2_SCTLR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_SCTLR_EL1_SHIFT)
#define	HFGWTR_EL2_SCTLR_EL1_VAL(x)	((x) & HFGWTR_EL2_SCTLR_EL1_MASK)
#define	 HFGWTR_EL2_SCTLR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_SCTLR_EL1_SHIFT)
#define	 HFGWTR_EL2_SCTLR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_SCTLR_EL1_SHIFT)
#define	HFGWTR_EL2_PAR_EL1_SHIFT	27
#define	HFGWTR_EL2_PAR_EL1_MASK		(UL(0x1) << HFGWTR_EL2_PAR_EL1_SHIFT)
#define	HFGWTR_EL2_PAR_EL1_VAL(x)	((x) & HFGWTR_EL2_PAR_EL1_MASK)
#define	 HFGWTR_EL2_PAR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_PAR_EL1_SHIFT)
#define	 HFGWTR_EL2_PAR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_PAR_EL1_SHIFT)
#define	HFGWTR_EL2_MAIR_EL1_SHIFT	24
#define	HFGWTR_EL2_MAIR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_MAIR_EL1_SHIFT)
#define	HFGWTR_EL2_MAIR_EL1_VAL(x)	((x) & HFGWTR_EL2_MAIR_EL1_MASK)
#define	 HFGWTR_EL2_MAIR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_MAIR_EL1_SHIFT)
#define	 HFGWTR_EL2_MAIR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_MAIR_EL1_SHIFT)
#define	HFGWTR_EL2_LORSA_EL1_SHIFT	23
#define	HFGWTR_EL2_LORSA_EL1_MASK	(UL(0x1) << HFGWTR_EL2_LORSA_EL1_SHIFT)
#define	HFGWTR_EL2_LORSA_EL1_VAL(x)	((x) & HFGWTR_EL2_LORSA_EL1_MASK)
#define	 HFGWTR_EL2_LORSA_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_LORSA_EL1_SHIFT)
#define	 HFGWTR_EL2_LORSA_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_LORSA_EL1_SHIFT)
#define	HFGWTR_EL2_LORN_EL1_SHIFT	22
#define	HFGWTR_EL2_LORN_EL1_MASK	(UL(0x1) << HFGWTR_EL2_LORN_EL1_SHIFT)
#define	HFGWTR_EL2_LORN_EL1_VAL(x)	((x) & HFGWTR_EL2_LORN_EL1_MASK)
#define	 HFGWTR_EL2_LORN_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_LORN_EL1_SHIFT)
#define	 HFGWTR_EL2_LORN_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_LORN_EL1_SHIFT)
#define	HFGWTR_EL2_LOREA_EL1_SHIFT	20
#define	HFGWTR_EL2_LOREA_EL1_MASK	(UL(0x1) << HFGWTR_EL2_LOREA_EL1_SHIFT)
#define	HFGWTR_EL2_LOREA_EL1_VAL(x)	((x) & HFGWTR_EL2_LOREA_EL1_MASK)
#define	 HFGWTR_EL2_LOREA_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_LOREA_EL1_SHIFT)
#define	 HFGWTR_EL2_LOREA_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_LOREA_EL1_SHIFT)
#define	HFGWTR_EL2_LORC_EL1_SHIFT	19
#define	HFGWTR_EL2_LORC_EL1_MASK	(UL(0x1) << HFGWTR_EL2_LORC_EL1_SHIFT)
#define	HFGWTR_EL2_LORC_EL1_VAL(x)	((x) & HFGWTR_EL2_LORC_EL1_MASK)
#define	 HFGWTR_EL2_LORC_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_LORC_EL1_SHIFT)
#define	 HFGWTR_EL2_LORC_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_LORC_EL1_SHIFT)
#define	HFGWTR_EL2_FAR_EL1_SHIFT	17
#define	HFGWTR_EL2_FAR_EL1_MASK		(UL(0x1) << HFGWTR_EL2_FAR_EL1_SHIFT)
#define	HFGWTR_EL2_FAR_EL1_VAL(x)	((x) & HFGWTR_EL2_FAR_EL1_MASK)
#define	 HFGWTR_EL2_FAR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_FAR_EL1_SHIFT)
#define	 HFGWTR_EL2_FAR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_FAR_EL1_SHIFT)
#define	HFGWTR_EL2_ESR_EL1_SHIFT	16
#define	HFGWTR_EL2_ESR_EL1_MASK		(UL(0x1) << HFGWTR_EL2_ESR_EL1_SHIFT)
#define	HFGWTR_EL2_ESR_EL1_VAL(x)	((x) & HFGWTR_EL2_ESR_EL1_MASK)
#define	 HFGWTR_EL2_ESR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_ESR_EL1_SHIFT)
#define	 HFGWTR_EL2_ESR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_ESR_EL1_SHIFT)
#define	HFGWTR_EL2_CSSELR_EL1_SHIFT	13
#define	HFGWTR_EL2_CSSELR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_CSSELR_EL1_SHIFT)
#define	HFGWTR_EL2_CSSELR_EL1_VAL(x)	((x) & HFGWTR_EL2_CSSELR_EL1_MASK)
#define	 HFGWTR_EL2_CSSELR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_CSSELR_EL1_SHIFT)
#define	 HFGWTR_EL2_CSSELR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_CSSELR_EL1_SHIFT)
#define	HFGWTR_EL2_CPACR_EL1_SHIFT	12
#define	HFGWTR_EL2_CPACR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_CPACR_EL1_SHIFT)
#define	HFGWTR_EL2_CPACR_EL1_VAL(x)	((x) & HFGWTR_EL2_CPACR_EL1_MASK)
#define	 HFGWTR_EL2_CPACR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_CPACR_EL1_SHIFT)
#define	 HFGWTR_EL2_CPACR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_CPACR_EL1_SHIFT)
#define	HFGWTR_EL2_CONTEXTIDR_EL1_SHIFT	11
#define	HFGWTR_EL2_CONTEXTIDR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_CONTEXTIDR_EL1_SHIFT)
#define	HFGWTR_EL2_CONTEXTIDR_EL1_VAL(x) ((x) & HFGWTR_EL2_CONTEXTIDR_EL1_MASK)
#define	 HFGWTR_EL2_CONTEXTIDR_EL1_NOTRAP (UL(0x0) << HFGWTR_EL2_CONTEXTIDR_EL1_SHIFT)
#define	 HFGWTR_EL2_CONTEXTIDR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_CONTEXTIDR_EL1_SHIFT)
#define	HFGWTR_EL2_APIBKey_SHIFT	8
#define	HFGWTR_EL2_APIBKey_MASK		(UL(0x1) << HFGWTR_EL2_APIBKey_SHIFT)
#define	HFGWTR_EL2_APIBKey_VAL(x)	((x) & HFGWTR_EL2_APIBKey_MASK)
#define	 HFGWTR_EL2_APIBKey_NOTRAP	(UL(0x0) << HFGWTR_EL2_APIBKey_SHIFT)
#define	 HFGWTR_EL2_APIBKey_TRAP	(UL(0x1) << HFGWTR_EL2_APIBKey_SHIFT)
#define	HFGWTR_EL2_APIAKey_SHIFT	7
#define	HFGWTR_EL2_APIAKey_MASK		(UL(0x1) << HFGWTR_EL2_APIAKey_SHIFT)
#define	HFGWTR_EL2_APIAKey_VAL(x)	((x) & HFGWTR_EL2_APIAKey_MASK)
#define	 HFGWTR_EL2_APIAKey_NOTRAP	(UL(0x0) << HFGWTR_EL2_APIAKey_SHIFT)
#define	 HFGWTR_EL2_APIAKey_TRAP	(UL(0x1) << HFGWTR_EL2_APIAKey_SHIFT)
#define	HFGWTR_EL2_APGAKey_SHIFT	6
#define	HFGWTR_EL2_APGAKey_MASK		(UL(0x1) << HFGWTR_EL2_APGAKey_SHIFT)
#define	HFGWTR_EL2_APGAKey_VAL(x)	((x) & HFGWTR_EL2_APGAKey_MASK)
#define	 HFGWTR_EL2_APGAKey_NOTRAP	(UL(0x0) << HFGWTR_EL2_APGAKey_SHIFT)
#define	 HFGWTR_EL2_APGAKey_TRAP	(UL(0x1) << HFGWTR_EL2_APGAKey_SHIFT)
#define	HFGWTR_EL2_APDBKey_SHIFT	5
#define	HFGWTR_EL2_APDBKey_MASK		(UL(0x1) << HFGWTR_EL2_APDBKey_SHIFT)
#define	HFGWTR_EL2_APDBKey_VAL(x)	((x) & HFGWTR_EL2_APDBKey_MASK)
#define	 HFGWTR_EL2_APDBKey_NOTRAP	(UL(0x0) << HFGWTR_EL2_APDBKey_SHIFT)
#define	 HFGWTR_EL2_APDBKey_TRAP	(UL(0x1) << HFGWTR_EL2_APDBKey_SHIFT)
#define	HFGWTR_EL2_APDAKey_SHIFT	4
#define	HFGWTR_EL2_APDAKey_MASK		(UL(0x1) << HFGWTR_EL2_APDAKey_SHIFT)
#define	HFGWTR_EL2_APDAKey_VAL(x)	((x) & HFGWTR_EL2_APDAKey_MASK)
#define	 HFGWTR_EL2_APDAKey_NOTRAP	(UL(0x0) << HFGWTR_EL2_APDAKey_SHIFT)
#define	 HFGWTR_EL2_APDAKey_TRAP	(UL(0x1) << HFGWTR_EL2_APDAKey_SHIFT)
#define	HFGWTR_EL2_AMAIR_EL1_SHIFT	3
#define	HFGWTR_EL2_AMAIR_EL1_MASK	(UL(0x1) << HFGWTR_EL2_AMAIR_EL1_SHIFT)
#define	HFGWTR_EL2_AMAIR_EL1_VAL(x)	((x) & HFGWTR_EL2_AMAIR_EL1_MASK)
#define	 HFGWTR_EL2_AMAIR_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_AMAIR_EL1_SHIFT)
#define	 HFGWTR_EL2_AMAIR_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_AMAIR_EL1_SHIFT)
#define	HFGWTR_EL2_AFSR1_EL1_SHIFT	1
#define	HFGWTR_EL2_AFSR1_EL1_MASK	(UL(0x1) << HFGWTR_EL2_AFSR1_EL1_SHIFT)
#define	HFGWTR_EL2_AFSR1_EL1_VAL(x)	((x) & HFGWTR_EL2_AFSR1_EL1_MASK)
#define	 HFGWTR_EL2_AFSR1_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_AFSR1_EL1_SHIFT)
#define	 HFGWTR_EL2_AFSR1_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_AFSR1_EL1_SHIFT)
#define	HFGWTR_EL2_AFSR0_EL1_SHIFT	0
#define	HFGWTR_EL2_AFSR0_EL1_MASK	(UL(0x1) << HFGWTR_EL2_AFSR0_EL1_SHIFT)
#define	HFGWTR_EL2_AFSR0_EL1_VAL(x)	((x) & HFGWTR_EL2_AFSR0_EL1_MASK)
#define	 HFGWTR_EL2_AFSR0_EL1_NOTRAP	(UL(0x0) << HFGWTR_EL2_AFSR0_EL1_SHIFT)
#define	 HFGWTR_EL2_AFSR0_EL1_TRAP	(UL(0x1) << HFGWTR_EL2_AFSR0_EL1_SHIFT)

/* HPFAR_EL2 - Hypervisor IPA Fault Address Register */
#define	HPFAR_EL2_FIPA_SHIFT	4
#define	HPFAR_EL2_FIPA_MASK	0xfffffffff0
#define	HPFAR_EL2_FIPA_GET(x)	\
    (((x) & HPFAR_EL2_FIPA_MASK) >> HPFAR_EL2_FIPA_SHIFT)
/* HPFAR_EL2_FIPA holds the 4k page address */
#define	HPFAR_EL2_FIPA_ADDR(x)	\
    (HPFAR_EL2_FIPA_GET(x) << 12)
/* The bits from FAR_EL2 we need to add to HPFAR_EL2_FIPA_ADDR */
#define	FAR_EL2_HPFAR_PAGE_MASK	(0xffful)

/* ICC_SRE_EL2 */
#define	ICC_SRE_EL2_SRE		(1UL << 0)
#define	ICC_SRE_EL2_EN		(1UL << 3)

/* MDCR_EL2 - Hyp Debug Control Register */
#define	MDCR_EL2_HPMN_MASK	0x1f
#define	MDCR_EL2_HPMN_SHIFT	0
#define	MDCR_EL2_TPMCR_SHIFT	5
#define	MDCR_EL2_TPMCR		(0x1UL << MDCR_EL2_TPMCR_SHIFT)
#define	MDCR_EL2_TPM_SHIFT	6
#define	MDCR_EL2_TPM		(0x1UL << MDCR_EL2_TPM_SHIFT)
#define	MDCR_EL2_HPME_SHIFT	7
#define	MDCR_EL2_HPME		(0x1UL << MDCR_EL2_HPME_SHIFT)
#define	MDCR_EL2_TDE_SHIFT	8
#define	MDCR_EL2_TDE		(0x1UL << MDCR_EL2_TDE_SHIFT)
#define	MDCR_EL2_TDA_SHIFT	9
#define	MDCR_EL2_TDA		(0x1UL << MDCR_EL2_TDA_SHIFT)
#define	MDCR_EL2_TDOSA_SHIFT	10
#define	MDCR_EL2_TDOSA		(0x1UL << MDCR_EL2_TDOSA_SHIFT)
#define	MDCR_EL2_TDRA_SHIFT	11
#define	MDCR_EL2_TDRA		(0x1UL << MDCR_EL2_TDRA_SHIFT)
#define	MDCR_EL2_E2PB_SHIFT	12
#define	MDCR_EL2_E2PB_MASK	(0x3UL << MDCR_EL2_E2PB_SHIFT)
#define	 MDCR_EL2_E2PB_EL1_0_NO_TRAP	(0x3UL << MDCR_EL2_E2PB_SHIFT)
#define	MDCR_EL2_TPMS_SHIFT	14
#define	MDCR_EL2_TPMS		(0x1UL << MDCR_EL2_TPMS_SHIFT)
#define	MDCR_EL2_EnSPM_SHIFT	15
#define	MDCR_EL2_EnSPM		(0x1UL << MDCR_EL2_EnSPM_SHIFT)
#define	MDCR_EL2_HPMD_SHIFT	17
#define	MDCR_EL2_HPMD		(0x1UL << MDCR_EL2_HPMD_SHIFT)
#define	MDCR_EL2_TTRF_SHIFT	19
#define	MDCR_EL2_TTRF		(0x1UL << MDCR_EL2_TTRF_SHIFT)
#define	MDCR_EL2_HCCD_SHIFT	23
#define	MDCR_EL2_HCCD		(0x1UL << MDCR_EL2_HCCD_SHIFT)
#define	MDCR_EL2_E2TB_SHIFT	24
#define	MDCR_EL2_E2TB_MASK	(0x3UL << MDCR_EL2_E2TB_SHIFT)
#define	MDCR_EL2_HLP_SHIFT	26
#define	MDCR_EL2_HLP		(0x1UL << MDCR_EL2_HLP_SHIFT)
#define	MDCR_EL2_TDCC_SHIFT	27
#define	MDCR_EL2_TDCC		(0x1UL << MDCR_EL2_TDCC_SHIFT)
#define	MDCR_EL2_MTPME_SHIFT	28
#define	MDCR_EL2_MTPME		(0x1UL << MDCR_EL2_MTPME_SHIFT)
#define	MDCR_EL2_HPMFZO_SHIFT	29
#define	MDCR_EL2_HPMFZO		(0x1UL << MDCR_EL2_HPMFZO_SHIFT)
#define	MDCR_EL2_PMSSE_SHIFT	30
#define	MDCR_EL2_PMSSE_MASK	(0x3UL << MDCR_EL2_PMSSE_SHIFT)
#define	MDCR_EL2_HPMFZS_SHIFT	36
#define	MDCR_EL2_HPMFZS		(0x1UL << MDCR_EL2_HPMFZS_SHIFT)
#define	MDCR_EL2_PMEE_SHIFT	40
#define	MDCR_EL2_PMEE_MASK	(0x3UL << MDCR_EL2_PMEE_SHIFT)
#define	MDCR_EL2_EBWE_SHIFT	43
#define	MDCR_EL2_EBWE		(0x1UL << MDCR_EL2_EBWE_SHIFT)

/* SCTLR_EL2 - System Control Register */
#define	SCTLR_EL2_RES1		0x30c50830
#define	SCTLR_EL2_M_SHIFT	0
#define	SCTLR_EL2_M		(0x1UL << SCTLR_EL2_M_SHIFT)
#define	SCTLR_EL2_A_SHIFT	1
#define	SCTLR_EL2_A		(0x1UL << SCTLR_EL2_A_SHIFT)
#define	SCTLR_EL2_C_SHIFT	2
#define	SCTLR_EL2_C		(0x1UL << SCTLR_EL2_C_SHIFT)
#define	SCTLR_EL2_SA_SHIFT	3
#define	SCTLR_EL2_SA		(0x1UL << SCTLR_EL2_SA_SHIFT)
#define	SCTLR_EL2_EOS_SHIFT	11
#define	SCTLR_EL2_EOS		(0x1UL << SCTLR_EL2_EOS_SHIFT)
#define	SCTLR_EL2_I_SHIFT	12
#define	SCTLR_EL2_I		(0x1UL << SCTLR_EL2_I_SHIFT)
#define	SCTLR_EL2_WXN_SHIFT	19
#define	SCTLR_EL2_WXN		(0x1UL << SCTLR_EL2_WXN_SHIFT)
#define	SCTLR_EL2_EIS_SHIFT	22
#define	SCTLR_EL2_EIS		(0x1UL << SCTLR_EL2_EIS_SHIFT)
#define	SCTLR_EL2_EE_SHIFT	25
#define	SCTLR_EL2_EE		(0x1UL << SCTLR_EL2_EE_SHIFT)

/* TCR_EL2 - Translation Control Register */
#define	TCR_EL2_RES1		((0x1UL << 31) | (0x1UL << 23))
#define	TCR_EL2_T0SZ_SHIFT	0
#define	TCR_EL2_T0SZ_MASK	(0x3fUL << TCR_EL2_T0SZ_SHIFT)
#define	TCR_EL2_T0SZ(x)		((x) << TCR_EL2_T0SZ_SHIFT)
/* Bits 7:6 are reserved */
#define	TCR_EL2_IRGN0_SHIFT	8
#define	TCR_EL2_IRGN0_MASK	(0x3UL << TCR_EL2_IRGN0_SHIFT)
#define	TCR_EL2_IRGN0_WBWA	(1UL << TCR_EL2_IRGN0_SHIFT)
#define	TCR_EL2_ORGN0_SHIFT	10
#define	TCR_EL2_ORGN0_MASK	(0x3UL << TCR_EL2_ORGN0_SHIFT)
#define	TCR_EL2_ORGN0_WBWA	(1UL << TCR_EL2_ORGN0_SHIFT)
#define	TCR_EL2_SH0_SHIFT	12
#define	TCR_EL2_SH0_MASK	(0x3UL << TCR_EL2_SH0_SHIFT)
#define	TCR_EL2_SH0_IS		(3UL << TCR_EL2_SH0_SHIFT)
#define	TCR_EL2_TG0_SHIFT	14
#define	TCR_EL2_TG0_MASK	(0x3UL << TCR_EL2_TG0_SHIFT)
#define	TCR_EL2_TG0_4K		(0x0UL << TCR_EL2_TG0_SHIFT)
#define	TCR_EL2_TG0_64K		(0x1UL << TCR_EL2_TG0_SHIFT)
#define	TCR_EL2_TG0_16K		(0x2UL << TCR_EL2_TG0_SHIFT)
#define	TCR_EL2_PS_SHIFT	16
#define	TCR_EL2_PS_MASK		(0xfUL << TCR_EL2_PS_SHIFT)
#define	 TCR_EL2_PS_32BITS	(0UL << TCR_EL2_PS_SHIFT)
#define	 TCR_EL2_PS_36BITS	(1UL << TCR_EL2_PS_SHIFT)
#define	 TCR_EL2_PS_40BITS	(2UL << TCR_EL2_PS_SHIFT)
#define	 TCR_EL2_PS_42BITS	(3UL << TCR_EL2_PS_SHIFT)
#define	 TCR_EL2_PS_44BITS	(4UL << TCR_EL2_PS_SHIFT)
#define	 TCR_EL2_PS_48BITS	(5UL << TCR_EL2_PS_SHIFT)
#define	 TCR_EL2_PS_52BITS	(6UL << TCR_EL2_PS_SHIFT)
#define	TCR_EL2_HPD_SHIFT	24
#define	TCR_EL2_HPD		(1UL << TCR_EL2_HPD_SHIFT)
#define	TCR_EL2_HWU59_SHIFT	25
#define	TCR_EL2_HWU59		(1UL << TCR_EL2_HWU59_SHIFT)
#define	TCR_EL2_HWU60_SHIFT	26
#define	TCR_EL2_HWU60		(1UL << TCR_EL2_HWU60_SHIFT)
#define	TCR_EL2_HWU61_SHIFT	27
#define	TCR_EL2_HWU61		(1UL << TCR_EL2_HWU61_SHIFT)
#define	TCR_EL2_HWU62_SHIFT	28
#define	TCR_EL2_HWU62		(1UL << TCR_EL2_HWU62_SHIFT)
#define	TCR_EL2_HWU		\
    (TCR_EL2_HWU59 | TCR_EL2_HWU60 | TCR_EL2_HWU61 | TCR_EL2_HWU62)

/* VMPDIR_EL2 - Virtualization Multiprocessor ID Register */
#define	VMPIDR_EL2_U		0x0000000040000000
#define	VMPIDR_EL2_MT		0x0000000001000000
#define	VMPIDR_EL2_RES1		0x0000000080000000

/* VTCR_EL2 - Virtualization Translation Control Register */
#define	VTCR_EL2_RES1		(0x1UL << 31)
#define	VTCR_EL2_T0SZ_SHIFT	0
#define	VTCR_EL2_T0SZ_MASK	(0x3fUL << VTCR_EL2_T0SZ_SHIFT)
#define	VTCR_EL2_T0SZ(x)	((x) << VTCR_EL2_T0SZ_SHIFT)
#define	VTCR_EL2_SL0_SHIFT	6
#define	 VTCR_EL2_SL0_4K_LVL2	(0x0UL << VTCR_EL2_SL0_SHIFT)
#define	 VTCR_EL2_SL0_4K_LVL1	(0x1UL << VTCR_EL2_SL0_SHIFT)
#define	 VTCR_EL2_SL0_4K_LVL0	(0x2UL << VTCR_EL2_SL0_SHIFT)
#define	 VTCR_EL2_SL0_16K_LVL2	(0x1UL << VTCR_EL2_SL0_SHIFT)
#define	 VTCR_EL2_SL0_16K_LVL1	(0x2UL << VTCR_EL2_SL0_SHIFT)
#define	 VTCR_EL2_SL0_16K_LVL0	(0x3UL << VTCR_EL2_SL0_SHIFT)
#define	VTCR_EL2_IRGN0_SHIFT	8
#define	 VTCR_EL2_IRGN0_WBWA	(0x1UL << VTCR_EL2_IRGN0_SHIFT)
#define	VTCR_EL2_ORGN0_SHIFT	10
#define	 VTCR_EL2_ORGN0_WBWA	(0x1UL << VTCR_EL2_ORGN0_SHIFT)
#define	VTCR_EL2_SH0_SHIFT	12
#define	 VTCR_EL2_SH0_NS	(0x0UL << VTCR_EL2_SH0_SHIFT)
#define	 VTCR_EL2_SH0_OS	(0x2UL << VTCR_EL2_SH0_SHIFT)
#define	 VTCR_EL2_SH0_IS	(0x3UL << VTCR_EL2_SH0_SHIFT)
#define	VTCR_EL2_TG0_SHIFT	14
#define	 VTCR_EL2_TG0_4K	(0x0UL << VTCR_EL2_TG0_SHIFT)
#define	 VTCR_EL2_TG0_64K	(0x1UL << VTCR_EL2_TG0_SHIFT)
#define	 VTCR_EL2_TG0_16K	(0x2UL << VTCR_EL2_TG0_SHIFT)
#define	VTCR_EL2_PS_SHIFT	16
#define	 VTCR_EL2_PS_32BIT	(0x0UL << VTCR_EL2_PS_SHIFT)
#define	 VTCR_EL2_PS_36BIT	(0x1UL << VTCR_EL2_PS_SHIFT)
#define	 VTCR_EL2_PS_40BIT	(0x2UL << VTCR_EL2_PS_SHIFT)
#define	 VTCR_EL2_PS_42BIT	(0x3UL << VTCR_EL2_PS_SHIFT)
#define	 VTCR_EL2_PS_44BIT	(0x4UL << VTCR_EL2_PS_SHIFT)
#define	 VTCR_EL2_PS_48BIT	(0x5UL << VTCR_EL2_PS_SHIFT)
#define	 VTCR_EL2_PS_52BIT	(0x6UL << VTCR_EL2_PS_SHIFT)
#define	VTCR_EL2_DS_SHIFT	32
#define	VTCR_EL2_DS		(0x1UL << VTCR_EL2_DS_SHIFT)

/* VTTBR_EL2 - Virtualization Translation Table Base Register */
#define	VTTBR_VMID_MASK		0xffff000000000000
#define	VTTBR_VMID_SHIFT	48
/* Assumed to be 0 by locore.S */
#define	VTTBR_HOST		0x0000000000000000

#endif /* !_MACHINE_HYPERVISOR_H_ */
