/*-
 * Copyright (c) 2015 Adrian Chadd <adrian@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/12/sys/mips/atheros/qca953xreg.h 290910 2015-11-16 04:28:00Z adrian $
 */
#ifndef	__QCA953XREG_H__
#define	__QCA953XREG_H__

#define	BIT(x)				(1 << (x))

/* Revision ID information */
#define	REV_ID_MAJOR_QCA9533		0x0140
#define	REV_ID_MAJOR_QCA9533_V2		0x0160
#define	QCA953X_REV_ID_REVISION_MASK	0xf

/* Big enough to cover APB and SPI, and most peripherals */
/*
 * it needs to cover SPI because right now the if_ath_ahb
 * code uses rman to map in the SPI address into memory
 * to read data instead of us squirreling it away at early
 * boot-time and using the firmware interface.
 *
 * if_ath_ahb.c should use the same firmware interface
 * that if_ath_pci.c uses.
 */
#define	QCA953X_GMAC_BASE      (AR71XX_APB_BASE + 0x00070000)
#define	QCA953X_GMAC_SIZE      0x14
#define	QCA953X_WMAC_BASE      (AR71XX_APB_BASE + 0x00100000)
#define	QCA953X_WMAC_SIZE      0x20000
#define	QCA953X_EHCI_BASE      0x1b000000
#define	QCA953X_EHCI_SIZE      0x200
#define	QCA953X_SRIF_BASE      (AR71XX_APB_BASE + 0x00116000)
#define	QCA953X_SRIF_SIZE      0x1000

#define	QCA953X_PCI_CFG_BASE0  0x14000000
#define	QCA953X_PCI_CTRL_BASE0 (AR71XX_APB_BASE + 0x000f0000)
#define	QCA953X_PCI_CRP_BASE0  (AR71XX_APB_BASE + 0x000c0000)
#define	QCA953X_PCI_MEM_BASE0  0x10000000
#define	QCA953X_PCI_MEM_SIZE   0x02000000

/* PLL Block */
#define	QCA953X_PLL_CPU_CONFIG_REG		(AR71XX_PLL_CPU_BASE + 0x00)
#define	QCA953X_PLL_DDR_CONFIG_REG		(AR71XX_PLL_CPU_BASE + 0x04)
#define	QCA953X_PLL_CLK_CTRL_REG		(AR71XX_PLL_CPU_BASE + 0x08)

#define	QCA953X_PLL_ETH_XMII_CONTROL_REG	(AR71XX_PLL_CPU_BASE + 0x2c)
#define	QCA953X_PLL_ETH_SGMII_CONTROL_REG	(AR71XX_PLL_CPU_BASE + 0x48)

#define	QCA953X_PLL_CPU_CONFIG_NFRAC_SHIFT	0
#define	QCA953X_PLL_CPU_CONFIG_NFRAC_MASK	0x3f
#define	QCA953X_PLL_CPU_CONFIG_NINT_SHIFT	6
#define	QCA953X_PLL_CPU_CONFIG_NINT_MASK	0x3f
#define	QCA953X_PLL_CPU_CONFIG_REFDIV_SHIFT	12
#define	QCA953X_PLL_CPU_CONFIG_REFDIV_MASK	0x1f
#define	QCA953X_PLL_CPU_CONFIG_OUTDIV_SHIFT	19
#define	QCA953X_PLL_CPU_CONFIG_OUTDIV_MASK	0x3

#define	QCA953X_PLL_DDR_CONFIG_NFRAC_SHIFT	0
#define	QCA953X_PLL_DDR_CONFIG_NFRAC_MASK	0x3ff
#define	QCA953X_PLL_DDR_CONFIG_NINT_SHIFT	10
#define	QCA953X_PLL_DDR_CONFIG_NINT_MASK	0x3f
#define	QCA953X_PLL_DDR_CONFIG_REFDIV_SHIFT	16
#define	QCA953X_PLL_DDR_CONFIG_REFDIV_MASK	0x1f
#define	QCA953X_PLL_DDR_CONFIG_OUTDIV_SHIFT	23
#define	QCA953X_PLL_DDR_CONFIG_OUTDIV_MASK	0x7

#define	QCA953X_PLL_CLK_CTRL_CPU_PLL_BYPASS	BIT(2)
#define	QCA953X_PLL_CLK_CTRL_DDR_PLL_BYPASS	BIT(3)
#define	QCA953X_PLL_CLK_CTRL_AHB_PLL_BYPASS	BIT(4)
#define	QCA953X_PLL_CLK_CTRL_CPU_POST_DIV_SHIFT	5
#define	QCA953X_PLL_CLK_CTRL_CPU_POST_DIV_MASK	0x1f
#define	QCA953X_PLL_CLK_CTRL_DDR_POST_DIV_SHIFT	10
#define	QCA953X_PLL_CLK_CTRL_DDR_POST_DIV_MASK	0x1f
#define	QCA953X_PLL_CLK_CTRL_AHB_POST_DIV_SHIFT	15
#define	QCA953X_PLL_CLK_CTRL_AHB_POST_DIV_MASK	0x1f
#define	QCA953X_PLL_CLK_CTRL_CPUCLK_FROM_CPUPLL	BIT(20)
#define	QCA953X_PLL_CLK_CTRL_DDRCLK_FROM_DDRPLL	BIT(21)
#define	QCA953X_PLL_CLK_CTRL_AHBCLK_FROM_DDRPLL	BIT(24)

#define	QCA953X_PLL_VAL_1000			0x16000000
#define	QCA953X_PLL_VAL_100			0x00000101
#define	QCA953X_PLL_VAL_10			0x00001616

/* Reset block */

#define	QCA953X_RESET_REG_RESET_MODULE		(AR71XX_RST_BLOCK_BASE + 0x1c)
#define	QCA953X_RESET_USB_EXT_PWR		BIT(29)
#define	QCA953X_RESET_EXTERNAL			BIT(28)
#define	QCA953X_RESET_RTC			BIT(27)
#define	QCA953X_RESET_FULL_CHIP			BIT(24)
#define	QCA953X_RESET_GE1_MDIO			BIT(23)
#define	QCA953X_RESET_GE0_MDIO			BIT(22)
#define	QCA953X_RESET_CPU_NMI			BIT(21)
#define	QCA953X_RESET_CPU_COLD			BIT(20)
#define	QCA953X_RESET_DDR			BIT(16)
#define	QCA953X_RESET_USB_PHY_PLL_PWD_EXT	BIT(15)
#define	QCA953X_RESET_GE1_MAC			BIT(13)
#define	QCA953X_RESET_ETH_SWITCH_ANALOG		BIT(12)
#define	QCA953X_RESET_USB_PHY_ANALOG		BIT(11)
#define	QCA953X_RESET_GE0_MAC			BIT(9)
#define	QCA953X_RESET_ETH_SWITCH		BIT(8)
#define	QCA953X_RESET_PCIE_PHY			BIT(7)
#define	QCA953X_RESET_PCIE			BIT(6)
#define	QCA953X_RESET_USB_HOST			BIT(5)
#define	QCA953X_RESET_USB_PHY			BIT(4)
#define	QCA953X_RESET_USBSUS_OVERRIDE		BIT(3)

#define	QCA953X_RESET_REG_BOOTSTRAP		(AR71XX_RST_BLOCK_BASE + 0xb0)
#define	QCA953X_BOOTSTRAP_SW_OPTION2		BIT(12)
#define	QCA953X_BOOTSTRAP_SW_OPTION1		BIT(11)
#define	QCA953X_BOOTSTRAP_EJTAG_MODE		BIT(5)
#define	QCA953X_BOOTSTRAP_REF_CLK_40		BIT(4)
#define	QCA953X_BOOTSTRAP_SDRAM_DISABLED	BIT(1)
#define	QCA953X_BOOTSTRAP_DDR1			BIT(0)

#define	QCA953X_RESET_REG_EXT_INT_STATUS	(AR71XX_RST_BLOCK_BASE + 0xac)

#define	QCA953X_DDR_REG_FLUSH_GE0		(AR71XX_APB_BASE + 0x9c)
#define	QCA953X_DDR_REG_FLUSH_GE1		(AR71XX_APB_BASE + 0xa0)
#define	QCA953X_DDR_REG_FLUSH_USB		(AR71XX_APB_BASE + 0xa4)
#define	QCA953X_DDR_REG_FLUSH_PCIE		(AR71XX_APB_BASE + 0xa8)
#define	QCA953X_DDR_REG_FLUSH_WMAC		(AR71XX_APB_BASE + 0xac)

/* GPIO block */
#define	QCA953X_GPIO_REG_OUT_FUNC0	0x2c
#define	QCA953X_GPIO_REG_OUT_FUNC1	0x30
#define	QCA953X_GPIO_REG_OUT_FUNC2	0x34
#define	QCA953X_GPIO_REG_OUT_FUNC3	0x38
#define	QCA953X_GPIO_REG_OUT_FUNC4	0x3c
#define	QCA953X_GPIO_REG_IN_ENABLE0	0x44
#define	QCA953X_GPIO_REG_FUNC		0x6c

#define	QCA953X_GPIO_OUT_MUX_SPI_CS1	10
#define	QCA953X_GPIO_OUT_MUX_SPI_CS2	11
#define	QCA953X_GPIO_OUT_MUX_SPI_CS0	9
#define	QCA953X_GPIO_OUT_MUX_SPI_CLK	8
#define	QCA953X_GPIO_OUT_MUX_SPI_MOSI	12
#define	QCA953X_GPIO_OUT_MUX_LED_LINK1	41
#define	QCA953X_GPIO_OUT_MUX_LED_LINK2	42
#define	QCA953X_GPIO_OUT_MUX_LED_LINK3	43
#define	QCA953X_GPIO_OUT_MUX_LED_LINK4	44
#define	QCA953X_GPIO_OUT_MUX_LED_LINK5	45

#define	QCA953X_GPIO_COUNT		18

/* GMAC block */
#define	QCA953X_GMAC_REG_ETH_CFG	(QCA953X_GMAC_BASE + 0x00)

#define	QCA953X_ETH_CFG_SW_ONLY_MODE		BIT(6)
#define	QCA953X_ETH_CFG_SW_PHY_SWAP		BIT(7)
#define	QCA953X_ETH_CFG_SW_APB_ACCESS		BIT(9)
#define	QCA953X_ETH_CFG_SW_ACC_MSB_FIRST	BIT(13)

/* SRIF block */
#define	QCA953X_SRIF_CPU_DPLL1_REG		0x1c0
#define	QCA953X_SRIF_CPU_DPLL2_REG		0x1c4
#define	QCA953X_SRIF_CPU_DPLL3_REG		0x1c8

#define	QCA953X_SRIF_DDR_DPLL1_REG		0x240
#define	QCA953X_SRIF_DDR_DPLL2_REG		0x244
#define	QCA953X_SRIF_DDR_DPLL3_REG		0x248

#define	QCA953X_SRIF_DPLL1_REFDIV_SHIFT		27
#define	QCA953X_SRIF_DPLL1_REFDIV_MASK		0x1f
#define	QCA953X_SRIF_DPLL1_NINT_SHIFT		18
#define	QCA953X_SRIF_DPLL1_NINT_MASK		0x1ff
#define	QCA953X_SRIF_DPLL1_NFRAC_MASK		0x0003ffff

#define	QCA953X_SRIF_DPLL2_LOCAL_PLL		BIT(30)
#define	QCA953X_SRIF_DPLL2_OUTDIV_SHIFT		13
#define	QCA953X_SRIF_DPLL2_OUTDIV_MASK		0x7

#endif	/* __QCA953XREG_H__ */
