#-
# Copyright (c) 2017-2018 Ruslan Bukin <br@bsdpad.com>
# All rights reserved.
#
# This software was developed by SRI International and the University of
# Cambridge Computer Laboratory under DARPA/AFRL contract FA8750-10-C-0237
# ("CTSRD"), as part of the DARPA CRASH research programme.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $FreeBSD: stable/12/sys/dev/flash/qspi_if.m 332885 2018-04-23 10:35:00Z br $
#

#include <sys/bus.h>
#include <sys/bio.h>

INTERFACE qspi;

METHOD int read {
	device_t dev;
	device_t child;
	struct bio *bp;
	off_t offset;
	caddr_t data;
	off_t count;
};

METHOD int write {
	device_t dev;
	device_t child;
	struct bio *bp;
	off_t offset;
	caddr_t data;
	off_t count;
};

METHOD int erase {
	device_t dev;
	device_t child;
	off_t offset;
};

METHOD int write_reg {
	device_t dev;
	device_t child;
	uint8_t opcode;
	uint8_t *addr;
	uint32_t len;
};

METHOD int read_reg {
	device_t dev;
	device_t child;
	uint8_t opcode;
	uint8_t *addr;
	uint32_t len;
};
