/*-
 * Copyright (c) 2020 The FreeBSD Foundation
 *
 * This software was developed by Emmanuel Vadot under sponsorship
 * from the FreeBSD Foundation.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/12/sys/compat/linuxkpi/common/include/linux/sizes.h 364674 2020-08-24 13:19:16Z manu $
 */

#ifndef __LINUX_SIZES_H__
#define	__LINUX_SIZES_H__

#define SZ_1K	(1024 * 1)
#define SZ_4K	(1024 * 4)
#define SZ_8K	(1024 * 8)
#define SZ_16K	(1024 * 16)
#define SZ_32K	(1024 * 32)
#define SZ_64K	(1024 * 64)
#define SZ_128K	(1024 * 128)
#define SZ_256K	(1024 * 256)
#define SZ_512K	(1024 * 512)

#define SZ_1M	(1024 * 1024 * 1)
#define SZ_2M	(1024 * 1024 * 2)
#define SZ_8M	(1024 * 1024 * 8)
#define SZ_16M	(1024 * 1024 * 16)
#define SZ_32M	(1024 * 1024 * 32)
#define SZ_64M	(1024 * 1024 * 64)

#endif
