/*

  Broadcom B43 wireless driver
  IEEE 802.11n PHY data tables

  Copyright (c) 2008 Michael Buesch <m@bues.ch>
  Copyright (c) 2010 Rafał Miłecki <zajec5@gmail.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
  Boston, MA 02110-1301, USA.

*/

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/11/sys/gnu/dev/bwn/phy_n/if_bwn_radio_2055.c 300190 2016-05-19 04:45:50Z adrian $");

/*
 * The Broadcom Wireless LAN controller driver.
 */

#include "opt_wlan.h"
#include "opt_bwn.h"

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/malloc.h>
#include <sys/module.h>
#include <sys/endian.h>
#include <sys/errno.h>
#include <sys/firmware.h>
#include <sys/lock.h>
#include <sys/mutex.h>
#include <machine/bus.h>
#include <machine/resource.h>
#include <sys/bus.h>
#include <sys/rman.h>
#include <sys/socket.h>
#include <sys/sockio.h>

#include <net/ethernet.h>
#include <net/if.h>
#include <net/if_var.h>
#include <net/if_arp.h>
#include <net/if_dl.h>
#include <net/if_llc.h>
#include <net/if_media.h>
#include <net/if_types.h>

#include <dev/pci/pcivar.h>
#include <dev/pci/pcireg.h>
#include <dev/siba/siba_ids.h>
#include <dev/siba/sibareg.h>
#include <dev/siba/sibavar.h>

#include <net80211/ieee80211_var.h>
#include <net80211/ieee80211_radiotap.h>
#include <net80211/ieee80211_regdomain.h>
#include <net80211/ieee80211_phy.h>
#include <net80211/ieee80211_ratectl.h>

#include <dev/bwn/if_bwnreg.h>
#include <dev/bwn/if_bwnvar.h>
#include <dev/bwn/if_bwn_debug.h>

#include <gnu/dev/bwn/phy_n/if_bwn_phy_n_regs.h>
#include <gnu/dev/bwn/phy_n/if_bwn_phy_n_tables.h>
#include <gnu/dev/bwn/phy_n/if_bwn_radio_2055.h>

struct b2055_inittab_entry {
	/* Value to write if we use the 5GHz band. */
	uint16_t ghz5;
	/* Value to write if we use the 2.4GHz band. */
	uint16_t ghz2;
	/* Flags */
	uint8_t flags;
#define B2055_INITTAB_ENTRY_OK	0x01
#define B2055_INITTAB_UPLOAD	0x02
};
#define UPLOAD		.flags = B2055_INITTAB_ENTRY_OK | B2055_INITTAB_UPLOAD
#define NOUPLOAD	.flags = B2055_INITTAB_ENTRY_OK

static const struct b2055_inittab_entry b2055_inittab [] = {
  [B2055_SP_PINPD]		= { .ghz5 = 0x0080, .ghz2 = 0x0080, NOUPLOAD, },
  [B2055_C1_SP_RSSI]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_SP_PDMISC]		= { .ghz5 = 0x0027, .ghz2 = 0x0027, NOUPLOAD, },
  [B2055_C2_SP_RSSI]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_SP_PDMISC]		= { .ghz5 = 0x0027, .ghz2 = 0x0027, NOUPLOAD, },
  [B2055_C1_SP_RXGC1]		= { .ghz5 = 0x007F, .ghz2 = 0x007F, UPLOAD, },
  [B2055_C1_SP_RXGC2]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, UPLOAD, },
  [B2055_C2_SP_RXGC1]		= { .ghz5 = 0x007F, .ghz2 = 0x007F, UPLOAD, },
  [B2055_C2_SP_RXGC2]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, UPLOAD, },
  [B2055_C1_SP_LPFBWSEL]	= { .ghz5 = 0x0015, .ghz2 = 0x0015, NOUPLOAD, },
  [B2055_C2_SP_LPFBWSEL]	= { .ghz5 = 0x0015, .ghz2 = 0x0015, NOUPLOAD, },
  [B2055_C1_SP_TXGC1]		= { .ghz5 = 0x004F, .ghz2 = 0x004F, UPLOAD, },
  [B2055_C1_SP_TXGC2]		= { .ghz5 = 0x0005, .ghz2 = 0x0005, UPLOAD, },
  [B2055_C2_SP_TXGC1]		= { .ghz5 = 0x004F, .ghz2 = 0x004F, UPLOAD, },
  [B2055_C2_SP_TXGC2]		= { .ghz5 = 0x0005, .ghz2 = 0x0005, UPLOAD, },
  [B2055_MASTER1]		= { .ghz5 = 0x00D0, .ghz2 = 0x00D0, NOUPLOAD, },
  [B2055_MASTER2]		= { .ghz5 = 0x0002, .ghz2 = 0x0002, NOUPLOAD, },
  [B2055_PD_LGEN]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_PD_PLLTS]		= { .ghz5 = 0x0040, .ghz2 = 0x0040, NOUPLOAD, },
  [B2055_C1_PD_LGBUF]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_PD_TX]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_PD_RXTX]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_PD_RSSIMISC]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_PD_LGBUF]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_PD_TX]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_PD_RXTX]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_PD_RSSIMISC]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_PWRDET_LGEN]		= { .ghz5 = 0x00C0, .ghz2 = 0x00C0, NOUPLOAD, },
  [B2055_C1_PWRDET_LGBUF]	= { .ghz5 = 0x00FF, .ghz2 = 0x00FF, NOUPLOAD, },
  [B2055_C1_PWRDET_RXTX]	= { .ghz5 = 0x00C0, .ghz2 = 0x00C0, NOUPLOAD, },
  [B2055_C2_PWRDET_LGBUF]	= { .ghz5 = 0x00FF, .ghz2 = 0x00FF, NOUPLOAD, },
  [B2055_C2_PWRDET_RXTX]	= { .ghz5 = 0x00C0, .ghz2 = 0x00C0, NOUPLOAD, },
  [B2055_RRCCAL_CS]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_RRCCAL_NOPTSEL]	= { .ghz5 = 0x002C, .ghz2 = 0x002C, NOUPLOAD, },
  [B2055_CAL_MISC]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_COUT]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_COUT2]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_CVARCTL]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_RVARCTL]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_LPOCTL]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_TS]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_RCCALRTS]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_RCALRTS]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_PADDRV]		= { .ghz5 = 0x00A4, .ghz2 = 0x00A4, NOUPLOAD, },
  [B2055_XOCTL1]		= { .ghz5 = 0x0038, .ghz2 = 0x0038, NOUPLOAD, },
  [B2055_XOCTL2]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_XOREGUL]		= { .ghz5 = 0x0004, .ghz2 = 0x0004, UPLOAD, },
  [B2055_XOMISC]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_PLL_LFC1]		= { .ghz5 = 0x000A, .ghz2 = 0x000A, NOUPLOAD, },
  [B2055_PLL_CALVTH]		= { .ghz5 = 0x0087, .ghz2 = 0x0087, NOUPLOAD, },
  [B2055_PLL_LFC2]		= { .ghz5 = 0x0009, .ghz2 = 0x0009, NOUPLOAD, },
  [B2055_PLL_REF]		= { .ghz5 = 0x0070, .ghz2 = 0x0070, NOUPLOAD, },
  [B2055_PLL_LFR1]		= { .ghz5 = 0x0011, .ghz2 = 0x0011, NOUPLOAD, },
  [B2055_PLL_PFDCP]		= { .ghz5 = 0x0018, .ghz2 = 0x0018, UPLOAD, },
  [B2055_PLL_IDAC_CPOPAMP]	= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_PLL_CPREG]		= { .ghz5 = 0x0004, .ghz2 = 0x0004, UPLOAD, },
  [B2055_PLL_RCAL]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_RF_PLLMOD0]		= { .ghz5 = 0x009E, .ghz2 = 0x009E, NOUPLOAD, },
  [B2055_RF_PLLMOD1]		= { .ghz5 = 0x0009, .ghz2 = 0x0009, NOUPLOAD, },
  [B2055_RF_MMDIDAC1]		= { .ghz5 = 0x00C8, .ghz2 = 0x00C8, UPLOAD, },
  [B2055_RF_MMDIDAC0]		= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_RF_MMDSP]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL1]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL2]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL3]		= { .ghz5 = 0x0001, .ghz2 = 0x0001, NOUPLOAD, },
  [B2055_VCO_CAL4]		= { .ghz5 = 0x0002, .ghz2 = 0x0002, NOUPLOAD, },
  [B2055_VCO_CAL5]		= { .ghz5 = 0x0096, .ghz2 = 0x0096, NOUPLOAD, },
  [B2055_VCO_CAL6]		= { .ghz5 = 0x003E, .ghz2 = 0x003E, NOUPLOAD, },
  [B2055_VCO_CAL7]		= { .ghz5 = 0x003E, .ghz2 = 0x003E, NOUPLOAD, },
  [B2055_VCO_CAL8]		= { .ghz5 = 0x0013, .ghz2 = 0x0013, NOUPLOAD, },
  [B2055_VCO_CAL9]		= { .ghz5 = 0x0002, .ghz2 = 0x0002, NOUPLOAD, },
  [B2055_VCO_CAL10]		= { .ghz5 = 0x0015, .ghz2 = 0x0015, NOUPLOAD, },
  [B2055_VCO_CAL11]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, NOUPLOAD, },
  [B2055_VCO_CAL12]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL13]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL14]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL15]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL16]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_KVCO]		= { .ghz5 = 0x0008, .ghz2 = 0x0008, NOUPLOAD, },
  [B2055_VCO_CAPTAIL]		= { .ghz5 = 0x0008, .ghz2 = 0x0008, NOUPLOAD, },
  [B2055_VCO_IDACVCO]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_VCO_REG]		= { .ghz5 = 0x0084, .ghz2 = 0x0084, UPLOAD, },
  [B2055_PLL_RFVTH]		= { .ghz5 = 0x00C3, .ghz2 = 0x00C3, NOUPLOAD, },
  [B2055_LGBUF_CENBUF]		= { .ghz5 = 0x008F, .ghz2 = 0x008F, NOUPLOAD, },
  [B2055_LGEN_TUNE1]		= { .ghz5 = 0x00FF, .ghz2 = 0x00FF, NOUPLOAD, },
  [B2055_LGEN_TUNE2]		= { .ghz5 = 0x00FF, .ghz2 = 0x00FF, NOUPLOAD, },
  [B2055_LGEN_IDAC1]		= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_LGEN_IDAC2]		= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_LGEN_BIASC]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_LGEN_BIASIDAC]		= { .ghz5 = 0x00CC, .ghz2 = 0x00CC, NOUPLOAD, },
  [B2055_LGEN_RCAL]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_LGEN_DIV]		= { .ghz5 = 0x0080, .ghz2 = 0x0080, NOUPLOAD, },
  [B2055_LGEN_SPARE2]		= { .ghz5 = 0x0080, .ghz2 = 0x0080, NOUPLOAD, },
  [B2055_C1_LGBUF_ATUNE]	= { .ghz5 = 0x00F8, .ghz2 = 0x00F8, NOUPLOAD, },
  [B2055_C1_LGBUF_GTUNE]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C1_LGBUF_DIV]		= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C1_LGBUF_AIDAC]	= { .ghz5 = 0x0088, .ghz2 = 0x0008, UPLOAD, },
  [B2055_C1_LGBUF_GIDAC]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C1_LGBUF_IDACFO]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_LGBUF_SPARE]	= { .ghz5 = 0x0001, .ghz2 = 0x0001, UPLOAD, },
  [B2055_C1_RX_RFSPC1]		= { .ghz5 = 0x008A, .ghz2 = 0x008A, NOUPLOAD, },
  [B2055_C1_RX_RFR1]		= { .ghz5 = 0x0008, .ghz2 = 0x0008, NOUPLOAD, },
  [B2055_C1_RX_RFR2]		= { .ghz5 = 0x0083, .ghz2 = 0x0083, NOUPLOAD, },
  [B2055_C1_RX_RFRCAL]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_C1_RX_BB_BLCMP]	= { .ghz5 = 0x00A0, .ghz2 = 0x00A0, NOUPLOAD, },
  [B2055_C1_RX_BB_LPF]		= { .ghz5 = 0x000A, .ghz2 = 0x000A, NOUPLOAD, },
  [B2055_C1_RX_BB_MIDACHP]	= { .ghz5 = 0x0087, .ghz2 = 0x0087, UPLOAD, },
  [B2055_C1_RX_BB_VGA1IDAC]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C1_RX_BB_VGA2IDAC]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C1_RX_BB_VGA3IDAC]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C1_RX_BB_BUFOCTL]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C1_RX_BB_RCCALCTL]	= { .ghz5 = 0x0018, .ghz2 = 0x0018, NOUPLOAD, },
  [B2055_C1_RX_BB_RSSICTL1]	= { .ghz5 = 0x006A, .ghz2 = 0x006A, UPLOAD, },
  [B2055_C1_RX_BB_RSSICTL2]	= { .ghz5 = 0x00AB, .ghz2 = 0x00AB, UPLOAD, },
  [B2055_C1_RX_BB_RSSICTL3]	= { .ghz5 = 0x0013, .ghz2 = 0x0013, UPLOAD, },
  [B2055_C1_RX_BB_RSSICTL4]	= { .ghz5 = 0x00C1, .ghz2 = 0x00C1, UPLOAD, },
  [B2055_C1_RX_BB_RSSICTL5]	= { .ghz5 = 0x00AA, .ghz2 = 0x00AA, UPLOAD, },
  [B2055_C1_RX_BB_REG]		= { .ghz5 = 0x0087, .ghz2 = 0x0087, UPLOAD, },
  [B2055_C1_RX_BB_SPARE1]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_RX_TXBBRCAL]	= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_C1_TX_RF_SPGA]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, NOUPLOAD, },
  [B2055_C1_TX_RF_SPAD]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, NOUPLOAD, },
  [B2055_C1_TX_RF_CNTPGA1]	= { .ghz5 = 0x0015, .ghz2 = 0x0015, NOUPLOAD, },
  [B2055_C1_TX_RF_CNTPAD1]	= { .ghz5 = 0x0055, .ghz2 = 0x0055, NOUPLOAD, },
  [B2055_C1_TX_RF_PGAIDAC]	= { .ghz5 = 0x0097, .ghz2 = 0x0097, UPLOAD, },
  [B2055_C1_TX_PGAPADTN]	= { .ghz5 = 0x0008, .ghz2 = 0x0008, NOUPLOAD, },
  [B2055_C1_TX_PADIDAC1]	= { .ghz5 = 0x0014, .ghz2 = 0x0014, UPLOAD, },
  [B2055_C1_TX_PADIDAC2]	= { .ghz5 = 0x0033, .ghz2 = 0x0033, NOUPLOAD, },
  [B2055_C1_TX_MXBGTRIM]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C1_TX_RF_RCAL]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_C1_TX_RF_PADTSSI1]	= { .ghz5 = 0x0003, .ghz2 = 0x0003, UPLOAD, },
  [B2055_C1_TX_RF_PADTSSI2]	= { .ghz5 = 0x000A, .ghz2 = 0x000A, NOUPLOAD, },
  [B2055_C1_TX_RF_SPARE]	= { .ghz5 = 0x0003, .ghz2 = 0x0003, UPLOAD, },
  [B2055_C1_TX_RF_IQCAL1]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C1_TX_RF_IQCAL2]	= { .ghz5 = 0x00A4, .ghz2 = 0x00A4, NOUPLOAD, },
  [B2055_C1_TXBB_RCCAL]		= { .ghz5 = 0x0018, .ghz2 = 0x0018, NOUPLOAD, },
  [B2055_C1_TXBB_LPF1]		= { .ghz5 = 0x0028, .ghz2 = 0x0028, NOUPLOAD, },
  [B2055_C1_TX_VOSCNCL]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_TX_LPF_MXGMIDAC]	= { .ghz5 = 0x004A, .ghz2 = 0x004A, NOUPLOAD, },
  [B2055_C1_TX_BB_MXGM]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_LGBUF_ATUNE]	= { .ghz5 = 0x00F8, .ghz2 = 0x00F8, NOUPLOAD, },
  [B2055_C2_LGBUF_GTUNE]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C2_LGBUF_DIV]		= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C2_LGBUF_AIDAC]	= { .ghz5 = 0x0088, .ghz2 = 0x0008, UPLOAD, },
  [B2055_C2_LGBUF_GIDAC]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C2_LGBUF_IDACFO]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_LGBUF_SPARE]	= { .ghz5 = 0x0001, .ghz2 = 0x0001, UPLOAD, },
  [B2055_C2_RX_RFSPC1]		= { .ghz5 = 0x008A, .ghz2 = 0x008A, NOUPLOAD, },
  [B2055_C2_RX_RFR1]		= { .ghz5 = 0x0008, .ghz2 = 0x0008, NOUPLOAD, },
  [B2055_C2_RX_RFR2]		= { .ghz5 = 0x0083, .ghz2 = 0x0083, NOUPLOAD, },
  [B2055_C2_RX_RFRCAL]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_C2_RX_BB_BLCMP]	= { .ghz5 = 0x00A0, .ghz2 = 0x00A0, NOUPLOAD, },
  [B2055_C2_RX_BB_LPF]		= { .ghz5 = 0x000A, .ghz2 = 0x000A, NOUPLOAD, },
  [B2055_C2_RX_BB_MIDACHP]	= { .ghz5 = 0x0087, .ghz2 = 0x0087, UPLOAD, },
  [B2055_C2_RX_BB_VGA1IDAC]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C2_RX_BB_VGA2IDAC]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C2_RX_BB_VGA3IDAC]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C2_RX_BB_BUFOCTL]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C2_RX_BB_RCCALCTL]	= { .ghz5 = 0x0018, .ghz2 = 0x0018, NOUPLOAD, },
  [B2055_C2_RX_BB_RSSICTL1]	= { .ghz5 = 0x006A, .ghz2 = 0x006A, UPLOAD, },
  [B2055_C2_RX_BB_RSSICTL2]	= { .ghz5 = 0x00AB, .ghz2 = 0x00AB, UPLOAD, },
  [B2055_C2_RX_BB_RSSICTL3]	= { .ghz5 = 0x0013, .ghz2 = 0x0013, UPLOAD, },
  [B2055_C2_RX_BB_RSSICTL4]	= { .ghz5 = 0x00C1, .ghz2 = 0x00C1, UPLOAD, },
  [B2055_C2_RX_BB_RSSICTL5]	= { .ghz5 = 0x00AA, .ghz2 = 0x00AA, UPLOAD, },
  [B2055_C2_RX_BB_REG]		= { .ghz5 = 0x0087, .ghz2 = 0x0087, UPLOAD, },
  [B2055_C2_RX_BB_SPARE1]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_RX_TXBBRCAL]	= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_C2_TX_RF_SPGA]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, NOUPLOAD, },
  [B2055_C2_TX_RF_SPAD]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, NOUPLOAD, },
  [B2055_C2_TX_RF_CNTPGA1]	= { .ghz5 = 0x0015, .ghz2 = 0x0015, NOUPLOAD, },
  [B2055_C2_TX_RF_CNTPAD1]	= { .ghz5 = 0x0055, .ghz2 = 0x0055, NOUPLOAD, },
  [B2055_C2_TX_RF_PGAIDAC]	= { .ghz5 = 0x0097, .ghz2 = 0x0097, UPLOAD, },
  [B2055_C2_TX_PGAPADTN]	= { .ghz5 = 0x0008, .ghz2 = 0x0008, NOUPLOAD, },
  [B2055_C2_TX_PADIDAC1]	= { .ghz5 = 0x0014, .ghz2 = 0x0014, UPLOAD, },
  [B2055_C2_TX_PADIDAC2]	= { .ghz5 = 0x0033, .ghz2 = 0x0033, NOUPLOAD, },
  [B2055_C2_TX_MXBGTRIM]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C2_TX_RF_RCAL]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_C2_TX_RF_PADTSSI1]	= { .ghz5 = 0x0003, .ghz2 = 0x0003, UPLOAD, },
  [B2055_C2_TX_RF_PADTSSI2]	= { .ghz5 = 0x000A, .ghz2 = 0x000A, NOUPLOAD, },
  [B2055_C2_TX_RF_SPARE]	= { .ghz5 = 0x0003, .ghz2 = 0x0003, UPLOAD, },
  [B2055_C2_TX_RF_IQCAL1]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C2_TX_RF_IQCAL2]	= { .ghz5 = 0x00A4, .ghz2 = 0x00A4, NOUPLOAD, },
  [B2055_C2_TXBB_RCCAL]		= { .ghz5 = 0x0018, .ghz2 = 0x0018, NOUPLOAD, },
  [B2055_C2_TXBB_LPF1]		= { .ghz5 = 0x0028, .ghz2 = 0x0028, NOUPLOAD, },
  [B2055_C2_TX_VOSCNCL]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_TX_LPF_MXGMIDAC]	= { .ghz5 = 0x004A, .ghz2 = 0x004A, NOUPLOAD, },
  [B2055_C2_TX_BB_MXGM]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_PRG_GCHP21]		= { .ghz5 = 0x0071, .ghz2 = 0x0071, NOUPLOAD, },
  [B2055_PRG_GCHP22]		= { .ghz5 = 0x0072, .ghz2 = 0x0072, NOUPLOAD, },
  [B2055_PRG_GCHP23]		= { .ghz5 = 0x0073, .ghz2 = 0x0073, NOUPLOAD, },
  [B2055_PRG_GCHP24]		= { .ghz5 = 0x0074, .ghz2 = 0x0074, NOUPLOAD, },
  [B2055_PRG_GCHP25]		= { .ghz5 = 0x0075, .ghz2 = 0x0075, NOUPLOAD, },
  [B2055_PRG_GCHP26]		= { .ghz5 = 0x0076, .ghz2 = 0x0076, NOUPLOAD, },
  [B2055_PRG_GCHP27]		= { .ghz5 = 0x0077, .ghz2 = 0x0077, NOUPLOAD, },
  [B2055_PRG_GCHP28]		= { .ghz5 = 0x0078, .ghz2 = 0x0078, NOUPLOAD, },
  [B2055_PRG_GCHP29]		= { .ghz5 = 0x0079, .ghz2 = 0x0079, NOUPLOAD, },
  [B2055_PRG_GCHP30]		= { .ghz5 = 0x007A, .ghz2 = 0x007A, NOUPLOAD, },
  [0xC7]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xC8]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xC9]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xCA]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xCB]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xCC]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_LNA_GAINBST]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xCE]			= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [0xCF]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xD0]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xD1]			= { .ghz5 = 0x0018, .ghz2 = 0x0018, NOUPLOAD, },
  [B2055_C1_B0NB_RSSIVCM]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [0xD3]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xD4]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xD5]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_GENSPARE2]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xD7]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xD8]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_LNA_GAINBST]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xDA]			= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [0xDB]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xDC]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xDD]			= { .ghz5 = 0x0018, .ghz2 = 0x0018, NOUPLOAD, },
  [B2055_C2_B0NB_RSSIVCM]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [0xDF]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xE0]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xE1]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_GENSPARE2]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
};

#define RADIOREGS(r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, \
		  r12, r13, r14, r15, r16, r17, r18, r19, r20, r21) \
	.radio_pll_ref		= r0,	\
	.radio_rf_pllmod0	= r1,	\
	.radio_rf_pllmod1	= r2,	\
	.radio_vco_captail	= r3,	\
	.radio_vco_cal1		= r4,	\
	.radio_vco_cal2		= r5,	\
	.radio_pll_lfc1		= r6,	\
	.radio_pll_lfr1		= r7,	\
	.radio_pll_lfc2		= r8,	\
	.radio_lgbuf_cenbuf	= r9,	\
	.radio_lgen_tune1	= r10,	\
	.radio_lgen_tune2	= r11,	\
	.radio_c1_lgbuf_atune	= r12,	\
	.radio_c1_lgbuf_gtune	= r13,	\
	.radio_c1_rx_rfr1	= r14,	\
	.radio_c1_tx_pgapadtn	= r15,	\
	.radio_c1_tx_mxbgtrim	= r16,	\
	.radio_c2_lgbuf_atune	= r17,	\
	.radio_c2_lgbuf_gtune	= r18,	\
	.radio_c2_rx_rfr1	= r19,	\
	.radio_c2_tx_pgapadtn	= r20,	\
	.radio_c2_tx_mxbgtrim	= r21

#define PHYREGS(r0, r1, r2, r3, r4, r5)	\
	.phy_regs.phy_bw1a	= r0,	\
	.phy_regs.phy_bw2	= r1,	\
	.phy_regs.phy_bw3	= r2,	\
	.phy_regs.phy_bw4	= r3,	\
	.phy_regs.phy_bw5	= r4,	\
	.phy_regs.phy_bw6	= r5

static const struct bwn_nphy_channeltab_entry_rev2 bwn_nphy_channeltab_rev2[] = {
  {	.channel		= 184,
	.freq			= 4920, /* MHz */
	.unk2			= 3280,
	RADIOREGS(0x71, 0xEC, 0x01, 0x0F, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07B4, 0x07B0, 0x07AC, 0x0214, 0x0215, 0x0216),
  },
  {	.channel		= 186,
	.freq			= 4930, /* MHz */
	.unk2			= 3287,
	RADIOREGS(0x71, 0xED, 0x01, 0x0F, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07B8, 0x07B4, 0x07B0, 0x0213, 0x0214, 0x0215),
  },
  {	.channel		= 188,
	.freq			= 4940, /* MHz */
	.unk2			= 3293,
	RADIOREGS(0x71, 0xEE, 0x01, 0x0F, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xEE, 0xEE, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07BC, 0x07B8, 0x07B4, 0x0212, 0x0213, 0x0214),
  },
  {	.channel		= 190,
	.freq			= 4950, /* MHz */
	.unk2			= 3300,
	RADIOREGS(0x71, 0xEF, 0x01, 0x0F, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xEE, 0xEE, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07C0, 0x07BC, 0x07B8, 0x0211, 0x0212, 0x0213),
  },
  {	.channel		= 192,
	.freq			= 4960, /* MHz */
	.unk2			= 3307,
	RADIOREGS(0x71, 0xF0, 0x01, 0x0F, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xEE, 0xEE, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07C4, 0x07C0, 0x07BC, 0x020F, 0x0211, 0x0212),
  },
  {	.channel		= 194,
	.freq			= 4970, /* MHz */
	.unk2			= 3313,
	RADIOREGS(0x71, 0xF1, 0x01, 0x0F, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xEE, 0xEE, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07C8, 0x07C4, 0x07C0, 0x020E, 0x020F, 0x0211),
  },
  {	.channel		= 196,
	.freq			= 4980, /* MHz */
	.unk2			= 3320,
	RADIOREGS(0x71, 0xF2, 0x01, 0x0E, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xDD, 0xDD, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07CC, 0x07C8, 0x07C4, 0x020D, 0x020E, 0x020F),
  },
  {	.channel		= 198,
	.freq			= 4990, /* MHz */
	.unk2			= 3327,
	RADIOREGS(0x71, 0xF3, 0x01, 0x0E, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xDD, 0xDD, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07D0, 0x07CC, 0x07C8, 0x020C, 0x020D, 0x020E),
  },
  {	.channel		= 200,
	.freq			= 5000, /* MHz */
	.unk2			= 3333,
	RADIOREGS(0x71, 0xF4, 0x01, 0x0E, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xDD, 0xDD, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07D4, 0x07D0, 0x07CC, 0x020B, 0x020C, 0x020D),
  },
  {	.channel		= 202,
	.freq			= 5010, /* MHz */
	.unk2			= 3340,
	RADIOREGS(0x71, 0xF5, 0x01, 0x0E, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xDD, 0xDD, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07D8, 0x07D4, 0x07D0, 0x020A, 0x020B, 0x020C),
  },
  {	.channel		= 204,
	.freq			= 5020, /* MHz */
	.unk2			= 3347,
	RADIOREGS(0x71, 0xF6, 0x01, 0x0E, 0xF7, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xCC, 0xCC, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07DC, 0x07D8, 0x07D4, 0x0209, 0x020A, 0x020B),
  },
  {	.channel		= 206,
	.freq			= 5030, /* MHz */
	.unk2			= 3353,
	RADIOREGS(0x71, 0xF7, 0x01, 0x0E, 0xF7, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xCC, 0xCC, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07E0, 0x07DC, 0x07D8, 0x0208, 0x0209, 0x020A),
  },
  {	.channel		= 208,
	.freq			= 5040, /* MHz */
	.unk2			= 3360,
	RADIOREGS(0x71, 0xF8, 0x01, 0x0D, 0xEF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xCC, 0xCC, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07E4, 0x07E0, 0x07DC, 0x0207, 0x0208, 0x0209),
  },
  {	.channel		= 210,
	.freq			= 5050, /* MHz */
	.unk2			= 3367,
	RADIOREGS(0x71, 0xF9, 0x01, 0x0D, 0xEF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xCC, 0xCC, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0x07E8, 0x07E4, 0x07E0, 0x0206, 0x0207, 0x0208),
  },
  {	.channel		= 212,
	.freq			= 5060, /* MHz */
	.unk2			= 3373,
	RADIOREGS(0x71, 0xFA, 0x01, 0x0D, 0xE6, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xBB, 0xBB, 0xFF, 0x00, 0x0E, 0x0F,
		  0x8E, 0xFF, 0x00, 0x0E, 0x0F, 0x8E),
	PHYREGS(0x07EC, 0x07E8, 0x07E4, 0x0205, 0x0206, 0x0207),
  },
  {	.channel		= 214,
	.freq			= 5070, /* MHz */
	.unk2			= 3380,
	RADIOREGS(0x71, 0xFB, 0x01, 0x0D, 0xE6, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xBB, 0xBB, 0xFF, 0x00, 0x0E, 0x0F,
		  0x8E, 0xFF, 0x00, 0x0E, 0x0F, 0x8E),
	PHYREGS(0x07F0, 0x07EC, 0x07E8, 0x0204, 0x0205, 0x0206),
  },
  {	.channel		= 216,
	.freq			= 5080, /* MHz */
	.unk2			= 3387,
	RADIOREGS(0x71, 0xFC, 0x01, 0x0D, 0xDE, 0x01, 0x04, 0x0A,
		  0x00, 0x8E, 0xBB, 0xBB, 0xEE, 0x00, 0x0E, 0x0F,
		  0x8D, 0xEE, 0x00, 0x0E, 0x0F, 0x8D),
	PHYREGS(0x07F4, 0x07F0, 0x07EC, 0x0203, 0x0204, 0x0205),
  },
  {	.channel		= 218,
	.freq			= 5090, /* MHz */
	.unk2			= 3393,
	RADIOREGS(0x71, 0xFD, 0x01, 0x0D, 0xDE, 0x01, 0x04, 0x0A,
		  0x00, 0x8E, 0xBB, 0xBB, 0xEE, 0x00, 0x0E, 0x0F,
		  0x8D, 0xEE, 0x00, 0x0E, 0x0F, 0x8D),
	PHYREGS(0x07F8, 0x07F4, 0x07F0, 0x0202, 0x0203, 0x0204),
  },
  {	.channel		= 220,
	.freq			= 5100, /* MHz */
	.unk2			= 3400,
	RADIOREGS(0x71, 0xFE, 0x01, 0x0C, 0xD6, 0x01, 0x04, 0x0A,
		  0x00, 0x8E, 0xAA, 0xAA, 0xEE, 0x00, 0x0D, 0x0F,
		  0x8D, 0xEE, 0x00, 0x0D, 0x0F, 0x8D),
	PHYREGS(0x07FC, 0x07F8, 0x07F4, 0x0201, 0x0202, 0x0203),
  },
  {	.channel		= 222,
	.freq			= 5110, /* MHz */
	.unk2			= 3407,
	RADIOREGS(0x71, 0xFF, 0x01, 0x0C, 0xD6, 0x01, 0x04, 0x0A,
		  0x00, 0x8E, 0xAA, 0xAA, 0xEE, 0x00, 0x0D, 0x0F,
		  0x8D, 0xEE, 0x00, 0x0D, 0x0F, 0x8D),
	PHYREGS(0x0800, 0x07FC, 0x07F8, 0x0200, 0x0201, 0x0202),
  },
  {	.channel		= 224,
	.freq			= 5120, /* MHz */
	.unk2			= 3413,
	RADIOREGS(0x71, 0x00, 0x02, 0x0C, 0xCE, 0x01, 0x04, 0x0A,
		  0x00, 0x8D, 0xAA, 0xAA, 0xDD, 0x00, 0x0D, 0x0F,
		  0x8C, 0xDD, 0x00, 0x0D, 0x0F, 0x8C),
	PHYREGS(0x0804, 0x0800, 0x07FC, 0x01FF, 0x0200, 0x0201),
  },
  {	.channel		= 226,
	.freq			= 5130, /* MHz */
	.unk2			= 3420,
	RADIOREGS(0x71, 0x01, 0x02, 0x0C, 0xCE, 0x01, 0x04, 0x0A,
		  0x00, 0x8D, 0xAA, 0xAA, 0xDD, 0x00, 0x0D, 0x0F,
		  0x8C, 0xDD, 0x00, 0x0D, 0x0F, 0x8C),
	PHYREGS(0x0808, 0x0804, 0x0800, 0x01FE, 0x01FF, 0x0200),
  },
  {	.channel		= 228,
	.freq			= 5140, /* MHz */
	.unk2			= 3427,
	RADIOREGS(0x71, 0x02, 0x02, 0x0C, 0xC6, 0x01, 0x04, 0x0A,
		  0x00, 0x8D, 0x99, 0x99, 0xDD, 0x00, 0x0C, 0x0E,
		  0x8B, 0xDD, 0x00, 0x0C, 0x0E, 0x8B),
	PHYREGS(0x080C, 0x0808, 0x0804, 0x01FD, 0x01FE, 0x01FF),
  },
  {	.channel		= 32,
	.freq			= 5160, /* MHz */
	.unk2			= 3440,
	RADIOREGS(0x71, 0x04, 0x02, 0x0B, 0xBE, 0x01, 0x04, 0x0A,
		  0x00, 0x8C, 0x99, 0x99, 0xCC, 0x00, 0x0B, 0x0D,
		  0x8A, 0xCC, 0x00, 0x0B, 0x0D, 0x8A),
	PHYREGS(0x0814, 0x0810, 0x080C, 0x01FB, 0x01FC, 0x01FD),
  },
  {	.channel		= 34,
	.freq			= 5170, /* MHz */
	.unk2			= 3447,
	RADIOREGS(0x71, 0x05, 0x02, 0x0B, 0xBE, 0x01, 0x04, 0x0A,
		  0x00, 0x8C, 0x99, 0x99, 0xCC, 0x00, 0x0B, 0x0D,
		  0x8A, 0xCC, 0x00, 0x0B, 0x0D, 0x8A),
	PHYREGS(0x0818, 0x0814, 0x0810, 0x01FA, 0x01FB, 0x01FC),
  },
  {	.channel		= 36,
	.freq			= 5180, /* MHz */
	.unk2			= 3453,
	RADIOREGS(0x71, 0x06, 0x02, 0x0B, 0xB6, 0x01, 0x04, 0x0A,
		  0x00, 0x8C, 0x88, 0x88, 0xCC, 0x00, 0x0B, 0x0C,
		  0x89, 0xCC, 0x00, 0x0B, 0x0C, 0x89),
	PHYREGS(0x081C, 0x0818, 0x0814, 0x01F9, 0x01FA, 0x01FB),
  },
  {	.channel		= 38,
	.freq			= 5190, /* MHz */
	.unk2			= 3460,
	RADIOREGS(0x71, 0x07, 0x02, 0x0B, 0xB6, 0x01, 0x04, 0x0A,
		  0x00, 0x8C, 0x88, 0x88, 0xCC, 0x00, 0x0B, 0x0C,
		  0x89, 0xCC, 0x00, 0x0B, 0x0C, 0x89),
	PHYREGS(0x0820, 0x081C, 0x0818, 0x01F8, 0x01F9, 0x01FA),
  },
  {	.channel		= 40,
	.freq			= 5200, /* MHz */
	.unk2			= 3467,
	RADIOREGS(0x71, 0x08, 0x02, 0x0B, 0xAF, 0x01, 0x04, 0x0A,
		  0x00, 0x8B, 0x88, 0x88, 0xBB, 0x00, 0x0A, 0x0B,
		  0x89, 0xBB, 0x00, 0x0A, 0x0B, 0x89),
	PHYREGS(0x0824, 0x0820, 0x081C, 0x01F7, 0x01F8, 0x01F9),
  },
  {	.channel		= 42,
	.freq			= 5210, /* MHz */
	.unk2			= 3473,
	RADIOREGS(0x71, 0x09, 0x02, 0x0B, 0xAF, 0x01, 0x04, 0x0A,
		  0x00, 0x8B, 0x88, 0x88, 0xBB, 0x00, 0x0A, 0x0B,
		  0x89, 0xBB, 0x00, 0x0A, 0x0B, 0x89),
	PHYREGS(0x0828, 0x0824, 0x0820, 0x01F6, 0x01F7, 0x01F8),
  },
  {	.channel		= 44,
	.freq			= 5220, /* MHz */
	.unk2			= 3480,
	RADIOREGS(0x71, 0x0A, 0x02, 0x0A, 0xA7, 0x01, 0x04, 0x0A,
		  0x00, 0x8B, 0x77, 0x77, 0xBB, 0x00, 0x09, 0x0A,
		  0x88, 0xBB, 0x00, 0x09, 0x0A, 0x88),
	PHYREGS(0x082C, 0x0828, 0x0824, 0x01F5, 0x01F6, 0x01F7),
  },
  {	.channel		= 46,
	.freq			= 5230, /* MHz */
	.unk2			= 3487,
	RADIOREGS(0x71, 0x0B, 0x02, 0x0A, 0xA7, 0x01, 0x04, 0x0A,
		  0x00, 0x8B, 0x77, 0x77, 0xBB, 0x00, 0x09, 0x0A,
		  0x88, 0xBB, 0x00, 0x09, 0x0A, 0x88),
	PHYREGS(0x0830, 0x082C, 0x0828, 0x01F4, 0x01F5, 0x01F6),
  },
  {	.channel		= 48,
	.freq			= 5240, /* MHz */
	.unk2			= 3493,
	RADIOREGS(0x71, 0x0C, 0x02, 0x0A, 0xA0, 0x01, 0x04, 0x0A,
		  0x00, 0x8A, 0x77, 0x77, 0xAA, 0x00, 0x09, 0x0A,
		  0x87, 0xAA, 0x00, 0x09, 0x0A, 0x87),
	PHYREGS(0x0834, 0x0830, 0x082C, 0x01F3, 0x01F4, 0x01F5),
  },
  {	.channel		= 50,
	.freq			= 5250, /* MHz */
	.unk2			= 3500,
	RADIOREGS(0x71, 0x0D, 0x02, 0x0A, 0xA0, 0x01, 0x04, 0x0A,
		  0x00, 0x8A, 0x77, 0x77, 0xAA, 0x00, 0x09, 0x0A,
		  0x87, 0xAA, 0x00, 0x09, 0x0A, 0x87),
	PHYREGS(0x0838, 0x0834, 0x0830, 0x01F2, 0x01F3, 0x01F4),
  },
  {	.channel		= 52,
	.freq			= 5260, /* MHz */
	.unk2			= 3507,
	RADIOREGS(0x71, 0x0E, 0x02, 0x0A, 0x98, 0x01, 0x04, 0x0A,
		  0x00, 0x8A, 0x66, 0x66, 0xAA, 0x00, 0x08, 0x09,
		  0x87, 0xAA, 0x00, 0x08, 0x09, 0x87),
	PHYREGS(0x083C, 0x0838, 0x0834, 0x01F1, 0x01F2, 0x01F3),
  },
  {	.channel		= 54,
	.freq			= 5270, /* MHz */
	.unk2			= 3513,
	RADIOREGS(0x71, 0x0F, 0x02, 0x0A, 0x98, 0x01, 0x04, 0x0A,
		  0x00, 0x8A, 0x66, 0x66, 0xAA, 0x00, 0x08, 0x09,
		  0x87, 0xAA, 0x00, 0x08, 0x09, 0x87),
	PHYREGS(0x0840, 0x083C, 0x0838, 0x01F0, 0x01F1, 0x01F2),
  },
  {	.channel		= 56,
	.freq			= 5280, /* MHz */
	.unk2			= 3520,
	RADIOREGS(0x71, 0x10, 0x02, 0x09, 0x91, 0x01, 0x04, 0x0A,
		  0x00, 0x89, 0x66, 0x66, 0x99, 0x00, 0x08, 0x08,
		  0x86, 0x99, 0x00, 0x08, 0x08, 0x86),
	PHYREGS(0x0844, 0x0840, 0x083C, 0x01F0, 0x01F0, 0x01F1),
  },
  {	.channel		= 58,
	.freq			= 5290, /* MHz */
	.unk2			= 3527,
	RADIOREGS(0x71, 0x11, 0x02, 0x09, 0x91, 0x01, 0x04, 0x0A,
		  0x00, 0x89, 0x66, 0x66, 0x99, 0x00, 0x08, 0x08,
		  0x86, 0x99, 0x00, 0x08, 0x08, 0x86),
	PHYREGS(0x0848, 0x0844, 0x0840, 0x01EF, 0x01F0, 0x01F0),
  },
  {	.channel		= 60,
	.freq			= 5300, /* MHz */
	.unk2			= 3533,
	RADIOREGS(0x71, 0x12, 0x02, 0x09, 0x8A, 0x01, 0x04, 0x0A,
		  0x00, 0x89, 0x55, 0x55, 0x99, 0x00, 0x08, 0x07,
		  0x85, 0x99, 0x00, 0x08, 0x07, 0x85),
	PHYREGS(0x084C, 0x0848, 0x0844, 0x01EE, 0x01EF, 0x01F0),
  },
  {	.channel		= 62,
	.freq			= 5310, /* MHz */
	.unk2			= 3540,
	RADIOREGS(0x71, 0x13, 0x02, 0x09, 0x8A, 0x01, 0x04, 0x0A,
		  0x00, 0x89, 0x55, 0x55, 0x99, 0x00, 0x08, 0x07,
		  0x85, 0x99, 0x00, 0x08, 0x07, 0x85),
	PHYREGS(0x0850, 0x084C, 0x0848, 0x01ED, 0x01EE, 0x01EF),
  },
  {	.channel		= 64,
	.freq			= 5320, /* MHz */
	.unk2			= 3547,
	RADIOREGS(0x71, 0x14, 0x02, 0x09, 0x83, 0x01, 0x04, 0x0A,
		  0x00, 0x88, 0x55, 0x55, 0x88, 0x00, 0x07, 0x07,
		  0x84, 0x88, 0x00, 0x07, 0x07, 0x84),
	PHYREGS(0x0854, 0x0850, 0x084C, 0x01EC, 0x01ED, 0x01EE),
  },
  {	.channel		= 66,
	.freq			= 5330, /* MHz */
	.unk2			= 3553,
	RADIOREGS(0x71, 0x15, 0x02, 0x09, 0x83, 0x01, 0x04, 0x0A,
		  0x00, 0x88, 0x55, 0x55, 0x88, 0x00, 0x07, 0x07,
		  0x84, 0x88, 0x00, 0x07, 0x07, 0x84),
	PHYREGS(0x0858, 0x0854, 0x0850, 0x01EB, 0x01EC, 0x01ED),
  },
  {	.channel		= 68,
	.freq			= 5340, /* MHz */
	.unk2			= 3560,
	RADIOREGS(0x71, 0x16, 0x02, 0x08, 0x7C, 0x01, 0x04, 0x0A,
		  0x00, 0x88, 0x44, 0x44, 0x88, 0x00, 0x07, 0x06,
		  0x84, 0x88, 0x00, 0x07, 0x06, 0x84),
	PHYREGS(0x085C, 0x0858, 0x0854, 0x01EA, 0x01EB, 0x01EC),
  },
  {	.channel		= 70,
	.freq			= 5350, /* MHz */
	.unk2			= 3567,
	RADIOREGS(0x71, 0x17, 0x02, 0x08, 0x7C, 0x01, 0x04, 0x0A,
		  0x00, 0x88, 0x44, 0x44, 0x88, 0x00, 0x07, 0x06,
		  0x84, 0x88, 0x00, 0x07, 0x06, 0x84),
	PHYREGS(0x0860, 0x085C, 0x0858, 0x01E9, 0x01EA, 0x01EB),
  },
  {	.channel		= 72,
	.freq			= 5360, /* MHz */
	.unk2			= 3573,
	RADIOREGS(0x71, 0x18, 0x02, 0x08, 0x75, 0x01, 0x04, 0x0A,
		  0x00, 0x87, 0x44, 0x44, 0x77, 0x00, 0x06, 0x05,
		  0x83, 0x77, 0x00, 0x06, 0x05, 0x83),
	PHYREGS(0x0864, 0x0860, 0x085C, 0x01E8, 0x01E9, 0x01EA),
  },
  {	.channel		= 74,
	.freq			= 5370, /* MHz */
	.unk2			= 3580,
	RADIOREGS(0x71, 0x19, 0x02, 0x08, 0x75, 0x01, 0x04, 0x0A,
		  0x00, 0x87, 0x44, 0x44, 0x77, 0x00, 0x06, 0x05,
		  0x83, 0x77, 0x00, 0x06, 0x05, 0x83),
	PHYREGS(0x0868, 0x0864, 0x0860, 0x01E7, 0x01E8, 0x01E9),
  },
  {	.channel		= 76,
	.freq			= 5380, /* MHz */
	.unk2			= 3587,
	RADIOREGS(0x71, 0x1A, 0x02, 0x08, 0x6E, 0x01, 0x04, 0x0A,
		  0x00, 0x87, 0x33, 0x33, 0x77, 0x00, 0x06, 0x04,
		  0x82, 0x77, 0x00, 0x06, 0x04, 0x82),
	PHYREGS(0x086C, 0x0868, 0x0864, 0x01E6, 0x01E7, 0x01E8),
  },
  {	.channel		= 78,
	.freq			= 5390, /* MHz */
	.unk2			= 3593,
	RADIOREGS(0x71, 0x1B, 0x02, 0x08, 0x6E, 0x01, 0x04, 0x0A,
		  0x00, 0x87, 0x33, 0x33, 0x77, 0x00, 0x06, 0x04,
		  0x82, 0x77, 0x00, 0x06, 0x04, 0x82),
	PHYREGS(0x0870, 0x086C, 0x0868, 0x01E5, 0x01E6, 0x01E7),
  },
  {	.channel		= 80,
	.freq			= 5400, /* MHz */
	.unk2			= 3600,
	RADIOREGS(0x71, 0x1C, 0x02, 0x07, 0x67, 0x01, 0x04, 0x0A,
		  0x00, 0x86, 0x33, 0x33, 0x66, 0x00, 0x05, 0x04,
		  0x81, 0x66, 0x00, 0x05, 0x04, 0x81),
	PHYREGS(0x0874, 0x0870, 0x086C, 0x01E5, 0x01E5, 0x01E6),
  },
  {	.channel		= 82,
	.freq			= 5410, /* MHz */
	.unk2			= 3607,
	RADIOREGS(0x71, 0x1D, 0x02, 0x07, 0x67, 0x01, 0x04, 0x0A,
		  0x00, 0x86, 0x33, 0x33, 0x66, 0x00, 0x05, 0x04,
		  0x81, 0x66, 0x00, 0x05, 0x04, 0x81),
	PHYREGS(0x0878, 0x0874, 0x0870, 0x01E4, 0x01E5, 0x01E5),
  },
  {	.channel		= 84,
	.freq			= 5420, /* MHz */
	.unk2			= 3613,
	RADIOREGS(0x71, 0x1E, 0x02, 0x07, 0x61, 0x01, 0x04, 0x0A,
		  0x00, 0x86, 0x22, 0x22, 0x66, 0x00, 0x05, 0x03,
		  0x80, 0x66, 0x00, 0x05, 0x03, 0x80),
	PHYREGS(0x087C, 0x0878, 0x0874, 0x01E3, 0x01E4, 0x01E5),
  },
  {	.channel		= 86,
	.freq			= 5430, /* MHz */
	.unk2			= 3620,
	RADIOREGS(0x71, 0x1F, 0x02, 0x07, 0x61, 0x01, 0x04, 0x0A,
		  0x00, 0x86, 0x22, 0x22, 0x66, 0x00, 0x05, 0x03,
		  0x80, 0x66, 0x00, 0x05, 0x03, 0x80),
	PHYREGS(0x0880, 0x087C, 0x0878, 0x01E2, 0x01E3, 0x01E4),
  },
  {	.channel		= 88,
	.freq			= 5440, /* MHz */
	.unk2			= 3627,
	RADIOREGS(0x71, 0x20, 0x02, 0x07, 0x5A, 0x01, 0x04, 0x0A,
		  0x00, 0x85, 0x22, 0x22, 0x55, 0x00, 0x04, 0x02,
		  0x80, 0x55, 0x00, 0x04, 0x02, 0x80),
	PHYREGS(0x0884, 0x0880, 0x087C, 0x01E1, 0x01E2, 0x01E3),
  },
  {	.channel		= 90,
	.freq			= 5450, /* MHz */
	.unk2			= 3633,
	RADIOREGS(0x71, 0x21, 0x02, 0x07, 0x5A, 0x01, 0x04, 0x0A,
		  0x00, 0x85, 0x22, 0x22, 0x55, 0x00, 0x04, 0x02,
		  0x80, 0x55, 0x00, 0x04, 0x02, 0x80),
	PHYREGS(0x0888, 0x0884, 0x0880, 0x01E0, 0x01E1, 0x01E2),
  },
  {	.channel		= 92,
	.freq			= 5460, /* MHz */
	.unk2			= 3640,
	RADIOREGS(0x71, 0x22, 0x02, 0x06, 0x53, 0x01, 0x04, 0x0A,
		  0x00, 0x85, 0x11, 0x11, 0x55, 0x00, 0x04, 0x01,
		  0x80, 0x55, 0x00, 0x04, 0x01, 0x80),
	PHYREGS(0x088C, 0x0888, 0x0884, 0x01DF, 0x01E0, 0x01E1),
  },
  {	.channel		= 94,
	.freq			= 5470, /* MHz */
	.unk2			= 3647,
	RADIOREGS(0x71, 0x23, 0x02, 0x06, 0x53, 0x01, 0x04, 0x0A,
		  0x00, 0x85, 0x11, 0x11, 0x55, 0x00, 0x04, 0x01,
		  0x80, 0x55, 0x00, 0x04, 0x01, 0x80),
	PHYREGS(0x0890, 0x088C, 0x0888, 0x01DE, 0x01DF, 0x01E0),
  },
  {	.channel		= 96,
	.freq			= 5480, /* MHz */
	.unk2			= 3653,
	RADIOREGS(0x71, 0x24, 0x02, 0x06, 0x4D, 0x01, 0x04, 0x0A,
		  0x00, 0x84, 0x11, 0x11, 0x44, 0x00, 0x03, 0x00,
		  0x80, 0x44, 0x00, 0x03, 0x00, 0x80),
	PHYREGS(0x0894, 0x0890, 0x088C, 0x01DD, 0x01DE, 0x01DF),
  },
  {	.channel		= 98,
	.freq			= 5490, /* MHz */
	.unk2			= 3660,
	RADIOREGS(0x71, 0x25, 0x02, 0x06, 0x4D, 0x01, 0x04, 0x0A,
		  0x00, 0x84, 0x11, 0x11, 0x44, 0x00, 0x03, 0x00,
		  0x80, 0x44, 0x00, 0x03, 0x00, 0x80),
	PHYREGS(0x0898, 0x0894, 0x0890, 0x01DD, 0x01DD, 0x01DE),
  },
  {	.channel		= 100,
	.freq			= 5500, /* MHz */
	.unk2			= 3667,
	RADIOREGS(0x71, 0x26, 0x02, 0x06, 0x47, 0x01, 0x04, 0x0A,
		  0x00, 0x84, 0x00, 0x00, 0x44, 0x00, 0x03, 0x00,
		  0x80, 0x44, 0x00, 0x03, 0x00, 0x80),
	PHYREGS(0x089C, 0x0898, 0x0894, 0x01DC, 0x01DD, 0x01DD),
  },
  {	.channel		= 102,
	.freq			= 5510, /* MHz */
	.unk2			= 3673,
	RADIOREGS(0x71, 0x27, 0x02, 0x06, 0x47, 0x01, 0x04, 0x0A,
		  0x00, 0x84, 0x00, 0x00, 0x44, 0x00, 0x03, 0x00,
		  0x80, 0x44, 0x00, 0x03, 0x00, 0x80),
	PHYREGS(0x08A0, 0x089C, 0x0898, 0x01DB, 0x01DC, 0x01DD),
  },
  {	.channel		= 104,
	.freq			= 5520, /* MHz */
	.unk2			= 3680,
	RADIOREGS(0x71, 0x28, 0x02, 0x05, 0x40, 0x01, 0x04, 0x0A,
		  0x00, 0x83, 0x00, 0x00, 0x33, 0x00, 0x02, 0x00,
		  0x80, 0x33, 0x00, 0x02, 0x00, 0x80),
	PHYREGS(0x08A4, 0x08A0, 0x089C, 0x01DA, 0x01DB, 0x01DC),
  },
  {	.channel		= 106,
	.freq			= 5530, /* MHz */
	.unk2			= 3687,
	RADIOREGS(0x71, 0x29, 0x02, 0x05, 0x40, 0x01, 0x04, 0x0A,
		  0x00, 0x83, 0x00, 0x00, 0x33, 0x00, 0x02, 0x00,
		  0x80, 0x33, 0x00, 0x02, 0x00, 0x80),
	PHYREGS(0x08A8, 0x08A4, 0x08A0, 0x01D9, 0x01DA, 0x01DB),
  },
  {	.channel		= 108,
	.freq			= 5540, /* MHz */
	.unk2			= 3693,
	RADIOREGS(0x71, 0x2A, 0x02, 0x05, 0x3A, 0x01, 0x04, 0x0A,
		  0x00, 0x83, 0x00, 0x00, 0x33, 0x00, 0x02, 0x00,
		  0x80, 0x33, 0x00, 0x02, 0x00, 0x80),
	PHYREGS(0x08AC, 0x08A8, 0x08A4, 0x01D8, 0x01D9, 0x01DA),
  },
  {	.channel		= 110,
	.freq			= 5550, /* MHz */
	.unk2			= 3700,
	RADIOREGS(0x71, 0x2B, 0x02, 0x05, 0x3A, 0x01, 0x04, 0x0A,
		  0x00, 0x83, 0x00, 0x00, 0x33, 0x00, 0x02, 0x00,
		  0x80, 0x33, 0x00, 0x02, 0x00, 0x80),
	PHYREGS(0x08B0, 0x08AC, 0x08A8, 0x01D7, 0x01D8, 0x01D9),
  },
  {	.channel		= 112,
	.freq			= 5560, /* MHz */
	.unk2			= 3707,
	RADIOREGS(0x71, 0x2C, 0x02, 0x05, 0x34, 0x01, 0x04, 0x0A,
		  0x00, 0x82, 0x00, 0x00, 0x22, 0x00, 0x01, 0x00,
		  0x80, 0x22, 0x00, 0x01, 0x00, 0x80),
	PHYREGS(0x08B4, 0x08B0, 0x08AC, 0x01D7, 0x01D7, 0x01D8),
  },
  {	.channel		= 114,
	.freq			= 5570, /* MHz */
	.unk2			= 3713,
	RADIOREGS(0x71, 0x2D, 0x02, 0x05, 0x34, 0x01, 0x04, 0x0A,
		  0x00, 0x82, 0x00, 0x00, 0x22, 0x00, 0x01, 0x00,
		  0x80, 0x22, 0x00, 0x01, 0x00, 0x80),
	PHYREGS(0x08B8, 0x08B4, 0x08B0, 0x01D6, 0x01D7, 0x01D7),
  },
  {	.channel		= 116,
	.freq			= 5580, /* MHz */
	.unk2			= 3720,
	RADIOREGS(0x71, 0x2E, 0x02, 0x04, 0x2E, 0x01, 0x04, 0x0A,
		  0x00, 0x82, 0x00, 0x00, 0x22, 0x00, 0x01, 0x00,
		  0x80, 0x22, 0x00, 0x01, 0x00, 0x80),
	PHYREGS(0x08BC, 0x08B8, 0x08B4, 0x01D5, 0x01D6, 0x01D7),
  },
  {	.channel		= 118,
	.freq			= 5590, /* MHz */
	.unk2			= 3727,
	RADIOREGS(0x71, 0x2F, 0x02, 0x04, 0x2E, 0x01, 0x04, 0x0A,
		  0x00, 0x82, 0x00, 0x00, 0x22, 0x00, 0x01, 0x00,
		  0x80, 0x22, 0x00, 0x01, 0x00, 0x80),
	PHYREGS(0x08C0, 0x08BC, 0x08B8, 0x01D4, 0x01D5, 0x01D6),
  },
  {	.channel		= 120,
	.freq			= 5600, /* MHz */
	.unk2			= 3733,
	RADIOREGS(0x71, 0x30, 0x02, 0x04, 0x28, 0x01, 0x04, 0x0A,
		  0x00, 0x81, 0x00, 0x00, 0x11, 0x00, 0x01, 0x00,
		  0x80, 0x11, 0x00, 0x01, 0x00, 0x80),
	PHYREGS(0x08C4, 0x08C0, 0x08BC, 0x01D3, 0x01D4, 0x01D5),
  },
  {	.channel		= 122,
	.freq			= 5610, /* MHz */
	.unk2			= 3740,
	RADIOREGS(0x71, 0x31, 0x02, 0x04, 0x28, 0x01, 0x04, 0x0A,
		  0x00, 0x81, 0x00, 0x00, 0x11, 0x00, 0x01, 0x00,
		  0x80, 0x11, 0x00, 0x01, 0x00, 0x80),
	PHYREGS(0x08C8, 0x08C4, 0x08C0, 0x01D2, 0x01D3, 0x01D4),
  },
  {	.channel		= 124,
	.freq			= 5620, /* MHz */
	.unk2			= 3747,
	RADIOREGS(0x71, 0x32, 0x02, 0x04, 0x21, 0x01, 0x04, 0x0A,
		  0x00, 0x81, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
		  0x80, 0x11, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08CC, 0x08C8, 0x08C4, 0x01D2, 0x01D2, 0x01D3),
  },
  {	.channel		= 126,
	.freq			= 5630, /* MHz */
	.unk2			= 3753,
	RADIOREGS(0x71, 0x33, 0x02, 0x04, 0x21, 0x01, 0x04, 0x0A,
		  0x00, 0x81, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
		  0x80, 0x11, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08D0, 0x08CC, 0x08C8, 0x01D1, 0x01D2, 0x01D2),
  },
  {	.channel		= 128,
	.freq			= 5640, /* MHz */
	.unk2			= 3760,
	RADIOREGS(0x71, 0x34, 0x02, 0x03, 0x1C, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08D4, 0x08D0, 0x08CC, 0x01D0, 0x01D1, 0x01D2),
  },
  {	.channel		= 130,
	.freq			= 5650, /* MHz */
	.unk2			= 3767,
	RADIOREGS(0x71, 0x35, 0x02, 0x03, 0x1C, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08D8, 0x08D4, 0x08D0, 0x01CF, 0x01D0, 0x01D1),
  },
  {	.channel		= 132,
	.freq			= 5660, /* MHz */
	.unk2			= 3773,
	RADIOREGS(0x71, 0x36, 0x02, 0x03, 0x16, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08DC, 0x08D8, 0x08D4, 0x01CE, 0x01CF, 0x01D0),
  },
  {	.channel		= 134,
	.freq			= 5670, /* MHz */
	.unk2			= 3780,
	RADIOREGS(0x71, 0x37, 0x02, 0x03, 0x16, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08E0, 0x08DC, 0x08D8, 0x01CE, 0x01CE, 0x01CF),
  },
  {	.channel		= 136,
	.freq			= 5680, /* MHz */
	.unk2			= 3787,
	RADIOREGS(0x71, 0x38, 0x02, 0x03, 0x10, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08E4, 0x08E0, 0x08DC, 0x01CD, 0x01CE, 0x01CE),
  },
  {	.channel		= 138,
	.freq			= 5690, /* MHz */
	.unk2			= 3793,
	RADIOREGS(0x71, 0x39, 0x02, 0x03, 0x10, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08E8, 0x08E4, 0x08E0, 0x01CC, 0x01CD, 0x01CE),
  },
  {	.channel		= 140,
	.freq			= 5700, /* MHz */
	.unk2			= 3800,
	RADIOREGS(0x71, 0x3A, 0x02, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08EC, 0x08E8, 0x08E4, 0x01CB, 0x01CC, 0x01CD),
  },
  {	.channel		= 142,
	.freq			= 5710, /* MHz */
	.unk2			= 3807,
	RADIOREGS(0x71, 0x3B, 0x02, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08F0, 0x08EC, 0x08E8, 0x01CA, 0x01CB, 0x01CC),
  },
  {	.channel		= 144,
	.freq			= 5720, /* MHz */
	.unk2			= 3813,
	RADIOREGS(0x71, 0x3C, 0x02, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08F4, 0x08F0, 0x08EC, 0x01C9, 0x01CA, 0x01CB),
  },
  {	.channel		= 145,
	.freq			= 5725, /* MHz */
	.unk2			= 3817,
	RADIOREGS(0x72, 0x79, 0x04, 0x02, 0x03, 0x01, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08F6, 0x08F2, 0x08EE, 0x01C9, 0x01CA, 0x01CB),
  },
  {	.channel		= 146,
	.freq			= 5730, /* MHz */
	.unk2			= 3820,
	RADIOREGS(0x71, 0x3D, 0x02, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08F8, 0x08F4, 0x08F0, 0x01C9, 0x01C9, 0x01CA),
  },
  {	.channel		= 147,
	.freq			= 5735, /* MHz */
	.unk2			= 3823,
	RADIOREGS(0x72, 0x7B, 0x04, 0x02, 0x03, 0x01, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08FA, 0x08F6, 0x08F2, 0x01C8, 0x01C9, 0x01CA),
  },
  {	.channel		= 148,
	.freq			= 5740, /* MHz */
	.unk2			= 3827,
	RADIOREGS(0x71, 0x3E, 0x02, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08FC, 0x08F8, 0x08F4, 0x01C8, 0x01C9, 0x01C9),
  },
  {	.channel		= 149,
	.freq			= 5745, /* MHz */
	.unk2			= 3830,
	RADIOREGS(0x72, 0x7D, 0x04, 0x02, 0xFE, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x08FE, 0x08FA, 0x08F6, 0x01C8, 0x01C8, 0x01C9),
  },
  {	.channel		= 150,
	.freq			= 5750, /* MHz */
	.unk2			= 3833,
	RADIOREGS(0x71, 0x3F, 0x02, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0900, 0x08FC, 0x08F8, 0x01C7, 0x01C8, 0x01C9),
  },
  {	.channel		= 151,
	.freq			= 5755, /* MHz */
	.unk2			= 3837,
	RADIOREGS(0x72, 0x7F, 0x04, 0x02, 0xFE, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0902, 0x08FE, 0x08FA, 0x01C7, 0x01C8, 0x01C8),
  },
  {	.channel		= 152,
	.freq			= 5760, /* MHz */
	.unk2			= 3840,
	RADIOREGS(0x71, 0x40, 0x02, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0904, 0x0900, 0x08FC, 0x01C6, 0x01C7, 0x01C8),
  },
  {	.channel		= 153,
	.freq			= 5765, /* MHz */
	.unk2			= 3843,
	RADIOREGS(0x72, 0x81, 0x04, 0x02, 0xF8, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0906, 0x0902, 0x08FE, 0x01C6, 0x01C7, 0x01C8),
  },
  {	.channel		= 154,
	.freq			= 5770, /* MHz */
	.unk2			= 3847,
	RADIOREGS(0x71, 0x41, 0x02, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0908, 0x0904, 0x0900, 0x01C6, 0x01C6, 0x01C7),
  },
  {	.channel		= 155,
	.freq			= 5775, /* MHz */
	.unk2			= 3850,
	RADIOREGS(0x72, 0x83, 0x04, 0x02, 0xF8, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x090A, 0x0906, 0x0902, 0x01C5, 0x01C6, 0x01C7),
  },
  {	.channel		= 156,
	.freq			= 5780, /* MHz */
	.unk2			= 3853,
	RADIOREGS(0x71, 0x42, 0x02, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x090C, 0x0908, 0x0904, 0x01C5, 0x01C6, 0x01C6),
  },
  {	.channel		= 157,
	.freq			= 5785, /* MHz */
	.unk2			= 3857,
	RADIOREGS(0x72, 0x85, 0x04, 0x02, 0xF2, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x090E, 0x090A, 0x0906, 0x01C4, 0x01C5, 0x01C6),
  },
  {	.channel		= 158,
	.freq			= 5790, /* MHz */
	.unk2			= 3860,
	RADIOREGS(0x71, 0x43, 0x02, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0910, 0x090C, 0x0908, 0x01C4, 0x01C5, 0x01C6),
  },
  {	.channel		= 159,
	.freq			= 5795, /* MHz */
	.unk2			= 3863,
	RADIOREGS(0x72, 0x87, 0x04, 0x02, 0xF2, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0912, 0x090E, 0x090A, 0x01C4, 0x01C4, 0x01C5),
  },
  {	.channel		= 160,
	.freq			= 5800, /* MHz */
	.unk2			= 3867,
	RADIOREGS(0x71, 0x44, 0x02, 0x01, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0914, 0x0910, 0x090C, 0x01C3, 0x01C4, 0x01C5),
  },
  {	.channel		= 161,
	.freq			= 5805, /* MHz */
	.unk2			= 3870,
	RADIOREGS(0x72, 0x89, 0x04, 0x01, 0xED, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0916, 0x0912, 0x090E, 0x01C3, 0x01C4, 0x01C4),
  },
  {	.channel		= 162,
	.freq			= 5810, /* MHz */
	.unk2			= 3873,
	RADIOREGS(0x71, 0x45, 0x02, 0x01, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0918, 0x0914, 0x0910, 0x01C2, 0x01C3, 0x01C4),
  },
  {	.channel		= 163,
	.freq			= 5815, /* MHz */
	.unk2			= 3877,
	RADIOREGS(0x72, 0x8B, 0x04, 0x01, 0xED, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x091A, 0x0916, 0x0912, 0x01C2, 0x01C3, 0x01C4),
  },
  {	.channel		= 164,
	.freq			= 5820, /* MHz */
	.unk2			= 3880,
	RADIOREGS(0x71, 0x46, 0x02, 0x01, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x091C, 0x0918, 0x0914, 0x01C2, 0x01C2, 0x01C3),
  },
  {	.channel		= 165,
	.freq			= 5825, /* MHz */
	.unk2			= 3883,
	RADIOREGS(0x72, 0x8D, 0x04, 0x01, 0xED, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x091E, 0x091A, 0x0916, 0x01C1, 0x01C2, 0x01C3),
  },
  {	.channel		= 166,
	.freq			= 5830, /* MHz */
	.unk2			= 3887,
	RADIOREGS(0x71, 0x47, 0x02, 0x01, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0920, 0x091C, 0x0918, 0x01C1, 0x01C2, 0x01C2),
  },
  {	.channel		= 168,
	.freq			= 5840, /* MHz */
	.unk2			= 3893,
	RADIOREGS(0x71, 0x48, 0x02, 0x01, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0924, 0x0920, 0x091C, 0x01C0, 0x01C1, 0x01C2),
  },
  {	.channel		= 170,
	.freq			= 5850, /* MHz */
	.unk2			= 3900,
	RADIOREGS(0x71, 0x49, 0x02, 0x01, 0xE0, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0928, 0x0924, 0x0920, 0x01BF, 0x01C0, 0x01C1),
  },
  {	.channel		= 172,
	.freq			= 5860, /* MHz */
	.unk2			= 3907,
	RADIOREGS(0x71, 0x4A, 0x02, 0x01, 0xDE, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x092C, 0x0928, 0x0924, 0x01BF, 0x01BF, 0x01C0),
  },
  {	.channel		= 174,
	.freq			= 5870, /* MHz */
	.unk2			= 3913,
	RADIOREGS(0x71, 0x4B, 0x02, 0x00, 0xDB, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0930, 0x092C, 0x0928, 0x01BE, 0x01BF, 0x01BF),
  },
  {	.channel		= 176,
	.freq			= 5880, /* MHz */
	.unk2			= 3920,
	RADIOREGS(0x71, 0x4C, 0x02, 0x00, 0xD8, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0934, 0x0930, 0x092C, 0x01BD, 0x01BE, 0x01BF),
  },
  {	.channel		= 178,
	.freq			= 5890, /* MHz */
	.unk2			= 3927,
	RADIOREGS(0x71, 0x4D, 0x02, 0x00, 0xD6, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0938, 0x0934, 0x0930, 0x01BC, 0x01BD, 0x01BE),
  },
  {	.channel		= 180,
	.freq			= 5900, /* MHz */
	.unk2			= 3933,
	RADIOREGS(0x71, 0x4E, 0x02, 0x00, 0xD3, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x093C, 0x0938, 0x0934, 0x01BC, 0x01BC, 0x01BD),
  },
  {	.channel		= 182,
	.freq			= 5910, /* MHz */
	.unk2			= 3940,
	RADIOREGS(0x71, 0x4F, 0x02, 0x00, 0xD6, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0940, 0x093C, 0x0938, 0x01BB, 0x01BC, 0x01BC),
  },
  {	.channel		= 1,
	.freq			= 2412, /* MHz */
	.unk2			= 3216,
	RADIOREGS(0x73, 0x6C, 0x09, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0D, 0x0C,
		  0x80, 0xFF, 0x88, 0x0D, 0x0C, 0x80),
	PHYREGS(0x03C9, 0x03C5, 0x03C1, 0x043A, 0x043F, 0x0443),
  },
  {	.channel		= 2,
	.freq			= 2417, /* MHz */
	.unk2			= 3223,
	RADIOREGS(0x73, 0x71, 0x09, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0C, 0x0B,
		  0x80, 0xFF, 0x88, 0x0C, 0x0B, 0x80),
	PHYREGS(0x03CB, 0x03C7, 0x03C3, 0x0438, 0x043D, 0x0441),
  },
  {	.channel		= 3,
	.freq			= 2422, /* MHz */
	.unk2			= 3229,
	RADIOREGS(0x73, 0x76, 0x09, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0C, 0x0A,
		  0x80, 0xFF, 0x88, 0x0C, 0x0A, 0x80),
	PHYREGS(0x03CD, 0x03C9, 0x03C5, 0x0436, 0x043A, 0x043F),
  },
  {	.channel		= 4,
	.freq			= 2427, /* MHz */
	.unk2			= 3236,
	RADIOREGS(0x73, 0x7B, 0x09, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0C, 0x0A,
		  0x80, 0xFF, 0x88, 0x0C, 0x0A, 0x80),
	PHYREGS(0x03CF, 0x03CB, 0x03C7, 0x0434, 0x0438, 0x043D),
  },
  {	.channel		= 5,
	.freq			= 2432, /* MHz */
	.unk2			= 3243,
	RADIOREGS(0x73, 0x80, 0x09, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0C, 0x09,
		  0x80, 0xFF, 0x88, 0x0C, 0x09, 0x80),
	PHYREGS(0x03D1, 0x03CD, 0x03C9, 0x0431, 0x0436, 0x043A),
  },
  {	.channel		= 6,
	.freq			= 2437, /* MHz */
	.unk2			= 3249,
	RADIOREGS(0x73, 0x85, 0x09, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0B, 0x08,
		  0x80, 0xFF, 0x88, 0x0B, 0x08, 0x80),
	PHYREGS(0x03D3, 0x03CF, 0x03CB, 0x042F, 0x0434, 0x0438),
  },
  {	.channel		= 7,
	.freq			= 2442, /* MHz */
	.unk2			= 3256,
	RADIOREGS(0x73, 0x8A, 0x09, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0A, 0x07,
		  0x80, 0xFF, 0x88, 0x0A, 0x07, 0x80),
	PHYREGS(0x03D5, 0x03D1, 0x03CD, 0x042D, 0x0431, 0x0436),
  },
  {	.channel		= 8,
	.freq			= 2447, /* MHz */
	.unk2			= 3263,
	RADIOREGS(0x73, 0x8F, 0x09, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0A, 0x06,
		  0x80, 0xFF, 0x88, 0x0A, 0x06, 0x80),
	PHYREGS(0x03D7, 0x03D3, 0x03CF, 0x042B, 0x042F, 0x0434),
  },
  {	.channel		= 9,
	.freq			= 2452, /* MHz */
	.unk2			= 3269,
	RADIOREGS(0x73, 0x94, 0x09, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x09, 0x06,
		  0x80, 0xFF, 0x88, 0x09, 0x06, 0x80),
	PHYREGS(0x03D9, 0x03D5, 0x03D1, 0x0429, 0x042D, 0x0431),
  },
  {	.channel		= 10,
	.freq			= 2457, /* MHz */
	.unk2			= 3276,
	RADIOREGS(0x73, 0x99, 0x09, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x08, 0x05,
		  0x80, 0xFF, 0x88, 0x08, 0x05, 0x80),
	PHYREGS(0x03DB, 0x03D7, 0x03D3, 0x0427, 0x042B, 0x042F),
  },
  {	.channel		= 11,
	.freq			= 2462, /* MHz */
	.unk2			= 3283,
	RADIOREGS(0x73, 0x9E, 0x09, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x08, 0x04,
		  0x80, 0xFF, 0x88, 0x08, 0x04, 0x80),
	PHYREGS(0x03DD, 0x03D9, 0x03D5, 0x0424, 0x0429, 0x042D),
  },
  {	.channel		= 12,
	.freq			= 2467, /* MHz */
	.unk2			= 3289,
	RADIOREGS(0x73, 0xA3, 0x09, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x08, 0x03,
		  0x80, 0xFF, 0x88, 0x08, 0x03, 0x80),
	PHYREGS(0x03DF, 0x03DB, 0x03D7, 0x0422, 0x0427, 0x042B),
  },
  {	.channel		= 13,
	.freq			= 2472, /* MHz */
	.unk2			= 3296,
	RADIOREGS(0x73, 0xA8, 0x09, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x07, 0x03,
		  0x80, 0xFF, 0x88, 0x07, 0x03, 0x80),
	PHYREGS(0x03E1, 0x03DD, 0x03D9, 0x0420, 0x0424, 0x0429),
  },
  {	.channel		= 14,
	.freq			= 2484, /* MHz */
	.unk2			= 3312,
	RADIOREGS(0x73, 0xB4, 0x09, 0x0F, 0xFF, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x07, 0x01,
		  0x80, 0xFF, 0x88, 0x07, 0x01, 0x80),
	PHYREGS(0x03E6, 0x03E2, 0x03DE, 0x041B, 0x041F, 0x0424),
  },
};

void b2055_upload_inittab(struct bwn_mac *mac,
			  bool ghz5, bool ignore_uploadflag)
{
	const struct b2055_inittab_entry *e;
	unsigned int i, writes = 0;
	uint16_t value;

	for (i = 0; i < nitems(b2055_inittab); i++) {
		e = &(b2055_inittab[i]);
		if (!(e->flags & B2055_INITTAB_ENTRY_OK))
			continue;
		if ((e->flags & B2055_INITTAB_UPLOAD) || ignore_uploadflag) {
			if (ghz5)
				value = e->ghz5;
			else
				value = e->ghz2;
			BWN_RF_WRITE(mac, i, value);
			if (++writes % 4 == 0)
				BWN_READ_4(mac, BWN_MACCTL); /* flush */
		}
	}
	/* One final flush */
	BWN_READ_4(mac, BWN_MACCTL);
}

const struct bwn_nphy_channeltab_entry_rev2 *
bwn_nphy_get_chantabent_rev2(struct bwn_mac *mac, uint8_t channel)
{
	const struct bwn_nphy_channeltab_entry_rev2 *e;
	unsigned int i;

	for (i = 0; i < nitems(bwn_nphy_channeltab_rev2); i++) {
		e = &(bwn_nphy_channeltab_rev2[i]);
		if (e->channel == channel)
			return e;
	}

	return NULL;
}
