#!/bin/sh

# panic: MNT_DEFERRED requires MNT_RECURSE | MNT_FORCE
# cpuid = 6
# time = 1766415391
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe01003ffaf0
# vpanic() at vpanic+0x136/frame 0xfffffe01003ffc20
# panic() at panic+0x43/frame 0xfffffe01003ffc80
# dounmount() at dounmount+0xa49/frame 0xfffffe01003ffcf0
# kern_unmount() at kern_unmount+0x30c/frame 0xfffffe01003ffe00
# amd64_syscall() at amd64_syscall+0x169/frame 0xfffffe01003fff30
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe01003fff30
# --- syscall (0, FreeBSD ELF64, syscall), rip = 0x8227c1c1a, rsp = 0x8204589e8, rbp = 0x820458a50 ---
# KDB: enter: panic
# [ thread pid 67901 tid 1052310 ]
# Stopped at      kdb_enter+0x33: movq    $0,0x12132c2(%rip)
# db> x/s version
# version:FreeBSD 16.0-CURRENT #1 vmfqe-n282663-949b0dac6c83: Sun Dec 21 12:59:23 CET 2025
# pho@mercat1.netperf.freebsd.org:/var/tmp/deviant3/sys/amd64/compile/PHO\

[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
set -u
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=e5807bfa71ca13538ae5c94e160b0c959a40750d
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// syzbot+1967136cd02c22bc6f0d@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <pwd.h>
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <unistd.h>

static __thread int clone_ongoing;
static __thread int skip_segv;
static __thread jmp_buf segv_env;

static void segv_handler(int sig, siginfo_t* info, void* ctx __unused)
{
  if (__atomic_load_n(&clone_ongoing, __ATOMIC_RELAXED) != 0) {
    exit(sig);
  }
  uintptr_t addr = (uintptr_t)info->si_addr;
  const uintptr_t prog_start = 1 << 20;
  const uintptr_t prog_end = 100 << 20;
  int skip = __atomic_load_n(&skip_segv, __ATOMIC_RELAXED) != 0;
  int valid = addr < prog_start || addr > prog_end;
  if (sig == SIGBUS)
    valid = 1;
  if (skip && valid) {
    _longjmp(segv_env, 1);
  }
  exit(sig);
}

static void install_segv_handler(void)
{
  struct sigaction sa;
  memset(&sa, 0, sizeof(sa));
  sa.sa_sigaction = segv_handler;
  sa.sa_flags = SA_NODEFER | SA_SIGINFO;
  sigaction(SIGSEGV, &sa, NULL);
  sigaction(SIGBUS, &sa, NULL);
}

#define NONFAILING(...)                                                        \
  ({                                                                           \
    int ok = 1;                                                                \
    __atomic_fetch_add(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    if (_setjmp(segv_env) == 0) {                                              \
      __VA_ARGS__;                                                             \
    } else                                                                     \
      ok = 0;                                                                  \
    __atomic_fetch_sub(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    ok;                                                                        \
  })

uint64_t r[1] = {0xffffffffffffffff};

int main(void)
{
  syscall(SYS_mmap, /*addr=*/0x200000000000ul, /*len=*/0x1000000ul,
          /*prot=PROT_WRITE|PROT_READ|PROT_EXEC*/ 7ul,
          /*flags=MAP_FIXED|MAP_ANONYMOUS|MAP_PRIVATE*/ 0x1012ul,
          /*fd=*/(intptr_t)-1, /*offset=*/0ul);
  const char* reason;
  (void)reason;
  install_segv_handler();
  intptr_t res = 0;
  if (write(1, "executing program\n", sizeof("executing program\n") - 1)) {
  }
  //  openat\$crypto arguments: [
  //    fd: const = 0xffffffffffffff9c (8 bytes)
  //    file: ptr[in, buffer] {
  //      buffer: {2f 64 65 76 2f 63 72 79 70 74 6f 00} (length 0xc)
  //    }
  //    flags: open_flags = 0x200 (8 bytes)
  //    mode: const = 0x0 (8 bytes)
  //  ]
  //  returns fd_crypto
  NONFAILING(memcpy((void*)0x200000000040, "/dev/crypto\000", 12));
  res = syscall(SYS_openat, /*fd=*/0xffffffffffffff9cul,
                /*file=*/0x200000000040ul, /*flags=O_CREAT*/ 0x200ul,
                /*mode=*/0ul);
  if (res != -1)
    r[0] = res;
  //  freebsd11_fstatfs arguments: [
  //    fd: fd (resource)
  //    buf: ptr[out, freebsd11_statfs] {
  //      freebsd11_statfs {
  //        version: int32 = 0x0 (4 bytes)
  //        type: int32 = 0x0 (4 bytes)
  //        flags: mount_flags = 0x0 (8 bytes)
  //        bsize: int64 = 0x0 (8 bytes)
  //        iosize: int64 = 0x0 (8 bytes)
  //        blocks: int64 = 0x0 (8 bytes)
  //        bfree: int64 = 0x0 (8 bytes)
  //        bavail: int64 = 0x0 (8 bytes)
  //        files: int64 = 0x0 (8 bytes)
  //        ffree: int64 = 0x0 (8 bytes)
  //        syncwrites: int64 = 0x0 (8 bytes)
  //        asyncwrites: int64 = 0x0 (8 bytes)
  //        syncreads: int64 = 0x0 (8 bytes)
  //        asyncreads: int64 = 0x0 (8 bytes)
  //        spare: array[int64] {
  //          int64 = 0x0 (8 bytes)
  //          int64 = 0x0 (8 bytes)
  //          int64 = 0x0 (8 bytes)
  //          int64 = 0x0 (8 bytes)
  //          int64 = 0x0 (8 bytes)
  //          int64 = 0x0 (8 bytes)
  //          int64 = 0x0 (8 bytes)
  //          int64 = 0x0 (8 bytes)
  //          int64 = 0x0 (8 bytes)
  //          int64 = 0x0 (8 bytes)
  //        }
  //        namemax: int32 = 0x0 (4 bytes)
  //        owner: uid (resource)
  //        fsid: fsid {
  //          val: array[int32] {
  //            int32 = 0x0 (4 bytes)
  //            int32 = 0x0 (4 bytes)
  //          }
  //        }
  //        cspare: buffer: (DirOut)
  //        fstype: buffer: (DirOut)
  //        mnton: buffer: (DirOut)
  //        mntfrom: buffer: (DirOut)
  //      }
  //    }
  //  ]
  syscall(SYS_freebsd11_fstatfs, /*fd=*/r[0], /*buf=*/0x200000000080ul);
  //  mprotect arguments: [
  //    addr: VMA[0x4000]
  //    len: len = 0x4000 (8 bytes)
  //    prot: mmap_prot = 0x1 (8 bytes)
  //  ]
  syscall(SYS_mprotect, /*addr=*/0x200000000000ul, /*len=*/0x4000ul,
          /*prot=PROT_READ*/ 1ul);
  //  unmount arguments: [
  //    path: ptr[in, buffer] {
  //      buffer: {2e 2f 66 69 6c 65 31 00} (length 0x8)
  //    }
  //    flags: mount_flags = 0xc40006c8 (8 bytes)
  //  ]
  NONFAILING(memcpy((void*)0x200000000200, "./file1\000", 8));
  syscall(
      SYS_unmount, /*path=*/0x200000000200ul,
      /*flags=MNT_EXPORTANON|MNT_DEFEXPORTED|MNT_EXRDONLY|MNT_MULTILABEL|MNT_NOCLUSTERW|MNT_NOCLUSTERR|MNT_ASYNC|0x8*/
      0xc40006c8ul);
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c -lpthread || exit 1

(cd ../testcases/swap; ./swap -t 3m -i 30 -l 100 > /dev/null 2>&1) &
sleep 5

kldstat | grep -q cryptodev && loaded=0 || { kldload cryptodev.ko && loaded=1; }
work=/tmp/$prog.dir
rm -rf $work
mkdir $work
cd /tmp/$prog.dir
for i in `jot 30`; do
	(
		mkdir d$i
		cd d$i
		timeout 3m /tmp/$prog > /dev/null 2>&1 &
	)
done
while pgrep -q $prog; do sleep 2; done
while pkill swap; do :; done
wait

rm -rf /tmp/$prog /tmp/$prog.c /tmp/$prog.core $work
[ $loaded -eq 1 ] && kldunload cryptodev.ko
exit 0
