# decode OpenPGP signatures per rfc4880
.PATH: ${.PARSEDIR}

CFLAGS+= -DUSE_BEARSSL

BRSSL_SRCS+= dearmor.c
SRCS+= \
	decode.c \
	opgp_key.c \
	opgp_sig.c

opgp_key.o opgp_key.po opgp_key.pico: ta_asc.h

# Generate ta_asc.h containing one or more OpenPGP trust anchors.
#
# Since each trust anchor must be processed individually,
# we create ta_ASC as a list of pointers to them.
#
# If we are doing self-tests, we define another arrary vc_ASC
# containing pointers to a signature of each trust anchor.
# It is assumed that these v*.asc files are named similarly to
# the appropriate t*.asc so that the relative order of vc_ASC
# entries matches ta_ASC.
#
TA_ASC_LIST ?= ${.ALLSRC:Mt*.asc}
VC_ASC_LIST ?= ${.ALLSRC:Mv*.asc}

ta_asc.h: 
.if ${VE_SIGNATURE_LIST:MOPENPGP} != ""
	@( echo '/* Autogenerated - DO NOT EDIT!!! */'; echo; \
	echo "#define HAVE_TA_ASC 1"; \
	set -- ${TA_ASC_LIST:@f@$f ${f:T:R}@}; \
	while test $$# -ge 2; do \
		file2c -sx "static const char $$2[] = {" ', 0x00 };' < $$1; \
		shift 2; \
	done; \
	echo 'static const char *ta_ASC[] = { ${TA_ASC_LIST:T:R:ts,}, NULL };'; \
	echo; ) > ${.TARGET}
.if ${VE_SELF_TESTS} != "no"
	@( echo "#define HAVE_VC_ASC 1"; \
	set -- ${VC_ASC_LIST:@f@$f ${f:T:R}@}; \
	while test $$# -ge 2; do \
		file2c -sx "static const char $$2[] = {" ', 0x00 };' < $$1; \
		shift 2; \
	done; \
	echo 'static const char *vc_ASC[] = { ${VC_ASC_LIST:T:R:ts,}, NULL };'; \
	echo; ) >> ${.TARGET}
.endif
.endif
