/* @generated by `generate-fortify-tests.lua "stdio"` */

#define	_FORTIFY_SOURCE	2
#define	TMPFILE_SIZE	(1024 * 32)

#include <sys/param.h>
#include <sys/jail.h>
#include <sys/random.h>
#include <sys/resource.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/wait.h>
#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <poll.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <sysexits.h>
#include <unistd.h>
#include <wchar.h>
#include <atf-c.h>

static FILE * __unused
new_fp(size_t __len)
{
	static char fpbuf[LINE_MAX];
	FILE *fp;

	ATF_REQUIRE(__len <= sizeof(fpbuf));

	memset(fpbuf, 'A', sizeof(fpbuf) - 1);
	fpbuf[sizeof(fpbuf) - 1] = '\0';

	fp = fmemopen(fpbuf, sizeof(fpbuf), "rb");
	ATF_REQUIRE(fp != NULL);

	return (fp);
}

/*
 * Create a new symlink to use for readlink(2) style tests, we'll just use a
 * random target name to have something interesting to look at.
 */
static const char * __unused
new_symlink(size_t __len)
{
	static const char linkname[] = "link";
	char target[MAXNAMLEN];
	int error;

	ATF_REQUIRE(__len <= sizeof(target));

	arc4random_buf(target, sizeof(target));

	error = unlink(linkname);
	ATF_REQUIRE(error == 0 || errno == ENOENT);

	error = symlink(target, linkname);
	ATF_REQUIRE(error == 0);

	return (linkname);
}

/*
 * For our purposes, first descriptor will be the reader; we'll send both
 * raw data and a control message over it so that the result can be used for
 * any of our recv*() tests.
 */
static void __unused
new_socket(int sock[2])
{
	unsigned char ctrl[CMSG_SPACE(sizeof(int))] = { 0 };
	static char sockbuf[256];
	ssize_t rv;
	size_t total = 0;
	struct msghdr hdr = { 0 };
	struct cmsghdr *cmsg;
	int error, fd;

	error = socketpair(AF_UNIX, SOCK_STREAM, 0, sock);
	ATF_REQUIRE(error == 0);

	while (total != sizeof(sockbuf)) {
		rv = send(sock[1], &sockbuf[total], sizeof(sockbuf) - total, 0);

		ATF_REQUIRE_MSG(rv > 0,
		    "expected bytes sent, got %zd with %zu left (size %zu, total %zu)",
		    rv, sizeof(sockbuf) - total, sizeof(sockbuf), total);
		ATF_REQUIRE_MSG(total + (size_t)rv <= sizeof(sockbuf),
		    "%zd exceeds total %zu", rv, sizeof(sockbuf));
		total += rv;
	}

	hdr.msg_control = ctrl;
	hdr.msg_controllen = sizeof(ctrl);

	cmsg = CMSG_FIRSTHDR(&hdr);
	cmsg->cmsg_level = SOL_SOCKET;
	cmsg->cmsg_type = SCM_RIGHTS;
	cmsg->cmsg_len = CMSG_LEN(sizeof(fd));
	fd = STDIN_FILENO;
	memcpy(CMSG_DATA(cmsg), &fd, sizeof(fd));

	error = sendmsg(sock[1], &hdr, 0);
	ATF_REQUIRE(error != -1);
}

/*
 * Constructs a tmpfile that we can use for testing read(2) and friends.
 */
static int __unused
new_tmpfile(void)
{
	char buf[1024];
	ssize_t rv;
	size_t written;
	int fd;

	fd = open("tmpfile", O_RDWR | O_CREAT | O_TRUNC, 0644);
	ATF_REQUIRE(fd >= 0);

	written = 0;
	while (written < TMPFILE_SIZE) {
		rv = write(fd, buf, sizeof(buf));
		ATF_REQUIRE(rv > 0);

		written += rv;
	}

	ATF_REQUIRE_EQ(0, lseek(fd, 0, SEEK_SET));
	return (fd);
}

static void
disable_coredumps(void)
{
	struct rlimit rl = { 0 };

	if (setrlimit(RLIMIT_CORE, &rl) == -1)
		_exit(EX_OSERR);
}

/*
 * Replaces stdin with a file that we can actually read from, for tests where
 * we want a FILE * or fd that we can get data from.
 */
static void __unused
replace_stdin(void)
{
	int fd;

	fd = new_tmpfile();

	(void)dup2(fd, STDIN_FILENO);
	if (fd != STDIN_FILENO)
		close(fd);
}

ATF_TC(ctermid_before_end);
ATF_TC_HEAD(ctermid_before_end, tc)
{
}
ATF_TC_BODY(ctermid_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[L_ctermid + 1];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = L_ctermid + 1;
	const size_t __idx __unused = __len - 1;

	ctermid(__stack.__buf);
#undef BUF

}

ATF_TC(ctermid_end);
ATF_TC_HEAD(ctermid_end, tc)
{
}
ATF_TC_BODY(ctermid_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[L_ctermid];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = L_ctermid;
	const size_t __idx __unused = __len - 1;

	ctermid(__stack.__buf);
#undef BUF

}

ATF_TC(ctermid_heap_before_end);
ATF_TC_HEAD(ctermid_heap_before_end, tc)
{
}
ATF_TC_BODY(ctermid_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (L_ctermid + 1);
	const size_t __len = L_ctermid + 1;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	ctermid(__stack.__buf);
#undef BUF

}

ATF_TC(ctermid_heap_end);
ATF_TC_HEAD(ctermid_heap_end, tc)
{
}
ATF_TC_BODY(ctermid_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (L_ctermid);
	const size_t __len = L_ctermid;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	ctermid(__stack.__buf);
#undef BUF

}

ATF_TC(ctermid_heap_after_end);
ATF_TC_HEAD(ctermid_heap_after_end, tc)
{
}
ATF_TC_BODY(ctermid_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (L_ctermid - 1);
	const size_t __len = L_ctermid - 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);

	ctermid(__stack.__buf);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(ctermid_r_before_end);
ATF_TC_HEAD(ctermid_r_before_end, tc)
{
}
ATF_TC_BODY(ctermid_r_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[L_ctermid + 1];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = L_ctermid + 1;
	const size_t __idx __unused = __len - 1;

	ctermid_r(__stack.__buf);
#undef BUF

}

ATF_TC(ctermid_r_end);
ATF_TC_HEAD(ctermid_r_end, tc)
{
}
ATF_TC_BODY(ctermid_r_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[L_ctermid];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = L_ctermid;
	const size_t __idx __unused = __len - 1;

	ctermid_r(__stack.__buf);
#undef BUF

}

ATF_TC(ctermid_r_heap_before_end);
ATF_TC_HEAD(ctermid_r_heap_before_end, tc)
{
}
ATF_TC_BODY(ctermid_r_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (L_ctermid + 1);
	const size_t __len = L_ctermid + 1;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	ctermid_r(__stack.__buf);
#undef BUF

}

ATF_TC(ctermid_r_heap_end);
ATF_TC_HEAD(ctermid_r_heap_end, tc)
{
}
ATF_TC_BODY(ctermid_r_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (L_ctermid);
	const size_t __len = L_ctermid;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	ctermid_r(__stack.__buf);
#undef BUF

}

ATF_TC(ctermid_r_heap_after_end);
ATF_TC_HEAD(ctermid_r_heap_after_end, tc)
{
}
ATF_TC_BODY(ctermid_r_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (L_ctermid - 1);
	const size_t __len = L_ctermid - 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);

	ctermid_r(__stack.__buf);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(fread_before_end);
ATF_TC_HEAD(fread_before_end, tc)
{
}
ATF_TC_BODY(fread_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;

	replace_stdin();

	fread(__stack.__buf, __len, 1, stdin);
#undef BUF

}

ATF_TC(fread_end);
ATF_TC_HEAD(fread_end, tc)
{
}
ATF_TC_BODY(fread_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;

	replace_stdin();

	fread(__stack.__buf, __len, 1, stdin);
#undef BUF

}

ATF_TC(fread_heap_before_end);
ATF_TC_HEAD(fread_heap_before_end, tc)
{
}
ATF_TC_BODY(fread_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);
	replace_stdin();

	fread(__stack.__buf, __len, 1, stdin);
#undef BUF

}

ATF_TC(fread_heap_end);
ATF_TC_HEAD(fread_heap_end, tc)
{
}
ATF_TC_BODY(fread_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);
	replace_stdin();

	fread(__stack.__buf, __len, 1, stdin);
#undef BUF

}

ATF_TC(fread_heap_after_end);
ATF_TC_HEAD(fread_heap_after_end, tc)
{
}
ATF_TC_BODY(fread_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	replace_stdin();

	fread(__stack.__buf, __len, 1, stdin);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(fread_unlocked_before_end);
ATF_TC_HEAD(fread_unlocked_before_end, tc)
{
}
ATF_TC_BODY(fread_unlocked_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;

	replace_stdin();

	fread_unlocked(__stack.__buf, __len, 1, stdin);
#undef BUF

}

ATF_TC(fread_unlocked_end);
ATF_TC_HEAD(fread_unlocked_end, tc)
{
}
ATF_TC_BODY(fread_unlocked_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;

	replace_stdin();

	fread_unlocked(__stack.__buf, __len, 1, stdin);
#undef BUF

}

ATF_TC(fread_unlocked_heap_before_end);
ATF_TC_HEAD(fread_unlocked_heap_before_end, tc)
{
}
ATF_TC_BODY(fread_unlocked_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);
	replace_stdin();

	fread_unlocked(__stack.__buf, __len, 1, stdin);
#undef BUF

}

ATF_TC(fread_unlocked_heap_end);
ATF_TC_HEAD(fread_unlocked_heap_end, tc)
{
}
ATF_TC_BODY(fread_unlocked_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);
	replace_stdin();

	fread_unlocked(__stack.__buf, __len, 1, stdin);
#undef BUF

}

ATF_TC(fread_unlocked_heap_after_end);
ATF_TC_HEAD(fread_unlocked_heap_after_end, tc)
{
}
ATF_TC_BODY(fread_unlocked_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	replace_stdin();

	fread_unlocked(__stack.__buf, __len, 1, stdin);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(gets_s_before_end);
ATF_TC_HEAD(gets_s_before_end, tc)
{
}
ATF_TC_BODY(gets_s_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;

	replace_stdin();

	gets_s(__stack.__buf, __len);
#undef BUF

}

ATF_TC(gets_s_end);
ATF_TC_HEAD(gets_s_end, tc)
{
}
ATF_TC_BODY(gets_s_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;

	replace_stdin();

	gets_s(__stack.__buf, __len);
#undef BUF

}

ATF_TC(gets_s_heap_before_end);
ATF_TC_HEAD(gets_s_heap_before_end, tc)
{
}
ATF_TC_BODY(gets_s_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);
	replace_stdin();

	gets_s(__stack.__buf, __len);
#undef BUF

}

ATF_TC(gets_s_heap_end);
ATF_TC_HEAD(gets_s_heap_end, tc)
{
}
ATF_TC_BODY(gets_s_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);
	replace_stdin();

	gets_s(__stack.__buf, __len);
#undef BUF

}

ATF_TC(gets_s_heap_after_end);
ATF_TC_HEAD(gets_s_heap_after_end, tc)
{
}
ATF_TC_BODY(gets_s_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	replace_stdin();

	gets_s(__stack.__buf, __len);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(sprintf_before_end);
ATF_TC_HEAD(sprintf_before_end, tc)
{
}
ATF_TC_BODY(sprintf_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	char srcvar[__len + 10];

	memset(srcvar, 'A', sizeof(srcvar) - 1);
	srcvar[sizeof(srcvar) - 1] = '\0';

	sprintf(__stack.__buf, "%.*s", (int)__len - 1, srcvar);
#undef BUF

}

ATF_TC(sprintf_end);
ATF_TC_HEAD(sprintf_end, tc)
{
}
ATF_TC_BODY(sprintf_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	char srcvar[__len + 10];

	memset(srcvar, 'A', sizeof(srcvar) - 1);
	srcvar[sizeof(srcvar) - 1] = '\0';

	sprintf(__stack.__buf, "%.*s", (int)__len - 1, srcvar);
#undef BUF

}

ATF_TC(sprintf_heap_before_end);
ATF_TC_HEAD(sprintf_heap_before_end, tc)
{
}
ATF_TC_BODY(sprintf_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	char srcvar[__len + 10];

	__stack.__buf = malloc(__bufsz);
	memset(srcvar, 'A', sizeof(srcvar) - 1);
	srcvar[sizeof(srcvar) - 1] = '\0';

	sprintf(__stack.__buf, "%.*s", (int)__len - 1, srcvar);
#undef BUF

}

ATF_TC(sprintf_heap_end);
ATF_TC_HEAD(sprintf_heap_end, tc)
{
}
ATF_TC_BODY(sprintf_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	char srcvar[__len + 10];

	__stack.__buf = malloc(__bufsz);
	memset(srcvar, 'A', sizeof(srcvar) - 1);
	srcvar[sizeof(srcvar) - 1] = '\0';

	sprintf(__stack.__buf, "%.*s", (int)__len - 1, srcvar);
#undef BUF

}

ATF_TC(sprintf_heap_after_end);
ATF_TC_HEAD(sprintf_heap_after_end, tc)
{
}
ATF_TC_BODY(sprintf_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	char srcvar[__len + 10];

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	memset(srcvar, 'A', sizeof(srcvar) - 1);
	srcvar[sizeof(srcvar) - 1] = '\0';

	sprintf(__stack.__buf, "%.*s", (int)__len - 1, srcvar);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(snprintf_before_end);
ATF_TC_HEAD(snprintf_before_end, tc)
{
}
ATF_TC_BODY(snprintf_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	char srcvar[__len + 10];

	memset(srcvar, 'A', sizeof(srcvar) - 1);
	srcvar[sizeof(srcvar) - 1] = '\0';

	snprintf(__stack.__buf, __len, "%.*s", (int)__len - 1, srcvar);
#undef BUF

}

ATF_TC(snprintf_end);
ATF_TC_HEAD(snprintf_end, tc)
{
}
ATF_TC_BODY(snprintf_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	char srcvar[__len + 10];

	memset(srcvar, 'A', sizeof(srcvar) - 1);
	srcvar[sizeof(srcvar) - 1] = '\0';

	snprintf(__stack.__buf, __len, "%.*s", (int)__len - 1, srcvar);
#undef BUF

}

ATF_TC(snprintf_heap_before_end);
ATF_TC_HEAD(snprintf_heap_before_end, tc)
{
}
ATF_TC_BODY(snprintf_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	char srcvar[__len + 10];

	__stack.__buf = malloc(__bufsz);
	memset(srcvar, 'A', sizeof(srcvar) - 1);
	srcvar[sizeof(srcvar) - 1] = '\0';

	snprintf(__stack.__buf, __len, "%.*s", (int)__len - 1, srcvar);
#undef BUF

}

ATF_TC(snprintf_heap_end);
ATF_TC_HEAD(snprintf_heap_end, tc)
{
}
ATF_TC_BODY(snprintf_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	char srcvar[__len + 10];

	__stack.__buf = malloc(__bufsz);
	memset(srcvar, 'A', sizeof(srcvar) - 1);
	srcvar[sizeof(srcvar) - 1] = '\0';

	snprintf(__stack.__buf, __len, "%.*s", (int)__len - 1, srcvar);
#undef BUF

}

ATF_TC(snprintf_heap_after_end);
ATF_TC_HEAD(snprintf_heap_after_end, tc)
{
}
ATF_TC_BODY(snprintf_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	char srcvar[__len + 10];

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	memset(srcvar, 'A', sizeof(srcvar) - 1);
	srcvar[sizeof(srcvar) - 1] = '\0';

	snprintf(__stack.__buf, __len, "%.*s", (int)__len - 1, srcvar);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(tmpnam_before_end);
ATF_TC_HEAD(tmpnam_before_end, tc)
{
}
ATF_TC_BODY(tmpnam_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[L_tmpnam + 1];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = L_tmpnam + 1;
	const size_t __idx __unused = __len - 1;

	tmpnam(__stack.__buf);
#undef BUF

}

ATF_TC(tmpnam_end);
ATF_TC_HEAD(tmpnam_end, tc)
{
}
ATF_TC_BODY(tmpnam_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[L_tmpnam];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = L_tmpnam;
	const size_t __idx __unused = __len - 1;

	tmpnam(__stack.__buf);
#undef BUF

}

ATF_TC(tmpnam_heap_before_end);
ATF_TC_HEAD(tmpnam_heap_before_end, tc)
{
}
ATF_TC_BODY(tmpnam_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (L_tmpnam + 1);
	const size_t __len = L_tmpnam + 1;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	tmpnam(__stack.__buf);
#undef BUF

}

ATF_TC(tmpnam_heap_end);
ATF_TC_HEAD(tmpnam_heap_end, tc)
{
}
ATF_TC_BODY(tmpnam_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (L_tmpnam);
	const size_t __len = L_tmpnam;
	const size_t __idx __unused = __len - 1;

	__stack.__buf = malloc(__bufsz);

	tmpnam(__stack.__buf);
#undef BUF

}

ATF_TC(tmpnam_heap_after_end);
ATF_TC_HEAD(tmpnam_heap_after_end, tc)
{
}
ATF_TC_BODY(tmpnam_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (L_tmpnam - 1);
	const size_t __len = L_tmpnam - 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);

	tmpnam(__stack.__buf);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(fgets_before_end);
ATF_TC_HEAD(fgets_before_end, tc)
{
}
ATF_TC_BODY(fgets_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	FILE *fp;

	fp = new_fp(__len);

	fgets(__stack.__buf, __len, fp);
#undef BUF

}

ATF_TC(fgets_end);
ATF_TC_HEAD(fgets_end, tc)
{
}
ATF_TC_BODY(fgets_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	FILE *fp;

	fp = new_fp(__len);

	fgets(__stack.__buf, __len, fp);
#undef BUF

}

ATF_TC(fgets_heap_before_end);
ATF_TC_HEAD(fgets_heap_before_end, tc)
{
}
ATF_TC_BODY(fgets_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	FILE *fp;

	__stack.__buf = malloc(__bufsz);
	fp = new_fp(__len);

	fgets(__stack.__buf, __len, fp);
#undef BUF

}

ATF_TC(fgets_heap_end);
ATF_TC_HEAD(fgets_heap_end, tc)
{
}
ATF_TC_BODY(fgets_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	FILE *fp;

	__stack.__buf = malloc(__bufsz);
	fp = new_fp(__len);

	fgets(__stack.__buf, __len, fp);
#undef BUF

}

ATF_TC(fgets_heap_after_end);
ATF_TC_HEAD(fgets_heap_after_end, tc)
{
}
ATF_TC_BODY(fgets_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	FILE *fp;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	fp = new_fp(__len);

	fgets(__stack.__buf, __len, fp);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TP_ADD_TCS(tp)
{
	ATF_TP_ADD_TC(tp, ctermid_before_end);
	ATF_TP_ADD_TC(tp, ctermid_end);
	ATF_TP_ADD_TC(tp, ctermid_heap_before_end);
	ATF_TP_ADD_TC(tp, ctermid_heap_end);
	ATF_TP_ADD_TC(tp, ctermid_heap_after_end);
	ATF_TP_ADD_TC(tp, ctermid_r_before_end);
	ATF_TP_ADD_TC(tp, ctermid_r_end);
	ATF_TP_ADD_TC(tp, ctermid_r_heap_before_end);
	ATF_TP_ADD_TC(tp, ctermid_r_heap_end);
	ATF_TP_ADD_TC(tp, ctermid_r_heap_after_end);
	ATF_TP_ADD_TC(tp, fread_before_end);
	ATF_TP_ADD_TC(tp, fread_end);
	ATF_TP_ADD_TC(tp, fread_heap_before_end);
	ATF_TP_ADD_TC(tp, fread_heap_end);
	ATF_TP_ADD_TC(tp, fread_heap_after_end);
	ATF_TP_ADD_TC(tp, fread_unlocked_before_end);
	ATF_TP_ADD_TC(tp, fread_unlocked_end);
	ATF_TP_ADD_TC(tp, fread_unlocked_heap_before_end);
	ATF_TP_ADD_TC(tp, fread_unlocked_heap_end);
	ATF_TP_ADD_TC(tp, fread_unlocked_heap_after_end);
	ATF_TP_ADD_TC(tp, gets_s_before_end);
	ATF_TP_ADD_TC(tp, gets_s_end);
	ATF_TP_ADD_TC(tp, gets_s_heap_before_end);
	ATF_TP_ADD_TC(tp, gets_s_heap_end);
	ATF_TP_ADD_TC(tp, gets_s_heap_after_end);
	ATF_TP_ADD_TC(tp, sprintf_before_end);
	ATF_TP_ADD_TC(tp, sprintf_end);
	ATF_TP_ADD_TC(tp, sprintf_heap_before_end);
	ATF_TP_ADD_TC(tp, sprintf_heap_end);
	ATF_TP_ADD_TC(tp, sprintf_heap_after_end);
	ATF_TP_ADD_TC(tp, snprintf_before_end);
	ATF_TP_ADD_TC(tp, snprintf_end);
	ATF_TP_ADD_TC(tp, snprintf_heap_before_end);
	ATF_TP_ADD_TC(tp, snprintf_heap_end);
	ATF_TP_ADD_TC(tp, snprintf_heap_after_end);
	ATF_TP_ADD_TC(tp, tmpnam_before_end);
	ATF_TP_ADD_TC(tp, tmpnam_end);
	ATF_TP_ADD_TC(tp, tmpnam_heap_before_end);
	ATF_TP_ADD_TC(tp, tmpnam_heap_end);
	ATF_TP_ADD_TC(tp, tmpnam_heap_after_end);
	ATF_TP_ADD_TC(tp, fgets_before_end);
	ATF_TP_ADD_TC(tp, fgets_end);
	ATF_TP_ADD_TC(tp, fgets_heap_before_end);
	ATF_TP_ADD_TC(tp, fgets_heap_end);
	ATF_TP_ADD_TC(tp, fgets_heap_after_end);
	return (atf_no_error());
}
